/* ********************************************** gdk-pixbuf-extension.h *** *
 * gdk-pixbufγĥؿإåե
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/11/14 11:27:50 sugaya>
 * ************************************************************************* */
#ifndef	__GDK_PIXBUF_EXTENSION_H__
#define	__GDK_PIXBUF_EXTENSION_H__

typedef struct _GdkPixbufColorModifier {
  gint	gamma;
  gint	brightness;
  gint	contrast;
} GdkPixbufColorModifier;

typedef struct _GdkPixbufModifierMap {
  unsigned char	rmap[256];
  unsigned char	gmap[256];
  unsigned char	bmap[256];
} GdkPixbufModifierMap;

typedef struct _GdkPixbufModifier {
  GdkPixbufColorModifier	mod;
  GdkPixbufColorModifier	rmod;
  GdkPixbufColorModifier	gmod;
  GdkPixbufColorModifier	bmod;  
  GdkPixbufModifierMap		*map;
} GdkPixbufModifier;

/* ************************************************************************* */
void		free_buffer		(guchar			*pixels,
					 gpointer		data);

gboolean	gdk_pixbuf_save_to_file	(const GdkPixbuf	*pixbuf,
					 const char		*file_name);

GdkPixbuf*	gdk_pixbuf_remove_alpha (const GdkPixbuf	*src);

void	gdk_pixbuf_calc_map_tables 	(GdkPixbufModifier		*mod);

void	gdk_pixbuf_set_image_modifier 	(GdkPixbufColorModifier		*cmod,
					 GdkPixbufModifier		*mod);

void	gdk_pixbuf_set_image_red_modifier (GdkPixbufColorModifier	*cmod,
					   GdkPixbufModifier		*mod);

void	gdk_pixbuf_set_image_green_modifier (GdkPixbufColorModifier	*cmod,
					     GdkPixbufModifier		*mod);

void	gdk_pixbuf_set_image_blue_modifier (GdkPixbufColorModifier	*cmod,
					    GdkPixbufModifier		*mod);

void	gdk_pixbuf_get_image_modifier	(GdkPixbufColorModifier	*src_mod,
					 GdkPixbufColorModifier	*dst_mod);

void	gdk_pixbuf_get_image_red_curve	(GdkPixbufModifierMap	*src_map,
					 unsigned char 		*mod);

void	gdk_pixbuf_get_image_green_curve(GdkPixbufModifierMap	*src_map,
					 unsigned char 		*mod);

void	gdk_pixbuf_get_image_blue_curve	(GdkPixbufModifierMap	*src_map,
					 unsigned char 		*mod);

void	gdk_pixbuf_apply_modifiers_to_rgb (GdkPixbuf		*pbuf,
					   GdkPixbufModifier	*mod,
					   int			clear_flg);

GdkPixbuf*	gdk_pixbuf_align_rowstride	(GdkPixbuf	*src);

GdkPixbuf*	gdk_pixbuf_new_from_file_extension (char	*filename);

#endif	/* __GDK_PIXBUF_EXTENSION_H__ */

/* *************************************** End of gdk-pixbuf-extension.h *** */
