/* *********************************************************** getargs.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/03/23 00:27:11 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* ************************************************************************* */
static WinGeometry*	
te_option_parse_geometry		(char		*option);
static void
te_option_parse_sequence_file		(GList		**list,
					 char		*filename,
					 int		start,
					 int		end,
					 int		step);

/* ץλɽ **************************************************** */
void
usage (char *s) {
  fprintf (stderr, "\n");
  fprintf (stderr, "----------------------------------------------------------"
	   "-----------------\n");
  fprintf (stderr, "TeoEyes Version%s                                         "
	   "     Usage\n", VERSION);
  fprintf (stderr, "----------------------------------------------------------"
	   "-----------------\n");
  fprintf (stderr, "> teoeyes file1 file2 ... [option]\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "[option]\n");
  fprintf (stderr, "   -l                         "
	   ": Load all image\n");
  fprintf (stderr, "   -Nl                        "
	   ": Cancel load all image option\n");
  fprintf (stderr, "   -c                         "
	   ": Free old image memory\n");
  fprintf (stderr, "   -Nc                        "
	   ": Cancel free old image memory option\n");
  fprintf (stderr, "\n");

  
  fprintf (stderr, "   -N                         "
	   ": Normalize (min_val - max_val)\n");
  fprintf (stderr, "   -NN                        "
	   ": Cancel normalize option\n");
  fprintf (stderr, "   -n #1 #2                   "
	   ": Normalize (#1 - #2)\n");
  fprintf (stderr, "\n");


  fprintf (stderr, "   -q                         "
	   ": Quick draw mode\n");
  fprintf (stderr, "   -Nq                        "
	   ": Cancel quick draw mode\n");
  fprintf (stderr, "   -d                         "
	   ": Display mode\n");
  fprintf (stderr, "   -Nd                        "
	   ": Cancel display mode option\n");
  fprintf (stderr, "   -f #                       "
	   ": Display #th frame(only teo format)\n");
  fprintf (stderr, "\n");

  fprintf (stderr, "   -s [file_header] #1 #2 #3  "
	   ": Read sequence files\n"
	   "                                (#1:Start #2:End #3:Step)\n");
  fprintf (stderr, "\n");

  
  fprintf (stderr, "   -root #                    "
	   ": Draw image on background (# 1:TILE 2:CENTER)\n");
  fprintf (stderr, "   -skin [skin_data]          "
	   ": Use custom skin\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "   -g                         "
	   ": Set window geometry\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "   -h                         "
	   ": Show this usage\n");
  fprintf (stderr, "   -v                         "
	   ": Show version\n");
  fprintf (stderr, "----------------------------------------------------------"
	   "-----------------\n");
  fprintf (stderr, "\n");

  exit (1);
}
   
/* Сɽ ********************************************************** */
void
version (void) {
  fprintf (stderr, "TeoEyes Ver%s\n", VERSION);
  exit (0);
}

/* Υå ********************************************************** */
int
getargs (int		argc,		/* ο */
	 char		**argv,		/*  */
	 Option		**opt,		/* TeoEyesΥץ */
	 TeoeyesConfig	**tc) {
  int 		args;
  TEImage	*tmpimg;
  char		*filename;
  int		start, end, step;

  for(args = 1; args < argc; ++args) {
    if ((*argv[args] == '-') && *(argv[args]+1) && isalpha (*(argv[args]+1))) {
      if ((strcmp ("l", ++argv[args])) == 0) {		/* -l */
	(*opt)->load_image = ON;
      } else if ((strcmp ("Nl", argv[args])) == 0) {	/* -Nl */
	(*opt)->load_image = OFF;
      } else if ((strcmp ("c", argv[args])) == 0) {	/* -c */
	(*opt)->clear_data = ON;
      } else if ((strcmp ("Nc", argv[args])) == 0) {	/* -Nc */
	if ((*opt)->display_mode != ON) (*opt)->clear_data = OFF;
      } else if ((strcmp ("N", argv[args])) == 0) {	/* -N */
	(*opt)->normalize = ON;
        (*opt)->min   = -1;
        (*opt)->max   = -1;
      } else if ((strcmp ("NN", argv[args])) == 0) {	/* -NN */
	(*opt)->normalize = OFF;
	(*opt)->min = 0;
	(*opt)->max = 0;
      } else if ((strcmp ("n", argv[args])) == 0) {	/* -n */
	(*opt)->normalize = ON;
	if (++args >= argc) return 0;
        (*opt)->min = (double) atof (argv[args]);
        if (++args >= argc) return 0;
	(*opt)->max = (double) atof (argv[args]);
      } else if ((strcmp ("q", argv[args])) == 0) {	/* -q */
	(*opt)->quick_draw = ON;
      } else if ((strcmp ("Nq", argv[args])) == 0) {	/* -Nq */
	(*opt)->quick_draw = OFF;
      } else if ((strcmp ("d", argv[args])) == 0) {	/* -d */
	(*opt)->display_mode = ON;
	(*opt)->load_image   = ON;
      } else if ((strcmp ("Nd", argv[args])) == 0) {	/* -Nd */
	(*opt)->display_mode = OFF;
      } else if ((strcmp ("f", argv[args])) == 0) {	/* -f */
        if (++args >= argc) return 0;
	(*opt)->frame = atoi (argv[args]);
      } else if ((strcmp ("s", argv[args])) == 0) {	/* -s */
	if (++args >= argc) return 0;
	filename = argv[args];
        if (++args >= argc) return 0;
        start	= atoi (argv[args]);
        if (++args >= argc) return 0;
	end	= atoi (argv[args]);
	if (++args >= argc) return 0;
	step	= atoi (argv[args]);
	te_option_parse_sequence_file (&image_list,filename, start, end, step);
      } else if ((strcmp ("root", argv[args])) == 0) {	/* -root */
        if (++args >= argc) return 0;
        (*opt)->draw_background = atoi (argv[args]);
      } else if ((strcmp ("skin", argv[args])) == 0) {	/* -skin */
        if (++args >= argc) return 0;
        (*tc)->skin_data = g_strdup (argv[args]);
      } else if ((strcmp ("g", argv[args])) == 0) {	/* -g */
        if (++args >= argc) return 0;
	(*opt)->geo = te_option_parse_geometry (argv[args]);
      } else if ((strcmp ("h", argv[args])) == 0) {	/* -h */
	usage (argv[0]);
      } else if ((strcmp ("v", argv[args])) == 0) {	/* -v */
	version ();
      } 
    } else {
      if (strcmp (argv[args], "-") == 0) {
	tmpimg 
	  = te_image_new (argv[args],
			  (!image_list) ? 
			  0 :
			  te_image_get_id (g_list_last (image_list)) + 1, 1);
      } else {
	tmpimg 
	  = te_image_new (argv[args],
			  (!image_list) ? 
			  0 :
			  te_image_get_id (g_list_last (image_list)) + 1, 0);
      }
      if (tmpimg) {
	image_list = g_list_append (image_list, (gpointer) tmpimg);
      }
    }
  }
  if (!image_list) {
    /* ¸ߤ뤫Ĵ٤ */
    if (!y_file_exist_file ((*tc)->title_image)) {
      fprintf (stderr, 
	       "%s %s\n", _("Can not find file :"), (*tc)->title_image);
      exit (1);
    }
    /*  */
    tmpimg = te_image_new ((*tc)->title_image, 0, 0);
    if (!tmpimg) exit (1);
    image_list = g_list_append (image_list, (gpointer) tmpimg);
    if (!image_list) {
      fprintf (stderr, _("Can not allocate enough memory.\n"));
      exit (1);
    }
  }
  return 1;
}

/* ************************************************************************* *
 * ץβϥ롼
 * ************************************************************************* */
	
/* -gץΰϴؿ () ************************************* */
static void
te_option_parse_geometry_size (char		*option,
			       WinGeometry	**geo) {
  char			buf[64];
  char			*ptr;

  /*  */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geo)->width = atoi (buf);

  /* x */
  if (*option++ != 'x') {
    (*geo)->height = UNDEF_VAL;
    return;
  }

  /* ⤵ */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geo)->height = atoi (buf);
}

/* -gץΰϴؿ () *************************************** */
static void
te_option_parse_geometry_position (char		*option,
				   WinGeometry	**geo) {
  char			buf[64];
  char			*ptr;


  /* X */
  if (*option != '+' && *option != '-') {
    (*geo)->x	= UNDEF_VAL;
    (*geo)->y	= UNDEF_VAL;
    return;
  }
  (*geo)->xsign = (*option++ == '+') ? 1 : -1;

  /* X */
  if (!isdigit (*option)) {
    (*geo)->x	= UNDEF_VAL;
    (*geo)->y	= UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geo)->x = atoi (buf);

  /* Y */
  if (*option != '+' && *option != '-') {
    (*geo)->x	= UNDEF_VAL;
    (*geo)->y	= UNDEF_VAL;
    return;
  }
  (*geo)->ysign = (*option++ == '+') ? 1 : -1;
  
  /* Y */
  if (!isdigit (*option)) {
    (*geo)->x	= UNDEF_VAL;
    (*geo)->y	= UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geo)->y = atoi (buf);
}

/* -gץΰϴؿ ********************************************** */
static WinGeometry*
te_option_parse_geometry (char	*option) {
  WinGeometry	*geo = NULL;
  char		*tmp;
  int		rx, ry, rw, rh, rd;

  tmp = option;
  if (*tmp == '+' || *tmp == '-') tmp++;
  /* ץλְ꤬äƤ饪ץ̵ˤ */
  if (!isdigit (*tmp)) return geo;
  
  /* ץβ */
  while (tmp && isdigit (*tmp)) tmp++;

  if (*tmp == 'x') {
    geo = (WinGeometry *) malloc (sizeof (WinGeometry));
    te_option_parse_geometry_size (option, &geo);
    while (option && !isalpha (*option)) option++;
    if (!option || *option != 'x') {
      geo->x	= UNDEF_VAL;
      geo->y	= UNDEF_VAL;
    } else {
      option++;
      while (option && isdigit (*option)) option++;
      if (*option == '+' || *option == '-') {
	te_option_parse_geometry_position (option, &geo);
      } else {
	geo->x	= UNDEF_VAL;
	geo->y	= UNDEF_VAL;
      }
    }
  } else if (*tmp == '+' || *tmp == '-') {
    geo = (WinGeometry *) malloc (sizeof (WinGeometry));
    te_option_parse_geometry_position (option, &geo);
    geo->width	= UNDEF_VAL;
    geo->height	= UNDEF_VAL;
  }
  return geo;
}

/* -sץβϴؿ ************************************************** */
static void
te_option_parse_sequence_file (GList	**list,
			       char	*filename,
			       int	start,
			       int	end,
			       int	step) {
  char		name[1024];
  int		n;
  TEImage	*tmpimg;

  for (n = start; n <= end; n+= step) {
    /* ե̾ */
    sprintf (name, filename, n);
    /*  */
    tmpimg = te_image_new ((!y_file_exist_file (name)) ?
			   tc->title_image : name,
			   (!(*list)) ? 
			   0 : te_image_get_id ((*list)) + 1, 0);
    *list =  g_list_append (*list, (gpointer) tmpimg);
  }
}

/* **************************************************** End of getargs.c *** */

