/* ************************************************************** grab.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-19 22:03:33 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "X11/cursorfont.h"

/* ************************************************************************* */
static Display		*dsp;
static Window		win;
static GC		gc;
static int		screen;

/* ************************************************************************* */
u_long
xorMasks[] = {
  0x01010101,
  0x02020203,
  0x84848485,
  0x88888889,
  0x10101011,
  0x20202023,
  0xc4c4c4c5,
  0xffffffff
};

/* ************************************************************************* */
static void
te_grab_flash_start (void) {
  XSetFunction (dsp, gc, GXinvert);
  XSetSubwindowMode (dsp, gc, IncludeInferiors);
}

/* ************************************************************************* */
static void
te_grab_flash_end (void) {
  XSetFunction (dsp, gc, GXcopy);
  XSetSubwindowMode (dsp, gc, ClipByChildren);
  XSetPlaneMask (dsp, gc, AllPlanes);
  XSync (dsp, FALSE);
}

/* ************************************************************************* */
static void
te_grab_flash_rect (int		x,
		    int		y,
		    int		w,
		    int		h,
		    int		show) {
  static int	isvis	= 0;
  static int	maskno	= 0;

  XSetPlaneMask (dsp, gc, xorMasks[maskno]);
  if (!show) {
    if (isvis) XDrawRectangle (dsp, win, gc, x, y, (u_int) w-1, (u_int) h-1);
    isvis = 0;
  } else {
    if (!isvis && w > 1 && h > 1) {
      maskno = (maskno + 1) & 7;
      XSetPlaneMask (dsp, gc, xorMasks[maskno]);
      XDrawRectangle (dsp, win, gc, x, y, (u_int) w-1, (u_int) h-1);
      isvis = 1;
    }
  }
}

/* ************************************************************************* */
static Window
te_grab_try_children (Display	*dsp,
		      Window	win,
		      Atom	WM_STATE) {
  Window	root, parent;
  Window	*children;
  unsigned int 	nchildren;
  unsigned int 	i;
  Atom		type = None;
  int 		format;
  unsigned long nitems, after;
  unsigned char *data;
  Window	inf = 0;

  if (!XQueryTree (dsp, win, &root, &parent, &children, &nchildren)) return 0;

  for (i = 0; !inf && (i < nchildren); i++) {
    XGetWindowProperty (dsp, children[i], WM_STATE, 0L, 0L, False,
			AnyPropertyType, &type, &format, &nitems,
			&after, &data);

    if (type) inf = children[i];
  }

  for (i = 0; !inf && (i < nchildren); i++) {
    inf = te_grab_try_children (dsp, children[i], WM_STATE);
  }
  if (children) XFree ((char *) children);

  return inf;
}

/* ************************************************************************* */
static Window
te_grab_client_window (Display	*dsp,
		       Window	win) {
  Atom		WM_STATE;
  Atom		type = None;
  int 		format;
  unsigned long nitems, after;
  unsigned char *data;
  Window	inf;

  WM_STATE = XInternAtom (dsp, "WM_STATE", TRUE);
  if (!WM_STATE) return win;

  XGetWindowProperty (dsp, win, WM_STATE, 0L, 0L, False, AnyPropertyType,
		      &type, &format, &nitems, &after, &data);
  if (type) return win;

  inf = te_grab_try_children (dsp, win, WM_STATE);

  return inf;
}
		       
/* ************************************************************************* */
void
te_grab_do (void) {
  GtkWidget	*draw_area;
  Window	rW, cW, clickW, tmpW;
  XEvent	ev;
  Cursor	tcross;
  unsigned int	mask;
  int		n, done;
  char		buf[256];
  int		x, y, rx, ry, x1, y1, x2, y2, ix, iy, iw, ih, rv; 

  draw_area = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  dsp    = GDK_DISPLAY ();
  win    = GDK_ROOT_WINDOW ();
  screen = DefaultScreen (dsp);
  gc     = DefaultGC (dsp, screen);
  tcross = XCreateFontCursor (dsp, XC_tcross);

  XGrabButton (dsp, (u_int) AnyButton, 0, win, FALSE, 0,
	       GrabModeAsync, GrabModeSync, None, tcross);
  while (1) {
    if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x1, &y1, &mask)) {
      if (mask & (Button1Mask | Button2Mask | Button3Mask)) break;
    }
  }
  if (mask & Button3Mask || rW != win) {
    /* ܥΥ٥ (֥󥻥) */    
    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x1, &y1, &mask)) {
	if (!(mask & Button3Mask)) break;
      }
    }
    XUngrabButton (dsp, (u_int) AnyButton, 0, win);
  } else if (mask & Button2Mask) {
    /* ܥΥ٥ (ɥΥ) */    
    GdkWindow		*gwin;
    GdkPixbuf		*pbuf, *tmp;
    TEImage		*te;
    int W = ((GdkWindowPrivate*) ((GdkWindow *) &gdk_root_parent))->width;
    int H = ((GdkWindowPrivate*) ((GdkWindow *) &gdk_root_parent))->height;
    
    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x1, &y1, &mask)) {
	if (!(mask & Button2Mask)) break;
      }
    }
    if (!cW || cW == win) {
      clickW = win;
    } else {
      int	xr, yr;
      Window	chwin;
      
      XTranslateCoordinates (dsp, rW, cW, rx, ry, &xr, &yr, &chwin);
      if (chwin != None) {
	XWindowAttributes	clickxwa, parentxwa;

	clickW = te_grab_client_window (dsp, chwin);

	if (!clickW || 
	    (XGetWindowAttributes (dsp, clickW, &clickxwa)     &&
	     XGetWindowAttributes (dsp, cW,     &parentxwa)    &&
	     clickxwa.visual->class == parentxwa.visual->class &&
	     clickxwa.colormap      == parentxwa.colormap      &&
	     clickxwa.depth         == parentxwa.depth)) {
	  clickW = cW;
	}
      } else {
	clickW = cW;
      }
    }
    if (clickW == win) {
      ix = iy = 0;
      iw = W;
      ih = H;
    } else {
      int		x, y;
      Window		wins;
      unsigned int	rw, rh, rb, rd;
      
      if (XGetGeometry (dsp, clickW, &rW, &x, &y, &rw, &rh, &rb, &rd)) {
	iw = (int) rw;
	ih = (int) rh;
	
	XTranslateCoordinates (dsp, clickW, win, 0, 0, &ix,&iy, &wins);
      } else {
	ix = iy = 0;
	iw = W;
	ih = H;
	clickW = win;
      }
    }
    if (ix<0) {
      iw += ix;
      ix = 0;
    }
    if (iy<0) {
      ih += iy;
      iy = 0;
    }
    if (ix + iw > W) iw = W - ix;
    if (iy + ih > H) ih = H - iy;

    te_grab_flash_start ();
    
    for (n = 0; n < 5; n++) {
      te_grab_flash_rect (ix, iy, iw, ih, 1);
      XFlush (dsp);
      usleep (100000);
      te_grab_flash_rect (ix, iy, iw, ih, 0);
      XFlush (dsp);
      usleep (100000);      
    }
    te_grab_flash_end ();

    XUngrabButton (dsp, (u_int) AnyButton, 0, win);
    
    gwin = gdk_window_foreign_new (clickW);
    tmp = gdk_pixbuf_get_from_drawable (NULL, (GdkDrawable *) gwin,
					gdk_window_get_colormap (gwin),
					0, 0, 0, 0, iw, ih);
    pbuf = gdk_pixbuf_align_rowstride (tmp);
    gdk_pixbuf_unref (tmp);
    
    sprintf (buf, "./_grab%d.ppm",
	     te_image_get_id (g_list_last (image_list)) + 1);    
    te_image_add_image_list (g_list_last (image_list), buf,
			     te_image_get_id (g_list_last (image_list))+1, 1);

    /* ȲΥ */
    if (opt->clear_data && !opt->display_mode) {
      te_image_clear_image (image_list);
    }
    image_list	= g_list_last (image_list);
    te		= te_image_get_image (image_list);
    te->pbuf	= pbuf;
    
    if (!opt->display_mode) {
      te_image_load_image (image_list, 0, opt->min, opt->max);
    }
    /* 礭 */
    gtk_widget_set_usize (draw_area, iw, ih);
    te_image_set_image_size (image_window, iw, ih);

    /* ꥹȥɥƤϥͥ򹹿 */
    if (list_window && GTK_WIDGET_VISIBLE (list_window)) {
      te_image_list_refresh_list ();
    }
  } else if (mask & Button1Mask) {
    /* ܥΥ٥ (ΰΥ) */
    int			org_x, org_y;
    Window		orgW;
    GdkPixbuf		*pbuf, *tmp;
    GdkWindow		*new_win;
    TEImage		*te;
    
    clickW = win;
    orgW   = cW;
    org_x  = ix = x2 = rx;
    org_y  = iy = y2 = ry;
    iw = ih = 0;

    XGrabServer (dsp);
    te_grab_flash_start ();

    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x, &y, &mask)) {
	if (!(mask & Button1Mask)) break;
      }
      te_grab_flash_rect (ix, iy, iw, ih, 0);
      if (rx != x2 || ry != y2) {
	ix = (x1 < rx) ? x1 : rx;
	iy = (y1 < ry) ? y1 : ry;
	iw = abs (rx - x1);
	ih = abs (ry - y1);
	x2 = rx;
	y2 = ry;
      }
      if (iw > 1 && ih > 1) te_grab_flash_rect (ix, iy, iw, ih, 1);
    }
    te_grab_flash_rect (ix, iy, iw, ih, 0);
    te_grab_flash_end ();

    XUngrabServer (dsp);
    XUngrabButton (dsp, (u_int) AnyButton, 0, win);

    if (iw <= 0 || ih <= 0) return;
    
    tmp =
      gdk_pixbuf_get_from_drawable (NULL,
				    (GdkDrawable *) GDK_ROOT_PARENT (),
				    gdk_window_get_colormap(GDK_ROOT_PARENT()),
				    ix, iy, 0, 0, iw, ih);
    pbuf = gdk_pixbuf_align_rowstride (tmp);
    gdk_pixbuf_unref (tmp);

    sprintf (buf, "./_grab%d.ppm",
	     te_image_get_id (g_list_last (image_list)) + 1);
    te_image_add_image_list (g_list_last (image_list), buf,
			     te_image_get_id (g_list_last (image_list))+1, 1);

    /* ȲΥ */
    if (opt->clear_data && !opt->display_mode) {
      te_image_clear_image (image_list);
    }
    image_list	= g_list_last (image_list);
    te		= te_image_get_image (image_list);
    te->format	= FORMAT_PPM;
    te->pbuf	= pbuf;

    if (!opt->display_mode) {
      te_image_load_image (image_list, 0, opt->min, opt->max);
    }
    /* 礭 */
    gtk_widget_set_usize (draw_area, iw, ih);
    te_image_set_image_size (image_window, iw, ih);

    /* ꥹȥɥƤϥͥ򹹿 */
    if (list_window && GTK_WIDGET_VISIBLE (list_window)) {
      te_image_list_refresh_list ();
    }
  }
}

/* ******************************************************* End of grab.c *** */
