/* ************************************************************************* *
 * gtkiconfileselection - gtkiconfileselection dialog widget for gtk+
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * ************************************************************************* */

/* ********************************************** gtkcustomiconfilesel.h *** *
 * ޥǽʥե
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-10-20 18:10:45 sugaya>
 * ************************************************************************* */

/* *** Layout of CustomFileSelection *************************************** *

  +---------------------------------------------------+----+
  | +-----------------------------------------------+ | *  |
  | | *************** Custom Box 1 **************** | | *  |
  | +-----------------------------------------------+ | *  |
  | +-------+ +--------------------------+ +--+--+--+ |    |
  | | Label | | Combo                    | | Button | | C  |
  | +-------+ +--------------------------+ +--+--+--+ |    |
  | +-----------------------------------------------+ | u  |
  | | *************** Custom Box 2 **************** | |    |
  | +-----------------------------------------------+ | s  |
  | +-------------+ +-------------------------------+ |    |
  | | Dir Tree    | |	Icon File List       	    | |	t  |	
  | |		  | |			            | |	   |	
  | |		  | |		         	    | |	u  |	
  | |		  | |	           		    | |	   |	
  | |		  | |		        	    | | m  |		
  | |		  | |		        	    | |    |		
  | |		  | |		        	    | | B  |		
  | +-------------+ +-------------------------------+ |    |
  | +-----------------------------------------------+ | o  |
  | | *************** Custom Box 3 **************** | |    |
  | +-----------------------------------------------+ | x  |
  | +-------+ +--------------------------+ +--------+ |    |
  | | Label | | Entry                    | | Button | | 5  |
  | +-------+ +--------------------------+ +--------+ |    |
  | +-------+ +--------------------------+ +--------+ | *  |
  | | Label | | Entry                    | | Button | | *  |
  | +-------+ +--------------------------+ +--------+ | *  |
  | +-----------------------------------------------+ | *  |
  | | *************** Custom Box 4 **************** | | *  |
  | +-----------------------------------------------+ | *  |
  +---------------------------------------------------+----+

  * ************************************************************************ */
#ifndef __GTK_CUSTOM_ICON_FILESEL_H__
#define __GTK_CUSTOM_ICON_FILESEL_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "gtkdirtree.h"
#include "gtkiconlist.h"
#include "gtkfilelist.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_CUSTOM_ICON_FILESEL (gtk_custom_icon_file_selection_get_type ())
#define GTK_CUSTOM_ICON_FILESEL(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_CUSTOM_ICON_FILESEL, GtkCustomIconFileSel))
#define GTK_CUSTOM_ICON_FILESEL_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_CUSTOM_ICON_FILESEL, GtkCustomIconFileSelClass))
#define GTK_IS_CUSTOM_ICON_FILESEL(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_CUSTOM_ICON_FILESEL))
#define GTK_IS_CUSTOM_ICON_FILESEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CUSTOM_ICON_FILESEL))

typedef struct _GtkCustomIconFileSel       GtkCustomIconFileSel;
typedef struct _GtkCustomIconFileSelClass  GtkCustomIconFileSelClass;

struct _GtkCustomIconFileSel
{
  GtkWindow	window;

  gchar		*title;

  gboolean	show_tree;

  GtkWidget	*path_label;
  
  GtkWidget 	*tree_window;
  GtkWidget 	*dir_tree;
  GtkWidget 	*list_window;
  GtkWidget 	*file_list;
  guint 	tree_signal_id;

  GtkWidget 	*file_entry;
  GtkWidget 	*filter_entry;

  GtkWidget 	*ok_button;
  GtkWidget 	*cancel_button;

  GtkWidget 	*action_area;     /* It's a GtkTable with the entries */

  GList		*dir_combo_list;  

  GtkWidget 	*folder_button_new;
  GtkWidget 	*folder_button_up;
  GtkWidget 	*folder_button_home;

  GtkWidget 	*dir_combo;
  
  GtkWidget	*custom_box1;
  GtkWidget	*custom_box2;
  GtkWidget	*custom_box3;
  GtkWidget	*custom_box4;
  GtkWidget	*custom_box5;
  GtkWidget	*custom_box6;
};

struct _GtkCustomIconFileSelClass
{
  GtkWindowClass parent_class;

};

GtkType
gtk_custom_icon_file_selection_get_type		(void);
GtkWidget*
gtk_custom_icon_file_selection_new 		(const gchar *title);
void
gtk_custom_icon_file_selection_construct	(GtkCustomIconFileSel *filesel,
						 const gchar *title);
void
gtk_custom_icon_file_selection_show_tree 	(GtkCustomIconFileSel *filesel,
						 gboolean show);
gint
gtk_custom_icon_file_selection_open_dir 	(GtkCustomIconFileSel *filesel,
						 const gchar *path);
void
gtk_custom_icon_file_selection_show_hidden	(GtkCustomIconFileSel *filesel,
						 gboolean visible);
void
gtk_cunstom_icon_file_selection_set_filter     	(GtkCustomIconFileSel *filesel,
						 const gchar *filter);

gchar*
gtk_custom_icon_file_selection_get_filename    (GtkCustomIconFileSel *filesel);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_ICON_FILESEL_H__ */

/* *************************************** End of gtkcustomiconfilesel.h *** */
