/* *********************************************************** gtkicon.c *** *
 * 󥦥å
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2002-01-17 00:32:03 sugaya>
 * ************************************************************************* */
#include "config.h"

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include "gtkicon.h"

/* 󥦥åȤ ********************************************** */
GtkWidget*
te_icon_new (char	**pixmap) {
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  pix = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &msk, NULL, pixmap);
  icon = gtk_pixmap_new (pix, msk);
  gtk_widget_ref (icon);
  
  return icon;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_new_with_label (const gchar	*label,
			 gchar		**pix_data,
			 gint		text_position,
			 gint		border) {
  GtkWidget	*box;
  GtkWidget	*icon;
  GtkWidget	*label_widget;
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  /* ܥå */
  if (text_position == GTK_ICON_TEXT_TOP ||
      text_position == GTK_ICON_TEXT_BOTTOM) {
    box = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (box);
  } else {
    box = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (box);    
  }
  gtk_widget_show (box);

  /*  */
  pix = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &msk, NULL, pix_data);
  icon = gtk_pixmap_new (pix, msk);
  gtk_widget_ref (icon);
  
  /* ٥ */
  label_widget = gtk_label_new (label);
  gtk_widget_ref (label_widget);
  
  if (text_position == GTK_ICON_TEXT_TOP ||
      text_position == GTK_ICON_TEXT_LEFT) {

    /* ٥Υѥå */
    gtk_box_pack_start (GTK_BOX (box), label_widget, FALSE, FALSE, border);
    gtk_widget_show (label_widget);

      /* Υѥå */    
    gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, border);
    gtk_widget_show (icon);

  } else {

    /* Υѥå */    
    gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, border);
    gtk_widget_show (icon);

    /* ٥Υѥå */
    gtk_box_pack_start (GTK_BOX (box), label_widget, FALSE, FALSE, border);
    gtk_widget_show (label_widget);

  }
  return box;
}

/* **************************************************** End of gtkicon.c *** */
