/* ***************************************************** gtkiconbutton.h *** *
 * ĥGtkWidget (ܥ)
 * Copyright (C) 1998 Yasuyuki SUGAYA
 * Computer Vision and Image Media Lab, University of Tsukuba
 * Time-stamp: <2001-11-07 22:46:48 sugaya>
 * ************************************************************************* */
#ifndef __GTK_ICON_BUTTON_H__
#define __GTK_ICON_BUTTON_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_ICON_BUTTON	(gtk_icon_button_get_type ())
#define GTK_ICON_BUTTON(obj)	(GTK_CHECK_CAST ((obj), GTK_TYPE_ICON_BUTTON, GtkIconButton))
#define GTK_ICON_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_ICON_BUTTON, GtkIconButtonClass))
#define GTK_IS_ICON_BUTTON(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_ICON_BUTTON))
#define GTK_IS_ICON_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_BUTTON))

typedef struct _GtkIconButton		GtkIconButton;
typedef struct _GtkIconButtonClass	GtkIconButtonClass;

struct _GtkIconButton
{
  GtkButton	button;
  GtkWidget	*icon;
};

struct _GtkIconButtonClass
{
  GtkButtonClass	parent_class;

  void (* pressed)  (GtkButton *button);
  void (* released) (GtkButton *button);
  void (* clicked)  (GtkButton *button);
  void (* enter)    (GtkButton *button);
  void (* leave)    (GtkButton *button);

};

enum {
  GTK_ICON_BUTTON_TEXT_TOP,
  GTK_ICON_BUTTON_TEXT_BOTTOM,
  GTK_ICON_BUTTON_TEXT_LEFT,
  GTK_ICON_BUTTON_TEXT_RIGHT
};

GtkType
gtk_icon_button_get_type		(void);
GtkWidget*
gtk_icon_button_new			(gchar		**pix_data);
GtkWidget*
gtk_icon_button_new_with_label		(const gchar	*label,
					 gchar		**pix_data,
					 gint		text_position,
					 gint		border);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_ICON_BUTTON_H__ */

/* ********************************************** End of gtkiconbutton.h *** */
