/* ************************************************************* image.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/22 13:54:44 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* ************************************************************************* *
 * TEImage¤ΤΥФ˥ؿ
 * ************************************************************************* */

/* ե̾ؿ ************************************************ */
char*
te_image_get_filename (GList	*list) {
  char	*fullname;

  fullname = te_image_get_full_filename (list);
  return (!strrchr (fullname, '/')) ? fullname : strrchr (fullname, '/') + 1;
}

/* ե̾ȹ礷ꥹȤФ ************************************** */
GList*
te_image_get_list_from_filename (GList	*list,
				 char	*filename) {
  GList	*plist;

  plist = g_list_first (list);
  while (plist) {
    if (strcmp (filename, te_image_get_full_filename (plist)) == 0) {
      return plist;
    }
    plist = g_list_next (plist);
  }
  return NULL;
}

/* ************************************************************************* *
 * ꤹؿ
 * ************************************************************************* */

/*  ******************************************************** */
void
te_image_set_size (GtkWidget	*widget,
		   int		width,
		   int		height) {
  GtkWidget	*canvas;
  GtkWidget	*scroll_window;

  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "canvas");
  scroll_window = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "scroll_window");

  /*  */
  te_image_set_curr_width  (image_list, width);
  te_image_set_curr_height (image_list, height);
  gtk_object_set_data (GTK_OBJECT (widget), "width", (gpointer) width);
  gtk_object_set_data (GTK_OBJECT (widget), "height", (gpointer)height);  

  if (canvas) {
    gtk_widget_set_usize (canvas, width, height);
    gtk_widget_queue_resize (scroll_window);
  }
}
/* ѹ ******************************************************** */
void
te_image_set_image_size (GtkWidget	*widget,
			 gint		width,
			 gint		height) {
  GtkWidget	*canvas;
  GtkWidget	*scroll_window;
  GtkWidget	*mbox;
  GtkWidget	*alignment;
  gint		scrollable;
  gint		forcescroll;
  gint		rw, rh;
  GdkPixbuf	*back;
    
  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "canvas");
  if (!canvas) return;
  scroll_window = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "scroll_window");
  mbox = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "middle");
  alignment = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "alignment");

  /* ѥ᡼γ */
  scrollable = (gint)
    gtk_object_get_data (GTK_OBJECT (widget), "scrollable");
  forcescroll = (gint)
    gtk_object_get_data (GTK_OBJECT (widget), "forcescroll");

  /* 礭 */
  te_image_set_curr_width (image_list, width);
  te_image_set_curr_height(image_list, height);
  gtk_object_set_data (GTK_OBJECT (widget), "width", (gpointer) width);
  gtk_object_set_data (GTK_OBJECT (widget), "height", (gpointer)height);  

  /* ̤礭γ */
  gdk_window_get_size (GDK_ROOT_PARENT (), &rw, &rh);

  /* СɽƤʤ...
     ̤礭ä */
  if (!scrollable) {
    if (width > rw && height > rh) {
      gtk_widget_set_usize (widget, rw - 64, rh - 64);
    } else if (width > rw) {
      gtk_widget_set_usize (widget, rw - 64, height - 32);      
    } else if (height > rh) {
      gtk_widget_set_usize (widget, width - 32, rh - 64);
    }
  }

  if (width > rw || height > rh || forcescroll) {
    if (!scrollable) {
      gtk_window_set_policy (GTK_WINDOW (widget), 1, 1, 0);
      gtk_widget_show (scroll_window);
      gtk_widget_reparent (canvas, alignment);
      gtk_widget_set_usize (scroll_window, -1, -1);
      gtk_widget_set_usize (canvas, width, height);
      gtk_object_set_data (GTK_OBJECT (widget), "scrollable", (gpointer) 1);
    }
  } else {
    if (scrollable) {
      gtk_window_set_policy (GTK_WINDOW (widget), 1, 1, 1);
      gtk_widget_set_usize (widget, -1, -1);
      gtk_widget_reparent (canvas, mbox);
      gtk_box_set_child_packing (GTK_BOX (mbox),
				 canvas, TRUE, TRUE, 0, GTK_PACK_START);
      gtk_widget_set_usize (scroll_window, 1, 1);
      gtk_widget_hide (scroll_window);
      gtk_widget_show (canvas);
      gtk_object_set_data (GTK_OBJECT (widget), "scrollable", (gpointer) 0);
    }
  }

  /*  */  
  te_draw_image (image_list, width, height);
}

/* ************************************************************************* *
 * ǡؿ
 * ************************************************************************* */

/* TEImage *********************************************************** */
TEImage*
te_image_new (char	*filename,
	      int	id,
	      int	inner_data) {
  TEImage	*ti;

  /* ΰ */
  ti = (TEImage *) malloc (sizeof (TEImage));
  if (!ti) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    return NULL;
  }
  /* եޥåȤĴ٤ */
  if (inner_data) {
    if (strcmp (filename, "-") == 0) {
      ti->format = FORMAT_TEO;
    } else {
      ti->format = FORMAT_PPM;
    }
  } else {
    ti->format = what_format_is_this (filename);
    if (ti->format == FORMAT_UNKNOWN) {
      free (ti);
      return NULL;
    }
  }
  /* Ф */
  ti->filename	= g_strdup (filename);
  ti->id	= id;
  ti->teofp	= NULL;
  ti->orig_data	= NULL;
  ti->curr_data = NULL;
  ti->pbuf	= NULL;
  ti->pix_list	= NULL;
  ti->msk_list  = NULL;
  ti->pixmap	= NULL;
  ti->mask	= NULL;
  ti->inner_data= inner_data;

  if (!opt->display_mode) {
    ti->mod = (GdkPixbufModifier *) malloc (sizeof (GdkPixbufModifier));
    ti->mod->mod.gamma		= 256;
    ti->mod->mod.brightness	= 256;
    ti->mod->mod.contrast	= 256;    
    ti->mod->rmod.gamma		= 256;
    ti->mod->rmod.brightness	= 256;
    ti->mod->rmod.contrast	= 256;    
    ti->mod->gmod.gamma		= 256;
    ti->mod->gmod.brightness	= 256;
    ti->mod->gmod.contrast	= 256;    
    ti->mod->bmod.gamma		= 256;
    ti->mod->bmod.brightness	= 256;
    ti->mod->bmod.contrast	= 256;
    ti->mod->map		= NULL;
    gdk_pixbuf_calc_map_tables (ti->mod);
  }
  
  return ti;
}

/* TEImageǡ ***************************************************** */
int
te_image_load_image (GList	*list,
		     int	frame,
		     double	min,
		     double	max) {
  int	w, h;
  
  /* GdkPixbuf */
  if (!te_image_create_data (list, frame, min, max, &w, &h)) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    return FALSE;
  }
  /* ץѥƥ */
  te_image_set_orig_width (list, w);
  te_image_set_orig_height(list, h);
  te_image_set_curr_width (list, w);
  te_image_set_curr_height(list, h);

  /* TEOǤлꤵ줿ե졼򥻥å */
  if (te_image_get_format (list) == FORMAT_TEO && 
      te_image_get_teofp (list)) {
    te_image_set_frame (list, (frame == -1) ?
			(TeoFrame (te_image_get_teofp (list)) - 1) : frame);
  } else {
    te_image_set_frame (list, 0);
  }
  te_image_set_plane (list, -1);
  
  return TRUE;
}

/* GdkPixbuf ********************************************************* */
int
te_image_create_data (GList	*list,
		      int	frame,
		      double	min,
		      double	max,
		      int	*width,
		      int	*height) {
  TEImage	*ti;
  GdkPixbuf	*pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  char		*filename;
  unsigned char	*ptr;
  char		*buf, *ext;
  int		n;
  
  /* TEImage¤Τγ */
  ti = te_image_get_image (list);
  
  /* ե̾γ */
  filename = te_image_get_full_filename (list);

  /* GdkPixbuf */
  if (!opt->display_mode) {                        /* ɽ⡼ɤǤϤʤ */
    if (te_image_get_format (list) == FORMAT_TEO) {   /* ե뤬TEOξ */
      /* TEOɤ߹ */
      if (!ti->teofp) ti->teofp = TeoOpenFile (filename);
      if (!ti->teofp) {
	fprintf (stderr, _("Can not open file %s\n"), filename);
	return 0;
      }
      /* ץ졼ĤɤĴ٤ */
      buf = TeoGetUserExtension (ti->teofp, "hasAlphaPlane");
      ti->has_alpha = 0;
      if (buf && strcmp (buf, "yes") == 0) ti->has_alpha = 1;

      /* ꥸʥǡΰ */
      ti->orig_data = TeoAllocSimilarImage (ti->teofp);
      if (!ti->orig_data) {
	fprintf (stderr, _("Can not allocate enough memory.\n"));
	TeoCloseFile (ti->teofp);
	return 0;
      }
      /* ե졼λ꤬ФΥե졼򥻥åȤ */
      if (frame < TeoFrame (ti->teofp) && frame >= 0) {
	TeoSetAbsFrame (ti->teofp, frame);
      } else if (frame == -1) {
	TeoSetAbsFrame (ti->teofp, TeoFrame (ti->teofp)-1);
      }
      /* ǡΥ */
      TeoReadFrame (ti->teofp, ti->orig_data);
    
      /* TEOGdkPixbufؤѴ */
      ti->pbuf = teo2gdk_pixbuf_new_from_teoimage (ti->orig_data,
						   min, max, ti->has_alpha);
      if (!ti->pbuf) {
	TeoCloseFile (ti->teofp);
	TeoFreeImage (ti->orig_data);
	fprintf (stderr, _("Can not allocate enough memory.\n"));
	return 0;
      }
    } else {					  /* ե뤬TEOʳξ */
      /* ɤ߹ */
      if (!ti->pbuf) {
#if 0
	if (te_image_get_format (list) == FORMAT_EPS) {
	  GdkPixbuf	**tmp;
	  int		i, pages;

	  tmp = load_ps_image (filename, &pages);
	  ti->pbuf = gdk_pixbuf_copy (tmp[0]);
	  for (i = 0; i < pages; i++) gdk_pixbuf_unref (tmp[i]);
	  free (tmp);
	} else if (te_image_get_format (list) == FORMAT_WMF) {
	  ti->pbuf = load_wmf_image (filename);
	} else {
	  ti->pbuf = gdk_pixbuf_new_from_file (filename);
	}
#else
	ti->pbuf = gdk_pixbuf_new_from_file_extension (filename);
#endif
      }
      if (!ti->pbuf) {
	fprintf (stderr, _("Can not allocate enough memory.\n"));
	return 0;
      }
      /* ץ졼ĤɤĴ٤ */
      ti->has_alpha = gdk_pixbuf_get_has_alpha (ti->pbuf);
    
      /* ꥸʥǡ */
      ti->orig_data =
	teo2gdk_pixbuf_convert_to_teoimage (ti->pbuf, ti->has_alpha);
    }
    /* 礭 */
    *width = gdk_pixbuf_get_width (ti->pbuf);
    *height= gdk_pixbuf_get_height(ti->pbuf);

    /* ɽTEOǡΰ */
    ti->curr_data = TeoAllocImage (TeoWidth  (ti->orig_data),
				   TeoHeight (ti->orig_data),
				   min, max, TEO_UNSIGNED, 8,
				   3 + ti->has_alpha);
    /* ɽTEOǡGdkPixbufǡؤΥ */
    free (ti->curr_data->data);
    ti->curr_data->data = (void *) gdk_pixbuf_get_pixels (ti->pbuf);
  } else {                                               /* ɽ⡼ɤξ */
    if (te_image_get_format (list) == FORMAT_TEO) {   /* ե뤬TEOξ */
      /* TEOɤ߹ */
      ti->teofp = TeoOpenFile (filename);
      if (!ti->teofp) {
	fprintf (stderr, _("Can not open file %s\n"), filename);
	return 0;
      }
      /* ץ졼ĤɤĴ٤ */
      buf = TeoGetUserExtension (ti->teofp, "hasAlphaPlane");
      ti->has_alpha = 0;
      if (buf && strcmp (buf, "yes") == 0) ti->has_alpha = 1;

      /* ꥸʥǡΰ */
      ti->orig_data = TeoAllocSimilarImage (ti->teofp);
      if (!ti->orig_data) {
	fprintf (stderr, _("Can not allocate enough memory.\n"));
	TeoCloseFile (ti->teofp);
	return 0;
      }
      /* ƥե졼ΥǡϿ */
      for (n = 0; n < TeoFrame (ti->teofp); n++) {
	/* ե졼ǡɤ߹ */
	TeoReadFrame (ti->teofp, ti->orig_data);
	/* GdkPixbuf */
	pbuf = teo2gdk_pixbuf_new_from_teoimage (ti->orig_data, min, max,
						 ti->has_alpha);
	if (!pbuf) {
	  TeoCloseFile (ti->teofp);
	  ti->teofp = NULL;
	  TeoFreeImage (ti->orig_data);
	  ti->orig_data = NULL;
	  fprintf (stderr, _("Can not allocate enough memory.\n"));
	  return 0;
	}
	/* 礭 */
	*width = gdk_pixbuf_get_width (pbuf);
	*height= gdk_pixbuf_get_height(pbuf);
	
	/* ԥåޥåפ */
	gdk_pixbuf_render_pixmap_and_mask (pbuf, &pixmap, &mask, 255);

	/* ꥹȤɲ */
	ti->pix_list = g_list_append (ti->pix_list, (gpointer) pixmap);
	ti->msk_list = g_list_append (ti->msk_list,   (gpointer) mask);

	/* GdkPixbufΰ */
	gdk_pixbuf_unref (pbuf);
      }
      /* ƬΥǡ򥻥å */
      ti->pixmap = (GdkPixmap *) g_list_first (ti->pix_list)->data;
      ti->mask   = (GdkBitmap *) g_list_first (ti->msk_list)->data;      
      
      /* TEOեΥ */
      TeoCloseFile (ti->teofp);
      ti->teofp = NULL;
      TeoFreeImage (ti->orig_data);
      ti->orig_data = NULL;
    } else {
      /* ɤ߹ */
#if 0
      if (te_image_get_format (list) == FORMAT_WMF) {
	pbuf = load_wmf_image (filename);
      } else {
	pbuf = gdk_pixbuf_new_from_file (filename);
      }
#else
      pbuf = gdk_pixbuf_new_from_file_extension (filename);
#endif
      if (!pbuf) {
	fprintf (stderr, _("Can not allocate enough memory.\n"));
	return 0;
      }
      /* ץ졼ĤɤĴ٤ */
      ti->has_alpha = gdk_pixbuf_get_has_alpha (pbuf);
    
      /* 礭 */
      *width = gdk_pixbuf_get_width (pbuf);
      *height= gdk_pixbuf_get_height(pbuf);
      
      /* ԥåޥåפ */
      gdk_pixbuf_render_pixmap_and_mask (pbuf, &pixmap, &mask, 255);

      /* ꥹȤɲ */
      ti->pix_list = g_list_append (ti->pix_list, (gpointer) pixmap);
      ti->msk_list = g_list_append (ti->msk_list, (gpointer) mask);
      ti->pixmap = (GdkPixmap *) g_list_first (ti->pix_list)->data;
      ti->mask   = (GdkBitmap *) g_list_first (ti->msk_list)->data;      
      
      /* GdkPixbufΰ */
      gdk_pixbuf_unref (pbuf);
    }
  }
  return 1;
}

/* ꤷɽ ****************************************************** */
void
te_image_set_image (GList	*list,
		    int		frame) {
  GtkWidget	*canvas;
  int		w, h;
  
  if (!list) return;

  if (opt->display_mode) {
    if (frame != -1) {
      te_image_set_pixlist_nth (list, frame);
      te_image_set_msklist_nth (list, frame);
      te_image_set_frame (list, frame);
    } else {
      te_image_set_pixlist_last (list);
      te_image_set_msklist_last (list);
      te_image_set_frame (list,
			  g_list_length
			  (g_list_first (te_image_get_pixlist (list)))-1);
    }
    te_image_set_pixmap (list);
    te_image_set_mask   (list);
  } else {
    if (!te_image_get_pbuf (list) ||
	(te_image_get_teofp (list) &&
	 TeoFrame (te_image_get_teofp (list)) > 2)) {
      te_image_load_image (list, frame, opt->min, opt->max);
    } 
  }
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  if (canvas) {
    w = te_image_get_curr_width (list);
    h = te_image_get_curr_height(list);
    te_image_set_image_size (image_window, w, h);
    gtk_widget_set_usize (canvas, w, h);    
  }
}

/* nܤΥե졼 *********************************************** */
void
te_image_create_frame_data (GList	*list,
			    int		frame) {
  TEOFILE	*teofp;

  /* TEOǤʤв⤷ʤ */
  teofp = te_image_get_teofp (list);
  if (!teofp) return;

  /* ꤵ줿ե졼ϰϳʤ鲿⤷ʤ */
  if (frame < 0 || frame >= TeoFrame (teofp)) return;

  /* ߤβǡβ */
  te_image_clear_image (list);

  /* ǡ */
  te_image_load_image (list, frame, opt->min, opt->max);
}

/* nܤΥץ졼 *********************************************** */
void
te_image_create_plane_data (GList	*list,
			    int		plane) {
  TEOIMAGE	*src, *dst;
  int		row, col, p;

  /* ץ졼 */
  src = te_image_get_curr_data (list);
  dst = te_image_get_curr_data (list);

  for (row = TeoYstart (dst); row <= TeoYend (dst); row++) {
    for (col = TeoXstart (dst); col <= TeoXend (dst); col++) {
      for (p = 0; p < 3; p++) {
        TeoPutPixel (dst, col, row, p, TEO_UINT8,
                     (TEO_UINT8) TeoGetPixel (src, col, row, plane,TEO_UINT8));
      }
      if (te_image_get_has_alpha (list)) {
        TeoPutPixel (dst, col, row, 3, TEO_UINT8,
                     (TEO_UINT8) TeoGetPixel (src, col, row, 3, TEO_UINT8));
      }
    }
  }
}

/* ************************************************************************* *
 * ǡؿ
 * ************************************************************************* */

/* ǡβ ******************************************************** */
void
te_image_clear_image (GList	*list) {
  TEImage	*te;

  /* TEImageγ */
  te = te_image_get_image (list);
  
  /* ǡϲʤ */
  if (te_image_get_inner_data (list) &&
      te_image_get_format (list) != FORMAT_TEO) return;

  /* GdkPixbufǡβ */
  if (te->pbuf) {
    gdk_pixbuf_unref (te->pbuf);
    te->pbuf = NULL;
  }
  /* ꥸʥǡβ */
  if (te->orig_data) {
    TeoFreeImage (te->orig_data);
    te->orig_data = NULL;
  }
  /* ɽѥǡβ */
  if (te->curr_data) {
    te->curr_data->data = NULL;
    TeoFreeImage (te->curr_data);
    te->curr_data = NULL;
  }
  /* ꥹȥǡβ */
  if (te->pix_list) {
    g_list_free (te->pix_list);
    te->pix_list = NULL;
  }
  if (te->msk_list) {
    g_list_free (te->msk_list);
    te->msk_list = NULL;
  }
  te->pixmap = NULL;
  te->mask   = NULL;
}

/* ǡβ ******************************************************** */
void
te_image_destroy_image (GList	*list) {
  TEImage	*te;

  /* TEImageγ */
  te = te_image_get_image (list);
  
  /* GdkPixbufǡβ */
  if (te->pbuf) {
    gdk_pixbuf_unref (te->pbuf);
    te->pbuf = NULL;
  }
  /* TEOեΥ */
  if (te->teofp) {
    TeoCloseFile (te->teofp);
    te->teofp = NULL;
  }
  /* ꥸʥǡβ */
  if (te->orig_data) {
    TeoFreeImage (te->orig_data);
    te->orig_data = NULL;
  }
  /* ɽѥǡβ */
  if (te->curr_data) {
    te->curr_data->data = NULL;
    TeoFreeImage (te->curr_data);
    te->curr_data = NULL;
  }
  /* ꥹȥǡβ */
  if (te->pix_list) {
    g_list_free (te->pix_list);
    te->pix_list = NULL;
  }
  if (te->msk_list) {
    g_list_free (te->msk_list);
    te->msk_list = NULL;
  }
  te->pixmap = NULL;
  te->mask   = NULL;

  /* Modifierβ */
  if (te->mod) {
    if (te->mod->map) free (te->mod->map);
    free (te->mod);
    te->mod = NULL;
  }
}

/* ************************************************************************* *
 * ꥹȤؤɲáؿ
 * ************************************************************************* */

/* ߤΥꥹȤ˿ɲä ************************************** */
int
te_image_add_image_list (GList	*list,
			 char	*filename,
			 int	id,
			 int	inner_data) {
  TEImage	*img;

  /*  */
  img = te_image_new (filename, id, inner_data);
  if (!img) return FALSE;

  /* ꥹȤɲ */
  list = g_list_append (list, (gpointer) img);
  
  return TRUE;
}

/* ߤΥꥹȤꤵ줿 ******************************** */
int
te_image_delete_image_list (GList	*list,
			    int		id) {
  return TRUE;
}

/* ****************************************************** End of image.c *** */
