/* ************************************************************* image.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-04 17:53:53 sugaya>
 * ************************************************************************* */
#ifndef	_TE_IMAGE_H_
#define	_TE_IMAGE_H_

/* ************************************************************************* *
 * TEImage¤ΤΥФ˥ޥ
 * ************************************************************************* */
#define	te_image_get_image(list)	((TEImage *) (list)->data)
#define	te_image_get_full_filename(list)(((TEImage *)(list)->data)->filename)
#define	te_image_get_id(list)		(((TEImage *)(list)->data)->id)
#define	te_image_get_format(list)	(((TEImage *)((list))->data)->format)
#define	te_image_get_frame(list)	(((TEImage *)(list)->data)->frame)
#define	te_image_get_plane(list)	(((TEImage *)(list)->data)->plane)
#define	te_image_get_has_alpha(list)	(((TEImage *)(list)->data)->has_alpha)
#define	te_image_get_orig_width(list)	(((TEImage *)(list)->data)->orig_width)
#define	te_image_get_orig_height(list) (((TEImage *)(list)->data)->orig_height)
#define	te_image_get_curr_width(list)	(((TEImage *)(list)->data)->width)
#define	te_image_get_curr_height(list)	(((TEImage *)(list)->data)->height)
#define	te_image_get_teofp(list)	(((TEImage *)(list)->data)->teofp)
#define	te_image_get_orig_data(list)	(((TEImage *)(list)->data)->orig_data)
#define	te_image_get_curr_data(list)	(((TEImage *)(list)->data)->curr_data)
#define	te_image_get_pbuf(list)		(((TEImage *)(list)->data)->pbuf)
#define	te_image_get_pixlist(list)	(((TEImage *)(list)->data)->pix_list)
#define	te_image_get_msklist(list)	(((TEImage *)(list)->data)->msk_list)
#define	te_image_get_pixmap(list)	(((TEImage *)(list)->data)->pixmap)
#define	te_image_get_mask(list)		(((TEImage *)(list)->data)->mask)
#define	te_image_get_modifier(list)	(((TEImage *)(list)->data)->mod)
#define	te_image_get_inner_data(list)	(((TEImage *)(list)->data)->inner_data)

#define	te_image_set_format(list, val) \
	(((TEImage *) (list)->data)->format = (val))
#define	te_image_set_frame(list, val) \
	(((TEImage *) (list)->data)->frame = (val))
#define	te_image_set_plane(list, val) \
	(((TEImage *) (list)->data)->plane = (val))
#define	te_image_set_orig_width(list, val) \
	(((TEImage *) (list)->data)->orig_width = (val))
#define	te_image_set_orig_height(list, val) \
	(((TEImage *) (list)->data)->orig_height = (val))
#define	te_image_set_curr_width(list, val) \
	(((TEImage *) (list)->data)->width = (val))
#define	te_image_set_curr_height(list, val) \
	(((TEImage *) (list)->data)->height = (val))
#define	te_image_set_pixmap(list) \
	(((TEImage *) (list)->data)->pixmap = \
        ((GdkPixmap *) ((TEImage *) (list)->data)->pix_list->data))
#define	te_image_set_mask(list) \
	(((TEImage *) (list)->data)->mask = \
        ((GdkBitmap *) ((TEImage *) (list)->data)->msk_list->data))
#define	te_image_set_pixlist_nth(list,val) \
       	(((TEImage *) (list)->data)->pix_list = \
        g_list_nth (g_list_first (((TEImage *) (list)->data)->pix_list),(val)))
#define	te_image_set_pixlist_first(list) \
	(((TEImage *) (list)->data)->pix_list = \
        g_list_first (((TEImage *) (list)->data)->pix_list))
#define	te_image_set_pixlist_previous(list) \
	(((TEImage *) (list)->data)->pix_list = \
        g_list_previous (((TEImage *) (list)->data)->pix_list))
#define	te_image_set_pixlist_next(list) \
	(((TEImage *) (list)->data)->pix_list = \
        g_list_next (((TEImage *) (list)->data)->pix_list))
#define	te_image_set_pixlist_last(list) \
	(((TEImage *) (list)->data)->pix_list = \
        g_list_last (((TEImage *) (list)->data)->pix_list))
#define	te_image_set_msklist_nth(list,val) \
       	(((TEImage *) (list)->data)->msk_list = \
        g_list_nth (g_list_first (((TEImage *) (list)->data)->msk_list),(val)))
#define	te_image_set_msklist_first(list) \
	(((TEImage *) (list)->data)->msk_list = \
        g_list_first (((TEImage *) (list)->data)->msk_list))
#define	te_image_set_msklist_previous(list) \
	(((TEImage *) (list)->data)->msk_list = \
        g_list_previous (((TEImage *) (list)->data)->msk_list))
#define	te_image_set_msklist_next(list) \
	(((TEImage *) (list)->data)->msk_list = \
        g_list_next (((TEImage *) (list)->data)->msk_list))
#define	te_image_set_msklist_last(list) \
	(((TEImage *) (list)->data)->msk_list = \
        g_list_last (((TEImage *) (list)->data)->msk_list))

/* ************************************************************************* */
char*		te_image_get_filename 		(GList		*list);

GList*		te_image_get_list_from_filename (GList		*list,
						 char		*filename);

void		te_image_set_size 		(GtkWidget	*widget,
						 int		width,
						 int		height);

void		te_image_set_image_size 	(GtkWidget	*widget,
						 gint		width,
						 gint		height);

TEImage*	te_image_new	 		(char		*filename,
						 int		id,
						 int		inner_data);

void		te_image_set_image 		(GList		*list,
						 int		frame);

void		te_image_create_frame_data 	(GList		*list,
						 int		frame);

void		te_image_create_plane_data	(GList		*list,
						 int		plane);

void		te_image_clear_image 		(GList		*list);

void		te_image_destroy_image 		(GList		*list);

int		te_image_add_image_list 	(GList		*list,
						 char		*filename,
						 int		id,
						 int		inner_data);

int		te_image_delete_image_list	(GList		*list,
						 int		id);

#endif	/* _TE_IMAGE_H_ */

/* ****************************************************** End of image.h *** */
