/* ******************************************************** image_list.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/11/14 11:34:01 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkicon.h"
#include "gtkiconlist.h"
#include "stock_open.xpm"
#include "stock_refresh.xpm"
#include "stock_reload.xpm"
#include "stock_trash.xpm"
#include "stock_properties.xpm"
#include "stock_close.xpm"
#include "stock_first_arrow3.xpm"
#include "stock_left_arrow3.xpm"
#include "stock_right_arrow3.xpm"
#include "stock_last_arrow3.xpm"

#define	ICON_WIDTH	160
#define	ICON_HEIGHT	120

/* ************************************************************************* */
static void
te_image_list_delete_list 		(void);
static void
te_image_list_window_hide 		(GtkWidget	*widget,
					 gpointer	data);
static void
te_image_list_mouse_press		(GtkWidget	*widget,
					 GdkEventButton	*event,
					 gpointer	data);
static GtkWidget*
te_image_list_icon_new 			(GList		*list,
					 int		frame);
static GtkWidget*
te_image_list_icon_new_for_teo		(TEOFILE	*teo,
					 int		frame);
static GtkWidget*
te_image_list_icon_box_new 		(GList		*list,
					 GtkWidget	*parent,
					 int		frame,
					 int		can_expand);
static GtkWidget*
te_image_list_icon_box_new_for_teo	(TEOFILE	*teo,
					 GList		*list,
					 GtkWidget	*parent,
					 int		frame,
					 int		can_expand);
static void
te_image_list_add_thumbnail 		(GtkWidget	*window,
					 GtkWidget	*box);
static GtkWidget*
te_image_list_component_toolbar_new 	(void);

/* ꥹȤ򤵤줿 ********************************** */
static void
te_image_list_delete_list (void) {
  GList		*this = NULL;
  GList		*prev = NULL;
  GList		*next = NULL;
  char		*filename;
  char		*src_ptr;
  char		*dst_ptr;  
  char		buf[MAX_STRING_MDL_LINE];

  /* 򤵤Ƥ̾ */
  filename = (char *)
    gtk_object_get_data (GTK_OBJECT (list_window), "selected_filename");
  if (!filename) return;

  /* ޥե졼ɤĴ٤ */
  src_ptr = filename;
  dst_ptr = buf;
  while (*src_ptr != ';') *dst_ptr++ = *src_ptr++;
  *dst_ptr = '\0';
  if (atoi (buf) != 0) return;
    
  /* ꥹȤγ */
  filename = strrchr (filename, ';') + 1;  
  this = te_image_get_list_from_filename (image_list, filename);
  if (!this) return;
  prev = g_list_previous (this);
  next = g_list_next     (this);

  /* ˲ʤϺʤ */
  if (!prev && !next) return;

  /* ߤΥꥹȤκ */
  if (prev) prev->next = next;
  if (next) next->prev = prev;

  /* ǡβ */
  te_image_destroy_image (this);

  /* ɽ */
  if (this == image_list) {
    image_list = (next) ? next : prev;

    gtk_object_set_data (GTK_OBJECT (image_window), "id",
			 (gpointer) te_image_get_id (image_list));

    if (!te_image_get_pbuf (image_list)) {
      te_image_load_image (image_list, 0, opt->min, opt->max);
    }

    /* ɥѹ */
    gtk_widget_set_usize ((GtkWidget *)
			  gtk_object_get_data (GTK_OBJECT (image_window),
					       "canvas"),
			  te_image_get_orig_width  (image_list),
			  te_image_get_orig_height (image_list));
			
    /* ɽ */
    te_image_set_image_size (image_window,
			     te_image_get_orig_width  (image_list),
			     te_image_get_orig_height (image_list));
  }

  /* ͥι */
  te_image_list_refresh_list ();

  /*  */
  gtk_object_set_data (GTK_OBJECT (list_window), "selected_filename", NULL);
}

/* ꥹȥɥĤ ******************************************** */
static void
te_image_list_window_hide (GtkWidget	*widget,
			   gpointer	data) {
  gtk_widget_destroy (list_window);
  list_window = NULL;
}

/* ************************************************************************* */
static void
te_image_list_mouse_press (GtkWidget		*widget,
			   GdkEventButton	*event,
			   gpointer		data) {
  GtkWidget	*ebox = NULL;
  GtkWidget	*icon_box;
  GList		*list;
  char		*filename;
  char		*file;
  int		frame;
  
  /*  */
  {
    /* 򤵤Ƥ̾ */
    filename = (char *)
      gtk_object_get_data (GTK_OBJECT (list_window), "selected_filename");

    /*  */
    if (filename) {
      ebox = (GtkWidget *)
	gtk_object_get_data (GTK_OBJECT (list_window), filename);
      if (ebox) {
	icon_box = (GtkWidget *)
	  gtk_object_get_data (GTK_OBJECT (ebox), "icon_box");
	if (icon_box)
	  gtk_frame_set_shadow_type (GTK_FRAME (icon_box), GTK_SHADOW_NONE);
	gtk_object_set_data (GTK_OBJECT (list_window),"selected_filename",
			     NULL);
      }
    }    
    /*  */
    if (widget != ebox) {
      icon_box = (GtkWidget *)
	gtk_object_get_data (GTK_OBJECT (widget), "icon_box");
      if (icon_box)
	gtk_frame_set_shadow_type (GTK_FRAME (icon_box),
				   GTK_SHADOW_ETCHED_OUT);
      
      /* 򤵤줿̾Ͽ */
      filename = (char *)
	gtk_object_get_data (GTK_OBJECT (widget), "filename");
      gtk_object_set_data (GTK_OBJECT (list_window),
			   "selected_filename", filename);
    }
  }  
  /* ֥륯å줿,βɽ */
  if (event->type == GDK_2BUTTON_PRESS) {
    switch (event->button) {
    case 1:
      filename = (char *)
	gtk_object_get_data (GTK_OBJECT (widget), "filename");
      if (filename) {
	file  = strrchr (filename, ';') + 1;
	frame = (int) gtk_object_get_data (GTK_OBJECT (widget), "frame");
	image_list = te_image_get_list_from_filename (image_list, file);
	if (image_list) {
	  if (frame == 0) {
	    te_image_set_image (image_list, 0);
	  } else {
	    te_image_create_frame_data (image_list, frame);
	    /*  */
	    te_draw_image (image_list,
			   te_image_get_curr_width  (image_list),
			   te_image_get_curr_height (image_list));
	  }
	}
      }
      break;
    case 3:
      if ((int) gtk_object_get_data (GTK_OBJECT (widget), "can_expand")) {
	if (!(int) gtk_object_get_data (GTK_OBJECT (widget), "expanded")) {
	  gtk_widget_show ((GtkWidget *)
			   gtk_object_get_data (GTK_OBJECT (widget),
						"group_box"));
	  gtk_object_set_data (GTK_OBJECT (widget), "expanded", (gpointer) 1);
	} else {
	  gtk_widget_hide ((GtkWidget *)
			   gtk_object_get_data (GTK_OBJECT (widget),
						"group_box"));
	  gtk_object_set_data (GTK_OBJECT (widget), "expanded", (gpointer) 0);
	}
      }
      break;
    }
  }
}

/* ͥ ******************************************************** */
static GtkWidget*
te_image_list_icon_new (GList	*list,
			int	frame) {
  GdkPixbuf	*pbuf, *spbuf;
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;
  int		ow, oh, sw, sh;  

  /* ꥸʥǡγ */
  if (te_image_get_pbuf (list)) {
    pbuf = te_image_get_pbuf (list);
  } else {
#if 0
    pbuf = gdk_pixbuf_new_from_file (te_image_get_full_filename (list));
#else
    pbuf =
      gdk_pixbuf_new_from_file_extension (te_image_get_full_filename (list));
#endif
  }
  /* ꥸʥǡ礭 */  
  ow = gdk_pixbuf_get_width (pbuf);
  oh = gdk_pixbuf_get_height(pbuf);

  /* ͥǡ礭 */  
  if (ow <= ICON_WIDTH && oh <= ICON_HEIGHT) {
    sw = ow;
    sh = oh;
  } else if (ow > ICON_WIDTH && oh > ICON_HEIGHT) {
    if (ow > oh) {
      sw = ICON_WIDTH;
      sh = sw * oh / ow;
    } else {
      sh = ICON_HEIGHT;
      sw = sh * ow / oh;
    }
  } else if (ow > ICON_WIDTH) {
    sw = ICON_WIDTH;
    sh = sw * oh / ow;
  } else if (oh > ICON_HEIGHT) {
    sh = ICON_HEIGHT;
    sw = sh * ow / oh;    
  }
  /* ͥǡ */    
  spbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, sw, sh);
  gdk_pixbuf_composite_color (pbuf, spbuf, 0, 0, sw, sh, 0, 0,
			      (double) sw / ow, (double) sh / oh,
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  gdk_pixbuf_render_pixmap_and_mask (spbuf, &pix, &msk, 255);  
  icon = gtk_pixmap_new (pix, msk);

  if (!te_image_get_pbuf (list)) gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (spbuf);
  gdk_pixmap_unref (pix);
  if (msk) gdk_bitmap_unref (msk);
  
  return icon;
}

/* ͥ ******************************************************** */
static GtkWidget*
te_image_list_icon_new_for_teo (TEOFILE	*teofp,				
				int	frame) {
  GdkPixbuf	*pbuf, *spbuf;
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;
  char		*buf;
  int		ow, oh, sw, sh;  

  /* ץ졼ĤɤĴ٤ */
  buf = TeoGetUserExtension (teofp, "hasAlphaPlane");

  /* ꥸʥǡγ */
  pbuf =
    teo2gdk_pixbuf_new_from_teofile (teofp, frame, opt->min, opt->max,
				     (buf && (strcmp (buf, "yes")==0) ? 1:0));

  /* ꥸʥǡ礭 */  
  ow = gdk_pixbuf_get_width (pbuf);
  oh = gdk_pixbuf_get_height(pbuf);

  /* ͥǡ礭 */    
  if (ow <= ICON_WIDTH && oh <= ICON_HEIGHT) {
    sw = ow;
    sh = oh;
  } else if (ow > ICON_WIDTH && oh > ICON_HEIGHT) {
    if (ow > oh) {
      sw = ICON_WIDTH;
      sh = sw * oh / ow;
    } else {
      sh = ICON_HEIGHT;
      sw = sh * ow / oh;
    }
  } else if (ow > ICON_WIDTH) {
    sw = ICON_WIDTH;
    sh = sw * oh / ow;
  } else if (oh > ICON_HEIGHT) {
    sh = ICON_HEIGHT;
    sw = sh * ow / oh;    
  }
  /* ͥǡ */    
  spbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, sw, sh);
  gdk_pixbuf_composite_color (pbuf, spbuf, 0, 0, sw, sh, 0, 0,
			      (double) sw / ow, (double) sh / oh,
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  gdk_pixbuf_render_pixmap_and_mask (spbuf, &pix, &msk, 255);
  icon = gtk_pixmap_new (pix, msk);

  gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (spbuf);
  gdk_pixmap_unref (pix);
  if (msk) gdk_bitmap_unref (msk);
  
  return icon;
}

/* ܥå ************************************************** */
static GtkWidget*
te_image_list_icon_box_new (GList	*list,
			    GtkWidget	*parent,
			    int		frame,
			    int		can_expand) {
  GtkWidget	*icon_box;
  GtkWidget	*ebox;
  GtkWidget	*icon;
  char		buf[MAX_STRING_LNG_LINE];
  
  /* ܥå */
  icon_box = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (icon_box), GTK_SHADOW_NONE);
  gtk_container_set_border_width (GTK_CONTAINER (icon_box), 2);
  {    
    /* ٥ȥܥå */
    ebox = gtk_event_box_new ();
    gtk_widget_set_events (ebox, GDK_BUTTON_PRESS_MASK);
    gtk_signal_connect (GTK_OBJECT (ebox), "button_press_event",
			GTK_SIGNAL_FUNC (te_image_list_mouse_press), NULL);
    gtk_container_add (GTK_CONTAINER (icon_box), ebox);
    gtk_widget_show (ebox);
    {
      /* ٥ȥܥå˾ղ */
      sprintf (buf, "%d;%s", frame, te_image_get_full_filename (list));
      gtk_object_set_data (GTK_OBJECT (parent), strdup (buf), ebox);
      gtk_object_set_data (GTK_OBJECT (ebox), "filename", strdup (buf));
      gtk_object_set_data (GTK_OBJECT (icon_box), "ebox", ebox);
      gtk_object_set_data (GTK_OBJECT (ebox), "icon_box", icon_box);
      gtk_object_set_data (GTK_OBJECT (ebox), "can_expand",
			   (gpointer) can_expand);
      gtk_object_set_data (GTK_OBJECT (ebox), "expanded", (gpointer) 0);
      gtk_object_set_data (GTK_OBJECT (ebox), "frame", (gpointer) frame);
    }
    /* ɲ */
    icon = te_image_list_icon_new (list, 0);
    gtk_container_add (GTK_CONTAINER (ebox), icon);
    gtk_widget_show (icon);
  }
  return icon_box;
}

/* ܥå ************************************************** */
static GtkWidget*
te_image_list_icon_box_new_for_teo (TEOFILE	*teo,
				    GList	*list,
				    GtkWidget	*parent,
				    int		frame,
				    int		can_expand) {
  GtkWidget	*icon_box;
  GtkWidget	*ebox;
  GtkWidget	*icon;
  char		buf[MAX_STRING_LNG_LINE];
  
  /* ܥå */
  icon_box = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (icon_box), GTK_SHADOW_NONE);
  gtk_container_set_border_width (GTK_CONTAINER (icon_box), 2);
  {    
    /* ٥ȥܥå */
    ebox = gtk_event_box_new ();
    gtk_widget_set_events (ebox, GDK_BUTTON_PRESS_MASK);
    gtk_signal_connect (GTK_OBJECT (ebox), "button_press_event",
			GTK_SIGNAL_FUNC (te_image_list_mouse_press), NULL);
    gtk_container_add (GTK_CONTAINER (icon_box), ebox);
    gtk_widget_show (ebox);
    {
      /* ٥ȥܥå˾ղ */
      sprintf (buf, "%d;%s", frame, te_image_get_full_filename (list));
      gtk_object_set_data (GTK_OBJECT (parent), strdup (buf), ebox);
      gtk_object_set_data (GTK_OBJECT (ebox), "filename", strdup (buf));
      gtk_object_set_data (GTK_OBJECT (icon_box), "ebox", ebox);      
      gtk_object_set_data (GTK_OBJECT (ebox), "icon_box", icon_box);
      gtk_object_set_data (GTK_OBJECT (ebox),
			   "can_expand", (gpointer) can_expand);
      gtk_object_set_data (GTK_OBJECT (ebox), "expanded", (gpointer) 0);
      gtk_object_set_data (GTK_OBJECT (ebox), "frame", (gpointer) frame);
    }
    /* ɲ */
    icon = te_image_list_icon_new_for_teo (teo, frame);
    gtk_container_add (GTK_CONTAINER (ebox), icon);
    gtk_widget_show (icon);
  }
  return icon_box;
}

/* ͥɲ ******************************************************** */
static void
te_image_list_add_thumbnail (GtkWidget	*window,
			     GtkWidget	*box) {
  GList		*list;
  GtkWidget	*icon_box;
  GtkWidget	*group_box;
  GtkWidget	*ebox;
  GtkWidget	*icon;
  TEOFILE	*teofp;
  int		n, flg = 0;

  list = g_list_first (image_list);

  while (list) {
    if (te_image_get_format (list) == FORMAT_TEO) {
      if ((teofp = te_image_get_teofp (list)) == NULL) {
	teofp = TeoOpenFile (te_image_get_full_filename (list));
	flg = 1;
      }
      icon_box =
	te_image_list_icon_box_new_for_teo (teofp, list, window, 0,
					    (TeoFrame (teofp) > 1) ? 1 : 0);
      gtk_box_pack_start (GTK_BOX (box), icon_box, FALSE, FALSE, 5);
      gtk_widget_show (icon_box);
      if (TeoFrame (teofp) > 1) {
	group_box = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), group_box, FALSE, FALSE, 0);
	gtk_object_set_data (GTK_OBJECT
			     (gtk_object_get_data (GTK_OBJECT (icon_box),
						   "ebox")),
			     "group_box", group_box);
	for (n = 1; n < TeoFrame (teofp); n++) {
	  icon_box =
	    te_image_list_icon_box_new_for_teo (teofp, list, window, n, 0);
	  gtk_box_pack_start (GTK_BOX (group_box), icon_box, FALSE, FALSE, 5);
	  gtk_widget_show (icon_box);	  
	}
      }
      if (flg) TeoCloseFile (teofp);
    } else {
      icon_box = te_image_list_icon_box_new (list, window, 0, 0);
      gtk_box_pack_start (GTK_BOX (box), icon_box, FALSE, FALSE, 5);
      gtk_widget_show (icon_box);
    }
    list = g_list_next (list);
  }
}

/* ġС ******************************************************** */
static GtkWidget*
te_image_list_component_toolbar_new (void) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GtkWidget	*button;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_widget_ref (handlebox);
  gtk_handle_box_set_handle_position (GTK_HANDLE_BOX (handlebox),
				      GTK_POS_LEFT);
  {
    /* ġС */
    toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
    gtk_widget_ref (toolbar);    
    gtk_toolbar_set_space_style (GTK_TOOLBAR (toolbar),GTK_TOOLBAR_SPACE_LINE);
    gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 10);
    gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
    gtk_object_set_data (GTK_OBJECT (handlebox), "toolbar", toolbar);
    gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
    gtk_widget_show (toolbar);
    {
      /* Ĥץܥ */
      icon = gtk_icon_new_with_label (_("Close"), stock_close,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_set_usize (icon, 48, -1);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Close"),
			       _("Close image list viewer"),
			       _("Close image list viewer"),
			       icon,
			       te_image_list_window_hide,
			       NULL);

      /* ֳץܥ */
      icon = gtk_icon_new_with_label (_("Open"), stock_open,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);      
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Open"), 
			       _("Open a new file"),
			       _("Open a new file"),
			       icon,
			       te_menu_cb_file_open,
			       NULL);

      /* ֥Ȣץܥ */
      icon = gtk_icon_new_with_label (_("Trash"), stock_trash,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Trash"), 
			       _("Delete a image from list"),
			       _("Delete a image from list"),
			       icon,
			       te_image_list_delete_list,
			       NULL);

      /* ֲꥹȤιץܥ */
      icon = gtk_icon_new_with_label (_("Refresh"), stock_reload,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Refresh"),
			       _("Refresh current list"),
			       _("Refresh current list"),
			       icon,
			       te_image_list_refresh_list,
			       NULL);

      /* ץܥ */
      icon = gtk_icon_new_with_label (_("Preference"), stock_properties,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Property"), 
			       _("Configure teoeyes properety"),
			       _("Configure teoeyes properety"),
			       icon,
			       te_menu_cb_preference,
			       NULL);

      /* ֡ץܥ */
      icon = gtk_icon_new_with_label (_("First Image"), stock_first_arrow3,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("First Image"), 
			       _("View the first image in the list"),
			       _("View the first image in the list"),
			       icon,
			       te_menu_cb_view_top_image,
			       NULL);

      /* ֡ץܥ */
      icon = gtk_icon_new_with_label (_("Previous Image"), stock_left_arrow3,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Previous Image"), 
			       _("View the previous image in the list"),
			       _("View the previous image in the list"),
			       icon,
			       te_menu_cb_view_prev_image,
			       NULL);

      /* ֡ץܥ */
      icon = gtk_icon_new_with_label (_("Next Image"), stock_right_arrow3,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Next Image"), 
			      _("View the next image in the list"),
			      _("View the next image in the list"),
			       icon,
			       te_menu_cb_view_next_image,
			       NULL);

      /* ֡ץܥ */
      icon = gtk_icon_new_with_label (_("Last Image"), stock_last_arrow3,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_ref (icon);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Last Image"), 
			       _("View the last image in the list"),
			       _("View the last image in the list"),
			       icon,
			       te_menu_cb_view_bottom_image,
			       NULL);
    }
  }
  return handlebox;
}

/* ꥹȥɥΥͥι ******************************** */
void
te_image_list_refresh_list (void) {
  GtkWidget	*box;
  GtkWidget	*swindow;
  
  box = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (list_window), "box");
  swindow = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (list_window), "swindow");
  
  gtk_widget_hide (box);
  gtk_widget_destroy (box);

  box = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (list_window), "box", box);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (swindow),
					 box);
  gtk_widget_show (box);
  te_image_list_add_thumbnail (list_window, box);
}

/* ꥹȥɥ ********************************************** */
GtkWidget*
te_image_list_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*handlebox;
  GtkWidget	*box;
  GtkWidget	*separator;
  GtkWidget	*swindow;
  GtkWidget	*iconlist;
  gchar		*title = _("TeoEyes Image List Viewer");

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_ref (window);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) te_image_list_window_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) te_image_list_window_hide, NULL);
  
  /* ȥ */
  gtk_window_set_title (GTK_WINDOW (window), title);
  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (window), box);
  {
    /* ϥɥܥå */
    handlebox = te_image_list_component_toolbar_new ();
    gtk_widget_show (handlebox);
    gtk_box_pack_start (GTK_BOX (box), handlebox, FALSE, TRUE, 0);

    /* ѥ졼 */
    separator = gtk_hseparator_new ();
    gtk_widget_show (separator);
    gtk_box_pack_start (GTK_BOX (box), separator, FALSE, TRUE, 3);

    /* 륦ɥ */
    swindow = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_ref (swindow);    
    gtk_object_set_data (GTK_OBJECT (window), "swindow", swindow);    
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow),
				    GTK_POLICY_ALWAYS,
				    GTK_POLICY_NEVER);
    gtk_widget_show (swindow);
    gtk_box_pack_start (GTK_BOX (box), swindow, TRUE, TRUE, 0);
    {
      /* ܥå */
      box = gtk_hbox_new (FALSE, 0);
      gtk_widget_ref (box);
      gtk_object_set_data (GTK_OBJECT (window), "box", box);
      gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (swindow),
					     box);
      gtk_widget_show (box);

      /* ͥɲ */
      te_image_list_add_thumbnail (window, box);

      /* 򤵤줿Ͽ (Ϥ̤) */
      gtk_object_set_data (GTK_OBJECT (window), "selected_filename", NULL);
    }
  }
  return window;
}

/* ************************************************* End of image_list.c *** */
