/* ************************************************************** info.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/07/22 18:24:03 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <sys/stat.h>

#include "gtkiconbutton.h"

#include "TEO.xpm"
#include "PNM.xpm"
#include "GIF.xpm"
#include "JPEG.xpm"
#include "TIFF.xpm"
#include "XPM.xpm"
#include "PNG.xpm"
#include "BMP.xpm"
#include "stock_button_close.xpm"

/* եޥå ************************************************************ */
static char*
FormatString[12] = {
  "TEO","PPM","PGM","PNG","JPEG","GIF","TIFF","XPM","XBM","BMP","EPS","WMF"
};

/* Υ ******************************************** */
static void
te_info_dialog_hide (GtkWidget	*widget,
		     gpointer	*data) {
  gtk_widget_hide (info_dialog);  
}

/*  ************************************************ */
GtkWidget*
te_info_dialog_new (void) {
  GtkWidget	*window;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;
  GtkWidget	*hbox;
  GtkWidget	*notebook;  
  GtkWidget	*icon;
  GtkWidget	*label[11];
  GtkWidget	*widget;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  int		n = 0;
  
  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_title  (GTK_WINDOW (window), _("Image Info Dialog"));
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) te_info_dialog_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) te_info_dialog_hide, NULL);
  {
    vbox1 = gtk_vbox_new (FALSE, 5);
    gtk_container_add (GTK_CONTAINER (window), vbox1);
    gtk_container_border_width (GTK_CONTAINER (vbox1), 5);
    gtk_widget_show (vbox1);
    {
      /* Ρȥ֥å */
      notebook = gtk_notebook_new ();
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
      gtk_box_pack_start (GTK_BOX (vbox1), notebook, FALSE, FALSE, 0);
      gtk_widget_show (notebook);
      {
	vbox2 = gtk_vbox_new (FALSE, 5);
	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
	gtk_widget_show (vbox2);
	{
	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /*  */
	    pixmap = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
						   &mask, NULL, bmp_icon);
	    icon = gtk_pixmap_new (pixmap, mask);
	    gtk_box_pack_start (GTK_BOX (hbox), icon, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (icon), 0.0, 0.5);
	    gtk_widget_show (icon);
	    
	    /* ٥ (ե̾) */
	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }
	  widget = gtk_hseparator_new ();
	  gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, TRUE, 0);
	  gtk_widget_show (widget);

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (ե륵) */
	    widget = gtk_label_new (_("File Size"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ () */
	    widget = gtk_label_new (_("Update"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  widget = gtk_hseparator_new ();
	  gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, TRUE, 0);
	  gtk_widget_show (widget);

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (եޥå) */
	    widget = gtk_label_new (_("Format"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (礭) */
	    widget = gtk_label_new (_("Image Size"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (ͤΥ) */
	    widget = gtk_label_new (_("Pixel Range"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (ե졼) */
	    widget = gtk_label_new (_("Frame"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n++]);
	  }

	  hbox = gtk_hbox_new (TRUE, 0);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {
	    /* ٥ (ץ졼) */
	    widget = gtk_label_new (_("Plane"));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
	    gtk_widget_show (widget);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    gtk_widget_show (label[n]);
	  }

	}
	/* ٥ (ȥ) */
	widget = gtk_label_new (_("Image Info"));
	gtk_widget_show (widget);
      }
      gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox2, widget);

      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (vbox1), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ٥ (OK) */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
      gtk_widget_show (hbox);
	
      widget = gtk_icon_button_new_with_label (_("Close"),
					       stock_button_close,
					       GTK_ICON_BUTTON_TEXT_RIGHT,5);
      gtk_widget_set_usize (widget, 100, -1);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_info_dialog_hide), NULL);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (widget);
    }
  }

  /* åȤΥå */
  gtk_object_set_data (GTK_OBJECT (window), "icon",   (gpointer) icon);
  gtk_object_set_data (GTK_OBJECT (window), "label0", (gpointer) label[0]);
  gtk_object_set_data (GTK_OBJECT (window), "label1", (gpointer) label[1]);
  gtk_object_set_data (GTK_OBJECT (window), "label2", (gpointer) label[2]);
  gtk_object_set_data (GTK_OBJECT (window), "label3", (gpointer) label[3]);
  gtk_object_set_data (GTK_OBJECT (window), "label4", (gpointer) label[4]);
  gtk_object_set_data (GTK_OBJECT (window), "label5", (gpointer) label[5]);
  gtk_object_set_data (GTK_OBJECT (window), "label6", (gpointer) label[6]);
  gtk_object_set_data (GTK_OBJECT (window), "label7", (gpointer) label[7]);
  gtk_object_set_data (GTK_OBJECT (window), "label8", (gpointer) label[8]);
  gtk_object_set_data (GTK_OBJECT (window), "label9", (gpointer) label[9]);  
  gtk_object_set_data (GTK_OBJECT (window), "label10", (gpointer) label[10]);
  gtk_object_set_data (GTK_OBJECT (window), "label11", (gpointer) label[11]);
  
  return window;
}

/* Υå ******************************************************** */
void
te_info_set_info (GtkWidget	*dialog,
		  GList		*list) {
  TEOFILE	*teo;
  TEOIMAGE	*data;
  GtkWidget	*icon;
  GtkWidget	*label[10];
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  int		format;
  int		plane;
  int		i, n = 0;
  char		*path;  
  char		buf[MAX_STRING_MDL_LINE];
  double	min, max;

  /* ե̾γ */
  teo    = te_image_get_teofp (list);
  data	 = te_image_get_curr_data (list);
  format = te_image_get_format (list);
  path   = te_image_get_full_filename (list);
  
  /* Υå */
  icon = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "icon");
  gtk_pixmap_get (GTK_PIXMAP (icon), &pixmap, &mask);
  gdk_pixmap_unref (pixmap);
  gdk_bitmap_unref (mask);
  
  switch (format) {
  case FORMAT_TEO:
    pixmap
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,teo_icon);
    break;
  case FORMAT_PPM:
  case FORMAT_PGM:    
    pixmap
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,pnm_icon);
    break;
  case FORMAT_PNG:
    pixmap 
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,png_icon);
    break;
  case FORMAT_JPEG:
    pixmap
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask,NULL,jpeg_icon);
    break;
  case FORMAT_GIF:
    pixmap
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,gif_icon);
    break;
  case FORMAT_TIFF:
    pixmap 
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask,NULL,tiff_icon);
    break;
  case FORMAT_XPM:
  case FORMAT_XBM:    
    pixmap
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,xpm_icon);
    break;
  case FORMAT_BMP:
    pixmap 
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,bmp_icon);
    break;
  case FORMAT_EPS:
    pixmap 
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,bmp_icon);
    break;
  case FORMAT_WMF:
    pixmap 
      = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(), &mask, NULL,bmp_icon);
    break;
  }
  gtk_pixmap_set (GTK_PIXMAP (icon), pixmap, mask);

  /* ٥륦åȤγ */
  label[0] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label0");
  label[1] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label1");
  label[2] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label2");
  label[3] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label3");
  label[4] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label4");
  label[5] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label5");
  label[6] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label6");
  label[7] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label7");
  label[8] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label8");
  label[9] = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (dialog), "label9");
    
  /* ե̾Υå */
  {
    char	*filename;

    if (te_image_get_filename (list)) {
      sprintf (buf, "%s", te_image_get_filename (list));
    } else {
      sprintf (buf, "%s", "no name");
    }
    gtk_label_set (GTK_LABEL (label[n++]), buf);
  }

  /* ե륵Υå */
  sprintf (buf, "%d %s", y_file_filesize (path),_("Bytes"));
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* եιΥå */
  gtk_label_set (GTK_LABEL (label[n++]), y_file_moddate_string (path));

  /* եեޥåȤΥå */
  if (!teo) {
    sprintf (buf, "%s", FormatString[format]);
  } else {
    switch (TeoType (teo)) {
    case (TEO_UNSIGNED):
      sprintf (buf, "%s (%s%d)", 
	       FormatString[format], "U", TeoBit (teo));
      break;
    case (TEO_SIGNED):
      sprintf (buf, "%s (%s%d)", 
	       FormatString[format], "S", TeoBit (teo));
      break;
    case (TEO_FLOAT):
      sprintf (buf, "%s (%s%d)", 
	       FormatString[format], "F", TeoBit (teo));
      break;
    }
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* Υå */
  sprintf (buf, "%dx%d (%d:%d, %d:%d)", 
	   te_image_get_curr_width  (list),
	   te_image_get_curr_height (list),
	   TeoXoffset (data),
	   TeoXoffset (data) + te_image_get_curr_width  (list) - 1,
	   TeoYoffset (data),
	   TeoYoffset (data) + te_image_get_curr_height (list) - 1);
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* ͤΥ󥸤Υå */
  TeoGetPixelRange (te_image_get_orig_data (list), &min, &max);
  if (!teo || TeoType (te_image_get_orig_data (list)) != TEO_FLOAT) {
    sprintf (buf, "[%d: %d]", (long) min, (long) max);
  } else {
    sprintf (buf, "[%.5le: %.5le]", min, max);
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* ե졼Υå */
  sprintf (buf, "%d / %d",
	   te_image_get_frame (list) + 1, (!teo) ? 1 : TeoFrame (teo));
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* ץ졼Υå */
  plane = te_image_get_plane (image_list);
  if (plane == -1) {
    sprintf (buf, "%d", (teo) ?
	     TeoPlane (teo) : ((te_image_get_has_alpha (list)) ? 4 : 3));
  } else {
    sprintf (buf, "%d / %d", plane + 1, (teo) ?
	     TeoPlane (teo) : ((te_image_get_has_alpha (list)) ? 4 : 3));
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);
}

/* ******************************************************* End of info.c *** */
