/* ************************************************************** init.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2002-01-18 10:54:19 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* 饤֥ν ****************************************************** */
void
te_init_library (int	argc,
		 char	**argv) {

  /*  */
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
  gtk_set_locale ();

  /* GTK饤֥ν */
  gtk_init (&argc, &argv);

  /* gdk_imlib饤֥ν */
  gdk_imlib_init ();
  
  /* Gdk-pixbuf饤֥ν */
  gdk_rgb_init ();
}

/* եɤ߹ ************************************************** */
TeoeyesConfig*
te_init_config (void) {
  TeoeyesConfig	*tc;
  char		*path, *filename, *thumb_dir;

  /* եΤǥ쥯ȥ */
  path = (char *)
    malloc (sizeof (char) * (strlen (y_dir_homedir ()) +
			     strlen (CONFIG_FILE_DIR) + 2));
  sprintf (path, "%s/%s", y_dir_homedir (), CONFIG_FILE_DIR);

  /* ǥ쥯ȥ꤬ʤк */
  if (!y_file_exist_file (path)) y_dir_make_dir (path);

  /* ե뤬¸ߤʤк */
  filename = (char *)
    malloc (sizeof (char) * (strlen (path) + strlen (CONFIG_FILE) + 2));
  sprintf (filename, "%s/%s", path, CONFIG_FILE);
  if (!y_file_exist_file (filename)) {

    /* ɸեɤ߹ */
    tc = te_preference_load (TEOEYES_CONFIG);

    /* ͥ¸ѤΥǥ쥯ȥ */
    thumb_dir = (char *)
      malloc (sizeof (char) * (strlen (y_dir_homedir ()) +
			       strlen (CONFIG_FILE_DIR) +
			       strlen ("icons")+3));
    sprintf (thumb_dir, "%s/%s/icons", y_dir_homedir (), CONFIG_FILE_DIR);
    if (tc->thumb_dir) free (tc->thumb_dir);
    tc->thumb_dir = g_strdup (thumb_dir);
    g_free (thumb_dir);
    
    /* եι */
    te_preference_save (tc, filename);
    te_preference_free (tc);
  }
  /* եΥСå */
  if (te_preference_check_version (filename) == 0) {
    /* ǧ */
    if (te_confirm_box_show (NULL,
			     _("Confirm"),
			     _("This config file may be for old version.\n"
			       "Are you sure replacing to new version's one?"))
	== FALSE) return NULL;

    /* եΥС󤬸Ťϡե򹹿 */
    te_preference_update_file (filename);
  }
  /* եΥ */
  tc = te_preference_load (filename);

  free (path);
  free (filename);
  
  return tc;
}
	    
/* ץν ****************************************************** */
Option*
te_init_option (void) {
  Option	*opt;

  opt = (Option *) malloc (sizeof (Option));
  opt->load_image	= tc->opt_load_image;
  opt->clear_data	= tc->opt_clear_data;
  opt->normalize	= tc->opt_normalize;
  opt->quick_draw	= tc->opt_quick_draw;
  opt->display_mode	= tc->opt_display_mode;
  opt->frame		= 0;
  opt->draw_background	= 0;
  opt->min		= 0;
  opt->max		= 0;  
  opt->geo		= NULL;
  opt->skin_data	= tc->skin_data;

  return opt;
}
/* ******************************************************* End of init.c *** */
