/* ************************************************************* loope.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/03/26 00:00:01 sugaya>
 * ************************************************************************* */
#include "config.h"
#include "teoeyes.h"
#include "stock_loope.xpm"

static void	gtk_radio_menu_item_activate	(GtkMenuItem	*menu_item);

static void	te_loope_change_size 		(GtkWidget	*widget,
						 gpointer	scale);

/* ************************************************************************* *
 * ɥФ륳Хåؿ
 * ************************************************************************* */

/* ѹ٥ ****************************************************** */
static int
te_loope_cb_configure (GtkWidget		*widget,
		       GdkEventConfigure	*ev) {
  int	x, y, rx, ry, scale;
  
  x	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "x");
  y	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "y");
  rx	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "rx");
  ry	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "ry");
  scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
  te_draw_loope_image (widget, image_list, x, y, rx, ry, scale);
  
  return TRUE;
}

/* 襤٥ ********************************************************** */
static int
te_loope_cb_expose (GtkWidget		*widget,
		    GdkEventExpose	*ev) {
  int	x, y, rx, ry, scale;
  
  x	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "x");
  y	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "y");
  rx	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "rx");
  ry	= (int) gtk_object_get_data (GTK_OBJECT (image_window), "ry");
  scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
  te_draw_loope_image (widget, image_list, x, y, rx, ry, scale);
  
  return FALSE;
}

/* ܥ󤬲줿ν ************************************************ */
static int
te_loope_cb_mouse_press (GtkWidget	*widget,
			 GdkEventButton	*ev) {
  int	x, y, rx, ry, ox, oy, scale;
  
  switch (ev->button) {
  case MOUSE_LEFT:	/* ܥ󤬲줿Ȥν */
    scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
    x	  = (int) ev->x / scale - SW_WIDTH  / (scale * 2) + 1;
    y     = (int) ev->y / scale - SW_HEIGHT / (scale * 2) + 1;
    rx    = SW_WIDTH  / 2 - (1 - x) * scale;
    ry    = SW_HEIGHT / 2 - (1 - y) * scale;
    ox	  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "x");
    oy	  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "y");

    te_draw_loope_image (widget, image_list, ox, oy, rx, ry, scale);
    te_pixel_window_show (ox + x, oy + y, (ev->state == 0) ?
			  PIXEL_ORIG_VAL : PIXEL_CURR_VAL,
			  ((GdkWindowPrivate *) ev->window)->xwindow,
			  ((GdkWindowPrivate *) ev->window)->xdisplay,
			  ev->time);
    
    gtk_object_set_data (GTK_OBJECT (image_window), "rx",    (gpointer) rx);
    gtk_object_set_data (GTK_OBJECT (image_window), "ry",    (gpointer) ry);
    gtk_object_set_data (GTK_OBJECT (image_window), "scale", (gpointer) scale);

    break;

  case MOUSE_CENTER:	/* ܥ󤬲줿Ȥν */
    gtk_widget_hide (loope);
    break;

  case MOUSE_RIGHT:	/* ܥ󤬲줿Ȥν */
    gtk_menu_popup (GTK_MENU (gtk_object_get_data (GTK_OBJECT (loope),"menu")),
		    NULL, NULL, NULL, NULL, ev->button, ev->time);
    break;
  case 4:
    scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
    if (scale != 2) {
      te_loope_change_size (widget, (gpointer) (scale/2));
    }
    break;
  case 5:
    scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");    
    if (scale != 128) {
      te_loope_change_size (widget, (gpointer) (scale*2));
    }
    break;
  }
  return TRUE;
}

/* ޥưν **************************************** */
static int
te_loope_cb_mouse_motion (GtkWidget		*widget,
			  GdkEventMotion 	*ev) {
  int	x, y, rx, ry, ox, oy, scale;
  GdkModifierType	state;
  
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
  } else {
    x = (int) ev->x;
    y = (int) ev->y;
  }
  if ((state & GDK_BUTTON1_MASK) != 0) {
    scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
    x	  = x / scale - SW_WIDTH  / (scale * 2) + 1;
    y     = y / scale - SW_HEIGHT / (scale * 2) + 1;
    rx    = SW_WIDTH  / 2 - (1 - x) * scale;
    ry    = SW_HEIGHT / 2 - (1 - y) * scale;
    ox	  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "x");
    oy	  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "y");

    te_draw_loope_image (widget, image_list, ox, oy, rx, ry, scale);
    te_pixel_window_show (ox + x, oy + y, (ev->state == 256) ?
			  PIXEL_ORIG_VAL : PIXEL_CURR_VAL,
			  ((GdkWindowPrivate *) ev->window)->xwindow,
			  ((GdkWindowPrivate *) ev->window)->xdisplay,
			  ev->time);
    
    gtk_object_set_data (GTK_OBJECT (image_window), "rx",    (gpointer) rx);
    gtk_object_set_data (GTK_OBJECT (image_window), "ry",    (gpointer) ry);
    gtk_object_set_data (GTK_OBJECT (image_window), "scale", (gpointer) scale);
  }
  return TRUE;
}


/* Ψѹ ************************************************************ */
static void
te_loope_change_size (GtkWidget		*widget,
		      gpointer		scale) {
  int	rx, ry;

  /* 롼ڥѹ */
  gtk_object_set_data (GTK_OBJECT (image_window), "scale", (gpointer) scale);

  /* ɸη׻ */
  rx = SW_WIDTH  / 2 - (int) scale;
  ry = SW_HEIGHT / 2 - (int) scale;
  gtk_object_set_data (GTK_OBJECT (image_window), "rx", (gpointer) rx);
  gtk_object_set_data (GTK_OBJECT (image_window), "ry", (gpointer) ry);

  /*  */
  te_draw_loope_image ((GtkWidget*) 
		       gtk_object_get_data (GTK_OBJECT (loope),  "canvas"),
		       image_list, -1, -1, rx, ry, (int) scale);
}

/* ݥåץåץ˥塼 ********************************************** */
static GtkIconItemFactoryEntry
menu_items[] =
{
  /* ȥ */
  {"/Tearoff",		NULL, NULL, NULL, 0, "<Tearoff>"},
  {N_("/Loope Size"),	stock_loope, NULL, NULL, 0, "<Title>"},
  {"/separator",	NULL, NULL, NULL, 0, "<Separator>"},

  {N_("/x   2"),	NULL,
   NULL,	te_loope_change_size,	2,	"<RadioItem>"},
  {N_("/x   4"),	NULL,
   NULL,	te_loope_change_size,	4,	N_("/x   2")},
  {N_("/x   8"),	NULL,
   NULL,	te_loope_change_size,	8,	N_("/x   2")},
  {N_("/x  16"),	NULL,	
   NULL,	te_loope_change_size,	16,	N_("/x   2")},
  {N_("/x  32"),	NULL,
   NULL,	te_loope_change_size,	32,	N_("/x   2")},
  {N_("/x  64"),	NULL,
   NULL,	te_loope_change_size,	64,	N_("/x   2")},
  {N_("/x 128"),	NULL,
   NULL,	te_loope_change_size,	128,	N_("/x   2")}
};

/* ************************************************************************* */
static int
te_loope_scale_to_id (int	scale) {
  switch (scale) {
  case 2:
    return 0;
    break;
  case 4:
    return 1;
    break;
  case 8:
    return 2;
    break;
  case 16:
    return 3;
    break;
  case 32:
    return 4;
    break;
  case 64:
    return 5;
    break;
  case 128:
    return 6;
    break;
  default:
    return 0;
    break;
  }
}

/* ˥塼 ********************************************************** */
static GtkWidget*
te_loope_menu_new (GtkWidget	*window,
		   int		val) {
  int			items = sizeof (menu_items) / sizeof (menu_items[0]);
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;
  GtkWidget		*item;
  char			*menu_string[] = {N_("/x   2"), N_("/x   4"),
					  N_("/x   8"), N_("/x  16"),
					  N_("/x  32"), N_("/x  64"),
					  N_("/x 128")};
  int			n;
  
  accel_group	= gtk_accel_group_new ();
  item_factory	= gtk_icon_item_factory_new (GTK_TYPE_MENU,
					     "<sub>", accel_group);
  gtk_icon_item_factory_create_items (item_factory, items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));

  item = gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY(item_factory),
					   menu_string[0]);
  GTK_CHECK_MENU_ITEM (item)->active = 0;
  
  item =
    gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY (item_factory),
				      menu_string[te_loope_scale_to_id
						 (tc->default_loope_scale)]);
  GTK_CHECK_MENU_ITEM (item)->active = 1;
  gtk_radio_menu_item_activate (GTK_MENU_ITEM (item));

  return gtk_icon_item_factory_get_widget (item_factory, "<sub>");
}

/* 祦ɥ **************************************************** */
GtkWidget*
te_loope_new (char	*title,
	      int	w,
	      int	h) {
  GtkWidget	*window;
  GtkWidget	*canvas;
  GtkWidget	*menu;

  /* ɥ */  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  /* ȥ */
  gtk_window_set_title  (GTK_WINDOW (window), title);
  /* ɥ */
  gtk_widget_set_usize (window, w, h);
  /* ɥꥵ */
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);

  /* ɥꥢ åȤ */
  {
    /* åȤ */
    canvas = gtk_drawing_area_new ();
    /*  */
    gtk_drawing_area_size (GTK_DRAWING_AREA (canvas), w, h);
    /* ɥåȤإѥå */
    gtk_widget_show (canvas);
    gtk_container_add (GTK_CONTAINER (window), canvas);
    /* ̾Ͽ */
    gtk_object_set_data (GTK_OBJECT (window), "canvas", canvas);
    /* ٥ȥϥɥ */
    gtk_widget_set_events (canvas,
			   GDK_BUTTON_PRESS_MASK |
			   GDK_POINTER_MOTION_MASK |
			   GDK_POINTER_MOTION_HINT_MASK |
			   GDK_KEY_PRESS_MASK);
    /* ٥	-ե奢- */
    gtk_signal_connect (GTK_OBJECT (canvas), "configure_event",
			GTK_SIGNAL_FUNC (te_loope_cb_configure), NULL);
    /* ٥	-ݡ- */
    gtk_signal_connect (GTK_OBJECT (canvas), "expose_event",
			GTK_SIGNAL_FUNC (te_loope_cb_expose), NULL);
    /* ٥	-ޥץ쥹- */
    gtk_signal_connect (GTK_OBJECT (canvas), "button_press_event",
			GTK_SIGNAL_FUNC (te_loope_cb_mouse_press), NULL);
    /* ٥	-ޥ⡼- */
    gtk_signal_connect (GTK_OBJECT (canvas), "motion_notify_event",
			GTK_SIGNAL_FUNC (te_loope_cb_mouse_motion), NULL);
  }
  /* ݥåץåץ˥塼 */
  menu = te_loope_menu_new (window, 
			    (int) gtk_object_get_data (GTK_OBJECT 
						       (image_window),
						       "scale"));
  gtk_object_set_data (GTK_OBJECT (window), "menu", menu);

  return window;
}

/* ************************************************************************* *
 * GtkRadioMeuItemǻϤ˥ƥ֤ˤ륢ƥѹ뤿δؿ
 * 	(This function is included in gtk+-1.2.10/gtk/gtk/gtkradiomenuitem.c)
 * ************************************************************************* */
static void
gtk_radio_menu_item_activate (GtkMenuItem *menu_item)
{
  GtkRadioMenuItem *radio_menu_item;
  GtkCheckMenuItem *check_menu_item;
  GtkCheckMenuItem *tmp_menu_item;
  GSList *tmp_list;
  gint toggled;

  g_return_if_fail (menu_item != NULL);
  g_return_if_fail (GTK_IS_RADIO_MENU_ITEM (menu_item));

  radio_menu_item = GTK_RADIO_MENU_ITEM (menu_item);
  check_menu_item = GTK_CHECK_MENU_ITEM (menu_item);
  toggled = FALSE;

  if (check_menu_item->active)
    {
      tmp_menu_item = NULL;
      tmp_list = radio_menu_item->group;

      while (tmp_list)
	{
	  tmp_menu_item = tmp_list->data;
	  tmp_list = tmp_list->next;

	  if (tmp_menu_item->active && (tmp_menu_item != check_menu_item))
	    break;

	  tmp_menu_item = NULL;
	}

      if (tmp_menu_item)
	{
	  toggled = TRUE;
	  check_menu_item->active = !check_menu_item->active;
	}
    }
  else
    {
      toggled = TRUE;
      check_menu_item->active = !check_menu_item->active;

      tmp_list = radio_menu_item->group;
      while (tmp_list)
	{
	  tmp_menu_item = tmp_list->data;
	  tmp_list = tmp_list->next;

	  if (tmp_menu_item->active && (tmp_menu_item != check_menu_item))
	    {
	      gtk_menu_item_activate (GTK_MENU_ITEM (tmp_menu_item));
	      break;
	    }
	}
    }

  if (toggled)
    gtk_check_menu_item_toggled (check_menu_item);
  gtk_widget_queue_draw (GTK_WIDGET (radio_menu_item));
}

/* ****************************************************** End of loope.c *** */
