/* ************************************************************** main.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/03/23 00:27:01 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* ꤵ줿طʲȤ褷λ **************************** */
static void
set_background (GList	*list) {
  
  /* طʲ */
  te_draw_on_desktop (list, opt->draw_background);  

  /* β */
  list = g_list_first (list);
  while (list) {
    te_image_destroy_image (list);
    list = g_list_next (list);
  }
  /* λ */
  exit (1);
}

/* ꤵ줿եƥɤ ************************************** */
static void
load_all_images (GList	*list) {
  GtkWidget		*progress_window;
  GtkWidget		*progress_bar;    
  GtkWidget		*vbox;
  GtkWidget		*align;
  GtkAdjustment		*adj;
  GList			*tmplist;  
  int			count;
  int			max;
  int			w, h;

  count = 0;
  max = g_list_length (list);

  /* ץ쥹Сɽ */
  {
    progress_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy (GTK_WINDOW (progress_window), FALSE, FALSE, TRUE);
    gtk_window_set_title (GTK_WINDOW (progress_window),
			  _("Now loading images..."));
    gtk_container_set_border_width (GTK_CONTAINER (progress_window), 0);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
    gtk_container_add (GTK_CONTAINER (progress_window), vbox);
    gtk_widget_show (vbox);

    align = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_box_pack_start (GTK_BOX (vbox), align, FALSE, FALSE, 1);
    gtk_widget_show (align);

    adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, (float) max, 0, 0, 0);
    progress_bar = gtk_progress_bar_new_with_adjustment (adj);
    gtk_progress_set_format_string (GTK_PROGRESS (progress_bar), "%p%%");
    gtk_progress_set_show_text (GTK_PROGRESS (progress_bar), 1);
    gtk_container_add (GTK_CONTAINER (align), progress_bar);
    gtk_widget_show (progress_bar);

    gdk_window_get_size (GDK_ROOT_PARENT (), &w, &h);
    w = w / 2 - 100;
    h = h / 2;
    gtk_widget_set_usize (progress_window, 200, -1);
    gtk_widget_set_uposition (progress_window, w, h);
    gtk_widget_show (progress_window);
  }    

  /* Υ */
  while (list) {
    count++;
    gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar),
			     (float) count / max);
    while (gtk_events_pending ()) gtk_main_iteration ();

    if (!te_image_load_image (list, 0, opt->min, opt->max)) {
      tmplist		= list->prev;
      tmplist->next	= NULL;
      while (list) list = g_list_remove (list, (gpointer) (list->data));
      break;
    }
    list = g_list_next (list);
  }
  gtk_widget_hide    (progress_window);
  gtk_widget_destroy (progress_window);
}

/* ɥΥȥ (-gץ) ************************* */
static void
te_window_set_geometry (GtkWidget	*window,
			Option		*opt) {
  int	rx, ry, rw, rh, rd;
    
  if (opt->geo->width  != UNDEF_VAL && opt->geo->height != UNDEF_VAL) {
    gtk_widget_set_usize (window, opt->geo->width, opt->geo->height);
  }
  if (opt->geo->x != UNDEF_VAL && opt->geo->y != UNDEF_VAL) {
    gdk_window_get_geometry (GDK_ROOT_PARENT (), &rx, &ry, &rw, &rh, &rd);
    opt->geo->x = (opt->geo->xsign > 0) ?
      opt->geo->x :
      rw - ((opt->geo->width == UNDEF_VAL) ? 
	    te_image_get_orig_width (image_list) :
	    opt->geo->width) - opt->geo->x;
    opt->geo->y = (opt->geo->ysign > 0) ?
      opt->geo->y :
      rh - ((opt->geo->height == UNDEF_VAL) ?
	    te_image_get_orig_height (image_list) :
	    opt->geo->height) - opt->geo->y;
    gtk_widget_set_uposition (window, opt->geo->x,  opt->geo->y);
  }
}

/* ************************************************************************* */
int
main (int	argc,
      char	**argv) {
  TEImage	*ti;

  /* 饤֥ν */
  te_init_library (argc, argv);
  
  /* ѥ᡼ν */
  tc  = te_init_config ();
  if (!tc) exit (1);
  opt = te_init_option ();

  /* Υå */
  if (!getargs (argc, argv, &opt, &tc)) {
    usage (argv[0]);
    exit (0);
  }
  /* ƬΥץ */
  image_list = g_list_first (image_list);
  if (!te_image_load_image (image_list,
			    opt->frame, opt->min, opt->max)) exit(1);

  /* طʤؤ (-rootץ) */
  if (opt->draw_background) set_background (image_list);

  /* ƥɤ߹ (-lץ) */
  if (opt->load_image && image_list->next) {
    load_all_images (image_list->next);
  }
  image_list = g_list_first (image_list);
  
  /* ɥ */
  image_window = te_image_window_new (_("TeoEyes"),
				      te_image_get_curr_width  (image_list),
				      te_image_get_curr_height (image_list));

  /* ɥå&ɥåפ */
  te_dnd_drop_on_widget (image_window);
  
  /* ɥΥȥ (-g ץ) */
  if (opt->geo) te_window_set_geometry (image_window, opt);

  /* ɥɽ */
  gtk_widget_show (image_window);

  /* ᥤ롼 */
  gtk_main ();

  return 0;
}

/* ******************************************************* End of main.c *** */
