/* **************************************************** main_callbacks.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2002 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/03/26 00:28:03 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkabout.h"
#include "gtkdirtree.h"
#include "gtkiconitemfactory.h"
#include "gtkiconlist.h"

/* ֳץɽ ************************************************ */
void
te_menu_cb_file_open (GtkWidget	*widget,
		      gpointer	data) {
  if (!open_dialog) {
    open_dialog = te_open_dialog_new (_("Open File Selection"));
  }
  if (!GTK_WIDGET_VISIBLE (open_dialog)) gtk_widget_show (open_dialog);
}

/* ¸ ************************************************************** */
void
te_menu_cb_file_save (GtkWidget	*widget,
		      gpointer		data) {
  te_save_operation (te_image_get_full_filename (image_list), 1, 0);
}

/* ¸ץɽ (̾¸) *********************************** */
void
te_menu_cb_file_saveas (GtkWidget	*widget,
			gpointer	data) {
  te_save_dialog_show ();
}

/* ְץɽ ************************************************ */
void
te_menu_cb_file_print (GtkWidget	*widget,
		       gpointer	data) {
  GtkWidget	*print_dialog;
  
  print_dialog = te_print_dialog_new ();
  gtk_widget_show (print_dialog);
}

/* TeoEyesεư *********************************************************** */
void
te_menu_cb_file_run_teoeyes (GtkWidget	*widget,
			     gpointer	data) {
  te_open_file_with_new_window (NULL);
}

/* Ƭβɽ ********************************************************** */
void
te_menu_cb_view_top_image (GtkWidget	*widget,
			   gpointer	data) {
  image_list = g_list_first (image_list);
  te_image_set_image (image_list, 0);  
}

/* βɽ ************************************************************ */
void
te_menu_cb_view_prev_image (GtkWidget	*widget,
			    gpointer	data) {
  if (g_list_previous (image_list)) {
    image_list = g_list_previous (image_list);
    te_image_set_image (image_list, 0);
  }
}

/* βɽ ************************************************************ */
void
te_menu_cb_view_next_image (GtkWidget	*widget,
			    gpointer	data) {
  if (g_list_next (image_list)) {
    image_list = g_list_next (image_list);
    te_image_set_image (image_list, 0);
  }
}

/* βɽ ********************************************************** */
void
te_menu_cb_view_bottom_image (GtkWidget	*widget,
			      gpointer		data) {
  image_list = g_list_last (image_list);
  te_image_set_image (image_list, 0);  
}

/* ƬΥե졼ɽ ****************************************************** */
void
te_menu_cb_view_top_frame (GtkWidget	*widget,
			   gpointer	data) {
  if (opt->display_mode) {                               /* ɽ⡼ɤξ */
    /* ꥹȤ */
    te_image_set_pixlist_first (image_list);
    te_image_set_msklist_first (image_list);

    /* ǡΥå */
    te_image_set_pixmap (image_list);
    te_image_set_mask   (image_list);

    /* ߤΥե졼 */
    te_image_set_frame (image_list, 0);
  } else if (te_image_get_teofp (image_list)) {    /* ɽ⡼ɤǤϤʤ */
    te_image_create_frame_data (image_list, 0);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Υե졼ɽ ******************************************************** */
void
te_menu_cb_view_prev_frame (GtkWidget	*widget,
			    gpointer	data) {
  if (opt->display_mode) {                               /* ɽ⡼ɤξ */
    if (g_list_previous (te_image_get_pixlist (image_list)) &&
	g_list_previous (te_image_get_msklist (image_list))) {

      /* ꥹȤ */      
      te_image_set_pixlist_previous (image_list);
      te_image_set_msklist_previous (image_list);      

      /* ǡΥå */
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) - 1);
    }
  } else if (te_image_get_teofp (image_list)) {    /* ɽ⡼ɤǤϤʤ */
    te_image_create_frame_data (image_list,
				te_image_get_frame (image_list) - 1);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Υե졼ɽ ******************************************************** */
void
te_menu_cb_view_next_frame (GtkWidget	*widget,
			    gpointer	data) {
  if (opt->display_mode) {                               /* ɽ⡼ɤξ */
    if (g_list_next (te_image_get_pixlist (image_list)) &&
	g_list_next (te_image_get_msklist (image_list))) {

      /* ꥹȤ */            
      te_image_set_pixlist_next (image_list);
      te_image_set_msklist_next (image_list);

      /* ǡΥå */      
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) + 1);
    }
  } else if (te_image_get_teofp (image_list)) {    /* ɽ⡼ɤǤϤʤ */
    te_image_create_frame_data (image_list,
				te_image_get_frame (image_list) + 1);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Υե졼ɽ ****************************************************** */
void
te_menu_cb_view_bottom_frame (GtkWidget	*widget,
			      gpointer	data) {
  if (opt->display_mode) {                               /* ɽ⡼ɤξ */
    
    /* ꥹȤ */
    te_image_set_pixlist_last (image_list);
    te_image_set_msklist_last (image_list);      

    /* ǡΥå */
    te_image_set_pixmap (image_list);
    te_image_set_mask   (image_list);

    /* ߤΥե졼 */
    te_image_set_frame (image_list,
			g_list_length
			(g_list_first (te_image_get_pixlist (image_list)))-1);
  } else if (te_image_get_teofp (image_list)) {    /* ɽ⡼ɤǤϤʤ */
    te_image_create_frame_data (image_list,
				TeoFrame (te_image_get_teofp (image_list))-1);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* ץ졼ɽ⡼ڤؤ ********************************************** */
void
te_menu_cb_view_show_plane (GtkWidget	*widget,
			    gpointer	data) {
  int	plane;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  /* ץ졼⡼ɤĴ٤ */
  plane = te_image_get_plane (image_list);
  if (plane == -1) {
    /* ץ졼ɽ⡼ ON */
    te_image_set_plane (image_list, 0);
  } else {
    /* ץ졼ɽ⡼ OFF */    
    te_image_set_plane (image_list, -1);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Υץ졼ɽ ******************************************************** */
void
te_menu_cb_view_prev_plane (GtkWidget	*widget,
			    gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* ץ졼ɽ⡼ɤǤʤв⤷ʤ */
  if (te_image_get_plane (image_list) == -1) return;
  
  /* ɽΥץ졼ֹι */
  te_image_set_plane (image_list,
		      (te_image_get_plane (image_list) == 0) ?
		      (TeoPlane (te_image_get_orig_data (image_list)) - 1) :
		      (te_image_get_plane (image_list) - 1));
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Υץ졼ɽ ******************************************************** */
void
te_menu_cb_view_next_plane (GtkWidget	*widget,
			    gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* ץ졼ɽ⡼ɤǤʤв⤷ʤ */  
  if (te_image_get_plane (image_list) == -1) return;
  
  /* ɽΥץ졼ֹι */
  te_image_set_plane (image_list,
		      (te_image_get_plane (image_list) ==
		       (TeoPlane (te_image_get_orig_data (image_list)) - 1)) ?
		      0 : (te_image_get_plane (image_list) + 1));
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* ġСɽ() **************************************************** */
void
te_menu_cb_view_toolbar_top (GtkWidget	*widget,
			     gpointer	data) {
  te_toolbar_hide ();
  toolbar = te_toolbar_new ();
  te_toolbar_add ((GtkWidget *)
		  gtk_object_get_data (GTK_OBJECT (image_window), "top"),
		  toolbar);
  gtk_object_set_data (GTK_OBJECT (image_window), "toolbar_pos", (gpointer) 0);
}

/* ġСɽ() **************************************************** */
void
te_menu_cb_view_toolbar_bottom (GtkWidget	*widget,
				gpointer	data) {
  te_toolbar_hide ();
  toolbar = te_toolbar_new ();
  te_toolbar_add ((GtkWidget *)
		  gtk_object_get_data (GTK_OBJECT (image_window), "bottom"),
		  toolbar);
  gtk_object_set_data (GTK_OBJECT (image_window), "toolbar_pos", (gpointer) 1);
}

/* ġСɽ/ɽ ************************************************* */
void
te_menu_cb_view_toolbar (GtkWidget	*widget,
			 gpointer	data) {
  GtkWidget	*menu;
  GtkWidget	*item;

  /* ġСɽƤ */
  if ((int) gtk_object_get_data (GTK_OBJECT (image_window), "toolbar")) {
    /* ġС򱣤 */
    te_toolbar_hide ();
    gtk_object_set_data (GTK_OBJECT (image_window), "toolbar", (gpointer) 0);
    te_window_force_scrollable (image_window, 1);
    /* ˥塼󥻥󥷥ƥֲ */
    menu = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (image_window), "menu_items");
    if (menu) {
      item = gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY (menu),
					       N_("/View/Toggle ScrollBar"));
      if (item) {
	gtk_widget_set_sensitive (item, TRUE);
	gtk_check_menu_item_toggled (GTK_CHECK_MENU_ITEM (item));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), FALSE);
      }
    }
  } else {
    /* ġСɽƤʤ */    
    menu = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (image_window), "menu_items");    
    if (menu) {
      item = gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY (menu),
					       N_("/View/Toggle ScrollBar"));
      if (item) {
	/* 륦ɥǤʤХ륦ɥؤ */
	if (!((int) gtk_object_get_data (GTK_OBJECT (image_window),
					 "forcescroll"))) {
	  gtk_check_menu_item_toggled (GTK_CHECK_MENU_ITEM (item));
	  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
	  gtk_object_set_data (GTK_OBJECT (image_window), "forcescroll",
			       (gpointer) 1);
	  /* ˥塼󥻥󥷥ƥֲ */	
	  gtk_widget_set_sensitive (item, FALSE);
	}
      }
    }
    /* ġСɽ */    
    te_menu_cb_view_toolbar_top (NULL, NULL);    
    gtk_object_set_data (GTK_OBJECT (image_window), "toolbar", (gpointer) 1);
  }
}

/* ߤβǥȥåפطʤˤ ************************************ */
void
te_menu_cb_view_draw_desktop (GtkWidget	*widget,
			      gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  te_draw_on_desktop (image_list, DRAW_TILE);
}

/* 2ܤˤ *************************************************** */
void
te_menu_cb_size_double (GtkWidget	*widget,
			gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  te_operation_scaling_by_scale (image_list, 2.0, 2.0);
}

/* 1/2ܤˤ ************************************************* */
void
te_menu_cb_size_half (GtkWidget	*widget,
		      gpointer		data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  te_operation_scaling_by_scale (image_list, 0.5, 0.5);  
}

/* 1.1ܤˤ ************************************************* */
void
te_menu_cb_size_plus (GtkWidget	*widget,
		      gpointer		data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  te_operation_scaling_by_scale (image_list, 1.1, 1.1);  
}

/* 0.9ܤˤ ************************************************* */
void
te_menu_cb_size_minus (GtkWidget	*widget,
		       gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  te_operation_scaling_by_scale (image_list, 0.9, 0.9);    
}

/* ɥ **************************************************************** */
void
te_menu_cb_operation_undo (GtkWidget	*widget,
			   gpointer	data) {
  TEImage	*ti;
  GdkPixbuf	*pbuf;
  int		w, h;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  /* ߤΥǡ򥳥ԡ */
  pbuf = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  /* ߤΥǡ */
  if (backup) {
    gdk_pixbuf_unref (te_image_get_pbuf (image_list));

    /* Хååץǡ򥳥ԡ */
    ti = te_image_get_image (image_list);  
    ti->pbuf = gdk_pixbuf_copy (backup);
    ti->curr_data->data = (void *) gdk_pixbuf_get_pixels (ti->pbuf);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));

  /* ԡƤǡХååץǡȤ */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (pbuf);
  gdk_pixbuf_unref (pbuf);
}

/* ꥸʥɽ **************************************************** */
void
te_menu_cb_operation_original (GtkWidget	*widget,
			       gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));

  /* ǡΥԡ */
  teo2gdk_pixbuf_copy_to_pixbuf (te_image_get_orig_data (image_list),
				 te_image_get_pbuf (image_list),
				 opt->min, opt->max,
				 te_image_get_has_alpha (image_list));
  /*  */
  te_operation_scaling_by_size (image_list,
		 te_image_get_orig_width  (image_list),
		 te_image_get_orig_height (image_list));
}

/* 쥤 ************************************************************ */
void
te_menu_cb_operation_gray (GtkWidget	*widget,
			   gpointer	data) {
  TEOIMAGE	*tmp;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));

  /* 쥤ؤѴ */
  tmp = TeoCreateCopyImage (te_image_get_curr_data (image_list));
  if (tmp) {
    TeoRGB2Gray  (tmp, te_image_get_curr_data (image_list));
    TeoFreeImage (tmp);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* ͤȿž ************************************************************ */
void
te_menu_cb_operation_negative (GtkWidget	*widget,
			       gpointer	data) {
  TEOIMAGE	*tmp;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));

  tmp = TeoCreateCopyImage (te_image_get_curr_data (image_list));
  if (tmp) {
    TeoNegativeImage (tmp, te_image_get_curr_data (image_list));
    TeoFreeImage (tmp);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/*  ************************************************************ */
void
te_menu_cb_operation_normalize (GtkWidget	*widget,
				gpointer	data) {
  TEOIMAGE	*tmp;
  double	min, max;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  tmp = TeoCreateCopyImage (te_image_get_curr_data (image_list));
  if (tmp) {
    TeoGetPixelRange (tmp, &min, &max);
    TeoNormalImage (tmp, te_image_get_curr_data (image_list), min, max);
    TeoFreeImage (tmp);
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* οʿȿž ********************************************************** */
void
te_menu_cb_operation_flip_h (GtkWidget	*widget,
			     gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  /* οʿȿž */
  te_operation_flip_horizontal (image_list);
  
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* οľȿž ********************************************************** */
void
te_menu_cb_operation_flip_v (GtkWidget	*widget,
			     gpointer	data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));

  /* οľȿž */
  te_operation_flip_vertical (image_list);
  
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* Сɽڤؤ ******************************************** */
void
te_menu_cb_force_scrollable (GtkWidget	*widget,
			     gpointer	data) {
  int	forcescroll;

  forcescroll = (int)
    gtk_object_get_data (GTK_OBJECT (image_window), "forcescroll");
  if (forcescroll) {
    te_window_force_scrollable (image_window, 0);
  } else {
    te_window_force_scrollable (image_window, 1);
  }
}

/* ꥹȥӥ塼ɽ ************************************************ */
void
te_menu_cb_list_show (GtkWidget	*window,
			gpointer	data) {
  if (!list_window) list_window = te_image_list_window_new ();
  if (!GTK_WIDGET_VISIBLE (list_window)) gtk_widget_show (list_window);
}

/* ǥɽ ****************************************************** */
void
te_menu_cb_edit_show (GtkWidget	*window,
			gpointer	data) {
  GtkWidget	*button;
  if (opt->display_mode) return;
  if (!edit_window) edit_window = te_edit_window_new ();
  if (!GTK_WIDGET_VISIBLE (edit_window)) gtk_widget_show (edit_window);
  button = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "channel_button0");
  if (button) {
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), 1);
  }
  te_edit_draw_preview ();  
}

/* ץɽ ************************************************ */
void
te_menu_cb_browser_show (GtkWidget	*window,
			   gpointer	data) {
  char  *current_dir;
  char  *path;

  if (!browser) browser = te_browser_window_new ();
  if (!GTK_WIDGET_VISIBLE (browser->window)) gtk_widget_show (browser->window);

  current_dir = y_dir_get_current_dir ();
  path = (char *) malloc (sizeof (char) * (strlen (current_dir) + 3));
  sprintf (path, "%s/", current_dir);
  gtk_dir_tree_open_dir (GTK_DIR_TREE (browser->dir_tree), path);

  free (current_dir);
  free (path);
}

/* ᡼ץ졼Iɽ ************************************************* */
void
te_menu_cb_playerII_show (GtkWidget	*widget,
			  gpointer	data) {
  if (!playerII) playerII = te_playerII_new (opt->skin_data);
  te_playerII_sync_to_skin (playerII);
  gtk_widget_show (playerII);
  update_timer
    = gtk_timeout_add (50, (GtkFunction) te_playerII_update_window, NULL);
}

/* ƥȤɽ ******************************************** */
void
te_menu_cb_assistant_show (GtkWidget	*widget,
			   gpointer	data) {
  AssistantSkinData	*skin;
  int			rw, rh;

  if (!assistant) {
    assistant = te_assistant_new (tc->assistant_data);
  }
  gtk_widget_show (assistant);

  gdk_window_get_size (GDK_ROOT_PARENT (), &rw, &rh);
  skin = (AssistantSkinData *)
    gtk_object_get_data (GTK_OBJECT (assistant), "skin");
  gtk_widget_set_uposition (assistant,
			    rw - skin->width - 50, rh - skin->height - 50);
}

/* ɽ ************************************************ */
void
te_menu_cb_image_info (GtkWidget	*widget,
		       gpointer		data) {
  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  if (!info_dialog) info_dialog = te_info_dialog_new ();
  te_info_set_info (info_dialog, image_list);
  if (!GTK_WIDGET_VISIBLE (info_dialog)) gtk_widget_show (info_dialog);
}

/* ɽ **************************************************** */
void
te_menu_cb_preference (GtkWidget	*widget,
		       gpointer		data) {
  if (!preference_dialog) preference_dialog = te_preference_dialog_new ();
  if (!GTK_WIDGET_VISIBLE (preference_dialog)) {
    gtk_widget_show (preference_dialog);
  }
}

/* TeoEyesˤĤơץɽ ************************************* */
void
te_menu_cb_about (GtkWidget	*widget,
		  gpointer	data) {
  GtkWidget	*about;
  gchar		*author[] = {_("Yasuyuki SUGAYA"),
			     _("sugaya@suri.it.okayama-u.ac.jp"),
			     NULL};

  about = gtk_about_new (_("TeoEyes"),
			 VERSION,
			 _("Copyright (C) 1999-2002 Yasuyuki SUGAYA"),
			 author,
			 _("TEO Image Viewer\n"
			   "http://www.suri.it.okayama-u.ac.jp/~sugaya/teoeyes/"),
			 ABOUTLOGO);
  gtk_widget_show (about);
}

/* TeoEyesΥإɽ ***************************************************** */
void
te_menu_cb_help (GtkWidget	*widget,
		 gpointer	data) {
  int		pid;

  if (!tc->help_browser) {
    fprintf (stderr, _("Not set help browser.\n"));
    return;
  }
  if ((pid = fork ()) == 0) {
    if (execlp (tc->help_browser, tc->help_browser,
		TEOEYES_HTML, (char *) 0) == -1) {
      perror (tc->help_browser);
      return;
    }
  }
}

/* TeoEyesνλ *********************************************************** */
void
te_menu_cb_quit (GtkWidget	*widget,
		 gpointer	data) {
  te_window_cb_quit (image_window, NULL);
}

/* ********************************************* End of main_callbacks.c *** */
