/* *************************************************** main_menu_items.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2002-01-19 22:18:57 sugaya>
 * ************************************************************************* */
#include "icon_small.xpm"
#include "stock_folder.xpm"
#include "stock_open.xpm"
#include "stock_save.xpm"
#include "stock_save_as.xpm"
#include "stock_print.xpm"
#include "stock_loope.xpm"
#include "stock_top.xpm"
#include "stock_top3.xpm"
#include "stock_bottom.xpm"
#include "stock_bottom3.xpm"
#include "stock_up_arrow.xpm"
#include "stock_up_arrow2.xpm"
#include "stock_up_arrow3.xpm"
#include "stock_down_arrow.xpm"
#include "stock_down_arrow2.xpm"
#include "stock_down_arrow3.xpm"
#include "stock_size_double.xpm"
#include "stock_size_half.xpm"
#include "stock_size_up.xpm"
#include "stock_size_down.xpm"
#include "stock_plane.xpm"
#include "stock_plane2.xpm"
#include "stock_toolbar.xpm"
#include "stock_swindow.xpm"
#include "stock_background.xpm"
#include "stock_exec3.xpm"
#include "stock_undo.xpm"
#include "stock_window.xpm"
#include "stock_dialog.xpm"
#include "stock_list.xpm"
#include "stock_edit.xpm"
#include "stock_explorer.xpm"
#include "stock_sound.xpm"
#include "stock_assistant.xpm"
#include "stock_book_blue.xpm"
#include "stock_properties.xpm"
#include "stock_menu_about.xpm"
#include "stock_help2.xpm"
#include "stock_exit.xpm"

/* ˥塼ƥ ******************************************************** */
static GtkIconItemFactoryEntry
menu_items[] =
{
  /* ȥ */
  {N_("/Tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/TeoEyes"),	
   teoeyes_icon_small,
   NULL,   		NULL,				0, "<Title>"},
  {N_("/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  /* <File>˥塼 */
  {N_("/_File"),		
   stock_folder,
   NULL,		NULL,				0, "<Branch>"},
  {N_("/_File/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_File/_Open"),
   stock_open,
   "<Control>O",	te_menu_cb_file_open,		0, NULL},
  {N_("/_File/_Save"),
   stock_save,
   "<Control>S",	te_menu_cb_file_save,		0, NULL},
  {N_("/_File/Save _as"),
   stock_save_as,
   "<Control><Alt>S",	te_menu_cb_file_saveas,	0, NULL},
  {N_("/_File/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},
  {N_("/_File/_Print"),
   stock_print,
   "<Control>P",	te_menu_cb_file_print,		0, NULL},  
  {N_("/_File/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},
  {N_("/_File/_Teoeyes"),
   teoeyes_icon_small,
   "<Control>2",	te_menu_cb_file_run_teoeyes,	0, NULL},

  /* <View>˥塼 */
  {N_("/_View"),
   stock_loope,
   NULL,		NULL,				0, "<Branch>"},
  {N_("/_View/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},

  {N_("/_View/Image List"),
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/Image List/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},

  {N_("/_View/Image List/_Top Image"),
   stock_top3,
   "<Alt><Shift>T",	te_menu_cb_view_top_image,	0, NULL},
  {N_("/_View/Image List/_Prev Image"),
   stock_up_arrow3,
   "<Alt><Shift>P",	te_menu_cb_view_prev_image,	0, NULL},
  {N_("/_View/Image List/_Next Image"),
   stock_down_arrow3,
   "<Alt><Shift>N",	te_menu_cb_view_next_image,	0, NULL},
  {N_("/_View/Image List/_Bottom Image"),
   stock_bottom3,
   "<Alt><Shift>B",	te_menu_cb_view_bottom_image,	0, NULL},

  {N_("/_View/Frame"),
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/Frame/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},

  {N_("/_View/Frame/_Top Frame"),		
   stock_top,
   "<Control><Shift>T",	te_menu_cb_view_top_frame,	0, NULL},
  {N_("/_View/Frame/_Prev Frame"),		
   stock_up_arrow,
   "<Control><Shift>P",	te_menu_cb_view_prev_frame,	0, NULL},
  {N_("/_View/Frame/_Next Frame"),		
   stock_down_arrow,
   "<Control><Shift>N",	te_menu_cb_view_next_frame,	0, NULL},
  {N_("/_View/Frame/_Bottom Frame"),		
   stock_bottom,
   "<Control><Shift>B",	te_menu_cb_view_bottom_frame,	0, NULL},

  {N_("/_View/Plane"),
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/Plane/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},

  {N_("/_View/Plane/_Show Plane"),	
   stock_plane2,
   "<Control>V",	te_menu_cb_view_show_plane,	0, "<ToggleItem>"},
  {N_("/_View/Plane/_Prev Plane"),		
   stock_up_arrow2,
   "<Shift>P",		te_menu_cb_view_prev_plane,	0, NULL},
  {N_("/_View/Plane/_Next Plane"),		
   stock_down_arrow2,
   "<Shift>N",		te_menu_cb_view_next_plane, 	0, NULL},

  {N_("/_View/Size"),
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/Size/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},

  {N_("/_View/Size/Double Size"),	
   stock_size_double,
   "<Control>period",	te_menu_cb_size_double,		0, NULL},
  {N_("/_View/Size/Half Size"),		
   stock_size_half,
   "<Control>comma",	te_menu_cb_size_half,		0, NULL},
  {N_("/_View/Size/Scale Up 10\\%"),		
   stock_size_up,
   "period",		te_menu_cb_size_plus,		0, NULL},
  {N_("/_View/Size/Scale Down 10\\%"),	
   stock_size_down,
   "comma",		te_menu_cb_size_minus,		0, NULL},

  {N_("/_View/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_View/ToolBar"),
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/ToolBar/tearoff"),	
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  
  {N_("/_View/ToolBar/Toggle ToolBar"),
   stock_toolbar, 
   "<Control>T",
   te_menu_cb_view_toolbar,				0, "<ToggleItem>"},
  {N_("/_View/ToolBar/ToolBar Top"),
   NULL,
   "<Alt>T",
   te_menu_cb_view_toolbar_top,				0, NULL},
  {N_("/_View/ToolBar/ToolBar Bottom"),
   NULL,
   "<Alt>B",
   te_menu_cb_view_toolbar_bottom,			0, NULL},

  {N_("/_View/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_View/_Toggle ScrollBar"),
   stock_swindow,
   "<Control>Y",	te_menu_cb_force_scrollable, 	0, "<ToggleItem>"},

  {N_("/_View/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_View/_Draw Desktop"),
   stock_background,
   "<Control>G",	te_menu_cb_view_draw_desktop,	0, NULL},

  /* <Operation>˥塼 */
  {N_("/_Edit"),	
   stock_exec3,
   NULL,		NULL,				0, "<Branch>"},
  {N_("/_Edit/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_Edit/_Undo"),	
   stock_undo,
   "<Alt>U",		te_menu_cb_operation_undo,	0, NULL},

  {N_("/_Edit/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_Edit/_Original Image"),
   NULL,
   "<Alt>O",		te_menu_cb_operation_original,	0, NULL},
  {N_("/_Edit/_Gray Image"),
   NULL,
   "<Alt>G",		te_menu_cb_operation_gray,	0, NULL},
  {N_("/_Edit/N_egative Image"),
   NULL,
   "<Alt>R",		te_menu_cb_operation_negative,	0, NULL},
  {N_("/_Edit/_Normalize Image"),
   NULL,	
   "<Alt>N",		te_menu_cb_operation_normalize,	0, NULL},
  {N_("/_Edit/Flip _Horizontal"),
   NULL,
   "<Alt>H",		te_menu_cb_operation_flip_h,	0, NULL},
  {N_("/_Edit/Flip _Vertical"),
   NULL,
   "<Alt>V",		te_menu_cb_operation_flip_v,	0, NULL},

  /* <PlugIn>˥塼 */
  /*
    ̤δؿǥ˥塼
   */
  
  /* <Dialog Box>˥塼 */
  {N_("/_Window"),
   stock_window,
   NULL,		NULL,				0, "<Branch>"},
  {N_("/_Window/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_Window/Image _List viewer"),
   stock_list_xpm,
   "<Control>L",	te_menu_cb_list_show,		0, NULL},
  {N_("/_Window/Image _Editor"),
   stock_edit_xpm,
   "<Control>E",	te_menu_cb_edit_show,		0, NULL},
  {N_("/_Window/Image E_xplorer"),
   stock_explorer_xpm,
   "<Control>B",	te_menu_cb_browser_show,	0, NULL},
  {N_("/_Window/Image _Player"),
   stock_sound_xpm,
   "<Control>C",	te_menu_cb_playerII_show,	0, NULL},

  /* ѥ졼 */  
  {N_("/_Window/separator"),
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_Window/Teoeyes _Assistant"),
   stock_assistant_xpm,
   "<Alt>A",		te_menu_cb_assistant_show,	0, NULL},

  /* ѥ졼 */
  {N_("/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},
  
  {N_("/_Image Information"),	
   stock_book_blue,
   "<Control>I",	te_menu_cb_image_info,		0, NULL},

  /* ѥ졼 */
  {N_("/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_Preferences"),
   stock_properties,
   "<Control>F",	te_menu_cb_preference,		0, NULL},

  {N_("/_About"),
   stock_menu_about,
   "<Control>A",	te_menu_cb_about,		0, NULL},
  {N_("/_Help"),		
   stock_help2,
   "<Control>H",	te_menu_cb_help,		0, NULL},
  /* ѥ졼 */
  {N_("/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_Quit"),	
   stock_exit,
   "<Control>Q",	te_menu_cb_quit,		0, NULL}
};

/* ******************************************** End of main_menu_items.h *** */
