/* ******************************************************* main_window.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/02/12 19:20:58 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkiconitemfactory.h"
#include "main_menu_items.h"
#include "icon.xpm"

/* ************************************************************************* *
 * ɥФ륳Хåؿ
 * ************************************************************************* */

/* TeoEyesνλ *********************************************************** */
void
te_window_cb_quit (GtkWidget	*widget,
		   gpointer	data) {
  GList	*list;

  /* β */
  list = g_list_first (image_list);
  while (list) {
    te_image_destroy_image (list);
    list = g_list_next (list);
  }
  g_list_free (image_list);
  /* λ */
  gtk_main_quit ();
}

/* ѹ٥ ****************************************************** */
static void
te_window_cb_change_size (GtkWidget		*widget,
			  GdkEventConfigure	*ev) {
  int		scrollable;
  int		w, h;	
  static int	pw = -1, ph = -1;
  
  w = ev->width;
  h = ev->height;

  if (pw == w && ph == h) return;

  scrollable = (int)
    gtk_object_get_data (GTK_OBJECT (image_window), "scrollable");
  if (scrollable) return;
  
  pw = w;
  ph = h;

  te_image_set_image_size (image_window, w, h);
}

/* 襤٥ ********************************************************** */
static void
te_window_cb_expose (GtkWidget		*widget,
		     GdkEventExpose	*ev) {
  int	w, h;

  w = (int) gtk_object_get_data (GTK_OBJECT (image_window), "width");
  h = (int) gtk_object_get_data (GTK_OBJECT (image_window), "height");  
  te_image_set_image_size (image_window, w, h);
}

/* ************************************************************************* *
 * ɥФؿ
 * ************************************************************************* */

/* 륦ɥɽ/ɽ *************************************** */
void
te_window_force_scrollable (GtkWidget	*widget,
			    gint	flg) {
  GtkWidget	*canvas;
  int		w, h;
  int		forcescroll;
  
  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "canvas");
  if (!canvas) return;

  /* */
  forcescroll = (int) gtk_object_get_data (GTK_OBJECT (widget), "forcescroll");
  
  /* γ */
  w = te_image_get_curr_width (image_list);
  h = te_image_get_curr_height(image_list);

  if (flg) {
    gtk_object_set_data (GTK_OBJECT (widget), "forcescroll", (gpointer) 1);
  } else {
    gtk_object_set_data (GTK_OBJECT (widget), "forcescroll", (gpointer) 0);
  }
  te_image_set_image_size (widget, w, h);      
}

/* ************************************************************************* *
 * ޥΥ٥ȴؿ
 * ************************************************************************* */

/* ܥ󤬲줿ν ************************************************ */
static void
te_window_cb_mouse_press (GtkWidget		*widget,
			  GdkEventButton	*ev) {
  GtkWidget	*menu;
  int		x, y, rx, ry, w, h, scale;

  if (!GTK_WIDGET_HAS_FOCUS (widget)) gtk_widget_grab_focus (widget);

  /* ޥݥ󥿤κɸ */
  w = te_image_get_curr_width  (image_list);
  h = te_image_get_curr_height (image_list);
  x = (int) (ev->x * te_image_get_orig_width (image_list) / w);
  y = (int) (ev->y * te_image_get_orig_height(image_list) / h);
  gtk_object_set_data (GTK_OBJECT (image_window), "x", (gpointer) x);
  gtk_object_set_data (GTK_OBJECT (image_window), "y", (gpointer) y);

  switch (ev->button) {

  case MOUSE_LEFT:	/* ܥ */

    /* ɽ⡼ɤξϲ⤷ʤ */
    if (opt->display_mode) return;
    
    /* ͤɽ */
    if (!pixel_window) pixel_window = te_pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show (pixel_window);
    gdk_window_raise (pixel_window->window);

    te_pixel_window_show (x, y,
			  (ev->state == 0) ? PIXEL_ORIG_VAL:PIXEL_CURR_VAL,
			  ((GdkWindowPrivate *) ev->window)->xwindow,
			  ((GdkWindowPrivate *) ev->window)->xdisplay,
			  ev->time);

    /* ⤷,ȥ륭Ƥ饯åԥ󥰥⡼ɤ */
    if (ev->state == 4) {
      te_crip_cb_mouse_press ((int) ev->x, (int) ev->y);
    }
    
    break;

  case MOUSE_CENTER:	/* ܥ */

    /* ɽ⡼ɤξϲ⤷ʤ */
    if (opt->display_mode) return;

    if (ev->state == 4) {	/* åԥ󥰤μ¹ */
      te_crip_cb_do_crip ();      
    } else {			/* ꤵ줿դɽ */
      if (!loope) {
	loope = te_loope_new (_("Loope Window"), SW_WIDTH, SW_HEIGHT);
      }
      if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);
      scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
      rx = SW_WIDTH / 2 - scale;
      ry = SW_HEIGHT/ 2 - scale;
      gtk_object_set_data (GTK_OBJECT (image_window), "rx", (gpointer) rx);
      gtk_object_set_data (GTK_OBJECT (image_window), "ry", (gpointer) ry);
      te_draw_loope_image ((GtkWidget *)
			   gtk_object_get_data (GTK_OBJECT (loope), "canvas"),
			   image_list, x, y, rx, ry, scale);

      /* ͤɽ */
      if (!pixel_window) pixel_window = te_pixel_window_new ();
      if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show (pixel_window);
      gdk_window_raise (pixel_window->window);
      te_pixel_window_show (x, y,
			    (ev->state == 0) ? PIXEL_ORIG_VAL:PIXEL_CURR_VAL,
			    ((GdkWindowPrivate *) ev->window)->xwindow,
			    ((GdkWindowPrivate *) ev->window)->xdisplay,
			    ev->time);
    }
    break;

  case MOUSE_RIGHT:	/* ܥ */

    /* ˥塼ɽ */
    menu = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (image_window), "menu");
    if (menu) {
      gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, ev->time);
    }
    break;

  case 4:	/* ۥܥ */

    /* ɽ⡼ɤξϲ⤷ʤ */
    if (opt->display_mode) return;
    
    te_menu_cb_size_minus (image_window, NULL);
    break;

  case 5:	/* ۥܥ */

    /* ɽ⡼ɤξϲ⤷ʤ */
    if (opt->display_mode) return;
    
    te_menu_cb_size_plus (image_window, NULL);    
    break;
  }
}

/* ޥưν **************************************** */
static int
te_window_cb_mouse_motion (GtkWidget		*widget,
			   GdkEventMotion	*ev) {
  int			x, y, rx, ry, ox, oy, scale, max_w, max_h;
  GdkModifierType	state;

  /* ɽ⡼ɤξϲ⤷ʤ */
  if (opt->display_mode) return;
  
  /* ޥݥ󥿤κɸ */
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
    ox = x;
    oy = y;
  } else {
    x	  = ev->x;
    y	  = ev->y;
    ox	  = x;
    oy	  = y;
    state = ev->state;
  }
  max_w = te_image_get_curr_width  (image_list);
  max_h = te_image_get_curr_height (image_list);
  if (x < 0) x = 0;
  if (y < 0) y = 0;
  if (x > max_w - 1) x = max_w - 1;
  if (y > max_h - 1) y = max_h - 1;
  x = x * te_image_get_orig_width  (image_list) / max_w;
  y = y * te_image_get_orig_height (image_list) / max_h;

  if ((state & GDK_BUTTON1_MASK) != 0) {	/* ܥ */
    /* ߤκɸ¸ */
    gtk_object_set_data (GTK_OBJECT (image_window), "x", (gpointer) x);
    gtk_object_set_data (GTK_OBJECT (image_window), "y", (gpointer) y);

    /* ͤɽ */
    if (!pixel_window) pixel_window = te_pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show (pixel_window);

    te_pixel_window_show (x, y,
			  (ev->state == 256) ? PIXEL_ORIG_VAL:PIXEL_CURR_VAL,
			  ((GdkWindowPrivate *) ev->window)->xwindow,
			  ((GdkWindowPrivate *) ev->window)->xdisplay,
			  ev->time);

    /* ⤷,ȥ륭Ƥ饯åԥ󥰥⡼ɤ */
    if (ev->state == 260) te_crip_cb_mouse_move (ox, oy);
    
  } else if ((state & GDK_BUTTON2_MASK) != 0) {	/* ܥ */

    /* ꤵ줿դɽ */
    if (!loope) {
      loope = te_loope_new (_("Loope Window"), SW_WIDTH, SW_HEIGHT);
    }
    if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);    
    if ((x != (int) gtk_object_get_data (GTK_OBJECT (image_window), "x")) ||
	(y != (int) gtk_object_get_data (GTK_OBJECT (image_window), "y"))) {
      scale = (int) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
      rx = SW_WIDTH / 2 - scale;
      ry = SW_HEIGHT/ 2 - scale;
      gtk_object_set_data (GTK_OBJECT (image_window), "x",  (gpointer) x);
      gtk_object_set_data (GTK_OBJECT (image_window), "y",  (gpointer) y);
      gtk_object_set_data (GTK_OBJECT (image_window), "rx", (gpointer) rx);
      gtk_object_set_data (GTK_OBJECT (image_window), "ry", (gpointer) ry);
      te_draw_loope_image ((GtkWidget *)
			   gtk_object_get_data (GTK_OBJECT (loope),"canvas"),
			   image_list, x, y, rx, ry, scale);
    }
    /* ͤɽ */
    if (!pixel_window) pixel_window = te_pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show (pixel_window);

    te_pixel_window_show (x, y,
			  (ev->state == 512) ? PIXEL_ORIG_VAL:PIXEL_CURR_VAL,
			  ((GdkWindowPrivate *) ev->window)->xwindow,
			  ((GdkWindowPrivate *) ev->window)->xdisplay,
			  ev->time);

  }
  return TRUE;
}

/* ܥΥ줿ν ************************************************** */
static void
te_window_cb_mouse_release (GtkWidget		*widget,
			    GdkEventButton	*ev) {

}

/* ************************************************************************* *
 * ɥؿ
 * ************************************************************************* */

/*  ********************************************************** */
static void
te_window_icon_new (GtkWidget	*parent) {
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;

  pixmap = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
					 &mask, NULL, teoeyes_icon);
  gdk_window_set_icon (parent->window, NULL, pixmap, mask);
  gdk_window_set_icon_name (parent->window, _("TeoEyes"));
}

/* ˥塼 ********************************************************** */
static GtkWidget*
te_window_menu_new (GtkWidget	*window) {
  int			items = sizeof (menu_items) / sizeof (menu_items[0]);
  int			n, m = 0;
  char			*accl;
  GtkWidget		*menu;
  GtkWidget		*item;
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;

  /* 硼ȥåȤ򥫥ޥ */
  for (n = 0; n < items; n++) {
    if (!menu_items[n].item_type || 
	(strcmp (menu_items[n].path, 
		 N_("/_View/Plane/_Show Plane")) == 0) ||
	(strcmp (menu_items[n].path, 
		 N_("/_View/ToolBar/Toggle ToolBar")) == 0) ||
	(strcmp (menu_items[n].path, 
		 N_("/_View/_Toggle ScrollBar")) == 0)) {
      accl = gtk_accelerator_name (tc->shortcut[m].keyval,
				   tc->shortcut[m].modifier);
      menu_items[n].accelerator = accl;
      m++;
    }
  }
  /* ˥塼 */
  accel_group = gtk_accel_group_new ();
  item_factory
    = gtk_icon_item_factory_new (GTK_TYPE_MENU, "<sub>", accel_group);
  gtk_object_set_data (GTK_OBJECT (window), "menu_items", item_factory);
  gtk_icon_item_factory_create_items (item_factory, items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));
  menu = gtk_icon_item_factory_get_widget (item_factory, "<sub>");
  te_plugin_menu_new (menu);

  return menu;
}

/* ɥ **************************************************** */
GtkWidget*
te_image_window_new (char	*title,
		     int	width,
		     int       	height) {
  GtkWidget	*window;
  GtkWidget	*table;
  GtkWidget	*scroll_window;
  GtkWidget	*drawarea;
  GtkWidget	*alignment;
  GtkWidget	*menu;
  GtkWidget	*top, *bottom, *left, *right, *middle;
  
  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_ref (window);
  
  /* ɥ饹 */
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  
  /* ȥ */
  gtk_window_set_title (GTK_WINDOW (window), title);

  /* ܡ */
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);

  /* ꥵ */
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, TRUE);

  /* ٥Ȥ */
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (te_window_cb_quit), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (te_window_cb_quit), NULL);

  /* ơ֥ */
  table = gtk_table_new (3, 3, FALSE);
  gtk_widget_ref (table);
  gtk_widget_show (table);  
  gtk_container_add (GTK_CONTAINER (window), table);
  {
    /* Υܥå */
    top = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (top);
    gtk_widget_show (top);
    gtk_table_attach (GTK_TABLE (table), top, 1, 2, 0, 1,
		      GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
    
    /* Υܥå */
    bottom = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (bottom);
    gtk_widget_show (bottom);    
    gtk_table_attach (GTK_TABLE (table), bottom, 1, 2, 2, 3,
		      GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);

    /* Υܥå */
    left = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (left);
    gtk_widget_show (left);    
    gtk_table_attach (GTK_TABLE (table), left, 0, 1, 1, 2,
		      GTK_FILL, GTK_FILL | GTK_SHRINK, 0, 0);
    
    /* Υܥå */
    right = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (right);
    gtk_widget_show (right);    
    gtk_table_attach (GTK_TABLE (table), right, 2, 3, 1, 2,
		      GTK_FILL, GTK_FILL | GTK_SHRINK, 0, 0);

    /* Υܥå */
    middle = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (middle);
    gtk_widget_show (middle);    
    gtk_table_attach (GTK_TABLE (table), middle, 1, 2, 1, 2,
		      GTK_EXPAND | GTK_FILL | GTK_SHRINK,
		      GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
    {
      /* Х */
      drawarea = gtk_drawing_area_new ();
      gtk_widget_ref (drawarea);
      gtk_widget_show (drawarea);
      gtk_box_pack_start (GTK_BOX (middle), drawarea, TRUE, TRUE, 0);      
      gtk_widget_set_usize (drawarea, width, height);
      
      /* ٥Ȥ */
      gtk_widget_set_events (drawarea,
			     GDK_EXPOSURE_MASK |
			     GDK_BUTTON_PRESS_MASK |
			     GDK_BUTTON_RELEASE_MASK |
			     GDK_POINTER_MOTION_MASK |
			     GDK_POINTER_MOTION_HINT_MASK);

      gtk_signal_connect (GTK_OBJECT (drawarea), "configure_event",
			  GTK_SIGNAL_FUNC (te_window_cb_change_size), NULL);
      gtk_signal_connect (GTK_OBJECT (drawarea), "expose_event",
			  GTK_SIGNAL_FUNC (te_window_cb_expose), NULL);
      gtk_signal_connect (GTK_OBJECT (drawarea), "button_press_event",
			  GTK_SIGNAL_FUNC (te_window_cb_mouse_press), NULL);
      gtk_signal_connect (GTK_OBJECT (drawarea), "button_release_event",
			  GTK_SIGNAL_FUNC (te_window_cb_mouse_release), NULL);
      gtk_signal_connect (GTK_OBJECT (drawarea), "motion_notify_event",
			  GTK_SIGNAL_FUNC (te_window_cb_mouse_motion), NULL);

      /* 륦ɥ */
      scroll_window = gtk_scrolled_window_new (NULL, NULL);
      gtk_widget_ref (scroll_window);
      gtk_box_pack_start (GTK_BOX (middle), scroll_window, TRUE, TRUE, 0);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_window),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
      {
	alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	gtk_widget_ref (alignment);
	gtk_widget_show (alignment);	
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					       (scroll_window), alignment);
      }
      gtk_widget_realize (scroll_window);
    }
  }
  /* ˥塼 */
  menu = te_window_menu_new (window);

  /* ꥢ饤 */
  gtk_widget_realize (window);
  
  /*  */
  te_window_icon_new (window);
  
  /* ѥ᡼ */
  gtk_object_set_data (GTK_OBJECT (window), "width", (gpointer) width);
  gtk_object_set_data (GTK_OBJECT (window), "height", (gpointer) height);  
  gtk_object_set_data (GTK_OBJECT (window), "forcescroll", (gpointer) 0);  
  gtk_object_set_data (GTK_OBJECT (window), "scrollable",  (gpointer) 0);  
  gtk_object_set_data (GTK_OBJECT (window), "toolbar",  (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "toolbar_pos",  (gpointer) 0);  
  gtk_object_set_data (GTK_OBJECT (window), "x", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "y", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "rx",
		       (gpointer) (SW_WIDTH / 2 - tc->default_loope_scale));
  gtk_object_set_data (GTK_OBJECT (window), "ry",
		       (gpointer) (SW_HEIGHT/ 2 - tc->default_loope_scale));
  gtk_object_set_data (GTK_OBJECT (window), "scale",
		       (gpointer) tc->default_loope_scale);
  gtk_object_set_data (GTK_OBJECT (window), "crip_do",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_x",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_y",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_w",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_h",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_dir_x", 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "crip_dir_y", 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "prev_x",	 	(gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "prev_y",	 	(gpointer) 0);
  
  /* ̾ */
  gtk_object_set_data (GTK_OBJECT (window), "top",		top);
  gtk_object_set_data (GTK_OBJECT (window), "bottom",		bottom);
  gtk_object_set_data (GTK_OBJECT (window), "left",		left);
  gtk_object_set_data (GTK_OBJECT (window), "right",		right);
  gtk_object_set_data (GTK_OBJECT (window), "middle",		middle);  
  gtk_object_set_data (GTK_OBJECT (window), "canvas",		drawarea);
  gtk_object_set_data (GTK_OBJECT (window), "scroll_window",	scroll_window);
  gtk_object_set_data (GTK_OBJECT (window), "alignment",	alignment);
  gtk_object_set_data (GTK_OBJECT (window), "menu",    		menu);

  return window;
}

/* ************************************************ End of main_window.c *** */
