/* *********************************************************** message.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/01/22 14:26:26 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "stock_button_ok.xpm"
#include "stock_button_cancel.xpm"

/* åɥɽ ****************************************** */
void
te_message_box_show (char	*title,
		     char	*message) {
  GtkWidget	*dialog;
  GtkWidget	*label;
  GtkWidget	*button;
  GtkWidget	*box;
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  /*  */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (dialog), 3);
  {
    /* ǥեѹ */
    gtk_box_set_child_packing (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			       GTK_WIDGET (GTK_DIALOG (dialog)->action_area),
			       FALSE, FALSE, 0, GTK_PACK_END);
    gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
			     FALSE);

    gtk_container_set_border_width (GTK_CONTAINER 
				    (GTK_DIALOG (dialog)->action_area), 5);
  }

  /* å٥ */
  label = gtk_label_new (message);
  gtk_misc_set_padding (GTK_MISC (label), 10, 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  /* OKܥ */
  button = gtk_button_new ();
  gtk_widget_set_usize (button, 100, -1);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  {
    /* ܥå */
    box = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (box);
    gtk_container_add (GTK_CONTAINER (button), box);
    {
      /*  */
      pix = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
					  &msk, NULL, stock_button_ok);
      icon = gtk_pixmap_new (pix, msk);
      gtk_widget_show (icon);
      gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, 5);
    
      /* OK٥ */
      label = gtk_label_new (_("OK"));
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
      gtk_widget_show (label);
    }
  }
  /* ɽ */
  gtk_widget_show (dialog);
}

/* ************************************************************************* */
static void
dialog_yes (GtkWidget	*widget,
	    int		*flg) {
  *flg = TRUE;
}

/* ************************************************************************* */
static void
dialog_no (GtkWidget	*widget,
	   int		*flg) {
  *flg = FALSE;
}

/* ǧɥɽ ************************************************ */
int
te_confirm_box_show (GtkWidget	*parent,
		     char	*title,
		     char	*message) {
  GtkWidget	*dialog;
  GtkWidget	*label;
  GtkWidget	*button;
  GtkWidget	*box;
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;
  int		flg = FALSE;
  
  /*  */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Confirm"));
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (dialog), 5);
  gtk_window_set_policy	(GTK_WINDOW (dialog), FALSE, FALSE, TRUE);
  {
    /* ǥեѹ */
    gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
			GTK_SIGNAL_FUNC (gtk_false), NULL);
    gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
			GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
    gtk_box_set_child_packing (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			       GTK_WIDGET (GTK_DIALOG (dialog)->action_area),
			       FALSE, FALSE, 0, GTK_PACK_END);
    gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
			     FALSE);

    gtk_container_set_border_width (GTK_CONTAINER 
				    (GTK_DIALOG (dialog)->action_area), 5);
  }

  /* å٥ */
  label = gtk_label_new (message);
  gtk_misc_set_padding (GTK_MISC (label), 20, 20);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  
  /* CANCELܥ */
  button = gtk_button_new ();
  gtk_widget_set_usize (button, 100, -1);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  gtk_widget_show (button);

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (dialog_no), &flg);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  {
    /* ܥå */
    box = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (box);
    gtk_container_add (GTK_CONTAINER (button), box);
    {
      /*  */
      pix = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
					  &msk, NULL, stock_button_cancel);
      icon = gtk_pixmap_new (pix, msk);
      gtk_widget_show (icon);
      gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, 5);
    
      /* Cancel٥ */
      label = gtk_label_new (_("Cancel"));
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_widget_show (label);
    }
  }

  /* OKܥ */
  button = gtk_button_new ();
  gtk_widget_set_usize (button, 100, -1);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (dialog_yes), &flg);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  {
    /* ܥå */
    box = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (box);
    gtk_container_add (GTK_CONTAINER (button), box);
    {
      /*  */
      pix = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
					  &msk, NULL, stock_button_ok);
      icon = gtk_pixmap_new (pix, msk);
      gtk_widget_show (icon);
      gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, 5);
    
      /* OK٥ */
      label = gtk_label_new (_("OK"));
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
      gtk_widget_show (label);
    }
  }

  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  if (parent) {
    gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (parent));
  }
  gtk_widget_show (dialog);
  gtk_main ();

  return flg;
}

/* **************************************************** End of message.c *** */
