/* ************************************************************** misc.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/06/29 18:25:03 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* Ρȥ֥åΥ٥ ************************************************ */
GtkWidget*
te_notebook_label_new (char		*label_name,
		       GdkPixmap	*pixmap,
		       GdkBitmap	*bitmap) {
  GtkWidget	*label_box;
  GtkWidget	*label;
  GtkWidget	*pix;
  
  label_box = gtk_hbox_new (FALSE, 0);
  {
    pix = gtk_pixmap_new (pixmap, bitmap);
    gtk_box_pack_start (GTK_BOX (label_box), pix, FALSE, TRUE, 0);
    gtk_misc_set_padding (GTK_MISC (pix), 3, 1);

    label = gtk_label_new (label_name);
    gtk_box_pack_start (GTK_BOX (label_box), label, FALSE, TRUE, 0);
  }
  gtk_widget_show_all (label_box);

  return label_box;
}

/* Ʊɥǳ **************************************** */
int
te_open_file_with_same_window (char	*filename) {
  TEImage	*te;
  GList		*list;
  int		w, h;

  /* ꤵ줿ɤ߹ޤƤ뤫ɤĴ٤ */
  if (strcmp (te_image_get_filename (image_list), filename) == 0) return TRUE;

  list = g_list_first (image_list);
  
  while (list) {

    if (strcmp (te_image_get_filename (list), filename) == 0) {

      /* ȲΥ */
      if (opt->clear_data) te_image_destroy_image (image_list);

      /* ɽ */
      image_list = list;
      te = te_image_get_image (image_list);
      gtk_object_set_data (GTK_OBJECT (image_window), "id", 
			   (gpointer) te_image_get_id (image_list));
      if (te_image_get_pbuf (image_list)) {
	w = te_image_get_orig_width (image_list);
	h = te_image_get_orig_height(image_list);
	gtk_object_set_data (GTK_OBJECT (image_window), "width", (gpointer) w);
	gtk_object_set_data (GTK_OBJECT (image_window), "height",(gpointer) h);
      } else {
	if (te_image_load_image (image_list, 0, opt->min, opt->max) == FALSE) {
	  return FALSE;
	}
      }
      /* ɥѹ */
      gtk_widget_set_usize ((GtkWidget *)
			    gtk_object_get_data (GTK_OBJECT (image_window),
						 "canvas"), w, h);
      te_image_set_image_size (image_window, w, h);
      return TRUE;
    } else {
      list = list->next;
    }
  }
  /* ȲΥ */
  if (opt->clear_data && !opt->display_mode) {
    te_image_clear_image (image_list);
  }
  /* ꥹȤɲä */
  if (!te_image_add_image_list (g_list_last (image_list), filename, 
				te_image_get_id (g_list_last (image_list)) + 1,
				0)) return FALSE;
  
  /* ɽ */
  image_list = g_list_last (image_list);
  if (te_image_load_image (image_list, 0, opt->min, opt->max) == FALSE) {
    return FALSE;
  }
  w = te_image_get_curr_width (image_list);
  h = te_image_get_curr_height(image_list);
  gtk_object_set_data (GTK_OBJECT (image_window), "id", 
		       (gpointer) te_image_get_id (image_list));
  gtk_object_set_data (GTK_OBJECT (image_window), "width", (gpointer) w);
  gtk_object_set_data (GTK_OBJECT (image_window), "height",(gpointer) h);
  gtk_widget_set_usize ((GtkWidget *)
			gtk_object_get_data (GTK_OBJECT (image_window),
					     "canvas"), w, h);
  te_image_set_image_size (image_window, w, h);

	  /* ꥹȥɥƤϥͥ򹹿 */
  if (list_window && GTK_WIDGET_VISIBLE (list_window)) {
    te_image_list_refresh_list ();
  }
  return TRUE;
}

/* ̤Υɥǳ **************************************** */
int
te_open_file_with_new_window (char	*filename) {
  int	pid;

  if (filename) {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, filename, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  } else {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  }
  return TRUE;
}

/* ******************************************************* End of misc.c *** */
