/* *************************************************************** bmp.h *** *
 * Original source code was included in gimp-1.3
 *
 *                                    Time-stamp: <02/07/07 00:38:34 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define	MAXCOLORS	256

#define BitSet(byte, bit)  (((byte) & (bit)) == (bit))

#define Write(file,buffer,len)   fwrite(buffer, len, 1, file)
#define WriteOK(file,buffer,len) (Write(buffer, len, file) != 0)

extern gint32	ToL           	(guchar *);
extern void	FromL         	(gint32,
				 guchar *);
extern gint16	ToS           	(guchar *);
extern void	FromS         	(gint16,
				 guchar *);
extern int	WriteBMP 	(gchar  	*filename,
				 GdkPixbuf	*pbuf);
extern void	WriteColorMap 	(FILE *,
				 gint *,
				 gint *,
				 gint *,
				 gint);
extern void	WriteImage    	(FILE		*filename,
				 guchar 	*data,
				 gint		width,
				 gint		height,
				 gint		encoded,
				 gint		channels,
				 gint		bpp,
				 gint		spzeile,
				 gint		MapSize);

extern struct Bitmap_File_Head_Struct
{
  gchar    zzMagic[2];  /* 00 "BM" */
  gulong   bfSize;      /* 02 */
  gushort  zzHotX;      /* 06 */
  gushort  zzHotY;      /* 08 */
  gulong   bfOffs;      /* 0A */
  gulong   biSize;      /* 0E */
} Bitmap_File_Head;

extern struct Bitmap_Head_Struct
{
  gulong   biWidth;     /* 12 */
  gulong   biHeight;    /* 16 */
  gushort  biPlanes;    /* 1A */
  gushort  biBitCnt;    /* 1C */
  gulong   biCompr;     /* 1E */
  gulong   biSizeIm;    /* 22 */
  gulong   biXPels;     /* 26 */
  gulong   biYPels;     /* 2A */
  gulong   biClrUsed;   /* 2E */
  gulong   biClrImp;    /* 32 */
                        /* 36 */
} Bitmap_Head;

/* *************************************************************** bmp.h *** */
