/* *************************************************************** xpm.c *** *
 * Original source code was included in gimp-1.3
 *
 *                                    Time-stamp: <02/05/20 16:51:17 sugaya>
 * ************************************************************************* */

/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* XPM plugin version 1.2.3 */

/*
1.2.3 fixes bug when running in noninteractive mode
changes alpha_threshold range from [0, 1] to [0,255] for consistency with
the threshold_alpha plugin

1.2.2 fixes bug that generated bad digits on images with more than 20000
colors. (thanks, yanele)
parses gtkrc (thanks, yosh)
doesn't load parameter screen on images that don't have alpha

1.2.1 fixes some minor bugs -- spaces in #XXXXXX strings, small typos in code.

1.2 compute color indexes so that we don't have to use XpmSaveXImage*

Previous...Inherited code from Ray Lehtiniemi, who inherited it from S & P.
*/
#if 0
#include "config.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

static const gchar linenoise [] =
" .+@#$%&*=-;>,')!~{]^/(_:<[}|1234567890abcdefghijklmnopqrstuvwxyz\
ABCDEFGHIJKLMNOPQRSTUVWXYZ`";

#define SCALE_WIDTH 125

/* Structs for the save dialog */
typedef struct
{
  gint threshold;
} XpmSaveVals;

typedef struct
{
  gint run;
} XpmSaveInterface;


typedef struct
{
  guchar r;
  guchar g;
  guchar b;
} rgbkey;

/*  whether the image is color or not.  global so I only have to pass
 *  one user value to the GHFunc
 */
gboolean   color;

/*  bytes per pixel.  global so I only have to pass one user value
 *  to the GHFunc
 */
gint       cpp;

/* Declare local functions */
GdkPixbuf*	load_xpm_image      (gchar         *filename);
static void     parse_colors        (XpmImage      *xpm_image,
				     guchar       **cmap);
static guchar*	parse_image         (XpmImage      *xpm_image,
				     guchar        *cmap);
gboolean 	save_xpm_image		(gchar         *filename,
					 GdkPixbuf	*pbuf);

static XpmSaveVals xpmvals = 
{
  127  /* alpha threshold */
};

static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  g_free (pixels);
}

GdkPixbuf*
load_xpm_image (gchar *filename)
{
  XpmImage  	xpm_image;
  guchar   	*cmap;
  GdkPixbuf	*pbuf;
  guchar	*data;
  
  /* read the raw file */
  XpmReadFileToXpmImage (filename, &xpm_image, NULL);

  /* parse out the colors into a cmap */
  parse_colors (&xpm_image, &cmap);
  if (cmap == NULL) return 0;

  /* fill it */
  data = parse_image(&xpm_image, cmap);

  /* create gdkpixbuf image */
  pbuf = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, 1, 8,
				   xpm_image.width, xpm_image.height,
				   xpm_image.width * 4, free_buffer, NULL);
  /* clean up and exit */
  g_free(cmap);
  
  return pbuf;
}

static void
parse_colors (XpmImage  *xpm_image, 
	      guchar   **cmap)
{
  Display  *display;
  Colormap  colormap;
  gint      i, j;

  /* open the display and get the default color map */
  display  = XOpenDisplay (NULL);
  colormap = DefaultColormap (display, DefaultScreen (display));
    
  /* alloc a buffer to hold the parsed colors */
  *cmap = g_new (guchar, 4 * xpm_image->ncolors);

  if ((*cmap) != NULL)
    {
      /* default to black transparent */
      memset((void*)(*cmap), 0, sizeof (guchar) * 4 * xpm_image->ncolors);
      
      /* parse each color in the file */
      for (i = 0, j = 0; i < xpm_image->ncolors; i++)
        {
          gchar     *colorspec = "None";
          XpmColor *xpm_color;
          XColor    xcolor;
        
          xpm_color = &(xpm_image->colorTable[i]);
        
          /* pick the best spec available */
          if (xpm_color->c_color)
            colorspec = xpm_color->c_color;
          else if (xpm_color->g_color)
            colorspec = xpm_color->g_color;
          else if (xpm_color->g4_color)
            colorspec = xpm_color->g4_color;
          else if (xpm_color->m_color)
            colorspec = xpm_color->m_color;
        
          /* parse if it's not transparent.  the assumption is that
             g_new will memset the buffer to zeros */
          if (strcmp (colorspec, "None") != 0)
	    {
	      XParseColor (display, colormap, colorspec, &xcolor);
	      (*cmap)[j++] = xcolor.red >> 8;
	      (*cmap)[j++] = xcolor.green >> 8;
	      (*cmap)[j++] = xcolor.blue >> 8;
	      (*cmap)[j++] = ~0;
	    }
	  else
	    {
	      j += 4;
	    }
        }
    }
    
  XCloseDisplay (display);
}

static guchar*
parse_image (XpmImage *xpm_image, 
	     guchar   *cmap)
{
  gint       tile_height;
  gint       scanlines;
  gint       val;  
  guchar    *buf;
  guchar    *dest;
  guint     *src;
  gint       i, j;

  tile_height = xpm_image->height;
    
  buf  = g_new (guchar, tile_height * xpm_image->width * 4);

  if (buf != NULL)
    {
      src  = xpm_image->data;
      for (i = 0; i < xpm_image->height; i+=tile_height)
        {
          dest = buf;
          scanlines = MIN(tile_height, xpm_image->height - i);
          j = scanlines * xpm_image->width;
          while (j--) {
            {
              val = *(src++) * 4;
              *(dest)   = cmap[val];
              *(dest+1) = cmap[val+1];
              *(dest+2) = cmap[val+2];
              *(dest+3) = cmap[val+3];
              dest += 4;
            }
          }
        }
    }
  return buf;
}

guint
rgbhash (rgbkey *c)
{
  return ((guint)c->r) ^ ((guint)c->g) ^ ((guint)c->b);
}

guint
compare (rgbkey *c1, 
	 rgbkey *c2)
{
  return (c1->r == c2->r) && (c1->g == c2->g) && (c1->b == c2->b);
}
	
void
set_XpmImage (XpmColor *array, 
	      guint     index, 
	      gchar    *colorstring)
{
  gchar *p;
  gint i, charnum, indtemp;
  
  indtemp=index;
  array[index].string = p = g_new (gchar, cpp+1);
  
  /*convert the index number to base sizeof(linenoise)-1 */
  for (i=0; i<cpp; ++i)
    {
      charnum = indtemp % (sizeof (linenoise) - 1);
      indtemp = indtemp / (sizeof (linenoise) - 1);
      *p++ = linenoise[charnum];
    }
  /* *p++=linenoise[indtemp]; */
  
  *p = '\0'; /* C and its stupid null-terminated strings... */

  array[index].symbolic = NULL;
  array[index].m_color  = NULL;
  array[index].g4_color = NULL;

  if (color)
    {
      array[index].g_color = NULL;
      array[index].c_color = colorstring;
    } else {	
      array[index].c_color = NULL;
      array[index].g_color = colorstring;
    }
}

void
create_colormap_from_hash (gpointer gkey, 
			   gpointer value, 
			   gpointer user_data)
{
  rgbkey *key = gkey;
  gchar *string = g_new(char, 8);

  sprintf (string, "#%02X%02X%02X", (int)key->r, (int)key->g, (int)key->b);
  set_XpmImage (user_data, *((int *) value), string);
}

gboolean
save_xpm_image (gchar  	*filename,
		GdkPixbuf	*pbuf)

{
  gint       width;
  gint       height;
  gint 	     ncolors = 1;
  gint	    *indexno;
  gboolean   indexed;
  gboolean   alpha;

  XpmColor  *colormap;
  XpmImage  *image;

  guint     *ibuff   = NULL;
  /*guint   *mbuff   = NULL;*/
  guchar    *buffer;
  guchar    *data;

  GHashTable *hash = NULL;

  gint       i, j, k;
  gint       threshold = xpmvals.threshold;

  gboolean   rc = FALSE;

  /* get some basic stats about the image */
  if (gdk_pixbuf_get_has_alpha (pbuf)) {
    alpha = TRUE;
  } else {
    alpha = FALSE;
  }
  color = TRUE;
  indexed = FALSE;

  width    = gdk_pixbuf_get_width  (pbuf);
  height   = gdk_pixbuf_get_height (pbuf);
  
  /* allocate buffers making the assumption that ibuff and mbuff
     are 32 bit aligned... */
  if ((ibuff = g_new (guint, width * height)) == NULL)
    goto cleanup;

  /*if ((mbuff = g_new(guint, width*height)) == NULL)
    goto cleanup;*/
  
  if ((hash = g_hash_table_new ((GHashFunc)rgbhash, 
				(GCompareFunc) compare)) == NULL)
    goto cleanup;
  
  /* allocate a pixel region to work with */
  if ((buffer = g_new (guchar, 
		       height*width*24)) == NULL)
    return 0;

  /* process each row of tiles */
  for (i = 0; i < height; i+=height)
    {
      gint scanlines;
  
      /* read the next row of tiles */
      scanlines = MIN (height, height - i);
#if 0
      gimp_pixel_rgn_get_rect (&pixel_rgn, buffer, 0, i, width, scanlines);
#endif      
      data = gdk_pixbuf_get_pixels (pbuf);
      
      /* process each pixel row */
      for (j=0; j<scanlines; j++)
        {
          /* go to the start of this row in each image */
          guint *idata = ibuff + (i+j) * width;
          /*guint *mdata = mbuff + (i+j) * width;*/

          /* do each pixel in the row */
          for (k=0; k<width; k++)
            {
	      rgbkey *key = g_new (rgbkey, 1);
	      guchar a;
  
              /* get pixel data */
              key->r = *(data++);
	      key->g = color && !indexed ? *(data++) : key->r;
	      key->b = color && !indexed ? *(data++) : key->r;
	      a = alpha ? *(data++) : 255;
	      
	      if (a < threshold) 
		{
		  *(idata++) = 0;
		}
	      else
		{
		  if (indexed)
		    {
		      *(idata++) = (key->r)+1;
		    }
		  else
		    {
		      indexno = g_hash_table_lookup (hash, key);
		      if (!indexno)
			{
			  indexno = g_new (gint, 1);
			  *indexno = ncolors++;
			  g_hash_table_insert (hash, key, indexno);
			  key = g_new (rgbkey, 1);
			}
		      *(idata++) = *indexno;
		    }
		}
            }
        }    
    } 
  g_free (buffer);

  colormap = g_new (XpmColor, ncolors);
      
  cpp = (gdouble) 1.0 + 
    (gdouble) log (ncolors) / (gdouble) log (sizeof (linenoise) - 1.0);
  set_XpmImage (colormap, 0, "None");
  
  g_hash_table_foreach (hash, create_colormap_from_hash, colormap);

  image = g_new (XpmImage, 1);
  
  image->width=width;
  image->height=height;
  image->ncolors=ncolors;
  image->cpp=cpp;
  image->colorTable=colormap;	    
  image->data = ibuff;
  
  /* do the save */
  XpmWriteFileFromXpmImage (filename, image, NULL);
  rc = TRUE;

 cleanup:
  if (ibuff) 
    g_free (ibuff);
  /*if (mbuff) g_free(mbuff);*/
  if (hash)  
    g_hash_table_destroy (hash);
  
  return rc;
}

/* *************************************************************** xpm.c *** */
