/* ******************************************************** opendialog.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2002-01-17 01:29:04 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkcustomiconfilesel.h"

/* OKܥ󤬲줿ν ********************************************** */
static void
te_open_dialog_ok (GtkWidget			*widget,
		   GtkCustomIconFileSel		*fs) {
  int		open_new_window;
  char		*filename;

  /* ɥ򳫤ɤĴ٤ */
  open_new_window
    = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON 
				    (gtk_object_get_data (GTK_OBJECT (fs),
							  "checkbutton")));
  /* ե̾ */
  filename = (char *) 
    gtk_custom_icon_file_selection_get_filename (GTK_CUSTOM_ICON_FILESEL (fs));

  if (!filename || strcmp (filename, "") == 0 || 
      !y_file_exist_file (filename)) return;  
  if (!y_file_is_file (filename)) return;
  
  /* ꤵ줿ե뤬бե뤫ɤĴ٤ */
  if (what_format_is_this (filename) == FORMAT_UNKNOWN) return;

  /* 򳫤 */
  if (open_new_window) {
    te_open_file_with_new_window (filename);
  } else {
    if (!te_open_file_with_same_window (filename)) exit (1);
  }
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void 
te_open_dialog_cancel (GtkWidget	*widget,
		       GtkWidget	*fs) {
  gtk_widget_hide (fs);
}

/* ************************************************************************* */
static void
te_open_dialog_select_item (GtkFileList		*flist,
			    GtkFileListItem	*icon,
			    GdkEventButton	*ev,
			    gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    te_open_dialog_ok (NULL, GTK_CUSTOM_ICON_FILESEL (data));
  }
}

/* ץ ************************************************ */
GtkWidget*
te_open_dialog_new (char	*title) {
  GtkWidget	*fs;
  GtkWidget	*obj;

  /*  */
  fs = gtk_custom_icon_file_selection_new (title);
  
  /* åܥɲ */
  obj = gtk_check_button_new_with_label (_("Open new window"));
  gtk_object_set_data (GTK_OBJECT (fs), "checkbutton", obj);
  gtk_widget_show (obj);
  gtk_box_pack_start (GTK_BOX (GTK_CUSTOM_ICON_FILESEL (fs)->custom_box3),
		      obj, FALSE, FALSE, 0);  
  gtk_widget_show (GTK_CUSTOM_ICON_FILESEL (fs)->custom_box3);

  /* ٥Ȥ */
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->ok_button),
		      "clicked", (GtkSignalFunc) te_open_dialog_ok, fs);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->cancel_button),
		      "clicked", GTK_SIGNAL_FUNC (te_open_dialog_cancel), fs);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->file_list),
		      "select_icon",
		      GTK_SIGNAL_FUNC (te_open_dialog_select_item), fs);
   
  return fs;
}

/* ************************************************* End of opendialog.c *** */
