/* ********************************************************* operation.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-02 00:31:50 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* ************************************************************************* *
 * Фؿ
 * ************************************************************************* */

/* ΨꤷƲ硦̾ ************************************** */
void
te_operation_scaling_by_scale (GList	*list,
			       double	xscale,
			       double	yscale) {
  GtkWidget	*canvas;
  int		w, h;
  
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  if (canvas) {
    w = xscale * te_image_get_curr_width (list);
    h = yscale * te_image_get_curr_height(list);
    te_image_set_image_size (image_window, w, h);
    gtk_widget_set_usize (canvas, w, h);
  }
}

/* 礭ꤷƲ硦̾ ************************************ */
void
te_operation_scaling_by_size (GList	*list,
			      int	width,
			      int	height) {	
  GtkWidget	*canvas;
  
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  if (canvas) {
    te_image_set_image_size (image_window, width, height);
    gtk_widget_set_usize (canvas, width, height);
  }
}

/* οʿȿž ********************************************************** */
void
te_operation_flip_horizontal (GList	*list) {
  unsigned char	*ptr1, *ptr2, r, rr;
  int		x, y, rowstride;

  rowstride = gdk_pixbuf_get_rowstride (te_image_get_pbuf (list));

  for (y = 0; y < te_image_get_orig_height (list); y++) {
    ptr1 = gdk_pixbuf_get_pixels (te_image_get_pbuf (list)) + (y * rowstride);
    ptr2 = gdk_pixbuf_get_pixels (te_image_get_pbuf (list))
      + (y * rowstride) + rowstride - 3;
    for (x = 0; x < te_image_get_orig_width (list) >> 1; x++) {
      r = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r = *ptr1;
      rr = *ptr2;
      *ptr2 = r;
      *ptr1++ = rr;

      ptr2 -= 5;
    }
  }
}

/* οľȿž ********************************************************** */
void
te_operation_flip_vertical (GList	*list) {
  unsigned char	*ptr1, *ptr2, r, rr;
  int		x, y, yy, rowstride;

  rowstride = gdk_pixbuf_get_rowstride (te_image_get_pbuf (list));

  for (yy = te_image_get_orig_height (list) - 1, y = 0;
       y < te_image_get_orig_height (list) >> 1; y++, yy--) {
    ptr1 = gdk_pixbuf_get_pixels (te_image_get_pbuf (list)) + (y * rowstride);
    ptr2 = gdk_pixbuf_get_pixels (te_image_get_pbuf (list)) + (yy * rowstride);
    for (x = 0; x < te_image_get_orig_width (list); x++) {
      r = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;
      r = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;
      r = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;
    }
  }
}

/* ************************************************** End of operation.c *** */
