/* ********************************************************* pixelinfo.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/02/01 11:06:36 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* ꤷβͤɽ ******************************************** */
void
te_pixel_window_show (int	x,
		      int	y,
		      int	pixel_type,
		      Window	win,
		      Display	*dsp,
		      guint32	time) {
  GtkWidget	*label;
  TEOIMAGE	*teoimg;
  int		wx, wy;
  int		w, h;
  int		d, n;
  char		info[MAX_STRING_MDL_LINE];
  static char	*xbuffer = NULL;
  TEO_FLOAT64	pixel[9];

  /* ͤĴ٤ǡ */
  teoimg = (pixel_type == PIXEL_CURR_VAL) ?
    te_image_get_curr_data (image_list) : te_image_get_orig_data (image_list);

  /* ͤγ */
  for (n = 0; n < 3; n++) pixel[n] = 0;
  for (n = 0; n < TeoPlane (teoimg); n++) {
    pixel[n] = TeoGetAnyPixel (teoimg,
			       x + TeoXoffset (teoimg),
			       y + TeoYoffset (teoimg),
			       n);
  }
  /* ͤɽ */
  switch (TeoType (teoimg)) {
  case (TEO_UNSIGNED):
  case (TEO_SIGNED):
    sprintf (info, "%3d, %3d  (%ld : %ld : %ld)", 
	     x + TeoXoffset (teoimg),
	     y + TeoYoffset (teoimg),
	     (long) pixel[0], (long) pixel[1], (long) pixel[2]);
    break;
  case (TEO_FLOAT):
    sprintf (info, "%3d, %3d  (%.5le : %.5le : %.5le)",
	     x + TeoXoffset (teoimg),
	     y + TeoYoffset (teoimg),
	     pixel[0], pixel[1], pixel[2]);
    break;
  }
  /* åȤؤΥå */
  label = (GtkWidget*)
    gtk_object_get_data (GTK_OBJECT (pixel_window), "label");

  if (xbuffer) free (xbuffer);
  xbuffer = (char *) malloc (sizeof (char) * (strlen (info) + 2));
  XStoreBytes (dsp, xbuffer, (int) strlen (xbuffer));
  gtk_selection_owner_set (GTK_WIDGET (gtk_object_get_data
				       (GTK_OBJECT (image_window), "canvas")),
			   GDK_SELECTION_PRIMARY, time);

  gtk_entry_set_text (GTK_ENTRY (label), info);
  gdk_window_get_geometry  (image_window->window, &wx, &wy, &w, &h, &d);
  gdk_window_get_origin    (image_window->window, &wx, &wy);
  gtk_widget_set_usize	   (pixel_window, strlen (info) * 8, 20);
  gtk_widget_set_uposition (pixel_window, wx, wy+h+7);
}

/* ɽɥɽ ******************************************** */
void 
te_pixel_window_hide (GtkWidget		*widget, 
		      GdkEventButton	*ev) {
  GtkWidget	*parent;

  if (ev->button == MOUSE_RIGHT) gtk_widget_hide (widget);    
}

/* ɽɥ ********************************************** */
GtkWidget*
te_pixel_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*label;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize (window);  
  gdk_window_set_decorations (window->window, FALSE);
  gtk_widget_set_events (window, GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect (GTK_OBJECT (window),
		      "button_press_event",
		      (GtkSignalFunc) te_pixel_window_hide, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);

  label= gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (label), FALSE);

  gtk_container_add (GTK_CONTAINER (window), label);
  gtk_widget_show (label);
  gtk_object_set_data (GTK_OBJECT (window), "label", label);

  return window;
}

/* ************************************************** End of pixelinfo.c *** */
