/* ********************************************************** playerII.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/02/01 11:07:45 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "playerII.h"
#include "playerII_left.xpm"
#include "playerII_right.xpm"
#include "playerII_top.xpm"
#include "playerII_bottom.xpm"
#include "playerII_mask.xpm"
#include "play.xpm"
#include "back.xpm"
#include "next.xpm"
#include "prev.xpm"
#include "stop.xpm"
#include "repeat.xpm"
#include "close.xpm"
#include "repeat_item.xpm"
#include "slider_item.xpm"
#include "slider.xpm"
#include "font.xpm"
#include "digits.xpm"

#define	MIN_SPEED	1
#define	MAX_SPEED	1000
#define	DEFAULT_SPEED	50

/* ؿ ************************************************************ */
static void	te_playerII_update_controller	(int		value);
static void	te_playerII_show_nth 		(int		n);
static void	te_playerII_show_next		(void);
static void	te_playerII_show_previous	(void);
static void	play_forward			(void);
static void	play_backward			(void);
static void	start_play_forward		(void);
static void	start_play_backward	 	(void);
static void	stop_play_image			(void);
static void	exit_player			(void);
static void	set_play_speed 			(float		value);

static int	te_playerII_scrollbar_changed	(GtkWidget	*widget,
						 GtkAdjustment	*adj);
static int	te_playerII_spinbutton_changed	(GtkWidget	*widget,
						 GtkAdjustment	*adj);

/* ޥ֤Υåؿ ************************************************ */
static int	check_control_widget_proximity 	(GtkWidget	*widget,
						 gint		x,
						 gint		y);
static int	check_each_button_proximity	(ButtonData	*button,
						 gint		x,
						 gint		y);
static int	check_button_proximity		(GtkWidget	*window,
						 gint		x,
						 gint		y);
static int	check_slider_press_proximity	(GtkWidget	*window,
						 SliderData	*slider,
						 gint		x,
						 gint		y);
static void	check_font_motion_proximity 	(FontData	*font,
						 gint		x,
						 gint		y);
static void	check_font_leave_proximity 	(FontData	*font);
static int	te_playerII_mouse_motion	(GtkWidget	*widget,
						 GdkEventMotion	*ev,
						 gpointer	data);
static int	te_playerII_mouse_pressed	(GtkWidget	*widget,
						 GdkEventMotion	*ev,
						 gpointer	data);
static int	te_playerII_mouse_released 	(GtkWidget	*widget,
						 GdkEventMotion	*ev,
						 gpointer	data);
static int	te_playerII_mouse_leave		(GtkWidget	*widget,
						 GdkEventMotion	*ev,
						 gpointer	data);

/* ǡؿ **************************************************** */
static void	redraw_skin 			(GtkWidget	*window);
static void	draw_button 			(GtkWidget	*window,
						 ButtonData	*button,
						 int		type);
static void	draw_item 			(GtkWidget	*window,
						 ItemData	*item,
						 int		type);
static void	draw_slider_private		(GtkWidget	*window,
						 SliderData	*slider,
						 float		position,
						 gint		absolute,
						 gint		move,
						 gint		force);
static void	slider_motion			(GtkWidget	*window,
						 SliderData	*slider,
						 gint		x,
						 gint		y);
static void	draw_font 			(GtkWidget	*window,
						 FontData	*font);
static void	update_font			(GtkWidget	*window);
static void	set_font_text 			(GtkWidget	*window,
						 gchar		*text);
static void	draw_digit			(GtkWidget	*window,
						 NumberData	*digit,
						 int		data);

/* ǡɤ߹ߴؿ ************************************************ */
static ButtonData*	button_new_from_file	(char		*pixname, 
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area,
						 int		type);
static ButtonData*	button_new_from_xpm 	(char		**data,
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area,
						 int		type);
static ItemData*	item_new_from_file	(char		*pixname,
						 int		sections,
						 int		cx,
						 int		cy,
						 int		area);
static ItemData*	item_new_from_xpm	(char		**data,
						 int		sections,
						 int		cx,
						 int		cy,
						 int		area);
static SliderData*	slider_new_from_file	(char		*pixname,
						 ItemData	*item,
						 int		prelight,
						 int		verticle,
						 int		reversed,
						 int		length,
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area);
static SliderData*	slider_new_from_xpm 	(char		**data,
						 ItemData	*item,
						 int		prelight,
						 int		verticle,
						 int		reversed,
						 int		length,
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area);
static FontData*	font_new_from_file	(char		*pixname, 
						 int		length,
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area);
static FontData*	font_new_from_xpm	(char		**data,
						 int		length,
						 int		cx,
						 int		cy,
						 int		x,
						 int		y,
						 int		area);
static SkinData*	te_playerII_skin_new	(char		*skin_data);

static void		set_style_all 		(GtkWidget	*widget,
						 gpointer	data);

static int		play_timer;
static int		play_speed = DEFAULT_SPEED;
static int		repeat_flg;

static const gchar	iso_ascii[] =
{
  ' ','|','c','L','c','Y','|','S','\"','c',' ','<','!','-','r','~',
  'o',' ','2','3','\'','u','p','.',',','1',' ','>',' ',' ',' ','?',
  'A','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I',
  'D','N','O','O','O','O','O','x','0','U','U','U','U','Y','P','B',
  'a','a','a','a','a','a','a','c','e','e','e','e','i','i','i','i',
  'o','n','o','o','o','o','o','/','o','u','u','u','u','y','p','y'
};

/* ************************************************************************* *
 * ؿ
 * ************************************************************************* */

/* 楦åȤι ************************************************** */
static void
te_playerII_update_controller (int	value) {
  GtkWidget	*widget;
  GtkAdjustment	*adj;
  char		buf[32];

  widget = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (playerII), "spinbutton");
  adj = (GtkAdjustment *)
    gtk_object_get_data (GTK_OBJECT (playerII), "spinbutton_adj");
  adj->value = value;
  sprintf (buf, "%d", (int) value);
  gtk_entry_set_text (GTK_ENTRY (widget), buf);

  widget = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (playerII), "scrollbar");
  adj = (GtkAdjustment *)
    gtk_object_get_data (GTK_OBJECT (playerII), "scrollbar_adj");
  adj->value = value;
  gtk_range_default_hslider_update (GTK_RANGE (widget));
}

/* ꤵ줿ɽ **************************************************** */
static void
te_playerII_show_nth (int	n) {
  if (g_list_nth (g_list_first (image_list), n)) {
    image_list = g_list_nth (g_list_first (image_list), n);
    te_image_set_image (image_list, 0);
    set_font_text (playerII, te_image_get_filename (image_list));
  }
}

/* βɽ ********************************************************** */
static void
te_playerII_show_next (void) {
  int	frame;

  if (opt->display_mode) {
    if (g_list_next (te_image_get_pixlist (image_list)) &&
	g_list_next (te_image_get_msklist (image_list))) {

      /* ꥹȤ */            
      te_image_set_pixlist_next (image_list);
      te_image_set_msklist_next (image_list);

      /* ǡΥå */      
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) + 1);

      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));
    } else {
      if (g_list_next (image_list)) {
	image_list = g_list_next (image_list);
	te_image_set_image (image_list, 0);
	set_font_text (playerII, te_image_get_filename (image_list));
	te_playerII_update_controller(g_list_length(g_list_first(image_list))-
				      g_list_length (image_list));
      }
    }
  } else {
    if (te_image_get_teofp (image_list) &&
	te_image_get_frame (image_list) <
	TeoFrame (te_image_get_teofp (image_list)) - 1) {
      /* Υե졼ǡΥå */
      te_image_create_frame_data (image_list,
				  te_image_get_frame (image_list) + 1);
      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));      
    } else {
      /* βɽ */
      if (g_list_next (image_list)) {
	image_list = g_list_next (image_list);
	te_image_set_image (image_list, 0);
	set_font_text (playerII, te_image_get_filename (image_list));
	te_playerII_update_controller (g_list_length(g_list_first(image_list))-
				       g_list_length (image_list));
      }
    }
  }
}

/* βɽ ********************************************************** */
static void
te_playerII_show_previous (void) {
  GList	*list;
  int	frame;

  if (opt->display_mode) {
    if (g_list_previous (te_image_get_pixlist (image_list)) &&
	g_list_previous (te_image_get_msklist (image_list))) {

      /* ꥹȤ */      
      te_image_set_pixlist_previous (image_list);
      te_image_set_msklist_previous (image_list);      

      /* ǡΥå */
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) - 1);

      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));
    } else {
      if (g_list_previous (image_list)) {
	image_list = g_list_previous (image_list);
	te_image_set_image (image_list, -1);
	set_font_text (playerII, te_image_get_filename (image_list));
	te_playerII_update_controller(g_list_length(g_list_first(image_list))-
				      g_list_length (image_list));
      }
    }
  } else {
    if (te_image_get_teofp (image_list) &&
	te_image_get_frame (image_list) > 0) {
      /* Υե졼ǡΥå */
      te_image_create_frame_data (image_list,
				  te_image_get_frame (image_list) - 1);
      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));
    } else {
      if (g_list_previous (image_list)) {
	image_list = g_list_previous (image_list);
	if (list && te_image_get_format (image_list) == FORMAT_TEO) {
	  te_image_set_image (image_list, -1);
	} else {
	  te_image_set_image (image_list, 0);
	}
	set_font_text (playerII, te_image_get_filename (image_list));
	te_playerII_update_controller (g_list_length
				       (g_list_first(image_list))-
				       g_list_length (image_list));
      }
    }
  }
}

/* ꥹȤϢ³ɽ() ******************************************** */
static void
play_forward (void) {
  GtkWidget	*widget;
  GtkAdjustment	*adj;
  char		buf[64];
  int		frame;
  int		value;

  if (opt->display_mode) {
    
    if (g_list_next (te_image_get_pixlist (image_list)) &&
	g_list_next (te_image_get_msklist (image_list))) {
	  
      /* ޥե졼TEOļΥե졼ब... */

      /* ꥹȤ */            
      te_image_set_pixlist_next (image_list);
      te_image_set_msklist_next (image_list);

      /* ǡΥå */      
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) + 1);

      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));

    } else if (g_list_next (image_list)) {
      
      /* β... */

      image_list = g_list_next (image_list);
      te_image_set_image (image_list, 0);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller(g_list_length(g_list_first(image_list))-
				    g_list_length (image_list));
      
    } else if (repeat_flg) {

      /* ֤⡼ɤξ...(Ƭ) */      

      image_list = g_list_first (image_list);
      te_image_set_image (image_list, 0);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller (0);
      
    } else {
      /*  */
      if (play_timer) gtk_timeout_remove (play_timer);
      play_timer = 0;
    }
  } else {
    
    if (te_image_get_teofp (image_list) &&
	te_image_get_frame (image_list) <
	TeoFrame (te_image_get_teofp (image_list)) - 1) {

      /* ޥե졼TEOļΥե졼ब... */

      /* Υե졼ǡΥå */
      te_image_create_frame_data (image_list,
				  te_image_get_frame (image_list) + 1);
      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));

    } else if (g_list_next (image_list)) {

      /* β... */
      image_list = g_list_next (image_list);
      te_image_set_image (image_list, 0);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller (g_list_length(g_list_first(image_list))-
				     g_list_length (image_list));
      
    } else if (repeat_flg) {
      
      /* ֤⡼ɤξ... */

      image_list = g_list_first (image_list);
      te_image_set_image (image_list, 0);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller (0);

    } else {
      /*  */
      if (play_timer) gtk_timeout_remove (play_timer);
      play_timer = 0;
    }
  }
}

/* ꥹȤϢ³ɽ() ******************************************** */
static void
play_backward (void) {
  int	frame;

  if (opt->display_mode) {

    if (g_list_previous (te_image_get_pixlist (image_list)) &&
	g_list_previous (te_image_get_msklist (image_list))) {
	  
      /* ޥե졼TEOΥե졼ब... */

      /* ꥹȤ */            
      te_image_set_pixlist_previous (image_list);
      te_image_set_msklist_previous (image_list);

      /* ǡΥå */      
      te_image_set_pixmap (image_list);
      te_image_set_mask   (image_list);

      /* ߤΥե졼 */
      te_image_set_frame (image_list, te_image_get_frame (image_list) - 1);

      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));

    } else if (g_list_previous (image_list)) {
      
      /* β... */

      image_list = g_list_previous (image_list);
      te_image_set_image (image_list, -1);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller(g_list_length(g_list_first(image_list))-
				    g_list_length (image_list));
      
    } else if (repeat_flg) {

      /* ֤⡼ɤξ...(β) */      

      image_list = g_list_last (image_list);
      te_image_set_image (image_list, -1);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller(g_list_length(g_list_first(image_list))-1);
      
    } else {
      /*  */
      if (play_timer) gtk_timeout_remove (play_timer);
      play_timer = 0;
    }    
  } else {
    if (te_image_get_teofp (image_list) &&
	te_image_get_frame (image_list) > 0) {

      /* ޥե졼TEOΥե졼ब... */

      /* Υե졼ǡΥå */
      te_image_create_frame_data (image_list,
				  te_image_get_frame (image_list) - 1);
      /*  */
      te_draw_image (image_list,
		     te_image_get_curr_width  (image_list),
		     te_image_get_curr_height (image_list));

    } else if (g_list_previous (image_list)) {

      /* β... */
      image_list = g_list_previous (image_list);
      te_image_set_image (image_list, -1);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller (g_list_length(g_list_first(image_list))-
				     g_list_length (image_list));
      
    } else if (repeat_flg) {
      
      /* ֤⡼ɤξ... */

      image_list = g_list_last (image_list);
      te_image_set_image (image_list, -1);
      set_font_text (playerII, te_image_get_filename (image_list));
      te_playerII_update_controller(g_list_length(g_list_first(image_list))-1);

    } else {
      /*  */
      if (play_timer) gtk_timeout_remove (play_timer);
      play_timer = 0;
    }
  }
}

/* ץ쥤ܥ󤬲줿ν ****************************************** */
static void 
start_play_forward (void) {
  if (play_timer != 0) return;
  play_timer = gtk_timeout_add (play_speed,
				(GtkFunction) play_forward, NULL);
}

/* Хåܥ󤬲줿ν ****************************************** */
static void
start_play_backward (void) {
  if (play_timer != 0) return;  
  play_timer = gtk_timeout_add (play_speed,
				(GtkFunction) play_backward, NULL);
}

/* ȥåץܥ󤬲줿ν **************************************** */
static void
stop_play_image (void) {
  if (play_timer) gtk_timeout_remove (play_timer);
  play_timer = 0;
}

/* ץ졼Ĥ ******************************************************** */
static void
exit_player (void) {
  stop_play_image ();
  gtk_widget_hide (playerII);
  gtk_widget_destroy (playerII);
  playerII = NULL;
  if (update_timer) gtk_timeout_remove (update_timer);
  update_timer = 0;
}

/* ®٤ ********************************************************** */
static void
set_play_speed (float	value) {
  play_speed = MIN_SPEED + ((MAX_SPEED - MIN_SPEED) / 100.0) * (value * 100.0);
}

/* Сˤ ****************************************** */
static int
te_playerII_scrollbar_changed	(GtkWidget	*widget,
				 GtkAdjustment	*adj) {
  GtkWidget	*spinbutton;
  GtkAdjustment	*spinbutton_adj;
  char		buf[64];

  spinbutton = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (playerII), "spinbutton");
  spinbutton_adj = (GtkAdjustment *)
    gtk_object_get_data (GTK_OBJECT (playerII), "spinbutton_adj");

  spinbutton_adj->value = adj->value;
  sprintf (buf, "%d", (int) adj->value);
  gtk_entry_set_text (GTK_ENTRY (spinbutton), buf);

  te_playerII_show_nth ((int) adj->value);
  
  return TRUE;
}

/* ԥܥˤ ******************************************** */
static int
te_playerII_spinbutton_changed	(GtkWidget	*widget,
				 GtkAdjustment	*adj) {
  GtkWidget	*scrollbar;
  GtkAdjustment	*scrollbar_adj;

  scrollbar = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (playerII), "scrollbar");
  scrollbar_adj = (GtkAdjustment *)
    gtk_object_get_data (GTK_OBJECT (playerII), "scrollbar_adj");

  scrollbar_adj->value = adj->value;
  gtk_range_default_hslider_update (GTK_RANGE (scrollbar));

  te_playerII_show_nth ((int) adj->value);
  
  return TRUE;
}

/* ************************************************************************* *
 * ޥåؿ
 * ************************************************************************* */

/* ޥ뤬ȥ륦åȤΥեäƤ뤫Ĵ٤  */
static int
check_control_widget_proximity (GtkWidget	*widget,
				gint		x,
				gint		y) {
  SkinData	*skin;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (widget), "skin");

  if (x >= skin->cx && x < skin->cx + skin->cw &&
      y >= skin->cy && y < skin->cy + skin->ch) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ޥ뤬ܥΥեäƤ뤫Ĵ٤ ****************** */
static int
check_each_button_proximity (ButtonData	*button,	
			     gint	x,
			     gint	y) {
  if (x >= button->x && x < button->x + button->w &&
      y >= button->y && y < button->y + button->h) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ޥ뤬ɤΥܥΥեäƤ뤫Ĵ٤ ************** */
static int
check_button_proximity (GtkWidget	*window,
			gint		x,
			gint		y) {
  SkinData	*skin;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");

  if (check_each_button_proximity (skin->play_button, x, y))
    return 1;
  if (check_each_button_proximity (skin->back_button, x, y))
    return 2;
  if (check_each_button_proximity (skin->next_button, x, y))
    return 3;
  if (check_each_button_proximity (skin->prev_button, x, y))
    return 4;
  if (check_each_button_proximity (skin->stop_button, x, y))
    return 5;
  if (check_each_button_proximity (skin->rept_button, x, y))
    return 6;
  if (check_each_button_proximity (skin->exit_button, x, y))
    return 7;
  return 0;
}

/* ޥ뤬饤äƤ뤫Ĵ٤ ************************** */
static int
check_slider_press_proximity (GtkWidget		*window,
			      SliderData	*slider,
			      gint		x,
			      gint		y) {
  float	pos;

  if ((slider->verticle &&
       x >= slider->x && x < slider->x + slider->h &&
       y >= slider->y && y < slider->y + slider->w) ||
      (!slider->verticle &&
       x >= slider->x && x < slider->x + slider->w &&
       y >= slider->y && y < slider->y + slider->h)) {

    if (slider->verticle) {
      pos = y - slider->y - (slider->handle_width / 2);
    } else {
      pos = x - slider->x - (slider->handle_width / 2);
    }
    if (pos < 0) pos = 0;
    if (pos > slider->w - slider->handle_width)
      pos = slider->w - slider->handle_width;
    draw_slider_private (window, slider, pos, TRUE, TRUE, FALSE);
    if (slider->reversed) {
      set_play_speed (1.0 - (pos / (slider->w - slider->handle_width)));
    } else {
      set_play_speed (pos / (slider->w - slider->handle_width));
    }
    draw_digit (window,
		((SkinData *)
		 gtk_object_get_data (GTK_OBJECT (window), "skin"))->digit,
		play_speed);
    return TRUE;
  }
  return FALSE;
}

/* ޥ뤬ȥɽϰϤäƤ뤫Ĵ٤ ******************** */
static void
check_font_motion_proximity (FontData	*font,
			     gint	x,
			     gint	y) {
  if (!font) return;
  
  if (x >= font->x && x < font->x + font->w &&
      y >= font->y && y < font->y + font->h) {
    font->scroll = 1;
  } else {
    font->scroll = -1;
  }
} 

/* ޥ뤬ɥФΥȥɽ **************** */
static void
check_font_leave_proximity (FontData	*font) {
  if (!font) return;
  font->scroll = -1;
}

/* ޥưν ************************************************** */
static int
te_playerII_mouse_motion (GtkWidget		*widget,
			  GdkEventMotion	*ev,
			  gpointer		data) {
  GtkWidget		*window;
  GdkModifierType	mod;
  SkinData		*skin;
  int			id;
  int			move_flg;
  int			slider_flg;
  gint			pos_x, pos_y;
  gint			new_x, new_y;
  gint			xmove, ymove;
  gint			x = (gint) ev->x;
  gint			y = (gint) ev->y;
  gint			l;

  skin  = (SkinData *)  gtk_object_get_data (GTK_OBJECT (widget), "skin");
  move_flg   = (int) gtk_object_get_data (GTK_OBJECT (widget), "move_flg");
  slider_flg = (int) gtk_object_get_data (GTK_OBJECT (widget), "slider_flg");  
  xmove = (int) gtk_object_get_data (GTK_OBJECT (widget), "move_x_pos");
  ymove = (int) gtk_object_get_data (GTK_OBJECT (widget), "move_y_pos");

  if (check_control_widget_proximity (widget, x, y)) return;

  if (move_flg) {
    gdk_window_get_pointer (NULL, &pos_x, &pos_y, &mod);
    new_x = pos_x - xmove;	
    new_y = pos_y - ymove;
    gdk_window_move (widget->window, new_x, new_y);
  } else if (slider_flg) {
    slider_motion (widget, skin->slider, x, y);
  } else {
    if ((id = check_button_proximity (widget, x, y)) != 0) {
      switch (id) {
      case 1:
	draw_button (widget, skin->play_button, 2);
	break;
      case 2:
	draw_button (widget, skin->back_button, 2);
	break;
      case 3:
	draw_button (widget, skin->next_button, 2);
	break;
      case 4:
	draw_button (widget, skin->prev_button, 2);
	break;
      case 5:
	draw_button (widget, skin->stop_button, 2);
	break;
      case 6:
	draw_button (widget, skin->rept_button, 2);
	break;
      case 7:
	draw_button (widget, skin->exit_button, 2);
	break;
      }
    } else {
      draw_button (widget, skin->play_button, 0);
      draw_button (widget, skin->back_button, 0);
      draw_button (widget, skin->next_button, 0);
      draw_button (widget, skin->prev_button, 0);
      draw_button (widget, skin->stop_button, 0);
      draw_button (widget, skin->rept_button, 0);
      draw_button (widget, skin->exit_button, 0);
    }
  }
  check_font_motion_proximity (skin->font, x, y);
}

/* ޥܥ󤬥å줿ν ************************************ */
static int
te_playerII_mouse_pressed (GtkWidget		*widget,
			   GdkEventMotion	*ev,
			   gpointer		data) {
  SkinData		*skin;
  GdkModifierType	mod;
  int			id;
  int			rept_flg;
  int			x = (gint) ev->x;
  int			y = (gint) ev->y;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (widget), "skin");

  gtk_object_set_data (GTK_OBJECT (widget), "move_x_pos", (gpointer) x);
  gtk_object_set_data (GTK_OBJECT (widget), "move_y_pos", (gpointer) y);

  if ((id = check_button_proximity (widget, x, y)) != 0) {
    switch (id) {
    case 1:
      draw_button (widget, skin->play_button, 1);
      break;
    case 2:
      draw_button (widget, skin->back_button, 1);
      break;
    case 3:
      draw_button (widget, skin->next_button, 1);
      break;
    case 4:
      draw_button (widget, skin->prev_button, 1);
      break;
    case 5:
      draw_button (widget, skin->stop_button, 1);
      break;
    case 6:
      rept_flg = (int) gtk_object_get_data (GTK_OBJECT (widget), "rept_flg");
      gtk_object_set_data (GTK_OBJECT (widget),
			   "rept_flg", (gpointer) !rept_flg);
      repeat_flg = !rept_flg;
      draw_button (widget, skin->rept_button, 1);
      draw_item   (widget, skin->rept_item, !rept_flg);
      break;
    case 7:
      draw_button (widget, skin->exit_button, 1);
      break;
    }
  } else if (check_slider_press_proximity (widget, skin->slider, x, y)) {
    gtk_object_set_data (GTK_OBJECT (widget), "slider_flg", (gpointer) 1);
  } else {
    gdk_window_get_pointer (widget->window, &x, &y, &mod);
    if (!check_control_widget_proximity (widget, x, y)) {
      gtk_object_set_data (GTK_OBJECT (widget), "move_flg", (gpointer) 1);
    }
  }
}

/* ޥܥΥ줿ν ****************************************** */
static int
te_playerII_mouse_released (GtkWidget		*widget,
			    GdkEventMotion	*ev,
			    gpointer		data) {
  GList		*list;
  SkinData	*skin;
  int		id;
  int		frame;
  int		xpos, ypos;

  skin = (SkinData *)  gtk_object_get_data (GTK_OBJECT (widget), "skin");
  xpos = (int) gtk_object_get_data (GTK_OBJECT (widget), "move_x_pos");
  ypos = (int) gtk_object_get_data (GTK_OBJECT (widget), "move_y_pos");

  gtk_object_set_data (GTK_OBJECT (widget), "move_flg",   (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (widget), "slider_flg", (gpointer) 0);
  
  if (id = check_button_proximity (widget, xpos, ypos)) {
    switch (id) {
    case 1:
      draw_button (widget, skin->play_button, 2);
      start_play_forward ();
      break;
    case 2:
      draw_button (widget, skin->back_button, 2);
      start_play_backward ();
      break;
    case 3:
      draw_button (widget, skin->next_button, 2);
      te_playerII_show_next ();
      break;
    case 4:
      draw_button (widget, skin->prev_button, 2);
      te_playerII_show_previous ();
      break;
    case 5:
      stop_play_image ();
      draw_button (widget, skin->stop_button, 2);
      break;
    case 6:
      draw_button (widget, skin->rept_button, 2);
      break;
    case 7:
      exit_player ();
#if 0      
      draw_button (widget, skin->exit_button, 2);
#endif
      break;
    }
  }
}

/* ޥݥ󥿤ե鳰줿ν **************************** */
static int
te_playerII_mouse_leave (GtkWidget		*widget,
			 GdkEventMotion		*ev,
			 gpointer		data) {
  SkinData	*skin;

  skin   = (SkinData *)  gtk_object_get_data (GTK_OBJECT (widget), "skin");

  draw_button (widget, skin->play_button, 0);
  draw_button (widget, skin->back_button, 0);
  draw_button (widget, skin->next_button, 0);
  draw_button (widget, skin->prev_button, 0);
  draw_button (widget, skin->stop_button, 0);
  draw_button (widget, skin->rept_button, 0);
  draw_button (widget, skin->exit_button, 0);
}

/* ************************************************************************* *
 * ؿ
 * ************************************************************************* */

/* κ ********************************************************** */
static void
redraw_skin (GtkWidget	*window) {
  SkinData	*skin;
  int		w, h;

  skin = (SkinData *)
    gtk_object_get_data (GTK_OBJECT (window), "skin");
  gdk_window_get_size (skin->mask[4], &w, &h);
  gtk_widget_set_usize (window, w, h);
  gtk_widget_shape_combine_mask (window, skin->mask[4], 0, 0);
}

/* ܥ ************************************************************ */
static void
draw_button (GtkWidget	*window,
	     ButtonData	*button,
	     int	type) {
  GtkWidget	*draw_area;
  SkinData	*skin;
  char		name[64];

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");
  
  sprintf (name, "draw_area%d", button->area);
  draw_area = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (window), name);

  gdk_draw_pixmap (skin->background[button->area], 
		   draw_area->style->fg_gc[GTK_WIDGET_STATE (draw_area)],
		   button->pixmap, button->w * type, 0, 
		   button->cx, button->cy, button->w, button->h);
  gdk_window_clear (draw_area->window);
}

/* ƥ ********************************************************** */
static void
draw_item (GtkWidget	*window,
	   ItemData	*item,
	   int		type) {
  GtkWidget	*draw_area;
  SkinData	*skin;
  char		name[64];

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");

  sprintf (name, "draw_area%d", item->area);
  draw_area = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (window), name);

  gdk_draw_pixmap (skin->background[item->area], 
		   draw_area->style->fg_gc[GTK_WIDGET_STATE (draw_area)],
		   item->pixmap, 0, item->h * type,
		   item->cx, item->cy, item->w, item->h);
  gdk_window_clear (draw_area->window);
}

/* 饤 ******************************************************** */
static void
draw_slider_private (GtkWidget	*window,
		     SliderData	*slider,
		     float	position,
		     gint	absolute,
		     gint	move,
		     gint	force) {
  gint	new_pos;

  if (move) {
    if (absolute) {
      new_pos = (float) position;
    } else {
      new_pos = (float) (slider->w - slider->handle_width) * position;
    }
    if (new_pos < 0) new_pos = 0;
    if (new_pos > slider->w - slider->handle_width)
      new_pos = slider->w - slider->handle_width;
  } else {
    new_pos = slider->position;
  }

  if (force) {
    if (move) slider->position = new_pos;
    if (slider->item) {
      gint section =
	(float) slider->position / (slider->w - slider->handle_width)
	* (slider->item->sections - 1);
      draw_item (window, slider->item, section);
    }
    return;
  }

  if (slider->position != new_pos) {
    if (slider->item) {
      gint section =
	(float) new_pos / (slider->w - slider->handle_width)
	* (slider->item->sections - 1);
      draw_item(window, slider->item, section);
    }
  }
}

/* ޥ뤬饤äƤ뤫Ĵ٤ ************************** */
static void
slider_motion (GtkWidget	*window,
	       SliderData	*slider,
	       gint		x,
	       gint		y) {
  float	pos;

  if (slider->verticle) {
    pos = y - slider->y - (slider->handle_width / 2);
  } else {
    pos = x - slider->x - (slider->handle_width / 2);
  }
  if (pos < 0) pos = 0;
  if (pos > slider->w - slider->handle_width)
    pos = slider->w - slider->handle_width;
  if (slider->position != pos) {
    if (slider->reversed) {
      set_play_speed (1.0 - (pos / (slider->w - slider->handle_width)));
    } else {
      set_play_speed (pos / (slider->w - slider->handle_width));
    }
    draw_digit (window,
		((SkinData *)
		 gtk_object_get_data (GTK_OBJECT (window), "skin"))->digit,
		play_speed);
    draw_slider_private (window, slider, pos, TRUE, TRUE, FALSE);
  }
}

/* ȥեȤ ************************************************** */
static void
draw_font (GtkWidget	*window,
	   FontData	*font) {
  GtkWidget	*draw_area;
  SkinData	*skin;
  gint		n;
  gint		px, py;
  guint8	c;
  gint		l;
  gchar		*start;
  char		name[64];

  if (!font) return;
  if (font->text) {
    l = strlen (font->text);
  } else {
    l = 0;
  }
  if (font->offset >= l) font->offset = l - 1;
  if (font->offset < 0)  font->offset = 0;
  if (font->text) {
    start = font->text + font->offset;
  } else {
    start = NULL;
  }
  l -= font->offset;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");

  sprintf (name, "draw_area%d", font->area);
  draw_area = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (window), name);

  for (n = 0; n < font->length; n++) {
    if (n < l) {
      c = start[n];
      if (c >= 32 && c < 128) {
	c -= 32;
      } else if (c >= 160 && c < 256) {
	c = iso_ascii[c-160];
	c -= 32;
      } else {
	c = 0;
      }

      py = c / 32;
      px = c - (py * 32);
      px = px * font->char_width;
      py = py * font->char_height;
      gdk_draw_pixmap (skin->background[font->area],
		       draw_area->style->fg_gc[GTK_WIDGET_STATE (draw_area)],
		       font->pixmap,
		       px, py,
		       font->cx + n * font->char_width, font->cy,
		       font->char_width, font->char_height);
    } else {
      gdk_draw_pixmap (skin->background[font->area],
		       draw_area->style->fg_gc[GTK_WIDGET_STATE (draw_area)],
		       font->pixmap,
		       0, 0,
		       font->cx + n * font->char_width, font->cy,
		       font->char_width, font->char_height);
    }
  }
  gdk_window_clear (draw_area->window);
}

/* ȥեȤΥåץǡ ****************************************** */
static void
update_font (GtkWidget	*window) {
  FontData	*font;

  font =
    ((SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin"))->font;
  if (!font || !font->text) return;
  if (font->scroll > 0) {
    gint l = strlen (font->text);
    if (font->offset < l - font->length && l > font->length) {
      font->offset++;
      draw_font (window, font);
    }
  } else if (font->offset > 0) {
    while (font->offset > 0) {
      font->offset--;
      draw_font (window, font);
    }
  }
}

/* ȥեȤ ************************************************** */
static void
set_font_text (GtkWidget	*window,
	       gchar		*text) {
  SkinData	*skin;
  FontData	*font;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");
  font = skin->font;
  
  if (!font) return;
  g_free (font->text);
  if (text) {
    font->text = g_strdup (text);
  } else {
    font->text = NULL;
  }
  font->offset = 0;
  draw_font (window, font);
}

/* ȥեȤ ************************************************** */
static void
draw_digit (GtkWidget	*window,
	    NumberData	*digit,
	    int		data) {
  GtkWidget	*draw_area;
  SkinData	*skin;
  int		n;
  int		pos;
  int		num;
  int		base = 1000;
  char		name[64];

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (window), "skin");
  
  sprintf (name, "draw_area%d", digit->area);
  draw_area = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (window), name);

  for (num = data, n = 0; n < 4; n++) {
    /*  */
    pos = (int) (num / base);
    if (pos != 0) num -= pos * base;
    base /= 10;
    /* 褹 */
    gdk_draw_pixmap (skin->background[digit->area], 
		     draw_area->style->fg_gc[GTK_WIDGET_STATE (draw_area)],
		     digit->pixmap,
		     digit->w * pos, 0,
		     digit->cx + n * digit->w, digit->cy,
		     digit->w, digit->h);
  }
  gdk_window_clear (draw_area->window);
}

/* ************************************************************************* *
 * ǡ
 * ************************************************************************* */

/* ܥǡ(ե) ********************************** */
static ButtonData*
button_new_from_file (char	*pixname,
		      int	cx,
		      int	cy,
		      int	x,
		      int	y,
		      int	area,	
		      int	type) {
  ButtonData	*b;
  int		w, h;
  GdkPixbuf	*pbuf;
  GdkBitmap	*mask;

  b = (ButtonData *) malloc (sizeof (ButtonData));

  pbuf = gdk_pixbuf_new_from_file (pixname);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &(b->pixmap), &mask, 255);
  gdk_pixbuf_unref (pbuf);
  if (mask) gdk_bitmap_unref (mask);

  gdk_window_get_size (b->pixmap, &w, &h);
  b->cx   = cx;
  b->cy	  = cy;
  b->x	  = x;
  b->y	  = y;
  b->w	  = (type == 0) ? w / 3 : w / 2;
  b->h	  = h;
  b->area = area;
  
  return b;	
}

/* ܥǡ(ǡ) ************************************ */
static ButtonData*
button_new_from_xpm (char	**data,
		     int	cx,
		     int	cy,
		     int	x,
		     int	y,
		     int	area,	
		     int	type) {
  ButtonData	*b;
  int		w, h;
  GdkBitmap	*mask;

  b = (ButtonData *) malloc (sizeof (ButtonData));

  b->pixmap =
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (), &mask, NULL, data);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (b->pixmap, &w, &h);
  b->cx   = cx;
  b->cy	  = cy;
  b->x	  = x;
  b->y	  = y;
  b->w 	  = (type == 0) ? w / 3 : w / 2;
  b->h	  = h;
  b->area = area;
  return b;	
}

/* ƥǡ(ե) ******************************** */
static ItemData*
item_new_from_file (char	*pixname,
		    int		sections,
		    int		cx,
		    int		cy,
		    int		area) {
  ItemData	*i;
  int		w, h;
  GdkPixbuf	*pbuf;
  GdkBitmap	*mask;

  i = (ItemData *) malloc (sizeof (ItemData));

  pbuf = gdk_pixbuf_new_from_file (pixname);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &(i->pixmap), &mask, 255);
  gdk_pixbuf_unref (pbuf);
  if (mask) gdk_bitmap_unref (mask);

  gdk_window_get_size (i->pixmap, &w, &h);

  i->sections	= sections;
  i->w		= w;
  i->h		= h / sections;
  i->cx		= cx;
  i->cy		= cy;
  i->area	= area;
  
  return i;
}

/* ƥǡ(ǡ) ********************************** */
static ItemData*
item_new_from_xpm (char		**data,
		   int		sections,
		   int		cx,
		   int		cy,
		   int		area) {
  ItemData	*i;
  int		w, h;
  GdkBitmap	*mask;

  i = (ItemData *) malloc (sizeof (ItemData));

  i->pixmap =
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (), &mask, NULL, data);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (i->pixmap, &w, &h);

  i->sections	= sections;
  i->w		= w;
  i->h		= h / sections;
  i->cx		= cx;
  i->cy		= cy;
  i->area	= area;
  
  return i;
}

/* 饤ǡ ************************************************** */
static SliderData*
slider_new_from_file (char		*pixname,
		      ItemData		*item,
		      int		prelight,
		      int		verticle,
		      int		reversed,
		      int		length,
		      int		cx,
		      int		cy,
		      int		x,
		      int		y,
		      int		area) {
  SliderData	*s;
  int		w, h;
  GdkPixbuf	*pbuf;
  GdkBitmap	*mask;

  s = (SliderData *) malloc (sizeof (SliderData));

  pbuf = gdk_pixbuf_new_from_file (pixname);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &(s->pixmap), &mask, 255);
  gdk_pixbuf_unref (pbuf);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (s->pixmap, &w, &h);

  s->prelight = prelight;
  s->verticle = verticle;
  s->reversed = reversed;
  s->cx	      = cx;
  s->cy	      = cy;
  s->x	      = x;
  s->y	      = y;
  s->position = 0;
  s->item     = item;
  s->area     = area;
  
  if (verticle) {
    s->w	     = length;
    s->h	     = w;
    s->handle_width  = (h - length) / (2 + prelight);
    s->handle_height = w;
  } else {
    s->w	     = length;
    s->h	     = h;
    s->handle_width  = (w - length) / (2 + prelight);
    s->handle_height = h;
  }

  return s;
}

/* 饤ǡ ************************************************** */
static SliderData*
slider_new_from_xpm (char		**data,
		     ItemData		*item,
		     int		prelight,
		     int		verticle,
		     int		reversed,
		     int		length,
		     int		cx,
		     int		cy,
		     int		x,
		     int		y,
		     int		area) {
  SliderData	*s;
  int		w, h;
  GdkBitmap	*mask;

  s = (SliderData *) malloc (sizeof (SliderData));

  s->pixmap =
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (), &mask, NULL, data);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (s->pixmap, &w, &h);

  s->prelight = prelight;
  s->verticle = verticle;
  s->reversed = reversed;
  s->cx	      = cx;
  s->cy	      = cy;
  s->x	      = x;
  s->y	      = y;
  s->position = 0;
  s->item     = item;
  s->area     = area;
  
  if (verticle) {
    s->w	     = length;
    s->h	     = w;
    s->handle_width  = (h - length) / (2 + prelight);
    s->handle_height = w;
  } else {
    s->w	     = length;
    s->h	     = h;
    s->handle_width  = (w - length) / (2 + prelight);
    s->handle_height = h;
  }

  return s;
}

/* եȥǡ(ե) ******************************** */
static FontData*
font_new_from_file (char	*pixname, 
		    int		length,
		    int		cx,
		    int		cy,
		    int		x,
		    int		y,
		    int		area) {
  FontData	*f;
  int		w, h;
  GdkPixbuf	*pbuf;
  GdkBitmap	*mask;

  f = (FontData *) malloc (sizeof (FontData));

  pbuf = gdk_pixbuf_new_from_file (pixname);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &(f->pixmap), &mask, 255);
  gdk_pixbuf_unref (pbuf);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (f->pixmap, &w, &h);

  f->char_width = w / 32;
  f->char_height= h / 3;
  f->w		= f->char_width * length;
  f->h		= f->char_height;
  f->length	= length;
  f->cx		= cx;
  f->cy		= cy;
  f->x		= x;
  f->y		= y;
  f->text	= NULL;
  f->offset	= 0;
  f->extended	= 0;
  f->area	= area;
  
  return f;
}

/* եȥǡ(ǡ) ********************************** */
static FontData*
font_new_from_xpm (char	**data,
		   int	length,
		   int	cx,
		   int	cy,
		   int	x,
		   int	y,
		   int	area) {
  FontData	*f;
  int		w, h;
  GdkBitmap	*mask;

  f = (FontData *) malloc (sizeof (FontData));

  f->pixmap =
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (), &mask, NULL, data);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (f->pixmap, &w, &h);

  f->char_width = w / 32;
  f->char_height= h / 3;
  f->w		= f->char_width * length;
  f->h		= f->char_height;
  f->length	= length;
  f->cx		= cx;
  f->cy		= cy;
  f->x		= x;
  f->y		= y;
  f->text	= NULL;
  f->offset	= 0;
  f->extended	= 0;
  f->area	= area;
  
  return f;
}

/* ʥСǡ(ե) ******************************** */
static NumberData*
digit_new_from_file (char	*pixname,
		     int	cx,
		     int	cy,
		     int	area) {
  NumberData	*d;
  int		w, h;
  GdkPixbuf	*pbuf;
  GdkBitmap	*mask;

  d = (NumberData *) malloc (sizeof (NumberData));

  pbuf = gdk_pixbuf_new_from_file (pixname);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &(d->pixmap), &mask, 255);
  gdk_pixbuf_unref (pbuf);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (d->pixmap, &w, &h);

  d->w    = w / 11;
  d->h	  = h;
  d->cx	  = cx;
  d->cy	  = cy;
  d->area = area;
  
  return d;
}

/* ʥСǡ(ǡ) ********************************** */
static NumberData*
digit_new_from_xpm (char	**data,
		    int		cx,
		    int		cy,
		    int		area) {
  NumberData	*d;
  int		w, h;
  GdkBitmap	*mask;

  d = (NumberData *) malloc (sizeof (NumberData));

  d->pixmap =
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (), &mask, NULL, data);
  if (mask) gdk_bitmap_unref (mask);
  gdk_window_get_size (d->pixmap, &w, &h);

  d->w	  = w / 11;
  d->h	  = h;
  d->cx	  = cx;
  d->cy	  = cy;
  d->area = area;
  
  return d;
}

/* ǡ ****************************************************** */
static SkinData*
te_playerII_skin_new (char	*skin_data) {
  SkinData	*skin;
  GdkPixbuf 	*pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  GdkBitmap	*dummy;
  ItemData	*slider_item;
  FILE		*fp;
  char		buf[512];
  char		data[512];
  char		b1[64], b2[64], b3[64];
  char		*skin_path;
  char		*name;
  int		cx, cy, a, x, y, l, n;

  skin = (SkinData *) malloc (sizeof (SkinData));

  if (skin_data) {
    /* ǡɤ߹ */
    fp = fopen (skin_data, "r");
    /* ǡѥγ */
    y_separate_dir_and_file (skin_data, &skin_path, &name);
    free (name);
    /* åȥɤ߹ */
    sprintf (data, "%s/gtkrc", skin_path);
    gtk_rc_parse (data);

    /* Υޥǡ */
    fscanf (fp, "%s", buf);
    sprintf (data, "%s/%s", skin_path, buf);
    pbuf = gdk_pixbuf_new_from_file (data);
    gdk_pixbuf_render_pixmap_and_mask (pbuf, &dummy, &(skin->mask[4]), 255);
    gdk_pixbuf_unref (pbuf);
    gdk_pixmap_unref (dummy);

    /* طʥǡ */
    for (n = 0; n < 4; n++) {
      fscanf (fp, "%s", buf);
      sprintf (data, "%s/%s", skin_path, buf);
      pbuf = gdk_pixbuf_new_from_file (data);
      skin->mask[n] = NULL;
      gdk_pixbuf_render_pixmap_and_mask (pbuf,
					 &(skin->background[n]),
					 &(skin->mask[n]), 255);
      gdk_pixbuf_unref (pbuf);
    }
    /* ץ쥤ܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);  
    sprintf (data, "%s/%s", skin_path, buf);
    skin->play_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* Хåܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->back_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->next_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->prev_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ȥåץܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->stop_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ԡȥܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->rept_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ܥ */
    fscanf (fp, "%s %d %d %d %d %d", buf, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->exit_button = button_new_from_file (data, cx, cy, x, y, a, FALSE);
    /* ԡȥƥ */
    fscanf (fp, "%s %d %d %d %d", buf, &l, &cx, &cy, &a);  
    sprintf (data, "%s/%s", skin_path, buf);
    skin->rept_item = item_new_from_file (data, l, cx, cy, a);
    /* 饤ƥ */
    fscanf (fp, "%s %d %d %d %d", buf, &l, &cx, &cy, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    slider_item = item_new_from_file (data, l, cx, cy, a);
    /* 饤 */
    fscanf (fp, "%s %s %s %s %d %d %d %d",
	    buf, b1, b2, b3, &l, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);

    skin->slider
      = slider_new_from_file (data,
			      slider_item,
			      (strcmp (b1, "FALSE") == 0) ? 0 : 1,
			      (strcmp (b2, "FALSE") == 0) ? 0 : 1,
			      (strcmp (b3, "FALSE") == 0) ? 0 : 1,
			      l, x, y, x, y, a);
    /* ե */
    fscanf (fp, "%s %d %d %d %d %d %d", buf, &l, &cx, &cy, &x, &y, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->font = font_new_from_file   (data, l, cx, cy, x, y, a);
    /* ǥ */
    fscanf (fp, "%s %d %d %d", buf, &cx, &cy, &a);
    sprintf (data, "%s/%s", skin_path, buf);
    skin->digit = digit_new_from_file   (data, cx, cy, a);
    /* 泰ΰ */
    fscanf (fp, "%d %d %d %d",
	    &(skin->cx), &(skin->cy), &(skin->cw), &(skin->ch));

    free (skin_path);

    fclose (fp);
    
  } else {

    /* åȥɤ߹ ************************************** */
    sprintf (data, "%s/gtkrc", DEFAULT_SKIN_DIR);
    gtk_rc_parse (data);

    /* طʥǡɤ߹ ************************************************ */
    /* ط() */
    gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
				  &(skin->mask[4]), NULL, playerII_mask_xpm);
    skin->background[0] =
      gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
				    &(skin->mask[0]), NULL, playerII_left_xpm);
    /* ط() */
    skin->background[1] =
      gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
				    &(skin->mask[1]),NULL, playerII_right_xpm);
    /* ط() */
    skin->background[2] =
      gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
				    &(skin->mask[2]), NULL, playerII_top_xpm);
    /* ط() */
    skin->background[3] =
      gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
				    &(skin->mask[3]),NULL,playerII_bottom_xpm);
    /* ܥǡɤ߹ */
    skin->play_button
      = button_new_from_xpm (play_xpm, 108,  15, 108,  15, 0, FALSE);
    skin->back_button
      = button_new_from_xpm (back_xpm,  29,  15,  29,  15, 0, FALSE);
    skin->next_button
      = button_new_from_xpm (next_xpm,  82,  15,  82,  15, 0, FALSE);
    skin->prev_button
      = button_new_from_xpm (prev_xpm,  55,  15,  55,  15, 0, FALSE);
    skin->stop_button
      = button_new_from_xpm (stop_xpm, 135,  15, 135,  15, 0, FALSE);
    skin->rept_button
      = button_new_from_xpm (repeat_xpm,  21,  30, 386,  30, 1, FALSE);
    skin->exit_button
      = button_new_from_xpm (close_xpm,  21,  9,  386,   9, 1, FALSE);
    skin->rept_item
      = item_new_from_xpm (repeat_item_xpm,   2, 160, 20, 2);
    slider_item
      = item_new_from_xpm   (slider_item_xpm, 18, 164, 0, 0);
    skin->slider
      = slider_new_from_xpm (slider_xpm, slider_item,
			     0, 1, 1, 68, 164, 0, 164, 0, 0);
    /* եȥǡɤ߹ */
    skin->font
      = font_new_from_xpm   (font_xpm, 14, 20, 10, 195, 10, 2);
    skin->digit
      = digit_new_from_xpm  (digit_xpm, 105, 25, 2);
    
    skin->cx = 175;
    skin->cy =  42;
    skin->cw = 190;
    skin->ch =  22;
  }
  return skin;
}

/* ץ졼 ********************************************************** */
GtkWidget*
te_playerII_new (char	*skin_data) {
  GtkWidget 	*window;
  GtkWidget 	*table;
  GtkWidget 	*hbox;
  GtkObject 	*hscrollbar_adj;
  GtkWidget 	*hscrollbar;
  GtkObject 	*spinbutton_adj;
  GtkWidget 	*spinbutton;
  GtkWidget 	*draw_area;
  SkinData	*skin;
  int		length;

  /* ǡɤ߹ */
  skin = te_playerII_skin_new (skin_data);
  
  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_ref (window);
  gtk_widget_set_name (window, "playerII widget");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);
  gtk_widget_set_events (window,
			 GDK_ENTER_NOTIFY_MASK | 
			 GDK_LEAVE_NOTIFY_MASK |
			 GDK_POINTER_MOTION_MASK |
			 GDK_BUTTON_PRESS_MASK |
			 GDK_BUTTON_RELEASE_MASK);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) exit_player, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) exit_player, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "motion_notify_event",
		      (GtkSignalFunc) te_playerII_mouse_motion, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "button_press_event",
		      (GtkSignalFunc) te_playerII_mouse_pressed, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "button_release_event",
		      (GtkSignalFunc) te_playerII_mouse_released, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "leave_notify_event",
		      (GtkSignalFunc) te_playerII_mouse_leave, NULL);

  gtk_widget_realize (window);
  gdk_window_set_decorations (window->window, FALSE);

  /* ơ֥ */
  table = gtk_table_new (3, 3, FALSE);
  gtk_widget_ref  (table);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (window), table);

  /* ʿBOX */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref  (hbox);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  {
    /* С */
    length = g_list_length (g_list_first (image_list));
    hscrollbar_adj = gtk_adjustment_new (0, 0, length, 1,
					 (length > 10) ? 10 : 1, 1);
    gtk_object_set_data (GTK_OBJECT (window),
			 "scrollbar_adj", (gpointer) hscrollbar_adj);
    hscrollbar = gtk_hscrollbar_new (GTK_ADJUSTMENT (hscrollbar_adj));
    gtk_widget_ref  (hscrollbar);
    gtk_widget_show (hscrollbar);
    gtk_box_pack_start (GTK_BOX (hbox), hscrollbar, TRUE, TRUE, 0);
    gtk_object_set_data (GTK_OBJECT (window),
			 "scrollbar", (gpointer) hscrollbar);

    /* ԥܥ */
    spinbutton_adj = gtk_adjustment_new (0, 0, length-1, 1, 10, 0);
    gtk_object_set_data (GTK_OBJECT (window),
			 "spinbutton_adj", (gpointer) spinbutton_adj);
    spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_adj), 1, 0);
    gtk_widget_ref  (spinbutton);
    gtk_widget_show (spinbutton);
    gtk_box_pack_start (GTK_BOX (hbox), spinbutton, FALSE, FALSE, 0);
    gtk_object_set_data (GTK_OBJECT (window),
			 "spinbutton", (gpointer) spinbutton);

    gtk_signal_connect (GTK_OBJECT (hscrollbar_adj), "value_changed",
			GTK_SIGNAL_FUNC (te_playerII_scrollbar_changed),
			(gpointer) hscrollbar_adj);

    gtk_signal_connect (GTK_OBJECT (spinbutton_adj), "value_changed",
			GTK_SIGNAL_FUNC (te_playerII_spinbutton_changed),
			(gpointer) spinbutton_adj);
  }

  /* ǡѥåȤ */
  draw_area = gtk_drawing_area_new ();
  gtk_widget_ref  (draw_area);
  gtk_widget_show (draw_area);
  gtk_object_set_data (GTK_OBJECT (window),
		       "draw_area0", (gpointer) draw_area);
  
  gtk_table_attach (GTK_TABLE (table), draw_area, 0, 1, 0, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  

  draw_area = gtk_drawing_area_new ();
  gtk_widget_ref  (draw_area);
  gtk_widget_show (draw_area);
  gtk_object_set_data (GTK_OBJECT (window),
		       "draw_area1", (gpointer) draw_area);
  
  gtk_table_attach (GTK_TABLE (table), draw_area, 2, 3, 0, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  draw_area = gtk_drawing_area_new ();
  gtk_widget_ref  (draw_area);
  gtk_widget_show (draw_area);
  gtk_object_set_data (GTK_OBJECT (window),
		       "draw_area2", (gpointer) draw_area);

  gtk_table_attach (GTK_TABLE (table), draw_area, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  draw_area = gtk_drawing_area_new ();
  gtk_widget_ref  (draw_area);
  gtk_widget_show (draw_area);
  gtk_object_set_data (GTK_OBJECT (window),
		       "draw_area3", (gpointer) draw_area);
  
  gtk_table_attach (GTK_TABLE (table), draw_area, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  gtk_object_set_data (GTK_OBJECT (window), "skin",       (gpointer) skin);
  gtk_object_set_data (GTK_OBJECT (window), "move_flg",   (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "rept_flg",	  (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "move_x_pos", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "move_y_pos", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "pos_x",	  (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (window), "pos_y",	  (gpointer) 0);

  return window;
}

/* ԥåޥåפ ********************************************** */
void
te_playerII_sync_to_skin (GtkWidget	*window) {
  GtkWidget	*widget;
  GtkStyle	*style;
  SkinData	*skin;
  char		name[64];
  int		w, h, n;

  skin = (SkinData *)
    gtk_object_get_data (GTK_OBJECT (window), "skin");

  /* ΤΥޥǡΥå */
  gdk_window_get_size (skin->mask[4], &w, &h);
  gtk_widget_set_usize (window, w, h);
  gtk_widget_shape_combine_mask (window, skin->mask[4], 0, 0);

  /* ǡ */
  for (n = 0; n < 4; n++) {
    sprintf (name, "draw_area%d", n);
    widget = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (window), name);
    gdk_window_get_size (skin->background[n], &w, &h);
    gtk_widget_set_usize (widget, w, h);
    gtk_drawing_area_size (GTK_DRAWING_AREA (widget), w, h);
  
    gtk_widget_shape_combine_mask (widget, skin->mask[n], 0, 0);
    gdk_window_set_back_pixmap (widget->window, skin->background[n], FALSE);
    gdk_window_clear (widget->window);
  }
}

/* ץ졼Υåץǡ ************************************************** */
void
te_playerII_update_window (void) {
  SkinData	*skin;

  skin = (SkinData *) gtk_object_get_data (GTK_OBJECT (playerII), "skin");
  if (!skin->font->text) 
    set_font_text (playerII, te_image_get_filename (image_list));
  update_font (playerII);
  draw_digit (playerII, skin->digit, play_speed);
}

/* *************************************************** End of playerII.c *** */
