/* ********************************************************** playerII.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2002-01-20 16:44:50 sugaya>
 * ************************************************************************* */
#ifndef	_TE_PLAYER_II_H_
#define	_TE_PLAYER_II_H_

typedef struct _IconButton {
  GdkPixmap	*pixmap;
  gint		width;
  gint		height;
  gint		cx;
  gint		cy;    
  gint		x;
  gint		y;
  gint		w;
  gint		h;
  gint		area;
} IconButton;

typedef struct _ButtonData {
  GdkPixmap	*pixmap;
  gint		cx;
  gint		cy;
  gint		x;
  gint		y;
  gint		w;
  gint		h;
  gint		area;  
} ButtonData;

typedef struct _ItemData {
  GdkPixmap	*pixmap;
  gint		sections;
  gint		cx;
  gint		cy;
  gint		w;
  gint		h;
  gint		area;  
} ItemData;

typedef struct _SliderData {
  GdkPixmap	*pixmap;
  gint		cx;
  gint		cy;
  gint		x;
  gint		y;
  gint		w;
  gint		h;
  gint		prelight;
  gint		verticle;
  gint		reversed;
  gint		handle_width;
  gint		handle_height;
  gint		position;
  gint		pushed;
  gint		prelit;
  void		(*press_func)   (float);
  void		(*release_func) (float);
  void		(*move_func)    (float);
  ItemData	*item;
  gint		area;  
} SliderData;

typedef struct _FontData {
  GdkPixmap	*pixmap;
  gint		length;
  gint		char_width;
  gint		char_height;
  gint		cx;
  gint		cy;
  gint		x;
  gint		y;
  gint		w;
  gint		h;
  gchar		*text;
  gint		offset;
  gint		scroll;
  gint		extended;
  gint		area;
} FontData;

typedef struct _NumberData {
  GdkPixmap	*pixmap;
  gint		cx;
  gint		cy;
  gint		w;
  gint		h;
  gint		area;
} NumberData;

typedef struct _SkinData {
  GdkPixmap	*background[4];
  GdkBitmap	*mask[5];
  ButtonData	*play_button;
  ButtonData	*back_button;
  ButtonData	*next_button;
  ButtonData	*prev_button;
  ButtonData	*stop_button;
  ButtonData	*rept_button;
  ButtonData	*exit_button;
  ItemData	*rept_item;
  FontData	*font;
  NumberData	*digit;
  SliderData	*slider;
  gint		cx;
  gint		cy;
  gint		cw;
  gint		ch;
} SkinData;

GtkWidget*	te_playerII_new			(char		*skin_data);
void		te_playerII_sync_to_skin 	(GtkWidget	*window);
void		te_playerII_update_window 	(void);

#endif /* _TE_PLAYER_II_H_ */

/* *************************************************** End of playerII.h *** */
