/* ********** TeoEyes ***************************************** plugin.c *** *
 * Teo and Multi Image Viewer
 * Copyright (C) 1998 Yasuyuki SUGAYA
 * Computer Vision and Image Media Lab, University of Tsukuba
 * Time-stamp: <2001-12-10 17:32:52 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <dirent.h>
#include <unistd.h>
#include <dlfcn.h>
#include "gtkicon.h"
#include "stock_volume.xpm"
#include "stock_plugin.xpm"

/* ************************************************************************* */
static guint	hash_func			(gpointer	key);
gint		hash_comp	 		(gpointer	arg1,
						 gpointer	arg2);
static int	te_plugin_add_hash 		(PluginInfo	*p,
						 int		id);
static char**	te_plugin_ls_plugin 		(char		*dir,
						 int		*num);
static void	te_plugin_free_plugin_list	(char		**list,
						 int		num);
static int	plugin_exec_func 		(gpointer	data,
						 guint		action,
						 GtkWidget	*widget);

/* ϥåơ֥ѥϥåͷ׻ؿ ************************************ */
static guint
hash_func (gpointer	key) {
  gchar		*skey = (gchar *) key;
  gint		n;
  guint		result = 0;

  if (key) return 0;

  for (n = 0; n < strlen (skey); n++) {
    result = (result << 4) + (result ^ (guint) skey[n]);
  }

  return result;
}

/* ϥåơ֥ѥӴؿ ****************************************** */
gint
hash_comp (gpointer	arg1,
	   gpointer	arg2) {
  return !strcmp ((gchar *) arg1, (gchar *) arg2);
}

/* ץ饰ϥåơ֥Ͽ ********************************** */
static int
te_plugin_add_hash (PluginInfo	*p,
		    int		id) {
  char	*key;
  char	uid[16];
  
  /* ϥåơ֥ */
  if (!plugin_table) {
    plugin_table = g_hash_table_new ((GHashFunc) hash_func,
				     (GCompareFunc) hash_comp);
  }
  if (!plugin_list) {
    plugin_list = g_hash_table_new ((GHashFunc) hash_func,
				    (GCompareFunc) hash_comp);
  }
  
  /* ϥå奭 */
  key = (char *) malloc (sizeof (char) *
			 (strlen (((GtkIconItemFactoryEntry *) p)->path) + 9));
  sprintf (key, "<plugin>%s", ((GtkIconItemFactoryEntry *) p)->path);
  sprintf (uid, "%d", id);
  
  /* ϥåơ֥ؤϿ */
  if (g_hash_table_lookup (plugin_table, key) &&
      g_hash_table_lookup (plugin_list,  g_strdup (uid))) {
    free (key);
    return 0;
  }
  g_hash_table_insert (plugin_table, key, p);
  g_hash_table_insert (plugin_list,  g_strdup (uid), p);  

  return 1;
}

/* ץ饰ꥹȤγ ************************************************** */
static char**
te_plugin_ls_plugin (char	*dir,
		     int	*num) {
  int           n, dirlen;
  DIR           *dirp;
  char		*ext;
  char          **names;
  struct dirent *dp;

  if ((!dir) || (!*dir)) return 0;
  dirp = opendir (dir);
  if (!dirp) {
    *num=0;
    return NULL;
  }
   
  /* count # of entries in dir (worst case) */
  for (dirlen = 0; (dp = readdir (dirp)) != NULL; dirlen++);
  if (!dirlen) {
    closedir (dirp);
    *num = dirlen;
    return NULL;
  }
    
  /* load up the entries, now that we know how many to make */
  names = (char **) malloc (dirlen * sizeof(char *));
  if (!names) return NULL;

  rewinddir (dirp);
  for (n = 0; n < dirlen; ) {
    dp = readdir (dirp);
    if (!dp) break;
    if ((ext = (char *) strrchr (dp->d_name, '.')) == NULL) continue;
    if (strcmp (ext, ".tpi") != 0) continue;
    names[n] = (char *) malloc (strlen (dp->d_name) + 1);
    if (!names) return NULL;
    strcpy (names[n], dp->d_name);
    n++;
  }
   
  if (n < dirlen) dirlen = n;   /* dir got shorter... */
  closedir (dirp);
  *num = dirlen;
  return names;
}

/* ץ饰ꥹΰβ ********************************************** */
static void
te_plugin_free_plugin_list (char	**list,
			    int		num) {
  int	n;

  for (n = 0; n < num; n++) free (list[n]);
  free (list);
}

/* ץ饰¹Դؿ ****************************************************** */
static int
plugin_exec_func (gpointer	data,
		  guint		action,
		  GtkWidget	*widget) {
  PluginInfo	*p;
  gchar		*key = (gchar *) widget->name;
  TEOIMAGE	*tmp, *dst;

  /* ¹Բǽɤå */
  if (opt->display_mode) return;
      
  /* ץ饰θ */
  if (!plugin_table) return 0;
  p = g_hash_table_lookup (plugin_table, key);

  /* Хåå */
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  /* ץ饰ؿμ¹ */
  tmp = TeoCreateCopyImage (te_image_get_curr_data (image_list));
  dst = TeoAllocSimilarImage (te_image_get_curr_data (image_list));
  (p->plugin_func) (tmp, dst);

  /* ̤ȿ */
  teo2gdk_pixbuf_copy_to_pixbuf(dst, te_image_get_pbuf (image_list),
				0.0, 0.0, te_image_get_has_alpha (image_list));
  
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
  return 1;
}

/* ץ饰ѤΥ˥塼 **************************************** */
void
te_plugin_menu_new (GtkWidget	*menu) {
  GtkWidget			*submenu;
  GtkWidget			*item;
  GtkWidget			*box;
  GtkWidget			*label;
  GtkWidget			*pix;
  GtkIconItemFactory		*item_factory;
  GtkIconItemFactoryEntry	*entry;  
  GtkIconItemFactoryEntry	*plugin_items;
  PluginInfo			*p;  
  char				**p_list;
  char				*plugin_path;	
  void				*handle;  
  int				menu_pos = 6;
  int				n, m, l;
  int				num;

  plugin_nums = 0;
  
  /* ץ饰˥塼٥ */
  item = gtk_menu_item_new ();
  {
    /* BOX */
    box = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (box);
    gtk_container_add (GTK_CONTAINER (item), box);

    /* PIXMAP */
    pix = te_icon_new (stock_plugin);

    gtk_misc_set_alignment (GTK_MISC (pix), 0.0, 0.5);
    gtk_widget_set_usize (pix, 24, -1);
    gtk_widget_show (pix);
    gtk_box_pack_start (GTK_BOX (box), pix, FALSE, FALSE, 0);
    /* ٥ */
    label = gtk_label_new (_("PlugIn"));
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);    
  }
  gtk_widget_show (item);

  /* ץ饰˥塼 */
  {
    plugin_items = (GtkIconItemFactoryEntry *)
      malloc (sizeof (GtkIconItemFactoryEntry));

    /* ԣţϣƣƥƥ */
    plugin_items[plugin_nums].path		= "/Tearoff";
    plugin_items[plugin_nums].pixmap		= NULL;
    plugin_items[plugin_nums].accelerator	= NULL;
    plugin_items[plugin_nums].callback		= NULL;
    plugin_items[plugin_nums].callback_action	= 0;
    plugin_items[plugin_nums].item_type		= "<Tearoff>";
    plugin_nums++;
    
    /* ץ饰򥵡ƥ˥塼ɲ */
    for (n = 0; n < tc->plugin_paths; n++) {
      p_list = te_plugin_ls_plugin (tc->plugin_path[n], &num);

      for (m = 0; m < num; m++) {
	plugin_path = y_concat_dir_and_file (tc->plugin_path[n],
					     p_list[m]);
	
	/* ץ饰ɤ߹ */
	if ((handle = dlopen (plugin_path, RTLD_LAZY)) == NULL) {
	  fprintf (stderr, "TeoEyes Plugin %s cannot be loaded !\n",
		   plugin_path);
	  free (plugin_path);
	  continue;
	}
	/* ץ饰γ */
	if ((p = dlsym (handle, "plugin_info")) == NULL) {
	  fprintf (stderr, "Plugin Information in %s is not found !\n",
		   plugin_path);
	  free (plugin_path);	  
	  continue;
	}

	free (plugin_path);

	entry = (GtkIconItemFactoryEntry *) p;

	for (l = 0; l < tc->non_use_plugins; l++) {
	  if (strcmp (entry->path, tc->non_use_plugin[l]) == 0) {
	    p->active = 0;
	    break;
	  }
	}
	
	if (plugin_nums != 0 && te_plugin_add_hash (p, plugin_nums)) {
	  /* ˥塼ƥκ */
	  plugin_items = (GtkIconItemFactoryEntry *)
	    realloc (plugin_items,
		     sizeof (GtkIconItemFactoryEntry) * (plugin_nums + 1));

	  plugin_items[plugin_nums].path	  = entry->path;
	  plugin_items[plugin_nums].pixmap	  = entry->pixmap;
	  plugin_items[plugin_nums].accelerator = entry->accelerator;
	  plugin_items[plugin_nums].callback
	    = (GtkIconItemFactoryCallback) plugin_exec_func;
	  plugin_items[plugin_nums].callback_action = entry->callback_action;
	  plugin_items[plugin_nums].item_type	= entry->item_type;
	  plugin_nums++;
	}
      }
      y_free_strings (p_list, num);
    }
  }
  
  /* ֥˥塼 */
  item_factory = gtk_icon_item_factory_new (GTK_TYPE_MENU, "<plugin>", NULL);
  gtk_icon_item_factory_create_items (item_factory,
				      plugin_nums, plugin_items, NULL);
  gtk_menu_item_set_submenu ((GtkMenuItem *) item,
			     gtk_icon_item_factory_get_widget (item_factory,
							       "<plugin>"));
  gtk_menu_insert (GTK_MENU (menu), item, menu_pos);

  /* ˥塼󥢥ƥֲ */
  if (plugin_nums != 1) {
    GList	*itemlist;
    PluginInfo	*p;

    itemlist = gtk_container_children (GTK_CONTAINER
				       (GTK_MENU_ITEM (item)->submenu));
    while (itemlist) {
      p = g_hash_table_lookup (plugin_table,
			       (GTK_WIDGET (itemlist->data))->name);
      if (p) {
	if (!p->active)
	  gtk_widget_set_sensitive (GTK_WIDGET (itemlist->data), FALSE);
      }
      itemlist = itemlist->next;
    }
  }
}

/* ***************************************************** End of plugin.c *** */
