/* ******************************************************** preference.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/06/27 15:17:37 sugaya>
 * ************************************************************************* */
#include "config.h"

#include "teoeyes.h"
#include "gtkiconbutton.h"
#include "gtkiconitemfactory.h"
#include "gtkcustomiconfilesel.h"
#include "xml.h"
#include <X11/keysym.h>

#include "stock_button_ok.xpm"
#include "stock_button_apply.xpm"
#include "stock_button_close.xpm"
#include "checkmark_yes.xpm"
#include "checkmark_no.xpm"
#include "book_open.xpm"
#include "book_closed.xpm"
#include "configure.xpm"
#include "misc.xpm"
#include "programs.xpm"
#include "shortcuts.xpm"
#include "windowmanager.xpm"
#include "assistant.xpm"

#define	XML_TAG_TEOEYES_CONFIG		"teoeyes_config"
#define	XML_TAG_VERSION			"version"
#define	XML_TAG_NAME			"name"
#define	XML_TAG_VALUE			"value"
#define	XML_TAG_ITEM			"item"
#define	XML_TAG_VESTION			"version"
#define	XML_TAG_OPTION			"option"
#define	XML_TAG_OPTION_LOAD_IMAGE	"option_load_image"
#define	XML_TAG_OPTION_CLEAR_DATA	"option_clear_data"
#define	XML_TAG_OPTION_NORMALIZE	"option_normalize"
#define	XML_TAG_OPTION_QUICK_DRAW	"option_quick_draw"
#define	XML_TAG_OPTION_DISPLAY_MODE	"option_display_mode"
#define	XML_TAG_CONFIRM			"confirm"
#define	XML_TAG_CONFIRM_SAVE		"confirm_save"
#define	XML_TAG_CONFIRM_OVERWRITE	"confirm_overwrite"
#define	XML_TAG_BROWSER_THUMB_DIR	"browser_thumb_dir"
#define	XML_TAG_BROWSER_THUMB_WIDTH	"browser_thumb_width"
#define	XML_TAG_BROWSER_THUMB_HEIGHT	"browser_thumb_height"
#define	XML_TAG_ASSISTANT_DATA		"assistant_data"
#define	XML_TAG_ASSISTANT_HELP_PATH	"assistant_help_path"
#define	XML_TAG_PLUGIN_PATH		"plugin_path"
#define	XML_TAG_NON_USE_PLUGIN		"non_use_plugin"
#define	XML_TAG_SHORTCUT		"shortcut"
#define	XML_TAG_ID			"id"
#define	XML_TAG_KEY			"key"
#define	XML_TAG_KEYVAL			"keyval"
#define	XML_TAG_MODIFIER		"modifier"
#define	XML_TAG_LOOPE_SIZE		"loope_size"
#define	XML_TAG_TITLE_IMAGE		"title_image"
#define	XML_TAG_SKIN_DATA		"skin_data"
#define	XML_TAG_SKIN_PATH		"skin_path"	/* ŤС */
#define	XML_TAG_HELP_BROWSER		"help_browser"

#define	OLD_CONFIG_VERSION		"2.4.0"

/* ************************************************************************* */
static void	te_change_loope_size 	(GtkWidget	*widget,
					 gpointer	data);
static void	te_shortcut_mod_change 	(GtkWidget	*widget,
					 gpointer	data);

/* ************************************************************************* */
static GdkPixmap	*book_open;
static GdkPixmap	*book_closed;
static GdkBitmap	*book_open_mask;
static GdkBitmap	*book_closed_mask;
static GdkPixmap	*pix_yes;
static GdkPixmap	*pix_no;
static GdkBitmap	*msk_yes;
static GdkBitmap	*msk_no;
static int		scale = 0;
static int		selected_shortcut_id;

/* ************************************************************************* *
 *
 * ************************************************************************* */

/* ǥեȥ硼ȥå ******************************************** */
static char *shortcut_list[] = 
{
  N_("Open"),
  N_("Save"),
  N_("Save as"),
  N_("Print"),
  N_("TeoEyes"),
  N_("Top Image"),
  N_("Prev Image"),
  N_("Next Image"),
  N_("Bottom Image"),
  N_("Top Frame"),
  N_("Prev Frame"),
  N_("Next Frame"),
  N_("Bottom Frame"),
  N_("Show Plane"),
  N_("Prev Plane"),
  N_("Next Plane"),
  N_("Double Size"),
  N_("Half Size"),
  N_("Scale Up 10\\%"),
  N_("Scale Down 10\\%"),
  N_("Toggle ToolBar"),
  N_("ToolBar Top"),
  N_("ToolBar Bottom"),
  N_("Toggle ScrollBar"),
  N_("Draw desktop"),
  N_("Undo"),
  N_("Original Image"),
  N_("Gray Image"),
  N_("Negative Image"),
  N_("Normalize Image"),
  N_("Flip Horizontal"),
  N_("Flip Vertical"),
  N_("Image List Viewer"),
  N_("Image Editor"),
  N_("Image Explorer"),
  N_("Image Player"),
  N_("Teoeyes Assistant"),  
  N_("Image Information"),
  N_("Preferences"),
  N_("About"),
  N_("Help"),
  N_("Quit")
};

/* ʸ ************************************************************ */
static char *mod_str[] = 
{
  "NONE", 
  "SHIFT",	"NONE", "NONE", 
  "CTRL",
  "CTRL+SHIFT", "NONE", "NONE",
  "ALT", 
  "ALT+SHIFT",	"NONE", "NONE",
  "CTRL+ALT", 
  "CTRL+ALT+SHIFT"
};

/* ʸ ************************************************************ */
static char *mod_str2[] = 
{
  "", 
  "<Shift>",		"", "", 
  "<Control>",
  "<Control><Shift>",	"", "",
  "<Alt>", 
  "<Alt><Shift>",	"", "",
  "<Control><Alt>", 
  "<Control><Alt><Shift>"
};

/* 롼ڤγΨ˥塼 ************************************************** */
static GtkIconItemFactoryEntry loope_menu_items[] =
{
  {N_("/x   2"),
   NULL,	NULL,	te_change_loope_size,	2,	NULL},
  {N_("/x   4"),
   NULL,	NULL,	te_change_loope_size,	4,	NULL},
  {N_("/x   8"),
   NULL,	NULL,	te_change_loope_size,	8,	NULL},
  {N_("/x  16"),
   NULL,	NULL,	te_change_loope_size,	16,	NULL},
  {N_("/x  32"),	
   NULL,	NULL,	te_change_loope_size,	32,	NULL},
  {N_("/x  64"),
   NULL,	NULL,	te_change_loope_size,	64,	NULL},
  {N_("/x 128"),
   NULL,	NULL,	te_change_loope_size,	128,	NULL}
};

/* ************************************************************************* *
 * ܤɤ߹
 * ************************************************************************* */

/* ץι ******************************************************** */
static int
te_preference_parse_option (TeoeyesConfig	*tc,
			    GNode		*node,
			    int			level) {
  GNode		*work_node;
  XMLNode	*xnode;

  if (node == NULL) return 0;
  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (xnode->element) {
    if (strcmp (xnode->element, XML_TAG_OPTION_LOAD_IMAGE) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->opt_load_image = (unsigned char) atoi (xnode->element);
    } else if (strcmp (xnode->element, XML_TAG_OPTION_CLEAR_DATA) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->opt_clear_data = (unsigned char) atoi (xnode->element);
    } else if (strcmp (xnode->element, XML_TAG_OPTION_NORMALIZE) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->opt_normalize = (unsigned char) atoi (xnode->element);
    } else if (strcmp (xnode->element, XML_TAG_OPTION_QUICK_DRAW) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->opt_quick_draw = (unsigned char) atoi (xnode->element);
    } else if (strcmp (xnode->element, XML_TAG_OPTION_DISPLAY_MODE) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->opt_display_mode = (unsigned char) atoi (xnode->element);
    }
  }
  if (node->children) {
    te_preference_parse_option (tc, node->children, level+1);
  } else if (node->next) {
    te_preference_parse_option (tc, node->next, level);
  } else {
    te_preference_parse_option (tc, node->parent->next, level-1);
  }

  return 1;
}

/* ǧι ************************************************************** */
static int
te_preference_parse_confirm (TeoeyesConfig	*tc,
			     GNode		*node,
			     int		level) {
  GNode		*work_node;	
  XMLNode	*xnode;

  if (node == NULL) return 0;
  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (xnode->element) {
    if (strcmp (xnode->element, XML_TAG_CONFIRM_SAVE) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->confirm_save = (unsigned char) atoi (xnode->element);
    } else if (strcmp (xnode->element, XML_TAG_CONFIRM_OVERWRITE) == 0) {
      work_node = node->next;
      xnode = (XMLNode *) work_node->data;
      tc->confirm_overwrite = (unsigned char) atoi (xnode->element);
    }
  }
  if (node->children) {
    te_preference_parse_confirm (tc, node->children, level+1);
  } else if (node->next) {
    te_preference_parse_confirm (tc, node->next, level);
  } else {
    te_preference_parse_confirm (tc, node->parent->next, level-1);
  }
  return 1;
}

/* ץ饰ѥο ********************************************** */
static int
te_preference_check_assistant_help_path_num (GNode	*node,
					     int	level) {
  XMLNode	*xnode;
  static int	nums = 0;
  
  if (node == NULL) return 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (level < 0) return nums;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    if (xnode->element) nums++;
  }
  if (node->children) {
    te_preference_check_assistant_help_path_num(node->children, level+1);
  } else if (node->next) {
    te_preference_check_assistant_help_path_num (node->next, level);
  }
  return nums;
}

/* ȥѥι ************************************************** */
static int
te_preference_parse_assistant_help_path (TeoeyesConfig	*tc,
					 GNode		*node,
					 int		level) {
  XMLNode	*xnode;
  static int	nums = 0;
  
  if (node == NULL) return 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    tc->assistant_help_path[nums] = g_strdup (xnode->element);
    nums++;
  }
  if (node->children) {
    te_preference_parse_assistant_help_path (tc, node->children, level+1);
  } else if (node->next) {
    te_preference_parse_assistant_help_path (tc, node->next, level);
  }
  return 1;
}

/* ץ饰ѥο ********************************************** */
static int
te_preference_check_plugin_path_num (GNode	*node,
				     int	level) {
  XMLNode	*xnode;
  static int	nums = 0;
  
  if (node == NULL) return 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (level < 0) return nums;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    if (xnode->element) nums++;
  }
  if (node->children) {
    te_preference_check_plugin_path_num (node->children, level+1);
  } else if (node->next) {
    te_preference_check_plugin_path_num (node->next, level);
  }
  return nums;
}

/* ץ饰ѥι **************************************************** */
static int
te_preference_parse_plugin_path (TeoeyesConfig	*tc,
				 GNode		*node,
				 int		level) {
  XMLNode	*xnode;
  static int	nums = 0;
  
  if (node == NULL) return 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    tc->plugin_path[nums] = g_strdup (xnode->element);
    nums++;
  }
  if (node->children) {
    te_preference_parse_plugin_path (tc, node->children, level+1);
  } else if (node->next) {
    te_preference_parse_plugin_path (tc, node->next, level);
  }
  return 1;
}

/* Ѥʤץ饰ο **************************************** */
static int
te_preference_check_non_use_plugin_num (GNode	*node,
					int	level) {
  XMLNode	*xnode;
  static int	nums = 0;
  
  if (node == NULL) return 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (level < 0) return nums;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    if (xnode->element) nums++;
  }
  if (node->children) {
    te_preference_check_non_use_plugin_num (node->children, level+1);
  } else if (node->next) {
    te_preference_check_non_use_plugin_num (node->next, level);
  }
  return nums;
}

/* Ѥʤץ饰ι ********************************************** */
static int
te_preference_parse_non_use_plugin (TeoeyesConfig	*tc,
				    GNode		*node,
				    int			level) {
  XMLNode	*xnode;
  static int	nums = 0;
  if (level == -1) {
    nums = 0;
    level++;
  }
  if (node == NULL) return 0;

  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    tc->non_use_plugin[nums] = g_strdup (xnode->element);
    nums++;
  }
  if (node->children) {
    te_preference_parse_non_use_plugin (tc, node->children, level+1);
  } else if (node->next) {
    te_preference_parse_non_use_plugin (tc, node->next, level);
  }
  return 1;
}

/* 硼ȥåȤι **************************************************** */
static int
te_preference_parse_shortcut (TeoeyesConfig	*tc,
			      GNode		*node,
			      int		level) {
  GNode		*work_node;
  XMLNode	*xnode;
  char		*key;
  int		id, keyval, modifier;
  
  if (node == NULL) return 0;
  if (level < 0) return 1;
  
  xnode = (XMLNode *) node->data;

  if (strcmp (xnode->tag->tag, XML_TAG_ITEM) == 0) {
    work_node = node->children;
    xnode = (XMLNode *) work_node->data;
    if (strcmp (xnode->tag->tag, XML_TAG_ID) == 0) {
      id = atoi (xnode->element);
    } else {
      fprintf (stderr, _("Can not parse node completely.\n"));
      return 0;
    }
    work_node = work_node->next;
    xnode = (XMLNode *) work_node->data;
    if (strcmp (xnode->tag->tag, XML_TAG_KEY) == 0) {
      key = g_strdup (xnode->element);
    } else {
      fprintf (stderr, _("Can not parse node completely.\n"));
      return 0;
    }
    work_node = work_node->next;
    xnode = (XMLNode *) work_node->data;
    if (strcmp (xnode->tag->tag, XML_TAG_KEYVAL) == 0) {
      keyval = atoi (xnode->element);
    } else {
      fprintf (stderr, _("Can not parse node completely.\n"));
      return 0;
    }
    work_node = work_node->next;
    xnode = (XMLNode *) work_node->data;
    if (strcmp (xnode->tag->tag, XML_TAG_MODIFIER) == 0) {
      modifier = atoi (xnode->element);
    } else {
      fprintf (stderr, _("Can not parse node completely.\n"));
      return 0;
    }
    tc->shortcut[id].key 	= g_strdup (key);
    tc->shortcut[id].keyval	= keyval;
    tc->shortcut[id].modifier	= modifier;
    g_free (key);
    te_preference_parse_shortcut (tc, node->next, level+1);
  }
  if (node->children) {
    te_preference_parse_shortcut (tc, node->children, level+1);
  }
  return 1;
}

/* եΥСå **************************************** */
int
te_preference_check_version (char	*filename) {
  GNode		*root_node, *node;
  XMLNode	*xnode;
  char		*version;
  
  /* եɤ߹ */
  root_node = xml_parse_file (filename);
  if (!root_node) {
    fprintf (stderr, _("Can not read teoeyes config file.\n"));
    return -1;
  }
  /* ¤Τΰ */
  tc = (TeoeyesConfig *) malloc (sizeof (TeoeyesConfig));
  if (!tc) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    g_node_destroy (root_node);
    return -1;
  }
  /* TeoEyesե뤫ɤǧ */
  xnode = (XMLNode *) root_node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_TEOEYES_CONFIG) != 0) {
    fprintf (stderr, _("%s is not teoeyes_config_file\n"), filename);
    g_node_destroy (root_node);
    free (tc);
    return -1;
  }
  /* Сɤ߹ */
  node  = root_node->children;
  xnode = (XMLNode *) node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_VERSION) != 0) {
    fprintf (stderr, _("Can not read version infomation.\n"));
    g_node_destroy (root_node);
    free (tc);
    return -1;
  }
  version = g_strdup (xnode->element);
  g_node_destroy (node);

  if (strcmp (version, OLD_CONFIG_VERSION) <= 0) {
    return 0;
  } else {
    return 1;
  }
}

/* ŤСե򸽥Сե˹ ********** */
void
te_preference_update_file (char	*filename) {
  TeoeyesConfig	*tc, *tc_old;
  int		n, m;
    
  /* ŤСեɤ߹ */
  tc_old = te_preference_load_old_version (filename);

  /* Сեɤ߹ */
  tc = te_preference_load (TEOEYES_CONFIG);

  /* ޤǤΰѤ */
  {
    /* ǥեȥץ */
    tc->opt_load_image	= tc_old->opt_load_image;
    tc->opt_clear_data	= tc_old->opt_clear_data;
    tc->opt_normalize	= tc_old->opt_normalize;
    tc->opt_quick_draw	= tc_old->opt_quick_draw;
    tc->opt_display_mode= tc_old->opt_display_mode;

    /* ǧ */
    tc->confirm_save	= tc_old->confirm_save;
    tc->confirm_overwrite	= tc_old->confirm_overwrite;

    /* ץ */
    if (tc->thumb_dir) {
      free (tc->thumb_dir);
      tc->thumb_dir = NULL;
    }
    if (tc_old->thumb_dir) tc->thumb_dir = g_strdup (tc_old->thumb_dir);
    tc->thumb_width	= tc_old->thumb_width;
    tc->thumb_height	= tc_old->thumb_height;
    
    /* ץ饰 */
    for (n = 0; n < tc->plugin_paths; n++) {
      free (tc->plugin_path[n]);
    }
    free (tc->plugin_path);
    tc->plugin_path	= NULL;
    tc->plugin_paths	= tc_old->plugin_paths;
    tc->plugin_path	= (char **) malloc (sizeof(char *) * tc->plugin_paths);
    for (n = 0; n < tc->plugin_paths; n++) {
      tc->plugin_path[n] = g_strdup (tc_old->plugin_path[n]);
    }

    for (n = 0; n < tc->non_use_plugins; n++) free (tc->non_use_plugin[n]);
    free (tc->non_use_plugin);
    tc->non_use_plugin	= NULL;
    tc->non_use_plugins	= tc_old->non_use_plugins;
    tc->non_use_plugin	= (char **) malloc(sizeof(char *)*tc->non_use_plugins);
    for (n = 0; n < tc->non_use_plugins; n++) {
      tc->non_use_plugin[n] = g_strdup (tc_old->non_use_plugin[n]);
    }
    /* 硼ȥåȤ */
    for (n = 0, m = 0; n < SHORTCUT_NUM; n++, m++) {
      if (n == 36) {
	m--;
	continue;
      }
      free (tc->shortcut[n].key);
      tc->shortcut[n].key	= g_strdup (tc_old->shortcut[m].key);
      tc->shortcut[n].keyval	= tc_old->shortcut[m].keyval;
      tc->shortcut[n].modifier	= tc_old->shortcut[m].modifier;
    }
    /* ¾ */
    tc->default_loope_scale	= tc_old->default_loope_scale;
    if (tc->title_image) {
      free (tc->title_image);
      tc->title_image = NULL;
    }
    if (tc_old->title_image) tc->title_image = g_strdup (tc_old->title_image);
    if (tc->skin_data) {
      free (tc->skin_data);
      tc->skin_data = NULL;
    }
    if (tc_old->skin_data) tc->skin_data = g_strdup (tc_old->skin_data);
    if (tc->help_browser) {
      free (tc->help_browser);
      tc->help_browser = NULL;
    }
    if (tc_old->help_browser) tc->help_browser=g_strdup (tc_old->help_browser);
  }
  /* ե¸ */
  te_preference_save (tc, filename);
  te_preference_free (tc);
  te_preference_free (tc_old);  
}

/* եɤ߹ (С2.4.0б) **************************** */
TeoeyesConfig*
te_preference_load_old_version (char	*filename) {
  TeoeyesConfig	*tc;
  GNode		*root_node, *node;
  XMLNode	*xnode;
  char		*version;
  int		nums;
  int		count = 0;
  const int	config_items = 12;
  
  /* եɤ߹ */
  root_node = xml_parse_file (filename);
  if (!root_node) {
    fprintf (stderr, _("Can not read teoeyes config file.\n"));
    return NULL;
  }
  /* ¤Τΰ */
  tc = (TeoeyesConfig *) malloc (sizeof (TeoeyesConfig));
  if (!tc) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    g_node_destroy (root_node);
    return NULL;
  }
  /* TeoEyesե뤫ɤǧ */
  xnode = (XMLNode *) root_node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_TEOEYES_CONFIG) != 0) {
    fprintf (stderr, _("%s is not teoeyes_config_file\n"), filename);
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  /* Сɤ߹ */
  node  = root_node->children;
  xnode = (XMLNode *) node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_VERSION) != 0) {
    fprintf (stderr, _("Can not read version infomation.\n"));
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  /* ܤɤ߹ */
  node  = node->next;
  xnode = (XMLNode *) node->data;

  while (count < config_items && node) {
    if (strcmp (xnode->tag->tag, XML_TAG_OPTION) == 0) {
      if (!te_preference_parse_option (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_CONFIRM) == 0) {
      if (!te_preference_parse_confirm (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_DIR) == 0) {
      tc->thumb_dir = g_strdup (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_WIDTH) == 0) {
      tc->thumb_width = atoi (xnode->element);
      node = node->next;      
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_HEIGHT) == 0) {
      tc->thumb_height = atoi (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_PLUGIN_PATH) == 0) {
      tc->plugin_paths = te_preference_check_plugin_path_num (node, -1);
      if (tc->plugin_paths != 0) {
	tc->plugin_path = (char **)
	  malloc (sizeof (char *) * tc->plugin_paths);
	if (!te_preference_parse_plugin_path (tc, node, -1)) break;
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_NON_USE_PLUGIN) == 0) {
      tc->non_use_plugins = te_preference_check_non_use_plugin_num (node, -1);
      if (tc->non_use_plugins != 0) {
	tc->non_use_plugin = (char **)
	  malloc (sizeof (char *) * tc->non_use_plugins);
	if (!te_preference_parse_non_use_plugin (tc, node, -1)) break;
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_SHORTCUT) == 0) {
      if (!te_preference_parse_shortcut (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_LOOPE_SIZE) == 0) {
      tc->default_loope_scale = atoi (xnode->element);            
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_TITLE_IMAGE) == 0) {
      if (xnode->element) tc->title_image = g_strdup (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_SKIN_PATH) == 0) {
      if (xnode->element) tc->skin_data = g_strdup (xnode->element);      
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_HELP_BROWSER) == 0) {
      if (xnode->element) {
	tc->help_browser = g_strdup (xnode->element);
      } else {
	tc->help_browser = g_strdup (DEFAULT_HELP_BROWSER);
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    }
  }
  if (count < config_items) {
    fprintf (stderr, _("Can not read config file completely.\n"));
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  g_node_destroy (root_node);
  
  return tc;
}

/* եɤ߹(С2.4.1ʹб) ************************* */
TeoeyesConfig*
te_preference_load (char	*filename) {
  TeoeyesConfig	*tc;
  GNode		*root_node, *node;
  XMLNode	*xnode;
  char		*version;
  int		nums;
  int		count = 0;
  const int	config_items = 14;
  
  /* եɤ߹ */
  root_node = xml_parse_file (filename);
  if (!root_node) {
    fprintf (stderr, _("Can not read teoeyes config file.\n"));
    return NULL;
  }
  /* ¤Τΰ */
  tc = (TeoeyesConfig *) malloc (sizeof (TeoeyesConfig));
  if (!tc) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    g_node_destroy (root_node);
    return NULL;
  }
  /* ʸѿν */
  tc->assistant_data	  = NULL;
  tc->assistant_help_path = NULL;
  tc->plugin_path	  = NULL;
  tc->non_use_plugin	  = NULL;
  tc->title_image	  = NULL;
  tc->skin_data		  = NULL;
  tc->help_browser	  = NULL;
  
  /* TeoEyesե뤫ɤǧ */
  xnode = (XMLNode *) root_node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_TEOEYES_CONFIG) != 0) {
    fprintf (stderr, _("%s is not teoeyes_config_file\n"), filename);
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  /* Сɤ߹ */
  node  = root_node->children;
  xnode = (XMLNode *) node->data;
  if (strcmp (xnode->tag->tag, XML_TAG_VERSION) != 0) {
    fprintf (stderr, _("Can not read version infomation.\n"));
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  /* ܤɤ߹ */
  node  = node->next;
  xnode = (XMLNode *) node->data;

  while (count < config_items && node) {
    if (strcmp (xnode->tag->tag, XML_TAG_OPTION) == 0) {
      if (!te_preference_parse_option (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_CONFIRM) == 0) {
      if (!te_preference_parse_confirm (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_DIR) == 0) {
      tc->thumb_dir = g_strdup (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_WIDTH) == 0) {
      tc->thumb_width = atoi (xnode->element);
      node = node->next;      
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_BROWSER_THUMB_HEIGHT) == 0) {
      tc->thumb_height = atoi (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_ASSISTANT_DATA) == 0) {
      tc->assistant_data = g_strdup (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_ASSISTANT_HELP_PATH) == 0) {
      tc->assistant_help_paths
	= te_preference_check_assistant_help_path_num (node, -1);
      if (tc->assistant_help_paths != 0) {
	tc->assistant_help_path = (char **)
	  malloc (sizeof (char *) * tc->assistant_help_paths);
	if (!te_preference_parse_assistant_help_path (tc, node, -1)) break;
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_PLUGIN_PATH) == 0) {
      tc->plugin_paths = te_preference_check_plugin_path_num (node, -1);
      if (tc->plugin_paths != 0) {
	tc->plugin_path = (char **)
	  malloc (sizeof (char *) * tc->plugin_paths);
	if (!te_preference_parse_plugin_path (tc, node, -1)) break;
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_NON_USE_PLUGIN) == 0) {
      tc->non_use_plugins = te_preference_check_non_use_plugin_num (node, -1);
      if (tc->non_use_plugins != 0) {
	tc->non_use_plugin = (char **)
	  malloc (sizeof (char *) * tc->non_use_plugins);
	if (!te_preference_parse_non_use_plugin (tc, node, -1)) break;
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_SHORTCUT) == 0) {
      if (!te_preference_parse_shortcut (tc, node, 0)) break;
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_LOOPE_SIZE) == 0) {
      tc->default_loope_scale = atoi (xnode->element);            
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_TITLE_IMAGE) == 0) {
      if (xnode->element) tc->title_image = g_strdup (xnode->element);
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_SKIN_DATA) == 0) {
      if (xnode->element) tc->skin_data = g_strdup (xnode->element);      
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    } else if (strcmp (xnode->tag->tag, XML_TAG_HELP_BROWSER) == 0) {
      if (xnode->element) {
	tc->help_browser = g_strdup (xnode->element);
      } else {
	tc->help_browser = g_strdup (DEFAULT_HELP_BROWSER);
      }
      node = node->next;
      if (node) xnode = (XMLNode *) node->data;
      count++;
    }
  }
  if (count < config_items) {
    fprintf (stderr, _("Can not read config file completely.\n"));
    g_node_destroy (root_node);
    free (tc);
    return NULL;
  }
  g_node_destroy (root_node);
  
  return tc;
}

/* ե¸ ****************************************************** */
int
te_preference_save (TeoeyesConfig	*tc,
		    char		*filename) {
  FILE		*fp;
  int		n;
  
  /* եΥץ */
  fp = fopen (filename, "w");
  if (!fp) {
    fprintf (stderr, _("Can not create file %s\n"), filename);
    return 0;
  }

  /* եؤν */
  fprintf (fp, "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>\n\n");

  fprintf (fp, "<%s>\n\n", XML_TAG_TEOEYES_CONFIG);

  fprintf (fp, "\t<%s>%s</%s>\n\n", XML_TAG_VERSION, VERSION, XML_TAG_VERSION);

  fprintf (fp, "\t<%s>\n", XML_TAG_OPTION);
  {
    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_OPTION_LOAD_IMAGE, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->opt_load_image, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);

    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);  
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_OPTION_CLEAR_DATA, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->opt_clear_data, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);

    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_OPTION_NORMALIZE, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->opt_normalize, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);

    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);  
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_OPTION_QUICK_DRAW, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->opt_quick_draw, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);

    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);  
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_OPTION_DISPLAY_MODE, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->opt_display_mode, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_OPTION);

  fprintf (fp, "\t<%s>\n", XML_TAG_CONFIRM);
  {
    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_CONFIRM_SAVE, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->confirm_save, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);

    fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
    fprintf (fp, "\t\t\t<%s>%s</%s>",
	     XML_TAG_NAME, XML_TAG_CONFIRM_OVERWRITE, XML_TAG_NAME);
    fprintf (fp, "<%s>%d</%s>\n",
	     XML_TAG_VALUE, tc->confirm_overwrite, XML_TAG_VALUE);
    fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_CONFIRM);

  fprintf (fp, "\t<%s>\n", XML_TAG_BROWSER_THUMB_DIR);
  fprintf (fp, "\t\t%s\n", tc->thumb_dir);
  fprintf (fp, "\t</%s>\n\n", XML_TAG_BROWSER_THUMB_DIR);  

  fprintf (fp, "\t<%s>%d</%s>\n\n",
	   XML_TAG_BROWSER_THUMB_WIDTH, tc->thumb_width,
	   XML_TAG_BROWSER_THUMB_WIDTH);

  fprintf (fp, "\t<%s>%d</%s>\n\n",
	   XML_TAG_BROWSER_THUMB_HEIGHT, tc->thumb_height,
	   XML_TAG_BROWSER_THUMB_HEIGHT);

  fprintf (fp, "\t<%s>\n\t\t%s\n\t</%s>\n\n",
	   XML_TAG_ASSISTANT_DATA, tc->assistant_data,
	   XML_TAG_ASSISTANT_DATA);

  fprintf (fp, "\t<%s>\n", XML_TAG_ASSISTANT_HELP_PATH);
  {
    for (n = 0; n < tc->assistant_help_paths; n++) {
      fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
      fprintf (fp, "\t\t\t%s\n", tc->assistant_help_path[n]);
      fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);      
    }
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_ASSISTANT_HELP_PATH);    
  
  fprintf (fp, "\t<%s>\n", XML_TAG_PLUGIN_PATH);
  {
    for (n = 0; n < tc->plugin_paths; n++) {
      fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
      fprintf (fp, "\t\t\t%s\n", tc->plugin_path[n]);
      fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);      
    }
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_PLUGIN_PATH);    

  fprintf (fp, "\t<%s>\n", XML_TAG_NON_USE_PLUGIN);
  {
    for (n = 0; n < tc->non_use_plugins; n++) {
      fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
      fprintf (fp, "\t\t\t%s\n", tc->non_use_plugin[n]);
      fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);      
    }
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_NON_USE_PLUGIN);

  fprintf (fp, "\t<%s>\n", XML_TAG_SHORTCUT);
  {
    for (n = 0; n < SHORTCUT_NUM; n++) {
      fprintf (fp, "\t\t<%s>\n", XML_TAG_ITEM);
      {
	fprintf (fp, "\t\t\t<%s>%d</%s>\n", XML_TAG_ID, n, XML_TAG_ID);
	fprintf (fp, "\t\t\t<%s>%s</%s>",
		 XML_TAG_KEY, tc->shortcut[n].key, XML_TAG_KEY);
	fprintf (fp, "<%s>%d</%s>",
		 XML_TAG_KEYVAL, tc->shortcut[n].keyval, XML_TAG_KEYVAL);
	fprintf (fp, "<%s>%d</%s>\n",
		 XML_TAG_MODIFIER, tc->shortcut[n].modifier, XML_TAG_MODIFIER);
      }
      fprintf (fp, "\t\t</%s>\n", XML_TAG_ITEM);            
    }
  }
  fprintf (fp, "\t</%s>\n\n", XML_TAG_SHORTCUT);

  fprintf (fp, "\t<%s>%d</%s>\n\n",
	   XML_TAG_LOOPE_SIZE, tc->default_loope_scale, XML_TAG_LOOPE_SIZE);

  fprintf (fp, "\t<%s>\n", XML_TAG_TITLE_IMAGE);
  if (tc->title_image) fprintf (fp, "\t\t%s\n", tc->title_image);
  fprintf (fp, "\t</%s>\n\n", XML_TAG_TITLE_IMAGE);

  fprintf (fp, "\t<%s>\n", XML_TAG_SKIN_DATA);
  if (tc->skin_data) fprintf (fp, "\t\t%s\n", tc->skin_data);
  fprintf (fp, "\t</%s>\n\n", XML_TAG_SKIN_DATA);

  fprintf (fp, "\t<%s>\n", XML_TAG_HELP_BROWSER);
  if (tc->help_browser) fprintf (fp, "\t\t%s\n", tc->help_browser);
  fprintf (fp, "\t</%s>\n\n", XML_TAG_HELP_BROWSER);

  fprintf (fp, "</%s>\n", XML_TAG_TEOEYES_CONFIG);

  fclose (fp);

  return 1;
}

/* ************************************************************************* */
void
te_preference_free (TeoeyesConfig	*tc) {
  int	n;
  
  if (!tc) return;

  if (tc->thumb_dir) free (tc->thumb_dir);
  if (tc->assistant_data) free (tc->assistant_data);
  if (tc->assistant_help_path) {
    for (n = 0; n < tc->assistant_help_paths; n++) {
      if (tc->assistant_help_path[n]) free (tc->assistant_help_path[n]);
    }
    free (tc->assistant_help_path);
  }
  if (tc->plugin_path) {
    for (n = 0; n < tc->plugin_paths; n++) {
      if (tc->plugin_path[n]) free (tc->plugin_path[n]);
    }
    free (tc->plugin_path);
  }
  if (tc->non_use_plugin) {
    for (n = 0; n < tc->non_use_plugins; n++) {
      if (tc->non_use_plugin[n]) free (tc->non_use_plugin[n]);
    }
    free (tc->non_use_plugin);
  }
  if (tc->title_image)  free (tc->title_image);
  if (tc->skin_data)    free (tc->skin_data);
  if (tc->help_browser) free (tc->help_browser);

  free (tc);
}

/* ************************************************************************* *
 * 
 * ************************************************************************* */

/* ************************************************************************* *
 * ȥ
 * ************************************************************************* */
   
/* ȥ (OKܥ󤬲줿ν) ***************************** */
static void
te_reference_dialog_ok (GtkWidget		*widget,
			GtkCustomIconFileSel	*fs) {
  gtk_entry_set_text (GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (fs),
						      "entry")),
		      gtk_custom_icon_file_selection_get_filename (fs));
  gtk_widget_hide	(GTK_WIDGET (fs));
  gtk_widget_destroy	(GTK_WIDGET (fs));
}

/* ȥ (Cancelܥ󤬲줿ν) ************************* */
static void
te_reference_dialog_cancel (GtkWidget	*widget,
			    GtkWidget	*fs) {
  gtk_widget_hide 	(fs);
  gtk_widget_destroy	(fs);
}

/* ȥ **************************************************** */
static GtkWidget*
te_reference_filesel_new (char		*title,
			  GtkEntry	*entry) {
  GtkWidget	*fs;

  /*  */
  fs = gtk_custom_icon_file_selection_new (title);
  /* ٥Ȥ */
  gtk_object_set_data (GTK_OBJECT (fs), "entry", entry);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->ok_button),
		      "clicked", (GtkSignalFunc) te_reference_dialog_ok, 
		      GTK_CUSTOM_ICON_FILESEL (fs));
  gtk_signal_connect (GTK_OBJECT 
		      (GTK_CUSTOM_ICON_FILESEL (fs)->cancel_button),
		      "clicked", (GtkSignalFunc) te_reference_dialog_cancel,
		      fs);
  return fs;
}

/* ȥɽ **************************************************** */
static void
te_preference_box_defalut_reference (GtkWidget	*widget,
				     GtkEntry	*entry) {
  GtkWidget	*fs;

  fs = te_reference_filesel_new (_("Reference"), entry);
  gtk_widget_show (fs);
}

/* ************************************************************************* *
 * ץΤΥڡ
 *
 *	- ǥեȥץ
 * ************************************************************************* */

/* ץ ******************************************************** */
static GtkWidget*
te_preference_box_option (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox, *hbox;
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkWidget	*label_box;

  /* BOX */  
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL); 
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_widget_show (frame);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_widget_show (vbox);
      {
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);	
	gtk_widget_show (hbox);
	{
	  label = gtk_label_new (_("Option"));
	  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	  gtk_widget_show (label);
	}
      }
      /* ǥեȥץ */
      {
	/* -l ץ */
	widget 
	  = gtk_check_button_new_with_label (_("Store all images in memory "
					       "when start teoeyes."));
	gtk_object_set_data (GTK_OBJECT (parent),
			     "config_option1", widget);
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				      tc->opt_load_image);
	/* -c ץ */
	widget 
	  = gtk_check_button_new_with_label (_("Free old image memory "
					       "when load new image."));
	gtk_object_set_data (GTK_OBJECT (parent),
			     "config_option2", widget);
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				      tc->opt_clear_data);
	/* -N ץ */
	widget 
	  = gtk_check_button_new_with_label (_("Normalize all images."));
	gtk_object_set_data (GTK_OBJECT (parent),
			     "config_option3", widget);
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				      tc->opt_normalize);
	/* -q ץ */
	widget 
	  = gtk_check_button_new_with_label (_("Quick draw mode"));
	gtk_object_set_data (GTK_OBJECT (parent),
			     "config_option4", widget);
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				      tc->opt_quick_draw);

	  
	/* -d ץ */
	widget 
	  = gtk_check_button_new_with_label (_("Run teoeyes in "
					       "display mode."));
	gtk_object_set_data (GTK_OBJECT (parent),
			     "config_option5", widget);
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				      tc->opt_display_mode);
      }

      label = gtk_label_new ("");
      gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
      gtk_widget_show (label);
      {
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);	
	gtk_widget_show (hbox);
	{
	  label = gtk_label_new (_("Confirm"));
	  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	  gtk_widget_show (label);
	}
      }
      /* ǧ */

      /* ¸Ȥγǧ */
      widget
	= gtk_check_button_new_with_label (_("Confirm Are you sure you want "
					     "to save."));
      gtk_object_set_data (GTK_OBJECT (parent), "config_confirm1", widget);
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				    tc->confirm_save);

      /* 񤭤Ȥγǧ */
      widget
	= gtk_check_button_new_with_label (_("Confirm Are you sure you want "
					     "to overwrite."));
      gtk_object_set_data (GTK_OBJECT (parent), "config_confirm2", widget);
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				    tc->confirm_overwrite);
    }
  }
  return box;
}

/* ************************************************************************* *
 * ǧΤΥڡ
 *
 *	- ¸γǧ
 *	- 񤭤γǧ
 * ************************************************************************* */

/* Ƽǧ ********************************************************** */
static GtkWidget*
te_preference_box_confirm (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*check_button;
  GtkWidget	*label_box;

  /* BOX */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL); 
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);    
    gtk_widget_show (frame); 
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_widget_show (vbox);

      /* ǧ */

      /* ¸Ȥγǧ */
      check_button
	= gtk_check_button_new_with_label (_("Confirm Are you sure you want "
					     "to save."));
      gtk_object_set_data (GTK_OBJECT (parent),
			   "config_confirm1", check_button);
      gtk_box_pack_start (GTK_BOX (vbox), check_button, FALSE, FALSE, 0);
      gtk_widget_show (check_button);
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_button),
					tc->confirm_save);

      /* 񤭤Ȥγǧ */
      check_button
	= gtk_check_button_new_with_label (_("Confirm Are you sure you want "
					     "to overwrite."));
      gtk_object_set_data (GTK_OBJECT (parent),
			   "config_confirm2", check_button);
      gtk_box_pack_start (GTK_BOX (vbox), check_button, FALSE, FALSE, 0);
      gtk_widget_show (check_button);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_button),
				    tc->confirm_overwrite);
    }
  }
  return box;
}

/* ************************************************************************* *
 * ץ
 *	-ͥΥȥåץǥ쥯ȥ
 *	-ͥ礭
 * ************************************************************************* */

/* ֥饦 ********************************************************** */
static GtkWidget*
te_preference_box_browser (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*separator;
  GtkWidget	*widget;
  GtkWidget	*label_box;
  GtkWidget	*check_button;

  /* BOX */
  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL); 
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0); 
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_widget_show (frame);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_widget_show (vbox);

      /* ٥ (Temporary Directory) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show (hbox);

	label = gtk_label_new (_("Thumbnail Directory:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);
	{
	  GtkWidget	*hbox;

	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {	
	    GtkWidget	*entry;

	    /* ȥܥå */
	    entry = gtk_entry_new ();
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_thumb_dir", entry);
	    gtk_entry_set_text (GTK_ENTRY (entry), tc->thumb_dir);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 3);
	    gtk_widget_show (entry);

	    /* ȥܥ */
	    widget = gtk_button_new_with_label (_("Browse..."));
	    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
				GTK_SIGNAL_FUNC 
				(te_preference_box_defalut_reference), 
				GTK_ENTRY (entry));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
	    gtk_widget_show (widget);
	  }
	}
      }

      /* ѥ졼 */ 
      separator = gtk_hseparator_new (); 
      gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 5); 
      gtk_widget_show (separator); 
      
      /* ٥ (Icon Size) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show (hbox);

	label = gtk_label_new (_("Thumbnail Size:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);
	{
	  GtkWidget	*hbox;

	  hbox = gtk_hbox_new (FALSE, 5);
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  gtk_widget_show (hbox);
	  {	
	    GtkObject	*adjustment;
	    GtkWidget	*spin;
	    GtkWidget	*label;

	    label = gtk_label_new (_("Width:"));
	    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	    gtk_widget_show (label);

	    adjustment = gtk_adjustment_new (1, 1, 9999, 1, 10, 10);
	    spin = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
	    gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin),
				       (gfloat) tc->thumb_width);
	    gtk_object_set_data (GTK_OBJECT (parent), "thumb_width", spin);
	    gtk_box_pack_start (GTK_BOX (hbox), spin, TRUE, TRUE, 0);
	    gtk_widget_show (spin);

	    label = gtk_label_new (_("Height:"));
	    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	    gtk_widget_show (label);

	    adjustment = gtk_adjustment_new (1, 1, 9999, 1, 10, 10);
	    spin = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
	    gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin),
				       (gfloat) tc->thumb_height);
	    gtk_object_set_data (GTK_OBJECT (parent), "thumb_height", spin);
	    gtk_box_pack_start (GTK_BOX (hbox), spin, TRUE, TRUE, 0);
	    gtk_widget_show (spin);
	  }
	}
      }
    }
  }
  return box;
}

/* ************************************************************************* *
 * ΤΥڡ
 *
 *	- ץ饰ѥ
 *	- ư˥ɤץ饰
 * ************************************************************************* */

/* ȥإץѥɲ ******************************************** */
static void
te_assistant_help_path_add (GtkWidget	*widget,
		       GtkWidget	*parent) {
  char		*new_path;
  char		**path;
  GtkCList	*list;
  GtkEntry	*entry;

  /* ȥꥦåȤγ */
  entry = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (parent), 
					  "config_assistant_help_path_entry"));
  /* ѥγ */
  new_path = gtk_entry_get_text (entry);
  if (!new_path || strcmp (new_path, "") == 0) return;

  /* ꥹȥåȤγ */
  list = GTK_CLIST (gtk_object_get_data (GTK_OBJECT (parent), 
					 "config_assistant_help_path"));

  /* ѥɲ */
  path = (char **) malloc (sizeof (char *));
  path[0] = (char *) malloc (sizeof (char) * (strlen (new_path) + 1));
  strcpy (path[0], new_path);

  gtk_clist_append (list, path);
  free (path[0]);
  free (path);
}

/* ȥإץѥκ ******************************************** */
static void
te_assistant_help_path_delete (GtkWidget	*widget,
			       GtkWidget	*parent) {
  GtkCList	*list;

  /* ꥹȥåȤγ */
  list = GTK_CLIST (gtk_object_get_data (GTK_OBJECT (parent),
					 "config_assistant_help_path"));
  /* ꥹȤʤ */
  if (list->rows == 0) return;
  if (!list->selection) return;
  
  /* 򤵤줿ꥹȤκ */
  gtk_clist_remove (list, list->focus_row);
}

/* ȥإץѥλȥ (OKܥ󤬲줿ν) ***** */
static void
te_assistant_help_path_reference_dialog_ok (GtkWidget		*widget,
					    GtkCustomIconFileSel	*fs) {
  gtk_entry_set_text (GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (fs),
						      "entry")),
		      gtk_custom_icon_file_selection_get_filename (fs));
  gtk_widget_hide	(GTK_WIDGET (fs));
  gtk_widget_destroy	(GTK_WIDGET (fs));
}

/* ȥإץѥλȥ (Cancelܥ󤬲줿ν) * */
static void
te_assistant_help_path_reference_dialog_cancel (GtkWidget	*widget,
						GtkWidget	*fs) {
  gtk_widget_hide 	(fs);
  gtk_widget_destroy	(fs);
}

/* ȥإץѥλȥ **************************** */
static GtkWidget*
te_assistant_help_path_reference_filesel_new (char		*title,
					      GtkEntry	*entry) {
  GtkWidget	*fs;

  /*  */
  fs = gtk_custom_icon_file_selection_new (title);

  /* ٥Ȥ */
  gtk_object_set_data (GTK_OBJECT (fs), "entry", entry);
  gtk_signal_connect(GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->ok_button),
		     "clicked", 
		     (GtkSignalFunc)
		     te_assistant_help_path_reference_dialog_ok,
		     GTK_CUSTOM_ICON_FILESEL (fs));
  gtk_signal_connect(GTK_OBJECT 
		     (GTK_CUSTOM_ICON_FILESEL (fs)->cancel_button),
		     "clicked", 
		     (GtkSignalFunc)
		     te_assistant_help_path_reference_dialog_cancel,
		     fs);
  return fs;
}

/* ȥإץѥλ ******************************************** */
static void
te_assistant_help_path_reference (GtkWidget	*widget,
			     GtkEntry	*entry) {
  GtkWidget	*fs;

  fs = te_reference_filesel_new (_("Reference"), entry);
  gtk_widget_show (fs);
}

/*  (Ȥ) ************************************* */
static GtkWidget*
te_preference_box_assistant (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;
  GtkWidget	*hbox;  
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*entry;  
  GtkWidget	*widget;

  /* BOX */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box); 
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL);
    gtk_widget_ref (frame);
    gtk_widget_show (frame);    
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0); 
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_widget_ref (vbox);
      gtk_widget_show (vbox);      
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      {
	/* ȥǡ */
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	{
	  label = gtk_label_new (_("Assistant Data:"));
	  gtk_widget_ref (label);
	  gtk_widget_show (label);	  
	  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	}
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	{	
	  /* ȥܥå */
	  entry = gtk_entry_new ();
	  gtk_widget_ref (entry);
	  gtk_widget_show (entry);	  
	  gtk_object_set_data (GTK_OBJECT (parent),
			       "config_assistant_data", entry);
	  gtk_entry_set_text (GTK_ENTRY (entry), tc->assistant_data);
	  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 3);

	  /* ȥܥ */
	  widget = gtk_button_new_with_label (_("Browse..."));
	  gtk_widget_ref (widget);
	  gtk_widget_show (widget);	  
	  gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			      GTK_SIGNAL_FUNC 
			      (te_preference_box_defalut_reference), 
			      GTK_ENTRY (entry));
	  gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
	}
	/* ѥ졼 */
	widget = gtk_hseparator_new ();
	gtk_widget_ref (widget);
	gtk_widget_show (widget);	
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);
	
	/* ȥإץǡꥹ */
	{
	  GtkWidget	*sframe;
	  GtkWidget	*list_path;
	  GtkWidget	*hbox;
	  gchar		*title[] = {_("Assistant Help Path"), NULL};

	  /* 륦ɥ */
	  sframe = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_ref (sframe);
	  gtk_widget_show (sframe);	  
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sframe),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  gtk_box_pack_start (GTK_BOX (vbox), sframe, TRUE, TRUE, 0);

	  /* ץ饰ѥꥹ */
	  list_path = gtk_clist_new_with_titles (1, title);
	  gtk_widget_ref (list_path);
	  gtk_widget_show (list_path);	  
	  gtk_clist_column_titles_passive (GTK_CLIST (list_path));
	  gtk_clist_set_selection_mode (GTK_CLIST (list_path),
					GTK_SELECTION_BROWSE);
	  gtk_object_set_data (GTK_OBJECT (parent),
			       "config_assistant_help_path", list_path);
	  gtk_container_add (GTK_CONTAINER (sframe), list_path);

	  /* ץ饰ѥɲ */
	  {	
	    int	n;
	    gchar	*buf[] = {""};

	    for (n = 0; n < tc->assistant_help_paths; n++) {
	      gtk_clist_append (GTK_CLIST (list_path), buf);
	      gtk_clist_set_text (GTK_CLIST (list_path), 
				  n, 0, tc->assistant_help_path[n]);
	    }
	  }
	  /* ʿܥå */
	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {
	    GtkWidget	*entry;
	    GtkWidget	*button;

	    /* ץ饰ѥΥȥ */
	    entry = gtk_entry_new ();
	    gtk_widget_ref (entry);
	    gtk_widget_show (entry);	    
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_assistant_help_path_entry", entry);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);

	    /* []ܥ */
	    button = gtk_button_new_with_label (_("Browse..."));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect(GTK_OBJECT (button), "clicked", 
			       (GtkSignalFunc)te_assistant_help_path_reference,
			       GTK_ENTRY (entry));
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	    
	    /* []ܥ */
	    button = gtk_button_new_with_label (_("Delete"));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
				(GtkSignalFunc) te_assistant_help_path_delete,
				parent);
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);

	    /* [ɲ]ܥ */
	    button = gtk_button_new_with_label (_("Add"));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
				(GtkSignalFunc) te_assistant_help_path_add,
				parent);
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	  }
	}
      }
    }
  }
  return box;
}

/* ************************************************************************* *
 * ץ饰ΤΥڡ
 *
 *	- ץ饰ѥ
 *	- ư˥ɤץ饰
 * ************************************************************************* */

/* ץ饰ѥɲ **************************************************** */
static void
te_plugin_path_add (GtkWidget	*widget,
		    GtkWidget	*parent) {
  char		*new_path;
  char		**path;
  GtkCList	*list;
  GtkEntry	*entry;

  /* ȥꥦåȤγ */
  entry = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (parent), 
					  "config_plugin_path_entry"));
  /* ѥγ */
  new_path = gtk_entry_get_text (entry);
  if (!new_path || strcmp (new_path, "") == 0) return;

  /* ꥹȥåȤγ */
  list = GTK_CLIST (gtk_object_get_data (GTK_OBJECT (parent), 
					 "config_plugin_path"));

  /* ѥɲ */
  path = (char **) malloc (sizeof (char *));
  path[0] = (char *) malloc (sizeof (char) * (strlen (new_path) + 1));
  strcpy (path[0], new_path);

  gtk_clist_append (list, path);
  free (path[0]);
  free (path);
}

/* ץ饰ѥκ **************************************************** */
static void
te_plugin_path_delete (GtkWidget	*widget,
		       GtkWidget	*parent) {
  GtkCList	*list;

  /* ꥹȥåȤγ */
  list = GTK_CLIST (gtk_object_get_data (GTK_OBJECT (parent),
					 "config_plugin_path"));

  /* ꥹȤʤ */
  if (list->rows == 0) return;
  if (!list->selection) return;
  /* 򤵤줿ꥹȤκ */
  gtk_clist_remove (list, list->focus_row);
}

/* ץ饰ѥλȥ (OKܥ󤬲줿ν) ************* */
static void
te_plugin_path_reference_dialog_ok (GtkWidget			*widget,
				    GtkCustomIconFileSel	*fs) {
  gtk_entry_set_text (GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (fs),
						      "entry")),
		      gtk_custom_icon_file_selection_get_filename (fs));
  gtk_widget_hide	(GTK_WIDGET (fs));
  gtk_widget_destroy	(GTK_WIDGET (fs));
}

/* ץ饰ѥλȥ (Cancelܥ󤬲줿ν) ********* */
static void
te_plugin_path_reference_dialog_cancel (GtkWidget	*widget,
					GtkWidget	*fs) {
  gtk_widget_hide 	(fs);
  gtk_widget_destroy	(fs);
}

/* ץ饰ѥλȥ ************************************ */
static GtkWidget*
te_plugin_path_reference_filesel_new (char	*title,
				      GtkEntry	*entry) {
  GtkWidget	*fs;

  /*  */
  fs = gtk_custom_icon_file_selection_new (title);
  /* ٥Ȥ */
  gtk_object_set_data (GTK_OBJECT (fs), "entry", entry);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->ok_button),
		      "clicked", 
		      (GtkSignalFunc) te_plugin_path_reference_dialog_ok, 
		      GTK_CUSTOM_ICON_FILESEL (fs));
  gtk_signal_connect (GTK_OBJECT 
		      (GTK_CUSTOM_ICON_FILESEL (fs)->cancel_button),
		      "clicked", 
		      (GtkSignalFunc) te_plugin_path_reference_dialog_cancel,
		      fs);
  return fs;
}

/* ץ饰ѥλ **************************************************** */
static void
te_plugin_path_reference (GtkWidget	*widget,
			  GtkEntry	*entry) {
  GtkWidget	*fs;

  fs = te_reference_filesel_new (_("Reference"), entry);
  gtk_widget_show (fs);
}

/* ץ饰Ȥ߹ߥå ******************************************** */
static void
te_plugin_check (GtkCList	*list,
		 gint		row,
		 gint		column,
		 GdkEvent	*ev,
		 gpointer	data) {
  GtkWidget	*parent;
  GtkWidget	*label;
  char		buf[1024];
  PluginInfo	*p;

  if (ev->type == GDK_2BUTTON_PRESS) {
    /* åĴ٤ */
    if ((int) gtk_clist_get_row_data (list, row) == 0) {
      /* ԥåޥåפĥդ */
      gtk_clist_set_pixmap (list, row, 0, pix_yes, msk_yes);
      /* ǡΥå */
      gtk_clist_set_row_data (list, row, (gpointer) 1);
    } else {
      /* ԥåޥåפĥդ */
      gtk_clist_set_pixmap (list, row, 0, pix_no, msk_no);
      /* ǡΥå */
      gtk_clist_set_row_data (list, row, (gpointer) 0);
    }
  }
  /* ץ饰ɽ */
  sprintf (buf, "%d", row+1);
  p = g_hash_table_lookup (plugin_list, buf);
  
  /* ȥ & С */
  sprintf (buf, "%s %s", p->name, p->version);
  label = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (list), "plugin_title");
  if (label) gtk_label_set (GTK_LABEL (label), buf);
  /*  */
  label = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (list), "plugin_author");
  gtk_label_set (GTK_LABEL (label), p->author);
  /* ץ饰 */
  label = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (list), "plugin_about");
  gtk_label_set (GTK_LABEL (label), p->help);
}

/*  (ץ饰) *************************************** */
static GtkWidget*
te_preference_box_plugin (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;  
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkWidget	*label_box;
  GtkWidget	*pix;
  GtkWidget	*list_plugin;
  GtkWidget	*label1;
  GtkWidget	*label2;
  GtkWidget	*label3;
  GtkWidget	*label4;
  PluginInfo	*p;

  /* BOX */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL);
    gtk_widget_ref (frame);
    gtk_widget_show (frame);    
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0); 
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_widget_ref (vbox);
      gtk_widget_show (vbox);      
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      {
	/* ץ饰ѥΥꥹȤ */
	{
	  GtkWidget	*sframe;
	  GtkWidget	*list_path;
	  GtkWidget	*hbox;
	  gchar		*title[] = {_("Plug-In Path"), NULL};

	  /* 륦ɥ */
	  sframe = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_ref (sframe);
	  gtk_widget_show (sframe);	  
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sframe),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);

	  gtk_box_pack_start (GTK_BOX (vbox), sframe, TRUE, TRUE, 0);

	  /* ץ饰ѥꥹ */
	  list_path = gtk_clist_new_with_titles (1, title);
	  gtk_widget_ref (list_path);
	  gtk_widget_show (list_path);	  
	  gtk_clist_column_titles_passive (GTK_CLIST (list_path));
	  gtk_clist_set_selection_mode (GTK_CLIST (list_path),
					GTK_SELECTION_BROWSE);
	  gtk_object_set_data (GTK_OBJECT (parent),
			       "config_plugin_path", list_path);
	  gtk_container_add (GTK_CONTAINER (sframe), list_path);

	  /* ץ饰ѥɲ */
	  {	
	    int	n;
	    gchar	*buf[] = {""};

	    for (n = 0; n < tc->plugin_paths; n++) {
	      gtk_clist_append (GTK_CLIST (list_path), buf);
	      gtk_clist_set_text (GTK_CLIST (list_path), 
				  n, 0, tc->plugin_path[n]);
	    }
	  }
	  /* ʿܥå */
	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {
	    GtkWidget	*entry;
	    GtkWidget	*button;

	    /* ץ饰ѥΥȥ */
	    entry = gtk_entry_new ();
	    gtk_widget_ref (entry);
	    gtk_widget_show (entry);	    
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_plugin_path_entry", entry);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);

	    /* []ܥ */
	    button = gtk_button_new_with_label (_("Browse..."));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
				(GtkSignalFunc) te_plugin_path_reference,
				GTK_ENTRY (entry));
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	    
	    /* []ܥ */
	    button = gtk_button_new_with_label (_("Delete"));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
				(GtkSignalFunc) te_plugin_path_delete, parent);
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);

	    /* [ϣ]ܥ */
	    button = gtk_button_new_with_label (_("Add"));
	    gtk_widget_ref (button);
	    gtk_widget_show (button);	    
	    gtk_signal_connect (GTK_OBJECT (button), "clicked", 
				(GtkSignalFunc) te_plugin_path_add, parent);
	    gtk_widget_set_usize (button, 60, -1);
	    gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	  }
	}
	/* ѥ졼 */
	widget = gtk_hseparator_new ();
	gtk_widget_ref (widget);
	gtk_widget_show (widget);	
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);

	/* ץ饰ꥹȤ */
	{
	  GtkWidget	*sframe;
	  GtkWidget	*hbox;
	  gchar		*title[] = {_("Active"), _("Plug-In"), NULL};

	  /* åޡԥåޥåפ */
	  pix_yes
	    = gdk_pixmap_create_from_xpm_d (parent->window, &msk_yes, NULL,
					    (char **) &checkmark_yes);
	  pix_no
	    = gdk_pixmap_create_from_xpm_d (parent->window, &msk_no, NULL,
					    (char **) &checkmark_no);	  
	  
	  /* 륦ɥ */
	  sframe = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_ref (sframe);
	  gtk_widget_show (sframe);	  
	  gtk_widget_set_usize (sframe, -1, 80);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sframe),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  gtk_box_pack_start (GTK_BOX (vbox), sframe, TRUE, TRUE, 0);

	  /* ץ饰ꥹ */
	  list_plugin = gtk_clist_new_with_titles (2, title);
	  gtk_widget_ref (list_plugin);
	  gtk_widget_show (list_plugin);	  
	  gtk_clist_column_titles_passive (GTK_CLIST (list_plugin));
	  gtk_clist_set_selection_mode (GTK_CLIST (list_plugin),
					GTK_SELECTION_BROWSE);
	  gtk_object_set_data (GTK_OBJECT (parent), 
			       "config_plugin", list_plugin);
	  gtk_object_set_data (GTK_OBJECT (list_plugin), "parent", parent);
	  gtk_container_add (GTK_CONTAINER (sframe), list_plugin);
	  
	  /* ꥹȤɲ */
	  {
	    int		n;
	    PluginInfo	*p;
	    gchar	id[16];
	    gchar	*buf[] = {"", ""};

	    for (n = 0; n < plugin_nums-1; n++) {
	      sprintf (id, "%d", n+1);
	      p = g_hash_table_lookup (plugin_list, id);

	      gtk_clist_append (GTK_CLIST (list_plugin), buf);
	      gtk_clist_set_text (GTK_CLIST (list_plugin), 
				  n, 1, p->name);
	      gtk_clist_set_row_data (GTK_CLIST (list_plugin),
				      n, (gpointer) p->active);
	      if (p->active) {
		gtk_clist_set_pixmap (GTK_CLIST (list_plugin),
				      n, 0, pix_yes, msk_yes);
	      } else {
		gtk_clist_set_pixmap (GTK_CLIST (list_plugin),
				      n, 0, pix_no, msk_no);
	      }
	    }
	  }
	}
	/* ѥ졼 */
	widget = gtk_hseparator_new ();
	gtk_widget_ref (widget);
	gtk_widget_show (widget);	
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);

	/* ץ饰ܥå */
	{
	  GtkWidget	*frame;
	  GtkWidget	*box;
	  
	  frame = gtk_frame_new (_("Plugin Info"));
	  gtk_widget_ref (frame);
	  gtk_widget_show (frame);  
	  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 2);

	  box = gtk_vbox_new (FALSE, 0);
	  gtk_widget_ref (box);
	  gtk_widget_show (box);  
	  gtk_container_add (GTK_CONTAINER (frame), box);
	  {
	    GtkWidget	*hbox;

	    /* ȥ&С */
	    hbox = gtk_hbox_new (TRUE, 0);
	    gtk_widget_ref (hbox);
	    gtk_widget_show (hbox);    
	    gtk_box_pack_start (GTK_BOX (box), hbox, TRUE, TRUE, 0);
	    {
	      label = gtk_label_new (_("Title"));
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);
					       
	      label = gtk_label_new ("");
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);
	      gtk_object_set_data (GTK_OBJECT (list_plugin),
				   "plugin_title", (gpointer) label);
	    }
	    /*  */	    
	    hbox = gtk_hbox_new (TRUE, 0);
	    gtk_widget_ref (hbox);
	    gtk_widget_show (hbox);	    
	    gtk_box_pack_start (GTK_BOX (box), hbox, TRUE, TRUE, 0);
	    {
	      label = gtk_label_new (_("Author"));
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);

	      label = gtk_label_new ("");
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);
	      gtk_object_set_data (GTK_OBJECT (list_plugin),
				   "plugin_author", (gpointer) label);
	    }	      
	    /* ץ饰 */	    
	    hbox = gtk_hbox_new (TRUE, 0);
	    gtk_widget_ref (hbox);	    
	    gtk_widget_show (hbox);
	    gtk_box_pack_start (GTK_BOX (box), hbox, TRUE, TRUE, 0);
	    {
	      label = gtk_label_new (_("Note"));
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);

	      label = gtk_label_new ("");
	      gtk_widget_ref (label);
	      gtk_widget_show (label);	      
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 5);
	      gtk_object_set_data (GTK_OBJECT (list_plugin),
				   "plugin_about", (gpointer) label);
	    }	
	    gtk_signal_connect (GTK_OBJECT (list_plugin), "select-row",
				GTK_SIGNAL_FUNC (te_plugin_check), NULL);
	  }
	}
      }
    }
  }
  return box;
}

/* ************************************************************************* *
 * 硼ȥåΤΥڡ
 *
 *	- ˥塼Υ硼ȥåȤ
 * ************************************************************************* */

/* 硼ȥåȥꥹȤ ********************************************** */
static void
te_shortcut_list_select (GtkWidget	*widget,
			 gpointer	data) {
  selected_shortcut_id = GTK_CLIST (widget)->focus_row;
}

/* 硼ȥåȤΥ ************************************************ */
static void
te_shortcut_key_change (GtkWidget	*widget,
			GtkWidget	*list) {
  GtkWidget	*window;
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*align;
  
  /* ϥɥ */
  window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 1);
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
    align = gtk_alignment_new (0.0, 0.0, 0.0, 0.0);
    gtk_container_set_border_width (GTK_CONTAINER (align), 32);
    {
      /* ٥ */
      label = gtk_label_new (_("Please press the key on the keyboard\n"
		       "you wish to modify this keyboard-shortcut\n"
			       "to use from now on."));
      gtk_container_add (GTK_CONTAINER (window), frame);
      gtk_container_add (GTK_CONTAINER (frame), align);
      gtk_container_add (GTK_CONTAINER (align), label);
    }
  }
  gtk_widget_show_all (window);

  /*  */
  while (gtk_events_pending ()) gtk_main_iteration ();
  gdk_flush ();
  while (gtk_events_pending ()) gtk_main_iteration ();
  {
    char	*key;
    XEvent	ev;
    
    gdk_window_set_events (window->window, GDK_KEY_PRESS_MASK);
    XSetInputFocus (GDK_DISPLAY (), GDK_WINDOW_XWINDOW (window->window),
		    RevertToPointerRoot, CurrentTime);
    gdk_keyboard_grab (window->window, TRUE, CurrentTime);
    XWindowEvent (GDK_DISPLAY (), GDK_WINDOW_XWINDOW (window->window),
                  KeyReleaseMask, &ev);
    gdk_keyboard_ungrab (gdk_time_get ());
    key = XKeysymToString (XKeycodeToKeysym(GDK_DISPLAY (), 
					    ev.xkey.keycode, 0));
    gtk_clist_set_text (GTK_CLIST (list), selected_shortcut_id, 1, key);
    gtk_clist_set_text (GTK_CLIST (list), 
			selected_shortcut_id, 2, mod_str[(int) ev.xkey.state]);
  }
  
  /*  */
  gtk_widget_destroy (window);
}

/* 硼ȥåȤ ********************************************** */
static void
te_shortcut_mod_change (GtkWidget	*widget,
			gpointer	data) {
  GtkWidget	*list;

  list = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (preference_dialog), 
					  "config_shortcut"));
  gtk_clist_set_text (GTK_CLIST (list), 
		      selected_shortcut_id, 2, mod_str[(int) data]);
}

/* 硼ȥåȤ **************************************************** */
static GtkWidget*
te_preference_box_shortcut (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;  
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkWidget	*list_shortcut;
  GtkWidget	*label_box;
  GtkWidget	*pix;

  /* BOX */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL);
    gtk_widget_ref (frame);
    gtk_widget_show (frame);    
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0); 
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_widget_ref (vbox);
      gtk_widget_show (vbox);      
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      {
	/* 硼ȥåȤΥꥹ */
	{
	  GtkWidget	*sframe;
	  GtkWidget	*hbox;
	  gchar		*title[] = {_("Name"),
				    _("Key"),
				    _("Modifier"),
				    NULL};
	  gchar		*buf[] = {"", "", ""};
	  int		n;

	  /* 륦ɥ */
	  sframe = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_ref (sframe);
	  gtk_widget_show (sframe);	  
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sframe),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  gtk_box_pack_start (GTK_BOX (vbox), sframe, TRUE, TRUE, 0);

	  /* 硼ȥåȥꥹȤ */
	  list_shortcut = gtk_clist_new_with_titles (3, title);
	  gtk_widget_ref (list_shortcut);
	  gtk_widget_show (list_shortcut);	  
	  gtk_signal_connect (GTK_OBJECT (list_shortcut), "select_row",
			      GTK_SIGNAL_FUNC (te_shortcut_list_select),
			      NULL);
	  gtk_clist_set_column_width (GTK_CLIST (list_shortcut), 0, 115);
	  gtk_clist_set_column_width (GTK_CLIST (list_shortcut), 1, 40);
	  gtk_clist_column_titles_passive (GTK_CLIST (list_shortcut));
	  gtk_clist_set_selection_mode (GTK_CLIST (list_shortcut),
					GTK_SELECTION_BROWSE);
	  gtk_object_set_data (GTK_OBJECT (parent),
			       "config_shortcut", list_shortcut);
	  gtk_container_add (GTK_CONTAINER (sframe), list_shortcut);

	  for (n = 0; n < SHORTCUT_NUM; n++) {
	    gtk_clist_append (GTK_CLIST (list_shortcut), buf);
	    gtk_clist_set_text (GTK_CLIST (list_shortcut), n, 0, 
				_(shortcut_list[n]));
	    gtk_clist_set_text (GTK_CLIST (list_shortcut), n, 1,
				tc->shortcut[n].key);
	    gtk_clist_set_text (GTK_CLIST (list_shortcut), n, 2,
				mod_str[tc->shortcut[n].modifier]);
	  }
	}
	/* ѥ졼 */
	widget = gtk_hseparator_new ();
	gtk_widget_ref (widget);
	gtk_widget_show (widget);	
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 10);
      
	/* ϥܥå */
	{
	  GtkWidget	*hbox;
	  GtkWidget	*option_menu;
	  GtkWidget	*menu;

	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {
	    /* ٥ (Key) */
	    widget = gtk_label_new (_("Key"));
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);

	    /* ϥܥ */
	    widget = gtk_button_new_with_label (_("input"));
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);	    
	    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
				GTK_SIGNAL_FUNC (te_shortcut_key_change),
				GTK_WIDGET (list_shortcut));
	    gtk_widget_set_usize (widget, 60, -1);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
	  }
	}
      }
    }
  }
  return box;
}

/* ʸ󤫤ɣĤؤѹ ******************************************** */
static int
te_modstr_to_modid (char	*modstr) {
  if (strcmp (modstr, "NONE") == 0)
    return 0;
  else if (strcmp (modstr, "SHIFT") == 0)
    return 1;
  else if (strcmp (modstr, "CTRL") == 0)
    return 4;
  else if (strcmp (modstr, "CTRL+SHIFT") == 0)
    return 5;
  else if (strcmp (modstr, "ALT") == 0)
    return 8;
  else if (strcmp (modstr, "ALT+SHIFT") == 0)
    return 9;
  else if (strcmp (modstr, "CTRL+ALT") == 0)
    return 12;
  else if (strcmp (modstr, "CTRL+ALT+SHIFT") == 0) 
    return 13;
  else
    return 0;
};

/* ************************************************************************* *
 * ¾ΤΥڡ
 *
 *	- 롼ڤγΨνͤ
 *	- ȥ
 *	- ץ졼䥹ǡ
 *	- ե 
 * ************************************************************************* */

/* Ψ˥塼Υǥå ******************************** */
static int
te_scale_to_index (int	scale) {
  int	n = 0;

  while (scale != 2) {
    scale /= 2;
    n++;
  }
  return n;
}

/* Ψѹ ************************************************************ */
static void
te_change_loope_size (GtkWidget		*widget,
		      gpointer		data) {
  scale	= (int) data;
}

/* 롼ڤγΨ˥塼 ******************************************** */
static GtkWidget*
te_loope_menu_new (GtkWidget	*widget) {
  int	items = sizeof (loope_menu_items) / sizeof (loope_menu_items[0]);
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;

  accel_group	= gtk_accel_group_new ();
  item_factory
    = gtk_icon_item_factory_new (GTK_TYPE_MENU, "<sub>", accel_group);
  gtk_icon_item_factory_create_items (item_factory,
				      items, loope_menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (widget));

  return gtk_icon_item_factory_get_widget (item_factory, "<sub>");
}

/* ¾ ************************************************************ */
static GtkWidget*
te_preference_box_misc (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*vbox;  
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkWidget	*label_box;
  GtkWidget	*pix;

  /* BOX */
  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL);
    gtk_widget_ref (frame);    
    gtk_widget_show (frame);
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 0); 
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    {
      /* BOX */
      vbox = gtk_vbox_new (FALSE, 5);
      gtk_widget_ref (vbox);    
      gtk_widget_show (vbox);
      gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
      gtk_container_add (GTK_CONTAINER (frame), vbox);

      /* ٥ (Loope Window) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("Loope Window:"));
	gtk_widget_ref (label);
	gtk_widget_show (label);	
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
      }

      {
	GtkWidget	*hbox;
	GtkWidget	*label;
	GtkWidget	*option_menu;
	GtkWidget	*menu;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	{
	  label = gtk_label_new (_("Defalut loope scale:"));
	  gtk_widget_ref (label);
	  gtk_widget_show (label);	  
	  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	  option_menu = gtk_option_menu_new ();
	  gtk_widget_ref (option_menu);
	  gtk_widget_show (option_menu);	  
	  gtk_box_pack_end (GTK_BOX (hbox), option_menu, FALSE, FALSE, 0);
	  {
	    menu = te_loope_menu_new (option_menu);
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_loope_scape", widget);
	    gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	  }
	  gtk_option_menu_set_history 
	    (GTK_OPTION_MENU (option_menu), 
	     te_scale_to_index (tc->default_loope_scale));
	}
      }

      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_widget_ref (widget);
      gtk_widget_show (widget);      
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);

      /* ٥ (Title Image) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("Title Image:"));
	gtk_widget_ref (label);
	gtk_widget_show (label);	
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	{
	  GtkWidget	*hbox;

	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {	
	    GtkWidget	*entry;

	    /* ȥܥå */
	    entry = gtk_entry_new ();
	    gtk_widget_ref (entry);
	    gtk_widget_show (entry);	    
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_title_image", entry);
	    gtk_entry_set_text (GTK_ENTRY (entry), tc->title_image);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 3);

	    /* ȥܥ */
	    widget = gtk_button_new_with_label (_("Browse..."));
	    gtk_widget_ref (widget);	    
	    gtk_widget_show (widget);
	    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
				GTK_SIGNAL_FUNC 
				(te_preference_box_defalut_reference), 
				GTK_ENTRY (entry));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
	  }
	}
      }
      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_widget_ref (widget);
      gtk_widget_show (widget);      
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);
      
      /* ٥ (Player Skin) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("Player Skin Data:"));
	gtk_widget_ref (label);
	gtk_widget_show (label);	
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	{
	  GtkWidget	*hbox;

	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {	
	    GtkWidget	*entry;

	    /* ȥܥå */
	    entry = gtk_entry_new ();
	    gtk_widget_ref (entry);
	    gtk_widget_show (entry);	    
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_skin_data", entry);
	    if (tc->skin_data)
	      gtk_entry_set_text (GTK_ENTRY (entry), tc->skin_data);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 3);

	    /* ȥܥ */
	    widget = gtk_button_new_with_label (_("Browse..."));
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
				GTK_SIGNAL_FUNC 
				(te_preference_box_defalut_reference), 
				GTK_ENTRY (entry));
	    gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
	  }
	}
      }
      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_widget_ref (widget);
      gtk_widget_show (widget);      
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 5);
      
      /* ٥ (Player Skin) */
      {
	GtkWidget	*hbox;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox);
	gtk_widget_show (hbox);	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("Default help browser:"));
	gtk_widget_ref (label);
	gtk_widget_show (label);	
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	{
	  GtkWidget	*hbox;

	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox);
	  gtk_widget_show (hbox);	  
	  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  {	
	    GtkWidget	*entry;

	    /* ȥܥå */
	    entry = gtk_entry_new ();
	    gtk_widget_ref (entry);
	    gtk_widget_show (entry);	    
	    gtk_object_set_data (GTK_OBJECT (parent),
				 "config_help_browser", entry);
	    if (tc->help_browser)
	      gtk_entry_set_text (GTK_ENTRY (entry), tc->help_browser);
	    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 3);
	  }
	}
      }
    }
  }
  return box;
}

/*  Ŭ ***************************************************** */
static void
te_preference_dialog_apply (GtkWidget	*widget,
			    GtkWidget	*dialog) {
  GtkWidget	*child;
  int		n;
  gint		keyval;
  guint		mod;
  char		*buf;
  char		*home;
  char		config_file[256];
  char		accl[256];

  /* ץι */
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_option1");
  tc->opt_load_image =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_option2");
  tc->opt_clear_data =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_option3");
  tc->opt_normalize =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_option4");
  tc->opt_quick_draw =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));
  
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_option5");
  tc->opt_display_mode
    = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));
  
  /* ǧι */  
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_confirm1");
  tc->confirm_save = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_confirm2");
  tc->confirm_overwrite
    = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  /* ֥饦ι */
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_thumb_dir");
  if (strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") == 0) {
    if (tc->thumb_dir) free (tc->thumb_dir);
    {
      gchar	*thumb_dir;

      thumb_dir = (gchar *)
	malloc (sizeof (gchar) * (strlen (y_dir_homedir ()) +
				  strlen (CONFIG_FILE_DIR) +
				  strlen ("icons")+3));
      sprintf (thumb_dir, "%s/%s/icons", y_dir_homedir (), CONFIG_FILE_DIR);
      tc->thumb_dir = g_strdup (thumb_dir);
      g_free (thumb_dir);
    }
  } else {
    if (tc->thumb_dir) free (tc->thumb_dir);
    tc->thumb_dir = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  }
  child = gtk_object_get_data (GTK_OBJECT (dialog), "thumb_width");  
  tc->thumb_width
    = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (child));
  child = gtk_object_get_data (GTK_OBJECT (dialog), "thumb_height");  
  tc->thumb_height
    = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (child));

  /* ι */
  {
    child = gtk_object_get_data (GTK_OBJECT (dialog), "config_assistant_data");
    if (tc->assistant_data) free (tc->assistant_data);
    tc->assistant_data = NULL;
    if (strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
      tc->assistant_data = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
    }

    child = gtk_object_get_data (GTK_OBJECT (dialog),
				 "config_assistant_help_path");
    if (tc->assistant_help_path) {
      y_free_strings (tc->assistant_help_path, tc->assistant_help_paths);
      tc->assistant_help_path = NULL;
    }
    tc->assistant_help_paths = GTK_CLIST (child)->rows;
    if (tc->assistant_help_paths != 0) {
      tc->assistant_help_path = (char **)
	malloc (sizeof (char) * tc->assistant_help_paths);
      for (n = 0; n < tc->assistant_help_paths; n++) {
	gtk_clist_get_text (GTK_CLIST (child), n, 0, &buf);
	tc->assistant_help_path[n] = g_strdup (buf);
      }
    }
  }
  /* ץ饰ѥι */
  {
    child = gtk_object_get_data (GTK_OBJECT (dialog), "config_plugin_path");
    if (tc->plugin_path) {
      y_free_strings (tc->plugin_path, tc->plugin_paths);
      tc->plugin_path = NULL;      
    }
    tc->plugin_paths = GTK_CLIST (child)->rows;
    if (tc->plugin_paths != 0) {
      tc->plugin_path = (char **) malloc (sizeof (char) * tc->plugin_paths);
      for (n = 0; n < tc->plugin_paths; n++) {
	gtk_clist_get_text (GTK_CLIST (child), n, 0, &buf);
	tc->plugin_path[n] = g_strdup (buf);
      }
    }
  }
  /* Ѥʤץ饰ι */
  {
    int	num = 0;
    
    /* Ѥʤץ饰ο */
    child = gtk_object_get_data (GTK_OBJECT (dialog), "config_plugin");
    for (n = 0; n < GTK_CLIST (child)->rows; n++) {
      if ((int) gtk_clist_get_row_data (GTK_CLIST (child), n) == 0) num++;
    }
    /* Ѥʤץ饰ꥹΰβ */
    if (tc->non_use_plugin) {
      y_free_strings (tc->non_use_plugin, tc->non_use_plugins);
      tc->non_use_plugin = NULL;
    }
    /* Ѥʤץ饰ι */
    tc->non_use_plugins = num;    

    /* Ѥʤץ饰ꥹȤ򹹿 */
    {
      GtkIconItemFactoryEntry	*p;
      char			buf[16];
      
      if (tc->non_use_plugins != 0) {
	num = 0;
	tc->non_use_plugin = (char **)
	  malloc (sizeof (char *) * tc->non_use_plugins);
	for (n = 0; n < GTK_CLIST (child)->rows; n++) {
	  if ((int) gtk_clist_get_row_data (GTK_CLIST (child), n) == 0) {
	    sprintf (buf, "%d", n+1);
	    p = (GtkIconItemFactoryEntry *)
	      g_hash_table_lookup (plugin_list, buf);
	    tc->non_use_plugin[num++] = g_strdup (p->path);
	  }
	}
      }
    }
  }
  /* 硼ȥåι */
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_shortcut");
  for (n = 0; n < SHORTCUT_NUM; n++) {
    gtk_clist_get_text (GTK_CLIST (child), n, 1, &buf);
    if (tc->shortcut[n].key) free (tc->shortcut[n].key);
    tc->shortcut[n].key = g_strdup (buf);
    gtk_clist_get_text (GTK_CLIST (child), n, 2, &buf);
    tc->shortcut[n].modifier = te_modstr_to_modid (buf);
    sprintf (accl, "%s%s",
	     mod_str2[tc->shortcut[n].modifier], tc->shortcut[n].key);
    gtk_accelerator_parse (accl, &keyval, &mod);
    tc->shortcut[n].keyval = keyval;
  }
  /* ¾ι */
  tc->default_loope_scale = scale;

  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_title_image");
  if (tc->title_image) {
    free (tc->title_image);
    tc->title_image = NULL;
  }
  if (!gtk_entry_get_text (GTK_ENTRY (child)) ||
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->title_image = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  }
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_skin_data");
  if (tc->skin_data) {
    free (tc->skin_data);
    tc->skin_data = NULL;
    opt->skin_data = NULL;
  }
  if (!gtk_entry_get_text (GTK_ENTRY (child)) ||
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->skin_data = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
    opt->skin_data = tc->skin_data;
  }
  
  child = gtk_object_get_data (GTK_OBJECT (dialog), "config_help_browser");
  if (tc->help_browser) {
    free (tc->help_browser);
    tc->help_browser = NULL;
  }
  if (!gtk_entry_get_text (GTK_ENTRY (child)) ||
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->help_browser = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  }
  /* եι */
  home = y_dir_homedir ();
  sprintf (config_file, "%s/%s/%s",
	   y_dir_homedir (), CONFIG_FILE_DIR, CONFIG_FILE);
  te_preference_save (tc, config_file);
  gtk_widget_grab_focus (gtk_object_get_data (GTK_OBJECT (dialog),
					      "button_close"));
}

/*  ϣ ***************************************************** */
static void
te_preference_dialog_ok (GtkWidget	*widget,
			 GtkWidget	*dialog) {
  te_preference_dialog_apply (widget, dialog);
  gtk_widget_hide (dialog);
  gtk_widget_destroy (dialog);
  preference_dialog = NULL;
}

/* Ĥ ************************************************** */
static void
te_preference_dialog_close_real (GtkWidget	*dialog,
				 gpointer	data) {
  gtk_widget_hide (dialog);
  gtk_widget_destroy (dialog);
  preference_dialog = NULL;
}

/* Ĥ ************************************************** */
static void
te_preference_dialog_close (GtkWidget	*widget,
			    GtkWidget	*dialog) {			
  te_preference_dialog_close_real (dialog, NULL);
}

/* ************************************************************************* */
static void
te_preference_change_box (GtkWidget	*widget,
			  gpointer	data) {
  GtkWidget	*box;
  char		*box_str[] = {"box0", "box1", "box2", "box3", "box4", "box5"};
  int		n;
  
  for (n = 0; n < 6; n++) {
    box = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (preference_dialog), box_str[n]);
    gtk_widget_hide (box);
  }
  box = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (preference_dialog), box_str[(int) data]);
  gtk_widget_show (box);
}

/*  **************************************************** */
GtkWidget*
te_preference_dialog_new (void) {
  GtkWidget	*window;
  GtkWidget	*vbox, *vbox2;
  GtkWidget	*hbox;
  GtkWidget	*button_box;
  GtkWidget	*notebook;
  GtkWidget	*separator;
  GtkWidget	*button;
  GtkWidget	*label;
  GtkWidget	*icon;
  GtkWidget	*box[6];
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_ref (window);
  gtk_object_set_data (GTK_OBJECT (window), "window", window); 
  gtk_window_set_title (GTK_WINDOW (window), _("Preference Dialog")); 
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_widget_set_usize (window, 480, -1);
  gtk_widget_realize (window);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) te_preference_dialog_close_real, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) te_preference_dialog_close_real, NULL);
  { 
    /* ľܥå */ 
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox);
    gtk_widget_show (vbox);     
    gtk_container_add (GTK_CONTAINER (window), vbox); 
    gtk_container_border_width (GTK_CONTAINER (vbox), 5); 
    {
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_widget_ref (hbox);
      gtk_widget_show (hbox);     
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);      
      {
	/* ľܥå */ 
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_widget_show (vbox2);	
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, FALSE, 0);      
	{
	  button =
	    gtk_icon_button_new_with_label (_("Option"),
					    configure,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 0); 

	  button =
	    gtk_icon_button_new_with_label (_("Image Explorer"),
					    windowmanager,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 1); 

	  button =
	    gtk_icon_button_new_with_label (_("Assistant"),
					    assistant_xpm,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 2); 

	  button =
	    gtk_icon_button_new_with_label (_("Plug-In"),
					    programs,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 3); 

	  button =
	    gtk_icon_button_new_with_label (_("ShortCut"),
					    shortcuts,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 4);

	  button =
	    gtk_icon_button_new_with_label (_("Misc"),
					    misc,
					    GTK_ICON_BUTTON_TEXT_BOTTOM, 0);
	  gtk_widget_ref (button);
	  gtk_widget_show (button);	  
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, FALSE, 0);
	  gtk_widget_set_usize (button, 120, -1);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_preference_change_box),
			      (gpointer) 5);
	}
	/* ץܥå */
	box[0] = te_preference_box_option (window);
	gtk_widget_show (box[0]);
	gtk_box_pack_start (GTK_BOX (hbox), box[0], TRUE, TRUE, 0);
	gtk_object_set_data (GTK_OBJECT (window), "box0", (gpointer) box[0]);
	
	/* ֥饦ܥå */
	box[1] = te_preference_box_browser (window);
	gtk_widget_hide (box[1]);
	gtk_box_pack_start (GTK_BOX (hbox), box[1], TRUE, TRUE, 0);	
	gtk_object_set_data (GTK_OBJECT (window), "box1", (gpointer) box[1]);
	
	/* ܥå */
	box[2] = te_preference_box_assistant (window);
	gtk_widget_hide (box[2]);
	gtk_box_pack_start (GTK_BOX (hbox), box[2], TRUE, TRUE, 0);	
	gtk_object_set_data (GTK_OBJECT (window), "box2", (gpointer) box[2]);

	/* ץ饰ܥå */
	box[3] = te_preference_box_plugin (window);
	gtk_widget_hide (box[3]);
	gtk_box_pack_start (GTK_BOX (hbox), box[3], TRUE, TRUE, 0);	
	gtk_object_set_data (GTK_OBJECT (window), "box3", (gpointer) box[3]);
	
	/* 硼ȥåܥå */
	box[4] = te_preference_box_shortcut (window);
	gtk_widget_hide (box[4]);
	gtk_box_pack_start (GTK_BOX (hbox), box[4], TRUE, TRUE, 0);	
	gtk_object_set_data (GTK_OBJECT (window), "box4", (gpointer) box[4]);
	
	/* ¾ܥå */
	box[5] = te_preference_box_misc (window);
	gtk_widget_hide (box[5]);
	gtk_box_pack_start (GTK_BOX (hbox), box[5], TRUE, TRUE, 0);
	gtk_object_set_data (GTK_OBJECT (window), "box5", (gpointer) box[5]);
      }
      /* ѥ졼 */ 
      separator = gtk_hseparator_new ();
      gtk_widget_ref (separator); 
      gtk_widget_show (separator);       
      gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 5); 

      /* ʿܥå */ 
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_widget_ref (hbox);
      gtk_widget_show (hbox);       
      gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0); 
      { 
	/* [Ĥ]ܥ */ 
 	button = gtk_icon_button_new_with_label (_("Close"), 
						 stock_button_close,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_widget_ref (button);
	gtk_widget_show (button);	
	gtk_object_set_data (GTK_OBJECT (window), "button_close", button); 
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (te_preference_dialog_close),
			    window);
 	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0); 
 	gtk_widget_set_usize (button, 100, -1); 
 	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
 	gtk_widget_grab_default (button);   

	/* [Ŭ]ܥ */ 
	button = gtk_icon_button_new_with_label (_("Apply"), 
						 stock_button_apply,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_widget_ref (button);
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (te_preference_dialog_apply),
			    window);
 	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0); 
 	gtk_widget_set_usize (button, 100, -1); 
 	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 


	/* [ϣ]ܥ */ 
	button = gtk_icon_button_new_with_label (_("OK"),
						 stock_button_ok,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_widget_ref (button);
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (te_preference_dialog_ok),
			    window); 
 	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0); 
 	gtk_widget_set_usize (button, 100, -1); 
 	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
      }
    }
  }
  if (scale == 0) scale = tc->default_loope_scale;
  
  return window;
}

/* ************************************************* End of preference.c *** */
