/* ************************************************************* print.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/05/21 09:21:05 sugaya>
 * ************************************************************************* */
#include "config.h"
#include "teoeyes.h"
#include "gtkscrollpane.h"
#include "gtkiconbutton.h"
#include "stock_print.xpm"
#include "stock_button_close.xpm"
#include <gdk_imlib.h>

/* ************************************************************************* */
static void	adjustment_changed	(GtkAdjustment		*a);
static void	print_cb_set_page 	(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_toggle_print	(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_toggle_color 	(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_scale_change 	(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_page_adj_change(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_print 		(GtkWidget		*widget,
					 gpointer		data);
static void	print_cb_cancel 	(GtkWidget		*widget,
					 gpointer		data);

/* ************************************************************************* */
static void
adjustment_changed (GtkAdjustment	*a) {
  gtk_signal_emit_by_name (GTK_OBJECT (a), "changed");
}

/* ѻ極 ******************************************************** */
static void
print_cb_set_page (GtkWidget	*widget,
		   gpointer	data) {
  GtkWidget		*parent;
  GdkImlibSaveInfo	*si;

  parent = GTK_WIDGET (data);
  si = (GdkImlibSaveInfo *)
    gtk_object_get_data (GTK_OBJECT (parent), "save_info");
  si->page_size =
    GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (widget), "data"));
}

/* ץ/եؤ *********************************************** */
static void
print_cb_toggle_print (GtkWidget	*widget,
		       gpointer	data) {
  GtkWidget	*parent;
  GtkWidget	*entry;
  int		select;

  select = (int) gtk_object_get_data (GTK_OBJECT (widget), "data");
  parent = GTK_WIDGET (data);
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
    gtk_object_set_data (GTK_OBJECT (parent), "print_mode",
			 GINT_TO_POINTER (select));
    if (select == 0) {
      entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (parent),
					       "entry_file"));
      gtk_widget_set_sensitive (entry, FALSE);
      entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (parent),
					       "entry_print"));
    } else {
      entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (parent),
					       "entry_print"));
      gtk_widget_set_sensitive (entry, FALSE);
      entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (parent),
					       "entry_file"));
    }
    gtk_widget_set_sensitive (entry, TRUE);    
  }
}

/* 顼/쥤ؤ *************************************************** */
static void
print_cb_toggle_color (GtkWidget	*widget,
		       gpointer		data) {
  GtkWidget		*parent;
  GdkImlibSaveInfo	*si;

  parent = GTK_WIDGET (data);
  si = (GdkImlibSaveInfo *)
    gtk_object_get_data (GTK_OBJECT (parent), "save_info");
  si->color = (si->color == 0) ? 1: 0;
}

/* ѹ ******************************************************** */
static void
print_cb_scale_change (GtkWidget	*widget,
		       gpointer		data) {
  GtkWidget          	*parent;
  GtkAdjustment      	*adj;
  GtkAdjustment      	*adj2;
  GtkAdjustment      	*adj3;
  GdkImlibSaveInfo   	*si;
  gint                	ww, hh;
  
  parent = GTK_WIDGET (data);

  adj  = gtk_object_get_data (GTK_OBJECT (parent), "scale_adj");
  adj2 = gtk_object_get_data (GTK_OBJECT (parent), "page_adj_w");
  adj3 = gtk_object_get_data (GTK_OBJECT (parent), "page_adj_h");

  si = gtk_object_get_data (GTK_OBJECT (parent), "save_info");
  si->scaling = (1024 * (int) adj->value) / 100;

  if ((te_image_get_curr_height(image_list) * 3) <
      (te_image_get_curr_width (image_list) * 4)) {
    ww = 64;
    hh = (3 * 64 * te_image_get_curr_height (image_list)) /
      (4 * te_image_get_curr_width (image_list));
  } else {
    hh = 64;
    ww = (4 * 64 * te_image_get_curr_width (image_list)) /
      (3 * te_image_get_curr_height (image_list));
  }
  adj2->page_size = (gfloat) ((si->scaling * ww) / 64) / 1024;
  adj3->page_size = (gfloat) ((si->scaling * hh) / 64) / 1024;
  adjustment_changed (adj2);
  adjustment_changed (adj3);
}

/* ֤ѹ ********************************************************** */
static void
print_cb_page_adj_change (GtkWidget	*widget,
			  gpointer	data) {
  GtkWidget          *parent;
  GtkAdjustment      *adj_w;
  GtkAdjustment      *adj_h;
  GdkImlibSaveInfo   *si;

  parent = GTK_WIDGET (data);
  adj_w = gtk_object_get_data (GTK_OBJECT (parent), "page_adj_w");
  adj_h = gtk_object_get_data (GTK_OBJECT (parent), "page_adj_h");
  si = gtk_object_get_data (GTK_OBJECT (parent), "save_info");
  si->xjustification = (int) ((1024 * adj_w->value) / 1);
  si->yjustification = 1024 - (int)((1024 * adj_h->value) / 1);
}

/* OKܥ󤬲줿ν ********************************************** */
static void
print_cb_print (GtkWidget	*widget,
		gpointer	data) {
  GtkWidget		*parent;
  GtkWidget		*entry;
  GdkImlibSaveInfo	*si;
  GdkImlibImage      	*im = NULL;
  GdkPixbuf		*pbuf = NULL;
  unsigned char		*pdata;  
  int			print_mode;
  char			filename[MAX_STRING_LNG_LINE];
  char			command[MAX_STRING_LNG_LINE];  
  char			*cmd;
  
  parent = GTK_WIDGET (data);
  si = gtk_object_get_data (GTK_OBJECT (parent), "save_info");
  print_mode = (int) gtk_object_get_data (GTK_OBJECT (parent), "print_mode");

  if (print_mode == 0) {
    entry = gtk_object_get_data (GTK_OBJECT (parent), "entry_print");
    g_snprintf(filename, sizeof (filename),
	       "/tmp/%i_%i.ps", getuid(), (int) time(NULL));

    if (te_image_get_has_alpha (image_list)) {
      pbuf  = gdk_pixbuf_remove_alpha (te_image_get_pbuf (image_list));
      pdata = gdk_pixbuf_get_pixels (pbuf);
    } else {
      pdata = gdk_pixbuf_get_pixels (te_image_get_pbuf (image_list));
    }
    im =
      gdk_imlib_create_image_from_data (pdata, NULL,
					te_image_get_curr_width (image_list),
					te_image_get_curr_height(image_list));
    gdk_imlib_save_image (im, filename, si);
    if (pbuf) gdk_pixbuf_unref (pbuf);
    if (im)   gdk_imlib_destroy_image (im);
    
    cmd = gtk_entry_get_text (GTK_ENTRY (entry));
    g_snprintf (command, sizeof (command), "cat %s | %s", filename, cmd);
    system (command);
    unlink (filename);
  } else {
    entry = gtk_object_get_data (GTK_OBJECT (parent), "entry_file");
    if (te_image_get_has_alpha (image_list)) {
      pbuf  = gdk_pixbuf_remove_alpha (te_image_get_pbuf (image_list));
      pdata = gdk_pixbuf_get_pixels (pbuf);
    } else {
      pdata = gdk_pixbuf_get_pixels (te_image_get_pbuf (image_list));
    }
    im =
      gdk_imlib_create_image_from_data (pdata, NULL,
					te_image_get_curr_width (image_list),
					te_image_get_curr_height(image_list));
    gdk_imlib_save_image (im, gtk_entry_get_text (GTK_ENTRY (entry)), si);
    if (pbuf) gdk_pixbuf_unref (pbuf);
    if (im)   gdk_imlib_destroy_image (im);
  }
  g_free (si);
  gtk_widget_hide    (parent);
  gtk_widget_destroy (parent);
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void
print_cb_cancel (GtkWidget	*widget,
		 gpointer	data) {
  GtkWidget		*parent;
  GdkImlibSaveInfo	*si;
  
  parent = GTK_WIDGET (data);
  si = gtk_object_get_data (GTK_OBJECT (parent), "save_info");  
  g_free (si);  
  gtk_widget_hide    (parent);
  gtk_widget_destroy (parent);
}

/*  **************************************************** */
GtkWidget*
te_print_dialog_new (void) {
  GtkWidget		*window;
  GtkWidget		*widget;	
  GtkWidget 		*vbox1;
  GtkWidget 		*vbox2;  
  GtkWidget 		*hbox1;
  GtkWidget 		*hbox2;
  GtkWidget 		*radio1;
  GtkWidget 		*radio2;
  GtkWidget		*menu;
  GtkWidget 		*optionmenu;
  GSList 		*group = NULL;
  GtkAdjustment		*adj;
  GtkAdjustment		*adj_w;
  GtkAdjustment		*adj_h;  
  GdkImlibSaveInfo	*si;
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("Print Dialog"));

  gtk_object_set_data (GTK_OBJECT (window), "print_mode", GINT_TO_POINTER (0));
  
  si = g_malloc (sizeof (GdkImlibSaveInfo));
  si->scaling        = 1024;
  si->xjustification = 512;
  si->yjustification = 512;
  si->page_size      = PAGE_SIZE_A4;
  si->color          = 0;
  gtk_object_set_data (GTK_OBJECT (window), "save_info", si);
  {
    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox1);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (window), vbox1);
    {
      widget = gtk_frame_new (_("Print Setting"));
      gtk_widget_ref (widget);
      gtk_widget_show (widget);
      gtk_box_pack_start (GTK_BOX (vbox1), widget, TRUE, TRUE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (widget), 5);
      {
	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (widget), hbox1);
	{
	  hbox2 = gtk_hbox_new (FALSE, 0);
	  gtk_widget_ref (hbox2);
	  gtk_widget_show (hbox2);
	  gtk_box_pack_start (GTK_BOX (hbox1), hbox2, TRUE, TRUE, 0);
	  {
	    vbox2 = gtk_vbox_new (TRUE, 0);
	    gtk_widget_ref (vbox2);
	    gtk_widget_show (vbox2);
	    gtk_box_pack_start (GTK_BOX (hbox2), vbox2, FALSE, FALSE, 2);
	    {
	      widget = gtk_label_new (_("Page"));
	      gtk_widget_ref (widget);
	      gtk_widget_show (widget);
	      gtk_misc_set_alignment (GTK_MISC (widget), 0.64, 0.5);
	      gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);

	      widget =
		gtk_radio_button_new_with_label (group, _("Printer"));
	      gtk_object_set_data (GTK_OBJECT (window), "radio_print", widget);
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (0));
	      group = gtk_radio_button_group (GTK_RADIO_BUTTON (widget));
	      gtk_widget_ref (widget);
	      gtk_widget_show (widget);
	      gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
	      gtk_signal_connect (GTK_OBJECT (widget), "toggled",
				  GTK_SIGNAL_FUNC (print_cb_toggle_print),
				  window);
	      
	      widget =
		gtk_radio_button_new_with_label (group, _("File"));
	      gtk_object_set_data (GTK_OBJECT (window), "radio_file", widget);
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (1));	      
	      gtk_widget_ref (widget);
	      gtk_widget_show (widget);
	      gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	      gtk_signal_connect (GTK_OBJECT (widget), "toggled",
				  GTK_SIGNAL_FUNC (print_cb_toggle_print),
				  window);
	      
	      widget = gtk_label_new ("");
	      gtk_widget_ref (widget);
	      gtk_widget_show (widget);
	      gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);

	      widget = gtk_label_new (_("Scaling Factor"));
	      gtk_widget_ref (widget);
	      gtk_widget_show (widget);
	      gtk_misc_set_alignment (GTK_MISC (widget), 0.64, 0.5);	      
	      gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	    }
	  }
	  vbox2 = gtk_vbox_new (TRUE, 0);
	  gtk_widget_ref (vbox2);
	  gtk_widget_show (vbox2);
	  gtk_box_pack_start (GTK_BOX (hbox2), vbox2, TRUE, TRUE, 0);
	  {
	    menu = gtk_menu_new ();
	    gtk_widget_show (menu);
	    
	    optionmenu = gtk_option_menu_new ();
	    gtk_widget_ref (optionmenu);
	    gtk_widget_show (optionmenu);
	    gtk_widget_set_usize (optionmenu, -1, 24);
	    gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
	    gtk_box_pack_start (GTK_BOX (vbox2), optionmenu, TRUE, FALSE, 0);
	    {
	      widget = gtk_menu_item_new_with_label (_("Executive"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_EXECUTIVE));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("Letter"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_LETTER));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("Legal"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_LEGAL));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("A4"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_A4));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("A3"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_A3));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate", 
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("A5"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_A5));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);

	      widget = gtk_menu_item_new_with_label (_("Folio"));
	      gtk_object_set_data (GTK_OBJECT (widget), "data",
				   GINT_TO_POINTER (PAGE_SIZE_FOLIO));
	      gtk_signal_connect (GTK_OBJECT (widget), "activate",
				  GTK_SIGNAL_FUNC (print_cb_set_page), window);
	      gtk_menu_append (GTK_MENU (menu), widget);
	      gtk_widget_show (widget);
	      
	      gtk_option_menu_set_history (GTK_OPTION_MENU(optionmenu), 3);
	    }
	    widget = gtk_entry_new ();
	    gtk_object_set_data (GTK_OBJECT (window), "entry_print", widget);
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 0);
	    gtk_entry_set_text (GTK_ENTRY (widget), "lpr");
	    
	    widget = gtk_entry_new ();
	    gtk_object_set_data (GTK_OBJECT (window), "entry_file", widget);
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 0);
	    gtk_widget_set_sensitive (widget, FALSE);
	    
	    widget = gtk_check_button_new_with_label (_("Color"));
	    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
				GTK_SIGNAL_FUNC (print_cb_toggle_color),
				window);
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);

	    adj = GTK_ADJUSTMENT (gtk_adjustment_new (100, 1, 101, 1, 1, 1));
	    widget = gtk_hscale_new (adj);
	    gtk_scale_set_digits (GTK_SCALE (widget), 0);	    	    
	    gtk_widget_ref (widget);
	    gtk_widget_show (widget);
	    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 0);
	    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
				GTK_SIGNAL_FUNC (print_cb_scale_change),
				window);
	    gtk_object_set_data (GTK_OBJECT(window), "scale_adj", adj);
	  }
	}
	vbox2 = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 5);
	
	adj_w = GTK_ADJUSTMENT (gtk_adjustment_new (0.5,0.0,1.0,1.0,1.0,1.0));
	adj_h = GTK_ADJUSTMENT (gtk_adjustment_new (0.5,0.0,1.0,1.0,1.0,1.0));
	widget = gtk_scrollpane_new (adj_w, adj_h, 1.0);
	gtk_widget_set_usize (widget, 60, 80);
	gtk_object_set_data (GTK_OBJECT (window), "page_adj_w", adj_w);
	gtk_object_set_data (GTK_OBJECT (window), "page_adj_h", adj_h);
	gtk_signal_connect (GTK_OBJECT (adj_w), "value_changed",
			    GTK_SIGNAL_FUNC(print_cb_page_adj_change), window);
	gtk_signal_connect (GTK_OBJECT (adj_h), "value_changed",
			    GTK_SIGNAL_FUNC(print_cb_page_adj_change), window);
	gtk_widget_ref (widget);
	gtk_widget_show (widget);
	gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
      }
      widget = gtk_hseparator_new ();
      gtk_widget_ref (widget);
      gtk_widget_show (widget);
      gtk_box_pack_start (GTK_BOX (vbox1), widget, FALSE, FALSE, 2);
      
      hbox1 = gtk_hbox_new (FALSE, 0);
      gtk_widget_ref (hbox1);
      gtk_widget_show (hbox1);
      gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 2);
      {
	widget = gtk_icon_button_new_with_label (_("Cancel"),
						 stock_button_close,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			    GTK_SIGNAL_FUNC (print_cb_cancel), window);	
	gtk_widget_ref (widget);
	gtk_widget_show (widget);
	gtk_box_pack_end (GTK_BOX (hbox1), widget, FALSE, FALSE, 0);
	gtk_widget_set_usize (widget, 100, -1);
 	GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
	
	widget = gtk_icon_button_new_with_label (_("Print"),
						 stock_print,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			    GTK_SIGNAL_FUNC (print_cb_print), window);	
	gtk_widget_ref (widget);
	gtk_widget_show (widget);
	gtk_box_pack_end (GTK_BOX (hbox1), widget, FALSE, FALSE, 0);
	gtk_widget_set_usize (widget, 100, -1);
 	GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT); 
 	gtk_widget_grab_default (widget);   
      }
    }
  }
  return window;
}
    
/* ****************************************************** End of print.c *** */
