/* ******************************************************** savedialog.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/07/22 18:25:39 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkcustomiconfilesel.h"
#include "bmp.h"
#include "ps.h"
#include "xpm.h"
#include <gdk_imlib.h>

/* եޥåȤγĥ **************************************************** */
static char *FormatString[9] = {"TEO (Teo Image Format)",
				"PPM (PNM)",
				"PGM (PNM)",
				"PNG",
				"JPEG",
				"TIFF",
				"XPM",
				"BMP", 
				"EPS (En. Postscript)"};

static char *sFormatString[9] = {"teo",
				 "ppm",
				 "pgm",
				 "png",
				 "jpg",
				 "tif",
				 "xpm",
				 "bmp",
				 "eps"};

/* եޥåȤŪꤹ ****************************************** */
static void
te_save_dialog_set_format (GtkWidget	*widget,
			   int		fmt) {
  char	*ext;
  char	*ptr;
  char	*filename;
  char	head[1024];
  char 	name[1024];

  if (fmt == FORMAT_UNKNOWN) return;

  /* ե̾ */  
  filename = (char *)
    gtk_entry_get_text ((GtkEntry *)
			GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry);
  
  if (!filename) return;

  if (strcmp (filename, "") == 0) {
    sprintf (name, "%s", sFormatString[fmt]);
    gtk_entry_set_text (GTK_ENTRY
			(GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			name);
  } else {
    /* ĥҤγ */
    ext = strrchr (filename, '.');
    /* ĥҤ˱ƥե̾ѹ */
    if (!ext) {	/* ĥҤʤ */
      sprintf (name, "%s.%s", filename, sFormatString[fmt]);
      gtk_entry_set_text (GTK_ENTRY
			  (GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			  name);
    } else {	/* ĥҤ */
      ptr = head;
      while (filename < ext) *ptr++ = *filename++;
      *ptr = '\0';
      sprintf (name, "%s.%s", head, sFormatString[fmt]);
      gtk_entry_set_text (GTK_ENTRY
			  (GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			  name);
    }
  }
}

/* ************************************************************************* */
void
te_save_operation (char		*filename,
		   int		flg_confirm,
		   int		flg_overwrite) {
  TEOFILE	*teo;
  TEOIMAGE	*teoimg;
  GdkImlibImage	*im;
  GdkPixbuf	*pbuf, *pbuf2;
  unsigned char	*pdata;    
  char		*ext;
  int		w, h, plane;

  if (!filename) return;
  if (strcmp (filename, "") == 0) return;

  /* ¸ǧ */
  if (flg_confirm && tc->confirm_save &&
      te_confirm_box_show (image_window, 
			   _("Confirm"), 
			   _("Are you sure you want to save it?")) == FALSE) {
    return;
  }
  /* 񤭳ǧ */
  if (y_file_exist_file (filename)) {
    if (flg_overwrite && tc->confirm_overwrite &&
	te_confirm_box_show (image_window, 
			     _("Confirm"), 
			     _("Already same filename exists.\n"
			       "Are you sure you want to overwrite it?"))
	== FALSE) {
      return;
    }
  }
  /* ¸ */
  ext = strrchr (filename, '.');
  if (!ext) return;
  w = te_image_get_curr_width  (image_list);
  h = te_image_get_curr_height (image_list);
  plane = 3 + te_image_get_has_alpha (image_list);
  
  pdata = (unsigned char *) malloc (sizeof (unsigned char) * (w * h * plane));
  pbuf = gdk_pixbuf_new_from_data (pdata, GDK_COLORSPACE_RGB,
				   te_image_get_has_alpha (image_list), 8,
				   w, h, w * plane, free_buffer, NULL);
  gdk_pixbuf_scale (te_image_get_pbuf (image_list), pbuf,
		    0, 0, w, h, 0, 0,
		    (double) w / te_image_get_orig_width  (image_list),
		    (double) h / te_image_get_orig_height (image_list),
		    GDK_INTERP_TILES);

  /* եޥåȤˤäƽʬ */
  if (strcmp (ext, ".png") == 0) {		/* PNG */
    gdk_pixbuf_save_to_file (pbuf, filename);
    gdk_pixbuf_unref (pbuf);
  } else if (strcmp (ext, ".teo") == 0) {	/* TEO */
    teo = TeoCreateFile (filename, w, h,
			 (te_image_get_teofp (image_list)) ?
			 TeoXoffset (te_image_get_teofp (image_list)) : 0,
			 (te_image_get_teofp (image_list)) ?
			 TeoYoffset (te_image_get_teofp (image_list)) : 0,
			 TEO_UNSIGNED, 8, plane, 1);
    teoimg = TeoAllocSimilarImage (teo);
    free (teoimg->data);
    teoimg->data = (unsigned char *) gdk_pixbuf_get_pixels (pbuf);
    TeoWriteFrame (teo, teoimg);
    TeoCloseFile (teo);
    teoimg->data = NULL;
    TeoFreeImage  (teoimg);
    gdk_pixbuf_unref (pbuf);
  } else if (strcmp (ext, ".bmp") == 0) {	/* BMP */
    if (gdk_pixbuf_get_has_alpha (pbuf)) {
      pbuf2 = gdk_pixbuf_remove_alpha (pbuf);
      WriteBMP (filename, pbuf2);
      gdk_pixbuf_unref (pbuf2);      
    } else {
      WriteBMP (filename, pbuf);
    }
    gdk_pixbuf_unref (pbuf);
  } else if (strcmp (ext, ".xpm") == 0) {	/* XPM */
    save_xpm_image (filename, pbuf);
    gdk_pixbuf_unref (pbuf);
  } else if (strcmp (ext, ".eps") == 0) {	/* EPS */
    if (gdk_pixbuf_get_has_alpha (pbuf)) {
      pbuf2 = gdk_pixbuf_remove_alpha (pbuf);
      save_ps_image (filename, pbuf2);
      gdk_pixbuf_unref (pbuf2);      
    } else {
      save_ps_image (filename, pbuf);
    }
    gdk_pixbuf_unref (pbuf);    
  } else {
    if (gdk_pixbuf_get_has_alpha (pbuf)) {
      pbuf2 = gdk_pixbuf_remove_alpha (pbuf);
      im = gdk_imlib_create_image_from_data (gdk_pixbuf_get_pixels (pbuf2),
					     NULL, w, h);
    } else {
      im = gdk_imlib_create_image_from_data (gdk_pixbuf_get_pixels (pbuf),
					     NULL, w, h);
    }
    gdk_imlib_save_image (im, filename, NULL);
    gdk_imlib_kill_image (im);
    gdk_pixbuf_unref (pbuf);
    if (gdk_pixbuf_get_has_alpha (pbuf)) gdk_pixbuf_unref (pbuf2);    
  }
}

/* OKܥ󤬲줿ν ********************************************** */
static void
te_save_dialog_ok (GtkWidget		*widget,
		   GtkCustomIconFileSel	*fs) {
  char		*filename;

  /* ե̾ */
  filename = (char *) 
    gtk_custom_icon_file_selection_get_filename (GTK_CUSTOM_ICON_FILESEL (fs));

  if (!filename || strcmp (filename, "") == 0) return;
  if (!widget && !y_file_is_file (filename)) return;

  te_save_operation (filename, 1, 1);
  
  gtk_widget_hide (GTK_WIDGET (fs));
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void 
te_save_dialog_cancel (GtkWidget	*widget,
		       GtkWidget	*fs) {
  gtk_widget_hide (fs);
}

/* ************************************************************************* */
static void
te_save_dialog_select_item (GtkFileList		*flist,
			    GtkFileListItem	*icon,
			    GdkEventButton	*ev,
			    gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    te_save_dialog_ok (NULL, GTK_CUSTOM_ICON_FILESEL (data));
  }
}

/* ¸Υץ ************************************************ */
void 
te_save_dialog_show (void) {
  if (!save_dialog)
    save_dialog = te_save_dialog_new (_("Save File Selection"));
  if (!GTK_WIDGET_VISIBLE (save_dialog))
    gtk_widget_show (save_dialog);
}

/* ߡؿ ************************************************************** */
static
te_save_dialog_entry_set_file (GtkWidget	*widget,
			       GdkEventKey	*key,
			       gpointer 	data) {

}

/* ¸ **************************************************** */
GtkWidget*
te_save_dialog_new (char	*title) {
  GtkWidget	*fs;
  int		n;
  int		format_nums = 9;

  /*  */
  fs = gtk_custom_icon_file_selection_new (title);

  /* ٥Ȥ */
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->ok_button),
		      "clicked", (GtkSignalFunc) te_save_dialog_ok, fs);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->cancel_button),
		      "clicked", (GtkSignalFunc) te_save_dialog_cancel, fs);
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->file_list),
		      "select_icon",
		      GTK_SIGNAL_FUNC (te_save_dialog_select_item), fs);
  
  /* եޥå˥塼ɲ */
  {
    GtkWidget	*box1;

    box1 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (box1);
    gtk_box_pack_start (GTK_BOX
			(GTK_CUSTOM_ICON_FILESEL (fs)->custom_box6),
			box1, FALSE, FALSE, 0);
    {
      GtkWidget	*separator;
    
      separator = gtk_vseparator_new ();
      gtk_widget_show (separator);
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 10);
    }

    {
      GtkWidget	*box;

      box = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (box);
      gtk_box_pack_start (GTK_BOX (box1), box, TRUE, TRUE, 0);
      {
	GtkWidget	*menu;
	GtkWidget 	*option_menu;
	GtkWidget	*item;

	option_menu = gtk_option_menu_new ();
	gtk_widget_set_usize (option_menu, 100, -1);
	gtk_widget_show (option_menu);
	gtk_box_pack_start (GTK_BOX (box), option_menu, TRUE, TRUE, 0);
	{
	  menu = gtk_menu_new ();
	  gtk_widget_show (menu);
	  gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	  {
	    for (n = 0; n < format_nums; n++) {
	      item = gtk_menu_item_new_with_label (FormatString[n]);
	      gtk_widget_show (item);
	      gtk_signal_connect (GTK_OBJECT (item), "activate",
				  GTK_SIGNAL_FUNC (te_save_dialog_set_format), 
				  (gpointer) n);
	      gtk_menu_append (GTK_MENU (menu), item);
	    }
	  }
	}
	gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);      
      }
    }
  }
  gtk_signal_connect (GTK_OBJECT (GTK_CUSTOM_ICON_FILESEL (fs)->file_entry),
		      "key_press_event",
		      GTK_SIGNAL_FUNC (te_save_dialog_entry_set_file), NULL);

  return fs;
}

/* ************************************************* End of savedialog.c *** */
