/* ********************************************************** teo_copy.h *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 11:44:53 sugaya>
 * ************************************************************************* */
#ifndef _TEO_COPY_H_
#define _TEO_COPY_H_

/* ************************************************************************* *
   These functions copy src-image dst-image.
   src	  : source image
   dst	  : destination image
   cs	  : col start
   ce	  : col end
   rs	  : row start
   re	  : row end
   p	  : plane
   offset : flag for decision of image offset
          0 - the offset of destination image is the offset of source image.
	  1 - the offset of destination image is (0, 0).
 * ************************************************************************* */
TEOIMAGE*	TeoCreateCopyImage		(TEOIMAGE	*src);

TEOIMAGE*	TeoCreateCopyImageRegion	(TEOIMAGE	*src,
						 int		cs,
						 int	 	ce,
						 int 		rs,
						 int	 	re,
						 int		offset);

TEOIMAGE*	TeoCreateCopyImagePlane		(TEOIMAGE	*src,
						 int		p);

TEOIMAGE*	TeoCreateCopyImagePlaneRegion	(TEOIMAGE 	*src,
						 int	 	p,
						 int 		cs,
						 int 		ce,
						 int 		rs, 
						 int 		re,
						 int		offset);

void		TeoCopyImage			(TEOIMAGE	*src, 
						 TEOIMAGE 	*dst);

void		TeoCopyImageRegion		(TEOIMAGE	*src,
						 TEOIMAGE 	*dst,
						 int 		cs,
						 int 		ce,
						 int 		rs,
						 int 		re);

void		TeoCopyImagePlane		(TEOIMAGE	*src,
						 TEOIMAGE	*dst,
						 int 		p);

void		TeoCopyImagePlaneRegion 	(TEOIMAGE	*src,
						 TEOIMAGE	*dst,
						 int 		p,
						 int 		cs,
						 int 		ce,
						 int 		rs,
						 int 		re);

#endif	/* _TEO_COPY_H_ */

/* *************************************************** End of teo_copy.h *** */
