/* ******************************************************** teo_normal.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 11:49:17 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNormalImage (TEOIMAGE	*src, 
		      double	min,
		      double	max) {
  TEOIMAGE      *dst;
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n;
  
  dst = TeoAllocImage (TeoWidth	  (src),
                       TeoHeight  (src),
                       TeoXoffset (src),
		       TeoYoffset (src),
                       TEO_UNSIGNED, 
		       8,
		       TeoPlane (src));
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;

  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNormalImageRegion (TEOIMAGE	*src,
			    int 	cs,
			    int 	ce,
			    int 	rs,
			    int 	re,
			    double 	min,
			    double 	max,
			    int		flg) {
  TEOIMAGE      *dst;
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, cols, step, plane;
  
  dst = TeoAllocImage (cols = ce - cs + 1,
		       re - rs + 1, 
		       (flg == 0) ? cs : 0,
		       (flg == 0) ? rs : 0,
		       TEO_UNSIGNED,
		       8,
		       plane = TeoPlane (src));
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  step	  = (TeoWidth (src) - cols) * plane;
  cols	 *= plane;
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNormalImagePlane (TEOIMAGE	*src,
			   int		p,
			   double	min,
			   double   	max) {
  TEOIMAGE      *dst;
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, step;
  
  dst = TeoAllocImage (TeoWidth   (src),
                       TeoHeight  (src),
                       TeoXoffset (src),
		       TeoYoffset (src),
                       TEO_UNSIGNED, 
		       8,
		       1);
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  step 	  = TeoPlane (src);
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (16):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNormalImagePlaneRegion (TEOIMAGE	*src,
				 int 		p,
				 int 		cs,
				 int 		ce,
				 int 		rs,
				 int 		re,
				 double 	min,
				 double		max,
				 int		flg) {
  TEOIMAGE      *dst;
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, step, cols, plane;

  dst = TeoAllocImage (cols = ce - cs + 1,
		       re - rs + 1, 
		       (flg == 0) ? cs : 0, 
		       (flg == 0) ? rs : 0, 
		       TEO_UNSIGNED, 
		       8, 
		       1);
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  plane	  = TeoPlane (src);
  step    = (TeoWidth (src) - cols) * plane;
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
void 
TeoNormalImage (TEOIMAGE	*src, 
		TEOIMAGE	*dst,
		double 		min,
		double 		max) {
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n;

  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  }
}

/* ************************************************************************* */
void
TeoNormalImageRegion (TEOIMAGE	*src,
		      TEOIMAGE 	*dst,
		      int 	cs,
		      int 	ce,
		      int 	rs,
		      int	re,
		      double 	min,
		      double 	max) {
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, cols, step, plane;
  
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  step	  = (TeoWidth (src) - cols) * plane;
  cols	 *= plane;
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
      }
      break;
    }
    break;
  }
}

/* ************************************************************************* */
void 
TeoNormalImagePlane (TEOIMAGE	*src,
		     TEOIMAGE 	*dst,
		     int	p,
		     double 	min,
		     double 	max) {
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, step;

  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  step 	  = TeoPlane (src);
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (16):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  }
}

/* ************************************************************************* */
void
TeoNormalImagePlaneRegion (TEOIMAGE	*src,	
			   TEOIMAGE 	*dst,
			   int		p,
			   int 		cs,
			   int 		ce,
			   int 		rs,
			   int 		re,
			   double	min,
			   double	max) {
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n, step, cols, plane;

  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;
  plane	  = TeoPlane (src);
  step    = (TeoWidth (src) - cols) * plane;
  switch (TeoType (src)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (16):
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (32):
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (src)) {
    case (8):
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (16):
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (32):
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (src)) {
    case (32):
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    case (64):
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	for (n = TeoFsize (dst); n > 0; n--) {
	  if (((n % cols) == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr - min) * 255 / param);
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  }
}

/* ******************************************************** teo_normal.c *** */
