/* *** libteo+ ********************************************* teo_pixel.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-07 22:44:29 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

/* ************************************************************************* *
   TeoGetPixel
 * ************************************************************************* */
double
TeoGetAnyPixel (TEOIMAGE	*img,
		int 		col, 
		int 		row,
		int 		p) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (img)) {
    case 1:
      return (double) TeoGetBit (img, col, row, p);
      break;
    case 8:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT8);
      break;
    case 16:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT16);
      break;
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT32);
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (img)) {
    case 8:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT8);
      break;
    case 16:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT16);
      break;
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT32);
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (img)) {
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_FLOAT32);
      break;
    case 64:
      return (double) TeoGetPixel (img, col, row, p, TEO_FLOAT64);
      break;
    }
    break;
  }
}

/* ************************************************************************* *
   TeoPutPixel
 * ************************************************************************* */
void
TeoPutAnyPixel (TEOIMAGE	*img,
		int 		col,
		int 		row,
		int 		p,
		double 		val) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (img)) {
    case 1:
      TeoPutBit (img, col, row, p, (TEO_BIT) val);
      break;
    case 8:
      TeoPutPixel (img, col, row, p, TEO_UINT8, (TEO_UINT8) val);
      break;
    case 16:
      TeoPutPixel (img, col, row, p, TEO_UINT16, (TEO_UINT16) val);
      break;
    case 32:
      TeoPutPixel (img, col, row, p, TEO_UINT32, (TEO_UINT32) val);
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (img)) {
    case 8:
      TeoPutPixel (img, col, row, p, TEO_SINT8, (TEO_SINT8) val);
      break;
    case 16:
      TeoPutPixel (img, col, row, p, TEO_SINT16, (TEO_SINT16) val);
      break;
    case 32:
      TeoPutPixel (img, col, row, p, TEO_SINT32, (TEO_SINT32) val);
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (img)) {
    case 32:
      TeoPutPixel (img, col, row, p, TEO_FLOAT32, (TEO_FLOAT32) val);
      break;
    case 64:
      TeoPutPixel (img, col, row, p, TEO_FLOAT64, (TEO_FLOAT64) val);
      break;
    }
    break;
  }
  return;
}

/* ************************************************************************* *
   TeoGetPixelRGB
 * ************************************************************************* */
void
TeoGetAnyPixelRGB (TEOIMAGE	*img, 
		   int 		col,
		   int 		row,
		   double 	val[3]) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (img)) {
    case 8:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_UINT8);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_UINT8);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_UINT8);
      break;
    case 16:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_UINT16);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_UINT16);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_UINT16);
      break;
    case 32:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_UINT32);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_UINT32);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_UINT32);
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (img)) {
    case 8:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_SINT8);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_SINT8);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_SINT8);
      break;
    case 16:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_SINT16);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_SINT16);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_SINT16);
      break;
    case 32:
	val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_SINT32);
	val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_SINT32);
	val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_SINT32);
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (img)) {
    case 32:
      val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_FLOAT32);
      val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_FLOAT32);
      val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_FLOAT32);
      break;
    case 64:
      val[0] = (double) TeoGetPixel (img, col, row, 0, TEO_FLOAT64);
      val[1] = (double) TeoGetPixel (img, col, row, 1, TEO_FLOAT64);
      val[2] = (double) TeoGetPixel (img, col, row, 2, TEO_FLOAT64);
      break;
    }
    break;
  }
}

/* ************************************************************************* *
   TeoPutPixelRGB
 * ************************************************************************* */
void
TeoPutAnyPixelRGB (TEOIMAGE	*img, 
		   int 		col,
		   int 		row,
		   double 	val[3]) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (img)) {
    case 8:
      TeoPutPixel (img, col, row, 0, TEO_UINT8, (TEO_UINT8) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_UINT8, (TEO_UINT8) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_UINT8, (TEO_UINT8) val[2]);
      break;
    case 16:
      TeoPutPixel (img, col, row, 0, TEO_UINT16, (TEO_UINT16) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_UINT16, (TEO_UINT16) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_UINT16, (TEO_UINT16) val[2]);
      break;
    case 32:
      TeoPutPixel (img, col, row, 0, TEO_UINT32, (TEO_UINT32) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_UINT32, (TEO_UINT32) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_UINT32, (TEO_UINT32) val[2]);
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (img)) {
    case 8:
      TeoPutPixel (img, col, row, 0, TEO_SINT8, (TEO_SINT8) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_SINT8, (TEO_SINT8) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_SINT8, (TEO_SINT8) val[2]);
      break;
    case 16:
      TeoPutPixel (img, col, row, 0, TEO_SINT16, (TEO_SINT16) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_SINT16, (TEO_SINT16) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_SINT16, (TEO_SINT16) val[2]);
      break;
    case 32:
      TeoPutPixel (img, col, row, 0, TEO_SINT32, (TEO_SINT32) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_SINT32, (TEO_SINT32) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_SINT32, (TEO_SINT32) val[2]);
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (img)) {
    case 32:
      TeoPutPixel (img, col, row, 0, TEO_FLOAT32, (TEO_FLOAT32) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_FLOAT32, (TEO_FLOAT32) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_FLOAT32, (TEO_FLOAT32) val[2]);
      break;
    case 64:
      TeoPutPixel (img, col, row, 0, TEO_FLOAT64, (TEO_FLOAT64) val[0]);
      TeoPutPixel (img, col, row, 1, TEO_FLOAT64, (TEO_FLOAT64) val[1]);
      TeoPutPixel (img, col, row, 2, TEO_FLOAT64, (TEO_FLOAT64) val[2]);
      break;
    }
    break;
  }
}

/* ********************************************************* teo_pixel.c *** */
