/* ****************************************************** teo_negative.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 11:49:09 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNegativeImage (TEOIMAGE	*src) {
  TEOIMAGE	*dst;
  TEO_UINT8	*src_ptr, *dst_ptr;
  int		n;
	
  dst     = TeoAllocSimilarImage (src);
  src_ptr = (TEO_UINT8 *) src->data;
  dst_ptr = (TEO_UINT8 *) dst->data;

  for (n = TeoFsize (src); n > 0; n--) *dst_ptr++ = 255 - *src_ptr++;

  return dst;
}

/* ************************************************************************* */
void
TeoNegativeImage (TEOIMAGE	*src,
		  TEOIMAGE	*dst) {
  TEO_UINT8	*src_ptr, *dst_ptr;
  int		n;

  src_ptr = (TEO_UINT8 *) src->data;
  dst_ptr = (TEO_UINT8 *) dst->data;

  for (n = TeoFsize (src); n > 0; n--) *dst_ptr++ = 255 - *src_ptr++;

}

/* *********************************************** End of teo_negative.c *** */
