/* ******************************************************** teo_normal.h *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 11:45:10 sugaya>
 * ************************************************************************* */
#ifndef _TEO_NORMAL_H_
#define _TEO_NORMAL_H_

TEOIMAGE*	TeoCreateNormalImage	 	(TEOIMAGE	*src,
						 double 	min,
						 double 	max);

TEOIMAGE*	TeoCreateNormalImageRegion	(TEOIMAGE	*src,
						 int	 	cs,
						 int 		ce,
						 int 		rs,
						 int 		re,
						 double 	min,
						 double 	max);

TEOIMAGE*	TeoCreateNormalImagePlane 	(TEOIMAGE 	*src,
						 int	   	p,
						 double   	min,
						 double   	max);

TEOIMAGE*	TeoCreateNormalImagePlaneRegion	(TEOIMAGE 	*src,
						 int 		p,
						 int 		cs,
						 int 		ce,
						 int 		rs,
						 int 		re,
						 double		min,
						 double		max);

void		TeoNormalImage			(TEOIMAGE	*src,
						 TEOIMAGE 	*dst,
						 double 	min,
						 double 	max);

void		TeoNormalImageRegion	 	(TEOIMAGE	*src,
						 TEOIMAGE 	*dst,
						 int 		cs,
						 int 		ce,
						 int 		rs,
						 int 		re,
						 double 	min,
						 double 	max);

void		TeoNormalImagePlane 		(TEOIMAGE	*src,
						 TEOIMAGE 	*dst,
						 int 		p,
						 double 	min,
						 double 	max);

void		TeoNormalImagePlaneRegion	(TEOIMAGE	*src,
						 TEOIMAGE 	*dst,
						 int		p,
						 int 		cs,
						 int 		ce,
						 int 		rs,
						 int 		re,
						 double 	min,
						 double 	max);

#endif	/* _TEO_NORMAL_H_ */

/* ************************************************* End of teo_normal.h *** */
