/* *********************************************************** teoeyes.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/17 12:25:42 sugaya>
 * ************************************************************************* */
#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <teo.h>
#include <teo2gdk-pixbuf.h>

#include "teo_convert.h"
#include "teo_copy.h"
#include "teo_negative.h"
#include "teo_normal.h"
#include "teo_pixel.h"
#include "teo_range.h"

#include "gdk-pixbuf-extension.h"

#include "intl.h"
#include "macros.h"


/* ȥ ********************************************************** */
typedef struct _WinGeometry {
  int	width;
  int	height;
  int	x;
  int	y;
  int	xsign;
  int	ysign;
} WinGeometry;

/* ץ¤ ******************************************************** */
typedef struct _Option {
  char		*skin_data;	/* ǥ쥯ȥ */
  unsigned char	load_image;	/* ɥץ */
  unsigned char	clear_data;	/* ǡץ */
  unsigned char	normalize;	/* ץ */
  unsigned char	quick_draw;	/* ˡץ */  
  unsigned char	display_mode;	/* ɽ⡼ɥץ */	
  int		frame;		/* ɽե졼ֹ */
  int		draw_background;/* ط西 */
  double	min;		/* Ǿ */
  double	max;		/*  */
  WinGeometry	*geo;		/* ȥ */
} Option;  

/* 硼ȥåȤι¤ ************************************************** */
typedef struct _Shortcut {
  char	*key;		/* ٥ */
  int	keyval;		/*  */
  int	modifier;	/*  */
} Shortcut;

/* ܤι¤ ******************************************************** */
typedef struct _TeoeyesConfig {
  /* ǥեȥץ */
  unsigned char	opt_load_image;		/* ɥץ */
  unsigned char	opt_clear_data;		/* ǡץ */
  unsigned char	opt_normalize;		/* ץ */
  unsigned char	opt_quick_draw;		/* ˡץ */	
  unsigned char	opt_display_mode;	/* ɽ⡼ɥץ */
  /* ǧ */
  unsigned char	confirm_save;		/* ¸γǧץ */
  unsigned char	confirm_overwrite;	/* 񤭻γǧץ */
  /* ֥饦 */
  char		*thumb_dir;		/* ͥǥ쥯ȥ */
  int		thumb_width;		/* ͥ */
  int		thumb_height;		/* ͥι⤵ */
  /* Ȥ */
  char		*assistant_data;	
  char		**assistant_help_path;
  int		assistant_help_paths;
  /* ץ饰 */
  int		plugin_paths;		/* ץ饰ѥο */
  int		non_use_plugins;	/* Ѥʤץ饰ο */
  char		**plugin_path;		/* ץ饰Υѥ */
  char		**non_use_plugin;	/* Ѥʤץ饰Υѥ */
  /* 硼ȥåȤ */
  Shortcut	shortcut[SHORTCUT_NUM];	/* 硼ȥå */
  /* ¾ */
  int		default_loope_scale;	/* Ψ */
  char		*title_image;		/* ȥե̾ */
  char		*skin_data;		/* ǥ쥯ȥ */
  char		*help_browser;		/* إץ֥饦 */
} TeoeyesConfig;

/* ֥饦ι¤ ******************************************************** */
typedef struct _TEBrowser {
  GtkWidget	*window;
  GtkWidget	*menu;
  GtkWidget	*toolbar;
  GtkWidget	*dir_combo;
  GtkWidget	*dir_tree;
  GtkWidget	*iconlist_window;
  GtkWidget	*filelist_window;
  GtkWidget	*iconlist;
  GtkWidget	*filelist;
  GtkWidget	*progressbar;
  GtkWidget	*state_label;
  GList		*combo_list;
  int		sort_type_name;
  int		sort_type_fsize;
  int		sort_type_isize;
  int		sort_type_update;
  int		display_mode;
} TEBrowser;

/* TEImage¤ *********************************************************** */
typedef struct _TEImage {
  
  char			 *filename;	/* ե̾ */
  int			 id;	 	/* ID */
  int			 format;	/* եޥå */
  int			 width;		/*  */
  int			 height;	/* ι⤵ */
  int			 orig_width;	/* ꥸʥ */
  int			 orig_height;	/* ꥸʥι⤵ */
  int			 frame;		/* ɽΥե졼ֹ */
  int			 plane;		/* ɽΥץ졼ֹ */
  int			 has_alpha;	/* ץ졼 */    
  TEOFILE		 *teofp;	/* TEOFILE */	
  TEOIMAGE		 *orig_data;	/* Υꥸʥǡ */
  TEOIMAGE		 *curr_data;	/* ɽβǡ */
  GdkPixbuf		 *pbuf;		/* GdkPixbufǡ */
  GList			 *pix_list;	/* GdkPixmapΥꥹ */
  GList			 *msk_list;	/* GdkBitmapΥꥹ */
  GdkPixmap		 *pixmap;
  GdkBitmap		 *mask;
  GdkPixbufModifier 	 *mod;
  unsigned char		 inner_data;	/* ǡɤΥե饰 */

} TEImage;

/* ************************************************************************* */
#include "assistant.h"
#include "browser.h"
#include "cripping.h"
#include "draw.h"
#include "edit.h"
#include "getargs.h"
#include "grab.h"
#include "fileop.h"
#include "info.h"
#include "init.h"
#include "image.h"
#include "image_list.h"
#include "loope.h"
#include "main_callbacks.h"
#include "main_window.h"
#include "misc.h"
#include "opendialog.h"
#include "pixelinfo.h"
#include "playerII.h"
#include "plugin.h"
#include "plugin_info.h"
#include "print.h"
#include "preference.h"
#include "savedialog.h"
#include "toolbar.h"

/* Хѿ ********************************************************** */
Option		*opt;
TeoeyesConfig	*tc;
GtkWidget	*image_window;
GtkWidget	*edit_window;
GtkWidget	*list_window;
GtkWidget	*pixel_window;
GtkWidget	*loope;
GtkWidget	*playerII;
GtkWidget	*assistant;
GtkWidget	*open_dialog;
GtkWidget	*save_dialog;
GtkWidget	*info_dialog;
GtkWidget	*preference_dialog;
GtkWidget	*toolbar;
GList		*image_list;
GdkPixbuf	*backup;
TEBrowser	*browser;
char		*selected_icon_name;
GHashTable	*plugin_table;
GHashTable	*plugin_list;
int		plugin_nums;
int		update_timer;

/* **************************************************** End of teoeyes.h *** */
