/* *********************************************************** toobar.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 11:49:30 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "gtkicon.h"

#include "icon_small.xpm"
#include "stock_open.xpm"
#include "stock_save.xpm"
#include "stock_save_as.xpm"
#include "stock-zoom-out.xpm"
#include "stock-zoom-in.xpm"
#include "stock_first_arrow3.xpm"
#include "stock_left_arrow3.xpm"
#include "stock_right_arrow3.xpm"
#include "stock_last_arrow3.xpm"
#include "stock_properties.xpm"
#include "stock_exit.xpm"

/* ġСɲ ******************************************************** */
void
te_toolbar_add (GtkWidget	*parent,
		GtkWidget	*toolbar) {
  /* ֤ܥ */
#if 0
  padder_button = gtk_button_new();
  gtk_widget_set_sensitive (padder_button, 0);
  gtk_widget_show (padder_button);
#endif  
  /* ġСɲ */
  gtk_box_pack_start(GTK_BOX (parent), toolbar, FALSE, FALSE, 0);
#if 0
  gtk_box_pack_start(GTK_BOX (parent), padder_button, TRUE, TRUE, 0);
#endif  
  gtk_widget_show (toolbar);
}

/* ġСä ******************************************************** */
void
te_toolbar_hide (void) {
  if (toolbar) {
    gtk_widget_hide (toolbar);
    gtk_widget_destroy (toolbar);
    toolbar = NULL;	
  }
#if 0
  if (padder_button) {
    gtk_widget_destroy (padder_button);
    padder_button = NULL;
  }
#endif
  gtk_object_set_data (GTK_OBJECT (image_window), "toolbar_pos", (gpointer) 0);
}

/* ġС ******************************************************** */
GtkWidget*
te_toolbar_new (void) {
  GtkWidget	*window;
  GtkWidget 	*handlebox;
  GtkWidget 	*toolbar;
  GtkWidget 	*icon;
  GtkWidget 	*button;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_widget_show (handlebox);
  {
    /* ġС */
    toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
    gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
    gtk_object_set_data (GTK_OBJECT (handlebox), "toolbar", toolbar);
    gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
    gtk_widget_show (toolbar);
    {
      /* TeoEyesεưܥ */
      icon = te_icon_new (teoeyes_icon_small);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Teoeyes"), 
			      _("Run TeoEyes"),
			      _("Run TeoEyes"),
			      icon,
			      te_menu_cb_file_run_teoeyes,
			      NULL);
      /* ֳץܥ */
      icon = te_icon_new (stock_open);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Open"), 
			      _("Open a new file"),
			      _("Open a new file"),
			      icon,
			      te_menu_cb_file_open,
			      NULL);
      /* ¸ץܥ */
      icon = te_icon_new (stock_save);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Save"), 
			      _("Save as original filename"),
			      _("Save as original filename"),
			      icon,
			      te_menu_cb_file_save,
			      NULL);
      /* ̾¸ץܥ */
      icon = te_icon_new (stock_save_as);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Save"), 
			      _("Save as new filename"),
			      _("Save as new filename"),
			      icon,
			      te_menu_cb_file_saveas,
			      NULL);
#if 1
      /* ֽ̾ץܥ */
      icon = te_icon_new (stock_zoom_out);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Zoom Out"), 
			      _("Zoom out image"),
			      _("Zoom out image"),
			      icon,
			      te_menu_cb_size_minus,
			      NULL);
      /* ֳץܥ */
      icon = te_icon_new (stock_zoom_in);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Zoom In"), 
			      _("Zoom in image"),
			      _("Zoom in image"),
			      icon,
			      te_menu_cb_size_plus,
			      NULL);
#endif
      /* Ƭβץܥ */
      icon = te_icon_new (stock_first_arrow3);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("First Image"), 
			      _("View the first image in the list"),
			      _("View the first image in the list"),
			      icon,
			      te_menu_cb_view_top_image,
			      NULL);
      /* βץܥ */
      icon = te_icon_new (stock_left_arrow3);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Previous Image"), 
			      _("View the previous image in the list"),
			      _("View the previous image in the list"),
			      icon,
			      te_menu_cb_view_prev_image,
			      NULL);
      /* ּβץܥ */
      icon = te_icon_new (stock_right_arrow3);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Next Image"), 
			      _("View the next image in the list"),
			      _("View the next image in the list"),
			      icon,
			      te_menu_cb_view_next_image,
			      NULL);
      /* βץܥ */
      icon = te_icon_new (stock_last_arrow3);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Last Image"), 
			      _("View the last image in the list"),
			      _("View the last image in the list"),
			      icon,
			      te_menu_cb_view_bottom_image,
			      NULL);
      /* ץܥ */
      icon = te_icon_new (stock_properties);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Property"), 
			      _("Configure teoeyes properety"),
			      _("Configure teoeyes properety"),
			      icon,
			      te_menu_cb_preference,
			      NULL);
      /* ֽλץܥ */
      icon = te_icon_new (stock_exit);
      gtk_widget_show (icon);
      gtk_toolbar_append_item(GTK_TOOLBAR (toolbar), 
			      _("Exit"), 
			      _("Exit TeoEyes"),
			      _("Exit TeoEyes"),
			      icon,
			      te_menu_cb_quit,
			      NULL);
    }
  }
  return handlebox;
}

/* **************************************************** End of toolbar.c *** */
