/* ********************************************************** gtkabout.c *** *
 * gtkabout
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/10/25 11:15:18 sugaya>
 * ************************************************************************* */
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gtkabout.h"
#include "gtkiconbutton.h"

#include "intl.h"

#include "stock_button_close.xpm"

/* եȾ */
#define HELVETICA_20_BFONT "-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*"
#define HELVETICA_14_BFONT "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"
#define HELVETICA_12_BFONT "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_12_FONT  "-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_10_FONT  "-adobe-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"

#define GTK_ABOUT_DEFAULT_WIDTH		100
#define GTK_ABOUT_MAX_WIDTH		600
#define BASE_LINE_SKIP			4

/* ************************************************************************* */
typedef struct {
  gchar		*title;
  gchar		*copyright;
  GList		*names;
  gchar		*comments;
  GdkPixmap 	*logo;
  GdkBitmap	*mask;
  gint 		logo_w;
  gint		logo_h;
  gint		w;
  gint		h;
  GdkColor	light_green;
  GdkFont	*font_title;
  GdkFont	*font_copyright;
  GdkFont	*font_author;
  GdkFont	*font_names;
  GdkFont	*font_comments;
} GtkAboutInfo;

/* ************************************************************************* */
static void	gtk_about_repaint		(GtkWidget	*w, 
						 GdkEventExpose	*event,
						 GtkAboutInfo	*data);

static void	gtk_about_display_comments	(GdkWindow	*win, 
						 GdkFont	*font,
						 GdkGC 		*gc, 
						 gint		x,
						 gint 		y,
						 gint 		w, 
						 gchar	 	*comments);

/* ************************************************************************* */
static void
gtk_about_repaint (GtkWidget		*widget, 
		   GdkEventExpose	*event,
		   GtkAboutInfo 	*gai) {
  GdkWindow	*win		= widget->window;
  GdkColor	*black		= &widget->style->black;
  GdkColor	*white		= &widget->style->white;
  GdkColor	*light_green	= &gai->light_green;
  GList		*name;
  static GdkGC	*gc		= NULL;
  int		h, y, x;

  /* GC */
  if (!gc) gc = gdk_gc_new (win);

  /* ɥΥꥢ */
  gdk_window_clear (win);

  /* ԥåޥåפ */
  y = 1;
  if (gai->logo) {
    y += 2;
    x = (gai->w - gai->logo_w) / 2;
    if (gai->mask) {
      gdk_gc_set_clip_mask (gc, gai->mask);
      gdk_gc_set_clip_origin (gc, x, y);
    }
    gdk_draw_pixmap (win, gc, gai->logo, 0, 0, x, y, gai->logo_w, gai->logo_h);
    if (gai->mask) {
      gdk_gc_set_clip_mask (gc, NULL);
      gdk_gc_set_clip_origin (gc, 0, 0);
    }
    y += 2 + gai->logo_h;
  }
      
  /* ȥ */
  h = gai->font_title->descent + gai->font_title->ascent + 13;
  if (gai->title) {
    y += 2;
    gdk_gc_set_foreground (gc, black);
    gdk_gc_set_background (gc, black);
    gdk_draw_rectangle (win, gc, TRUE, 2, y, gai->w - 5, h);
    y += h - 7 - gai->font_title->descent;
    x = (gai->w - gdk_string_measure (gai->font_title, gai->title)) / 2;
    gdk_gc_set_foreground (gc, white);
    gdk_draw_string (win, gai->font_title, gc, x, y, gai->title);
    y += 7 + gai->font_title->descent + 2;
  }

  if (gai->copyright || gai->names || gai->comments) {
    gdk_gc_set_foreground (gc, light_green);
    gdk_gc_set_background (gc, light_green);
    gdk_draw_rectangle (win, gc, TRUE, 2, y, gai->w-5, gai->h - y - 3);
  }

  gdk_gc_set_foreground (gc, black);

  if (gai->copyright) {
    y += 4 + gai->font_copyright->ascent;
    gdk_draw_string (win, gai->font_copyright, gc, 5, y, gai->copyright);
    y += gai->font_copyright->descent + 4;
  }

  if (gai->names) {
    y += 2 + gai->font_author->ascent;
    if (g_list_length (gai->names) == 1)
      gdk_draw_string (win, gai->font_author, gc, 5, y, _("Author:"));
    else
      gdk_draw_string (win, gai->font_author, gc, 5, y, _("Authors:"));
  }
  x = 5 + gdk_string_measure (gai->font_author, _("Authors:")) + 10;

  name = g_list_first (gai->names);
  while (name) {
    h = gai->font_names->descent + gai->font_names->ascent;
    gdk_draw_string (win, gai->font_names, gc, x, y, (char *)name->data);
    name = name->next;
    if (name != NULL) y += h;
  }

  if (gai->comments) {
    y += 2 + 2 * gai->font_comments->ascent;
    gtk_about_display_comments (win, gai->font_comments, gc, 8, y, gai->w, 
				  gai->comments);
  }

  return;
}

/* ************************************************************************* */
static void
gtk_about_display_comments (GdkWindow		*win, 
			    GdkFont		*font,
			    GdkGC		*gc, 
			    gint		x,
			    gint		y,
			    gint 		w, 
			    gchar 		*comments) {
  int	ypos, width, done;
  char 	*tok, *p1, *p2, *p3, c;
  char	*buffer;
  char	*endp;
  char	*tokp;
  GList *par, *tmp;

  width = w - 16;
  if (!comments) return;

  buffer = g_strdup(comments);
  ypos = y;

  par = (GList *) NULL;
#ifdef HAVE_STRTOK_R
  for (tok = strtok_r (buffer, "\n", &tokp); tok;
       tok = strtok_r (NULL, "\n", &tokp)) {
    par = g_list_append (par, g_strdup(tok));
  }
#else
  for (tok = strtok (buffer, "\n", &tokp); tok;
       tok = strtok (NULL, "\n", &tokp)) {
    par = g_list_append (par, g_strdup(tok));
  }
#endif  
  tmp = par;
  while (tmp != NULL) {
    done = FALSE;
    p1 = p2 = tmp->data;
    while (!done) {
      c = *p1; *p1 = 0;
      while ( gdk_string_measure (font, p2) < width && c != 0) {
	*p1 = c; 
	p1++;
	c = *p1;
	*p1 = 0;
      }
      switch (c) {
      case ' ':
	p1++;
	gdk_draw_string (win, font, gc, x, ypos, p2);
	break;
      case '\0':
	done = TRUE;
	gdk_draw_string (win, font, gc, x, ypos, p2);
	break;
      default:
	p3 = p1;
	while (*p1 != ' ' && p1 > p2)
	  p1--;
	if (p1 == p2) {
	  gdk_draw_string (win, font, gc, x, ypos, p2);
	  *p3 = c;
	  p1 = p3;
	  break;
	} else {
	  *p3 = c;
	  *p1 = 0; 
	  p1++;
	  gdk_draw_string (win, font, gc, x, ypos, p2);
	}
	break;
      }
      ypos += font->descent + font->ascent;
      p2 = p1;
    }
    tmp = tmp->next;
    ypos += BASE_LINE_SKIP;
  }

  g_list_foreach(par, (GFunc) g_free, NULL);
  g_list_free (par);
  g_free (buffer);

  return;
}

/* η׻ **************************************************** */
static void
gtk_about_calc_size (GtkAboutInfo	*gai) {
  GList		*name;
  gint		num_pars, i, h, w, len[4], tmpl;
  gfloat	maxlen;
  const gchar	*p;

  w = GTK_ABOUT_DEFAULT_WIDTH;
  h = 1;

  if (gai->title) {
    len[0] = gdk_string_measure (gai->font_title, gai->title);
    h += 4 + gai->font_title->descent + gai->font_title->ascent + 14;
  } else {
    len[0] = 0;
  }
  if (gai->copyright) {
    h += gai->font_copyright->descent + gai->font_copyright->ascent + 8;
    len[1] = gdk_string_measure (gai->font_copyright, gai->copyright);
  } else {
    len[1] = 0;
  }
  len[2] = 0;
  if (gai->names) {
    name = g_list_first (gai->names);
    while (name) {
      tmpl = gdk_string_measure (gai->font_names, name->data);
      if (tmpl > len[2]) len[2] = tmpl;
      name = name->next;
    }
    tmpl = gdk_string_measure (gai->font_names, _("Authors: "));
    len[2] += tmpl + 15;
    h += g_list_length (gai->names) * (gai->font_names->descent + 
				       gai->font_names->ascent + 
				       BASE_LINE_SKIP ) + 4;
  }
  maxlen = (gfloat) w;
  for (i=0; i<3; i++)
    if (len[i] > maxlen) maxlen = (gfloat) len[i];
    
  w = (int) (maxlen * 1.2);
  if (w > GTK_ABOUT_MAX_WIDTH) w = GTK_ABOUT_MAX_WIDTH;

  if (gai->comments) {
    num_pars = 1;
    p = gai->comments;
    while (*p != '\0') {
      if (*p == '\n') num_pars++;
      p++;
    }
    i = gdk_string_measure (gai->font_comments, gai->comments);
    i /= w - 16;
    i += 1 + num_pars;;
    h += i * (gai->font_comments->descent + gai->font_comments->ascent);
  }
  gai->w = w+4;
  gai->h = h+3;

  return;
}  

/*  ************************************************************** */
static GtkAboutInfo*
gtk_fill_info (GtkWidget 	*widget,
	       gchar		*title,
	       gchar		*version,
	       gchar   		*copyright,
	       gchar   		**authors,
	       gchar   		*comments,
	       gchar   		*logo) {
  GtkAboutInfo	*gai;
  static GdkColor	light_green = {0, 30208, 41216, 33792};
  GtkStyle		*style;

  /* alloc mem for struct */
  gai = g_new (GtkAboutInfo, 1);

  /* Create fonts */
  /* FIXME: dirty hack, but it solves i18n problem without rewriting the
     drawing code..  */
  style = gtk_style_ref (widget->style);
  /* ܸɽǤ褦˽ */
  gtk_widget_ensure_style (widget);  
  gtk_widget_set_name (widget, "Title");
  gai->font_title = gdk_font_ref (widget->style->font);

  gtk_widget_set_name (widget, "Copyright");
  gai->font_copyright = gdk_font_ref (widget->style->font);

  gtk_widget_set_name (widget, "Author");
  gai->font_author = gdk_font_ref (widget->style->font);

  gtk_widget_set_name (widget, "Names");
  gai->font_names = gdk_font_ref (widget->style->font);

  gtk_widget_set_name (widget, "Comments");
  gai->font_comments = gdk_font_ref (widget->style->font);

  gtk_widget_set_style (widget, style);
  gtk_style_unref (style);
  
  /* Add color */
  memcpy (&gai->light_green, &light_green, sizeof (GdkColor));
  /*   gdk_color_alloc (gdk_colormap_get_system (), &gai->light_green); */

  /* FIXME: this should use a GdkColorContext for allocation.
   * The cc structure should reside in the GtkAboutClass so
   * that all about boxes share it. */
  gdk_color_alloc (gtk_widget_get_default_colormap (), &gai->light_green);

  /* fill struct */
  if(title) 
    gai->title = g_strconcat (title, " ", version ? version : "", NULL);
  else
    gai->title = NULL;
  
  gai->copyright = g_strdup(copyright);
  
  gai->comments = g_strdup(comments);
  
  gai->names = NULL;
  if (authors && authors[0]) {
    while( *authors ) {
      gai->names = g_list_append (gai->names, g_strdup(*authors));
      authors++;
    }
  }

  /* Calculate width of window */
  gtk_about_calc_size (gai);

  /* Done */
  return gai;
}

/* ˲ ******************************************************** */
static void
gtk_destroy_about (GtkWidget	*widget,
		   gpointer 	*data) {
  GtkAboutInfo	*gai;

  gai = (GtkAboutInfo *) data;

  /* Free memory used for title, copyright and comments */
  g_free (gai->title);
  g_free (gai->copyright);
  g_free (gai->comments);

  /* Free GUI's. */
  gdk_font_unref (gai->font_title);
  gdk_font_unref (gai->font_copyright);
  gdk_font_unref (gai->font_author);
  gdk_font_unref (gai->font_names);
  gdk_font_unref (gai->font_comments);
  
  /* Free memory used for authors */
  g_list_foreach(gai->names, (GFunc) g_free, NULL);
  g_list_free (gai->names);

  g_free (gai);
}

/**
 * gtk_about_new
 * @title: Name of app.
 * @version: version number
 * @copyright: copyright string
 * @authors: %NULL terminated list of authors
 * @comments: Other comments
 * @logo: a logo pixmap file.
 *
 * Description: Creates a new GTK About dialog.  @title, @version,
 * @copyright, and @authors are displayed first, in that order.
 * @comments is typically the location for multiple lines of text, if
 * necessary.  (Separate with "\n".)  @logo is the filename of a
 * optional pixmap to be displayed in the dialog, typically a product or
 * company logo of some sort; set to %NULL if no logo file is available.
 *
 * Returns: &GtkWidget pointer to new dialog
 **/

/* ************************************************************************* */
GtkWidget*
gtk_about_new (gchar	*title,
	       gchar	*version,
	       gchar	*copyright,
	       gchar	**authors,
	       gchar	*comments,
	       gchar	*logo) {
  GtkAboutInfo	*ai;
  GtkWidget	*about;
  GtkWidget	*frame;
  GtkWidget	*drawing_area;
  GtkWidget	*button;
  GtkWidget	*box;
  GtkWidget	*label;
  GtkWidget	*icon;
  GdkPixmap	*pix;
  GdkBitmap	*msk;
  GtkStyle	*style;
  gint		w, h;
  GdkPixbuf	*pbuf;
  
  if (!title)		title		= "";
  if (!version)		version		= "";
  if (!copyright)	copyright	= "";
  g_return_val_if_fail (authors != NULL, NULL);
  if (!comments)	comments	= "";

  /* ܥå */
  about = gtk_dialog_new ();
  gtk_window_set_title	(GTK_WINDOW (about), _("About"));
  gtk_window_set_policy	(GTK_WINDOW (about), FALSE, FALSE, TRUE);
  {
    /* ǥեѹ */
    gtk_box_set_child_packing (GTK_BOX (GTK_DIALOG (about)->vbox),
			       GTK_WIDGET (GTK_DIALOG (about)->action_area),
			       FALSE, FALSE, 0, GTK_PACK_END);
    gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (about)->action_area), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER 
				    (GTK_DIALOG (about)->action_area), 5);
  }
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 4);
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG (about)->vbox),
		       GTK_WIDGET(frame));
    gtk_widget_show (frame);
    
    /* ɥ󥰥ꥢ */
    drawing_area = gtk_drawing_area_new ();
    gtk_widget_set_name (drawing_area, "DrawingArea");
    gtk_container_add (GTK_CONTAINER (frame), drawing_area);
    style = gtk_widget_get_style (drawing_area);
    
    ai = gtk_fill_info (drawing_area,
			title, version, copyright, authors, comments, logo);
  
    w = ai->w; h = ai->h;

    if (logo) {
      pbuf = gdk_pixbuf_new_from_file (logo);
      if (pbuf) {
	gdk_pixbuf_render_pixmap_and_mask (pbuf, &ai->logo, &ai->mask, 255);
	gdk_window_get_size ((GdkWindow *) ai->logo, &ai->logo_w, &ai->logo_h);
	h += 4 + ai->logo_h;
	ai->h = h;
	ai->w = MAX (w, (ai->logo_w + 6)); 
	w = ai->w;
	gdk_pixbuf_unref (pbuf);
      } else {
	ai->logo = NULL;
      }
    } else {
      ai->logo = NULL;
    }
    gtk_widget_set_usize (GTK_WIDGET (drawing_area), w, h);
    gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK);
    gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event",
			(GtkSignalFunc) gtk_about_repaint, (gpointer) ai);
    gtk_widget_show (drawing_area);
  }
  
  /* Closeܥ */
  button = gtk_icon_button_new_with_label (_("Close"),
					   stock_button_close,
					   GTK_ICON_BUTTON_TEXT_RIGHT, 5);
  gtk_widget_set_usize (button, 100, -1);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (about)->action_area), button,
		    FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (gtk_destroy_about), (gpointer) ai);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (about));
#if 0	/* modified 2002/10/25
	   ܥ򲡤ȥȥ顼򵯤Τǥȥ */
  gtk_signal_connect (GTK_OBJECT (about), "destroy",
		      (GtkSignalFunc) gtk_destroy_about, (gpointer) ai);
  gtk_signal_connect (GTK_OBJECT (about), "delete_event",
		      (GtkSignalFunc) gtk_destroy_about, (gpointer) ai);
#endif
  return about;
}

/* ********************************************************** gtkabout.c *** */
