/* ************************************************************************* *
 * gtkiconfileselection - gtkiconfileselection dialog widget for gtk+
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * ************************************************************************* */

/* ********************************************** gtkcustomiconfilesel.c *** *
 * ޥǽʥե
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-10-20 18:10:45 sugaya>
 * ************************************************************************* */
#include "config.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <unistd.h>

#include <dirent.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* 2001/07/02 sugaya */
#include <locale.h>
#include "intl.h"
/* End of 2001/07/02 sugaya */

#include "gtkcustomiconfilesel.h"

/* 2001/07/02 sugaya */
#include "gtkiconbutton.h"

#include "folder_up.xpm"
#include "folder_new.xpm"
#include "home2.xpm"
#include "stock_button_ok.xpm"
#include "stock_button_cancel.xpm"
/* End of 2001/07/02 sugaya */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

/* 2001/07/02 sugaya */
#ifndef COMBO_LIST_LIMIT
#define COMBO_LIST_LIMIT	20
#endif

static void
gtk_custom_icon_file_selection_class_init (GtkCustomIconFileSelClass *klass);
static void
gtk_custom_icon_file_selection_init 	(GtkCustomIconFileSel	*filesel);
static void	open_dir		(GtkWidget 		*widget, 
					 GtkCTreeNode 		*node, 
					 gint 			n,
					 gpointer 		data);
static void	entry_set_file		(GtkWidget 		*widget, 
					 GdkEventKey 		*key, 
					 gpointer 		data);
static void 	real_set_file		(GtkWidget 		*widget, 
					 gpointer 		data);
static void 	set_filter		(GtkWidget 		*widget, 
					 GdkEventKey 		*key,
					 gpointer 		data);
static gboolean	select_icon		(GtkIconList 		*iconlist, 
					 GtkIconListItem 	*icon,
					 GdkEvent 		*event, 
					 gpointer 		data);
static void 	insert_text		(GtkEditable 		*editable,
					 const gchar 		*new_text,
					 gint  		new_text_length,
					 gint  			*position,
					 gpointer 		data);
static gchar 	*get_real_path		(const gchar 		*full_path);

/* 2001/07/03 sugaya */
static void	set_dir			(GtkWidget		*widget, 
					 GdkEventKey		*key, 
					 gpointer		data);
static void	combo_changed 		(GtkWidget		*widget,
					 GtkWidget		*child,
					 gpointer		data);
static void	event_folder_up 	(GtkWidget		*widget,
					 gpointer		data);
static void	event_folder_home 	(GtkWidget		*widget,
					 gpointer		data);
static void	event_folder_new 	(GtkWidget		*widget,
					 gpointer		data);
static void	event_button_ok 	(GtkWidget		*widget,
					 gpointer		data);
static void	event_button_cancel 	(GtkWidget		*widget,
					 gpointer		data);
static void	set_new_dirname		(GtkWidget		*widget, 
					 GdkEventKey		*key, 
					 gpointer		data);
static GtkWidget* create_dir_new 	(GtkCustomIconFileSel	*parent);
gchar*
gtk_custom_icon_file_selection_get_filename (GtkCustomIconFileSel *filesel);
static void	gtk_custom_combo_list_add (GtkCustomIconFileSel	*parent,
					   gchar		*folder);
static void	gtk_custom_combo_select_item (GtkWidget		*widget,
					      GdkEvent		*ev,
					      gpointer		data);
static void	gtk_custom_combo_set_popdown_strings (GtkCombo	*combo,
						      GList	*strings,
						      GtkWidget	*filesel);


static void	event_folder_test 	(GtkWidget		*widget,
					 gpointer		data);

static GtkWindowClass *parent_class = NULL;


GtkType
gtk_custom_icon_file_selection_get_type (void)
{
  static GtkType filesel_type = 0;
  
  if (!filesel_type)
    {
      GtkTypeInfo filesel_info =
      {
	"GtkCustomIconFileSel",
	sizeof (GtkCustomIconFileSel),
	sizeof (GtkCustomIconFileSelClass),
	(GtkClassInitFunc) gtk_custom_icon_file_selection_class_init,
	(GtkObjectInitFunc) gtk_custom_icon_file_selection_init,
	/* reserved_1 */ NULL,
	/* reserved_2 */ NULL,
	(GtkClassInitFunc) NULL,
      };
      
      filesel_type = gtk_type_unique (gtk_window_get_type(), &filesel_info);
    }
  
  return filesel_type;
}

GtkWidget*
gtk_custom_icon_file_selection_new (const gchar *title)
{
  GtkWidget *widget;

  widget = gtk_widget_new (gtk_custom_icon_file_selection_get_type(), NULL);

  gtk_custom_icon_file_selection_construct(GTK_CUSTOM_ICON_FILESEL(widget), title);

  return widget;
}

void
gtk_custom_icon_file_selection_construct (GtkCustomIconFileSel *file_sel, const gchar *title)
{
  /*  GTK_CUSTOM_ICON_FILESEL(widget)->title = g_strdup(title);
   */
  gtk_window_set_title(GTK_WINDOW(file_sel),title);
}

static void
gtk_custom_icon_file_selection_class_init (GtkCustomIconFileSelClass *klass)
{
  GtkWidgetClass *widget_class;
  
  widget_class = (GtkWidgetClass*) klass;
  parent_class = gtk_type_class (gtk_window_get_type ());

}

static void
gtk_custom_icon_file_selection_init (GtkCustomIconFileSel *filesel)
{
  GtkWidget	*main_vbox;
  GtkWidget	*main_hbox;  
  GtkWidget	*hbox, *box;
  GtkWidget 	*table;
  GtkWidget 	*label;
  GtkWidget 	*scrolled_window;
  GtkWidget 	*separator;
  GtkWidget 	*frame;
  GtkWidget 	*hpaned;
  GtkTooltips	*tooltips;
  gchar		dir[4096];

#if 0	/* 2001/07/03 sugaya */
  filesel->show_tree = FALSE;
#else
  filesel->show_tree = TRUE;
#endif
#if 0	/* 2001/07/03 sugaya */
  gtk_window_set_policy(GTK_WINDOW(filesel), FALSE, FALSE, FALSE);
#else
  gtk_window_set_policy(GTK_WINDOW(filesel), FALSE, TRUE, TRUE);
#endif
  gtk_container_set_border_width (GTK_CONTAINER (filesel), 10);

  /* ʿܥåɲ 2001/07/02 sugaya */
  main_hbox = gtk_hbox_new (FALSE, 1);
  gtk_container_add (GTK_CONTAINER (filesel), main_hbox);
  gtk_widget_show (main_hbox);
  
  
  main_vbox=gtk_vbox_new(FALSE,1);
  gtk_container_set_border_width(GTK_CONTAINER(main_vbox),0);
#if 0	/* 2001/07/03 sugaya */
  gtk_container_add(GTK_CONTAINER(filesel), main_vbox);
#else
  gtk_box_pack_start (GTK_BOX (main_hbox),
		      main_vbox, TRUE, TRUE, 0);
#endif
  gtk_widget_show(main_vbox);


  /* ܥå5ɲ 2001/07/03 sugaya */
  filesel->custom_box5 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_hbox),
		      filesel->custom_box5, FALSE, FALSE, 0);

  /* ܥå1ɲ 2001/07/03 sugaya */
  filesel->custom_box1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box1, FALSE, FALSE, 0);
  gtk_widget_show (filesel->custom_box1);

  /* ǥ쥯ȥꥨȥ, եܥɲ 2001/07/03 sugaya */
  filesel->custom_box6 = gtk_hbox_new (FALSE, 1);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box6, FALSE, FALSE, 5);
  gtk_widget_show (filesel->custom_box6);
  {
    /* ٥ */
    label = gtk_label_new (_("Current Directory:"));
    gtk_misc_set_alignment (GTK_MISC (label), 1., 0.5);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box6),
			label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    /* ǥ쥯ȥꥳ */
    filesel->dir_combo = gtk_combo_new ();
    gtk_box_pack_start (GTK_BOX (filesel->custom_box6),
			filesel->dir_combo, TRUE, TRUE, 10);
    gtk_combo_disable_activate(GTK_COMBO(filesel->dir_combo));
    gtk_widget_show (filesel->dir_combo);

    gtk_signal_handler_block (GTK_OBJECT (GTK_COMBO
					  (filesel->dir_combo)->entry),
			      GTK_COMBO (filesel->dir_combo)->entry_change_id);
    
    gtk_signal_connect (GTK_OBJECT (GTK_COMBO (filesel->dir_combo)->entry),
			"key_press_event", GTK_SIGNAL_FUNC (set_dir), filesel);

    gtk_signal_connect (GTK_OBJECT (GTK_COMBO (filesel->dir_combo)->list), 
			"select_child",GTK_SIGNAL_FUNC(combo_changed),filesel);
  
    /* ġåפ */
    tooltips = gtk_tooltips_new ();

    /* [ƥǥ쥯ȥ]ܥ */
    filesel->folder_button_up = gtk_icon_button_new (folder_up_xpm);
    gtk_widget_set_usize (filesel->folder_button_up, 32, 28);
    gtk_widget_show (filesel->folder_button_up);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box6),
			filesel->folder_button_up, FALSE, FALSE, 0);
    gtk_signal_connect (GTK_OBJECT (filesel->folder_button_up), "clicked",
			GTK_SIGNAL_FUNC (event_folder_up), filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_up,
			  _("Go parent directory"), NULL);

    /* [ǥ쥯ȥκ]ܥ */    
    filesel->folder_button_new = gtk_icon_button_new (folder_new_xpm);
    gtk_widget_set_usize (filesel->folder_button_new, 32, 28);
    gtk_widget_show (filesel->folder_button_new);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box6),
			filesel->folder_button_new, FALSE, FALSE, 0);
    gtk_signal_connect (GTK_OBJECT (filesel->folder_button_new), "clicked",
			GTK_SIGNAL_FUNC (event_folder_new), filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_new,
			  _("Create new directory"), NULL);

    /* [ۡǥ쥯ȥ]ܥ */    
    filesel->folder_button_home = gtk_icon_button_new (home2_xpm);
    gtk_widget_set_usize (filesel->folder_button_new, 32, 28);
    gtk_widget_show (filesel->folder_button_home);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box6),
			filesel->folder_button_home, FALSE, FALSE, 0);
    gtk_signal_connect (GTK_OBJECT (filesel->folder_button_home), "clicked",
			GTK_SIGNAL_FUNC (event_folder_home), filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_home,
			  _("Go home directory"), NULL);
  }

#if 0	/* 2001/07/03 sugaya */
  filesel->path_label = gtk_label_new(G_DIR_SEPARATOR_S);
  gtk_misc_set_alignment(GTK_MISC(filesel->path_label), 0., .5);
  gtk_box_pack_start(GTK_BOX(main_vbox), filesel->path_label, FALSE, TRUE, 0);
  gtk_widget_show(filesel->path_label);
#endif

  /* ܥå2ɲ 2001/07/03 sugaya */
  filesel->custom_box2 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box2, FALSE, FALSE, 0);
  gtk_widget_show (filesel->custom_box2);

#if 0	/* 2001/07/03 sugaya */
  hbox=gtk_hbox_new(FALSE,1);
  gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
#else  
  /* ʿڥ */
  hpaned = gtk_hpaned_new ();
  gtk_widget_ref (hpaned);
  gtk_widget_show (hpaned);
  gtk_container_add (GTK_CONTAINER (main_vbox), hpaned);  
#endif

  filesel->tree_window = scrolled_window=gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(scrolled_window, 200, 250);
#if 0	/* 2001/07/03 sugaya */
  gtk_box_pack_start(GTK_BOX(hbox), scrolled_window, TRUE, TRUE, 0);
#else
  gtk_container_add (GTK_CONTAINER (hpaned), scrolled_window);
#endif
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  
  filesel->dir_tree = gtk_dir_tree_new();
#if 0
  GTK_DIR_TREE(filesel->dir_tree)->show_hidden = TRUE;
#else
  GTK_DIR_TREE(filesel->dir_tree)->show_hidden = FALSE;
#endif
  gtk_container_add(GTK_CONTAINER(scrolled_window), filesel->dir_tree);
  gtk_widget_show(filesel->dir_tree);
  gtk_widget_show(filesel->tree_window);	/* 2001/07/03 sugaya */
  
#if 0	/* 2001/07/03 sugaya */
  gtk_box_pack_start(GTK_BOX(hbox), gtk_vseparator_new(), TRUE, TRUE, 0);
#endif

  
  /* ե졼ɲ 2001/07/03 sugaya */
  frame = gtk_frame_new (NULL);
  gtk_widget_ref (frame);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (hpaned), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 2);

  
  filesel->list_window = scrolled_window=gtk_scrolled_window_new(NULL, NULL);
#if 0	/* 2001/07/03 sugaya */
  gtk_box_pack_start(GTK_BOX(hbox), scrolled_window, TRUE, TRUE, 0);
#else
  gtk_widget_set_usize(filesel->list_window, 380, 250);
  gtk_container_add (GTK_CONTAINER (frame), filesel->list_window);
#endif
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				 GTK_POLICY_ALWAYS,
				 GTK_POLICY_AUTOMATIC);

  filesel->file_list = gtk_file_list_new (20, GTK_ICON_LIST_TEXT_RIGHT, G_DIR_SEPARATOR_S);
  GTK_ICON_LIST(filesel->file_list)->is_editable = TRUE;
  GTK_FILE_LIST(filesel->file_list)->show_folders = TRUE;
#if 0
  GTK_FILE_LIST(filesel->file_list)->show_hidden = TRUE;
#else
  GTK_FILE_LIST(filesel->file_list)->show_hidden = FALSE;
#endif
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), 
					filesel->file_list);
  gtk_widget_show(filesel->file_list);
  gtk_widget_show(filesel->list_window);	/* 2001/07/03 sugaya */
  
#if 0	/* 2001/07/03 sugaya */
  if(filesel->show_tree){ 
    gtk_custom_icon_file_selection_show_tree(filesel, TRUE);
    gtk_widget_set_usize(filesel->list_window, 380, 250);
  }else{
    gtk_widget_set_usize(filesel->list_window, 550, 250);
  }

  gtk_widget_show(scrolled_window);
#endif
  
  gtk_signal_connect(GTK_OBJECT(filesel->file_list), "select_icon",
		     GTK_SIGNAL_FUNC(select_icon), filesel);

  /* 2001/07/03 sugaya */
  gtk_signal_connect(GTK_OBJECT(filesel->dir_tree), "tree_select_row",
		     GTK_SIGNAL_FUNC(open_dir), filesel);


#if 0	/* 2001/07/03 sugaya */
  filesel->action_area = table = gtk_table_new(TRUE, 2, 4);
  gtk_box_pack_start(GTK_BOX(main_vbox), table, TRUE, TRUE, 3);
  gtk_widget_show(table);

  label = gtk_label_new("File:        ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
			    label,
			    0, 1, 0, 1);
  gtk_widget_show(label);

  label = gtk_label_new("Filter:        ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
			    label,
			    0, 1, 1, 2);
  gtk_widget_show(label);
#else
  /* ѥ졼ɲ */
  separator = gtk_hseparator_new ();
  gtk_widget_show (separator);
  gtk_box_pack_start(GTK_BOX(main_vbox), separator, FALSE, FALSE, 5);  

  /* ܥå3ɲ */
  filesel->custom_box3 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box3, FALSE, FALSE, 0);
  gtk_widget_show (filesel->custom_box3);

  table = gtk_table_new (TRUE, 2, 4);
  gtk_box_pack_start(GTK_BOX(main_vbox), table, FALSE, FALSE, 0);
  gtk_widget_show(table);

  label = gtk_label_new (_("File:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
			    label,
			    0, 1, 0, 1);
  gtk_widget_show(label);

  label = gtk_label_new (_("File Filter:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
			    label,
			    0, 1, 1, 2);
  gtk_widget_show(label);
#endif
  
  filesel->file_entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), filesel->file_entry, 1, 3, 0, 1);
  gtk_widget_show(filesel->file_entry);

  gtk_signal_connect(GTK_OBJECT(filesel->file_entry), "key_press_event",
		     GTK_SIGNAL_FUNC(entry_set_file), filesel);

  filesel->filter_entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), filesel->filter_entry, 1, 3, 1, 2);
  gtk_widget_show(filesel->filter_entry);

  
  gtk_signal_connect(GTK_OBJECT(filesel->filter_entry), "key_press_event",
		     GTK_SIGNAL_FUNC(set_filter), filesel);

  gtk_signal_connect(GTK_OBJECT(filesel->filter_entry), "insert_text",
		     GTK_SIGNAL_FUNC(insert_text), NULL);
  
  box = gtk_vbutton_box_new();
  gtk_table_attach_defaults(GTK_TABLE(table), box, 3, 4, 0, 2);
  gtk_widget_show(box);

#if 0 /* 2001/07/03 sugaya */
  filesel->ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_end (GTK_BOX (box), filesel->ok_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->ok_button);

  gtk_signal_connect(GTK_OBJECT(filesel->ok_button), "clicked",
		     GTK_SIGNAL_FUNC(real_set_file), filesel);

  filesel->cancel_button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_end (GTK_BOX (box), filesel->cancel_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->cancel_button);
#else
  filesel->ok_button =
    gtk_icon_button_new_with_label (_("OK"),
				    stock_button_ok,
				    GTK_ICON_BUTTON_TEXT_RIGHT, 5);

  gtk_box_pack_start (GTK_BOX (box), filesel->ok_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->ok_button);

  filesel->cancel_button =
    gtk_icon_button_new_with_label (_("Cancel"),
				    stock_button_cancel,
				    GTK_ICON_BUTTON_TEXT_RIGHT, 5);
  gtk_box_pack_start (GTK_BOX (box), filesel->cancel_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->cancel_button);

  /* ܥå4ɲ */
  filesel->custom_box4 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box4, FALSE, FALSE, 0);
  gtk_widget_show (filesel->custom_box4);

  getcwd (dir, sizeof (dir));
  sprintf (dir, "%s/", dir);
  gtk_custom_icon_file_selection_open_dir (GTK_CUSTOM_ICON_FILESEL (filesel),
					   dir);
#endif
}

void
gtk_custom_icon_file_selection_show_tree(GtkCustomIconFileSel *filesel, gboolean show)
{
  if(show == filesel->show_tree) return;

  filesel->show_tree = show;

  if(show){
    gchar *path;

    filesel->tree_signal_id = gtk_signal_connect(GTK_OBJECT(filesel->dir_tree), 
						 "tree_select_row",
						 GTK_SIGNAL_FUNC(open_dir), 
						 filesel);

    path = gtk_file_list_get_path(GTK_FILE_LIST(filesel->file_list));
    gtk_dir_tree_open_dir(GTK_DIR_TREE(filesel->dir_tree), path);

    gtk_widget_set_usize(filesel->list_window, 380, 250);
    gtk_widget_show(filesel->tree_window);
  } else {
    gtk_signal_disconnect(GTK_OBJECT(filesel->dir_tree), 
			  filesel->tree_signal_id);
    gtk_widget_hide(filesel->tree_window);
    gtk_widget_set_usize(filesel->list_window, 550, 250);
  } 
}

static void
insert_text     (GtkEditable *editable,
		 const gchar *new_text,
		 gint         new_text_length,
		 gint        *position,
		 gpointer data)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "insert_text");
  if(new_text[0] != ' '){
    GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ENTRY))->insert_text(editable,
								     new_text,
								     new_text_length, 
								     position);


  }

}

static gboolean 
select_icon(GtkIconList *iconlist, 
	    GtkIconListItem *icon,
	    GdkEvent *event, gpointer data)
{
  GtkCustomIconFileSel *filesel;
  GdkModifierType mods;
  gchar *path = NULL;
  gchar *real_path = NULL;
  gchar *full_path = NULL;
  gchar *file = NULL;
  GtkFileListItem *item;
  gboolean return_val = FALSE;

  item = (GtkFileListItem *)icon->link;

  filesel = GTK_CUSTOM_ICON_FILESEL(data);

  if(item->type != GTK_FILE_LIST_FOLDER){
    gtk_entry_set_text(GTK_ENTRY(filesel->file_entry), icon->label);
    return TRUE;
  }else{
    gtk_entry_set_text(GTK_ENTRY(filesel->file_entry), "");
  }

  if(!event) return FALSE;

  if(event->type == GDK_BUTTON_PRESS || event->type == GDK_2BUTTON_PRESS)
    gdk_window_get_pointer(event->button.window, NULL, NULL, &mods);
  else
    return FALSE; 

  if((mods & GDK_BUTTON1_MASK) && event->type == GDK_2BUTTON_PRESS){
    path = gtk_file_list_get_path(GTK_FILE_LIST(filesel->file_list));
    file = gtk_file_list_get_filename(GTK_FILE_LIST(filesel->file_list));
    file = icon->label;

    full_path = (gchar *)g_malloc(strlen(path)+strlen(file)+3);
    g_snprintf(full_path,strlen(path)+strlen(file)+2,"%s%s%s",path,file,G_DIR_SEPARATOR_S);
    real_path = get_real_path((const gchar *)full_path);
#if 0	/* 2001/07/03 */
    gtk_label_set_text(GTK_LABEL(filesel->path_label), "Scanning...");
#endif
    if(filesel->show_tree)
      return_val = gtk_dir_tree_open_dir(GTK_DIR_TREE(filesel->dir_tree), real_path);
    else
      return_val = gtk_file_list_open_dir(GTK_FILE_LIST(filesel->file_list), real_path);
#if 0	/* 2001/07/03 */
    gtk_label_set_text(GTK_LABEL(filesel->path_label), real_path);
#endif
    g_free(full_path);
    g_free(real_path);
    return (!return_val);
  }

  return TRUE;
}

static void
entry_set_file(GtkWidget *widget, GdkEventKey *key, gpointer data)
{
  GtkCustomIconFileSel *filesel = GTK_CUSTOM_ICON_FILESEL(data);

  if(key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  /*  real_set_file(widget, data);
   */
  gtk_signal_emit_by_name(GTK_OBJECT(filesel->ok_button), "clicked", filesel);
}

static void
real_set_file(GtkWidget *widget, gpointer data)
{
  GtkCustomIconFileSel *filesel;
  GtkIconListItem *item;
  GList *list;
  gchar *c, *last, *text;
  gchar *folder;
  gchar *file;
  gint nlen, file_len;

  filesel = (GtkCustomIconFileSel *)data;

  c = gtk_entry_get_text(GTK_ENTRY(filesel->file_entry));
  folder = NULL;
  file = NULL;
  last = NULL;
  file_len = nlen = 0;

  while(*c != '\0' && *c != '\n' && c != NULL){
    nlen++;
    file_len++;
    folder = (char *)g_realloc(folder, (nlen+1)*sizeof(char));
    folder[nlen-1] = *c;
    folder[nlen]='\0';
    file = (char *)g_realloc(file, (file_len+1)*sizeof(char));
    file[file_len-1] = *c;
    file[file_len]='\0';
    if(*c == G_DIR_SEPARATOR){
      g_free(file);
      g_free(last);
      last = g_strdup(folder);
      file_len = 0;
      file = NULL;
    }
    c++;
  }

  if(last) gtk_custom_icon_file_selection_open_dir(filesel, last); 

  if(file){
    list = GTK_ICON_LIST(filesel->file_list)->icons;
    while(list){
      item = (GtkIconListItem *)list->data;
      text = ((GtkFileListItem *)item->link)->file_name;
      if(strcmp(text, file) == 0){
	gtk_icon_list_select_icon(GTK_ICON_LIST(filesel->file_list), item);
	break;
      }
      list = list->next;
    }
  }


  g_free(folder);
  g_free(file);
  g_free(last);
}

static void
set_filter(GtkWidget *widget, GdkEventKey *key, gpointer data)
{
  GtkCustomIconFileSel *filesel;

  if(key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  filesel = (GtkCustomIconFileSel *)data;
  gtk_file_list_set_filter(GTK_FILE_LIST(filesel->file_list), 
			   gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
open_dir(GtkWidget *widget, GtkCTreeNode *node, gint n, gpointer data)
{
  DIR *dir;
  GtkDirTreeNode *dirnode;
  gchar *path, *last_path;
  GtkCustomIconFileSel *filesel;

  filesel = GTK_CUSTOM_ICON_FILESEL(data);


  dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),node);

  path = dirnode->path;

  last_path = gtk_file_list_get_path(GTK_FILE_LIST(filesel->file_list));

  if(strcmp(last_path, G_DIR_SEPARATOR_S) !=0 && strcmp(last_path, path) == 0) return; 

  gtk_widget_unmap(filesel->file_list);

  if((dir = opendir(path)) == NULL){
    return;
  }
  closedir(dir);
#if 0	/* 2001/07/03 */
  gtk_label_set_text(GTK_LABEL(filesel->path_label), "Scanning...");
#endif
  gtk_file_list_open_dir(GTK_FILE_LIST(filesel->file_list), path);

  gtk_widget_map(filesel->file_list);
#if 0	/* 2001/07/03 */
  gtk_label_set_text(GTK_LABEL(filesel->path_label), path);
#else
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry), path);
  gtk_custom_combo_list_add (filesel, path);
#endif
}

gint
gtk_custom_icon_file_selection_open_dir(GtkCustomIconFileSel *filesel, const gchar *path)
{
  gint return_val;
  gchar *real_path = NULL;
 
  if(!path) return FALSE;
#if 0	/* 2001/07/03 */
  gtk_label_set_text(GTK_LABEL(filesel->path_label), "Scanning...");
#endif
  real_path = get_real_path(path);

  if(filesel->show_tree)
    return_val = gtk_dir_tree_open_dir(GTK_DIR_TREE(filesel->dir_tree), real_path);
  else
    return_val = gtk_file_list_open_dir(GTK_FILE_LIST(filesel->file_list), real_path);
#if 0	/* 2001/07/03 */
  gtk_label_set_text(GTK_LABEL(filesel->path_label), real_path);
#endif
  g_free(real_path);

  return return_val;
}

void
gtk_custom_icon_file_selection_show_hidden(GtkCustomIconFileSel *filesel, gboolean visible)
{
  GTK_DIR_TREE(filesel->dir_tree)->show_hidden = visible;
  GTK_FILE_LIST(filesel->file_list)->show_hidden = visible;
}

void
gtk_custom_icon_file_selection_set_filter(GtkCustomIconFileSel *filesel, const gchar *filter)
{
#if 0	/* 2001/07/03 sugaya */
  GTK_FILE_LIST(filesel->file_list)->filter = g_strdup(filter);
#else
  gtk_file_list_set_filter(GTK_FILE_LIST(filesel->file_list), filter);
#endif
  gtk_file_list_open_dir(GTK_FILE_LIST(filesel->file_list), GTK_FILE_LIST(filesel->file_list)->path);
  if(filter != NULL)
    gtk_entry_set_text(GTK_ENTRY(filesel->filter_entry),filter);
}

static gchar *
get_real_path(const gchar *full_path)
{
  gchar root[5], root1[5], root2[5], root3[5], root4[5];
  gchar *aux_path;
  gint length;

  /* GET ABSOLUTE PATH */

  sprintf(root,"%s",G_DIR_SEPARATOR_S);
  sprintf(root1,"%s.",G_DIR_SEPARATOR_S);
  sprintf(root2,"%s..",G_DIR_SEPARATOR_S);
  sprintf(root3,"%s..%s",G_DIR_SEPARATOR_S,G_DIR_SEPARATOR_S);
  sprintf(root4,"%s.%s",G_DIR_SEPARATOR_S,G_DIR_SEPARATOR_S);


  aux_path = g_strdup(full_path);
  length = strlen(aux_path);

  if(strcmp(aux_path + length - 2, root1) == 0){
    if(length == 2) {
      g_free(aux_path);
      aux_path = g_strdup(root);
    } else {
      aux_path[length - 1] = '\0';
    }
  } else if(strcmp(aux_path + length - 3, root2) == 0){
    if(length == 3) {
      g_free(aux_path);
      aux_path = g_strdup(root);
    } else {
      gint i = length - 4;
      while(i >= 0){
	if(aux_path[i] == root[0]){
	  aux_path[i+1] = '\0';
	  break;
	}
	i--;
      }
    }
  } else if(strcmp(aux_path + length - 4, root3) == 0){
    if(length == 4) {
      g_free(aux_path);
      aux_path = g_strdup(root);
    } else {
      gint i = length - 5;
      while(i >= 0){
	if(aux_path[i] == root[0]){
	  aux_path[i+1] = '\0';
	  break;
	}
	i--;
      }
    }
  } else if(strcmp(aux_path + length - 3, root4) == 0){
    if(length == 3) {
      g_free(aux_path);
      aux_path = g_strdup(root);
    } else {
      aux_path[length - 2] = '\0';
    }
  }
  else
    aux_path = g_strdup(full_path);

  return(aux_path);
}

/* ************************************************************************* */
static void
set_dir	(GtkWidget	*widget, 
	 GdkEventKey	*key, 
	 gpointer	data) {
  gchar		*folder;
  struct stat	st;
  
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;
  folder = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));

  if ((!folder) || (!*folder)) return;
  if (stat (folder, &st) < 0) {
    free (folder);
    return;
  }
  if (!S_ISDIR (st.st_mode)) {
    free (folder);
    return;
  }

  if (folder[strlen (folder)-1] != '/') {
    folder = (gchar *)
      g_realloc (folder, sizeof (gchar) * (strlen (folder) + 2));
    sprintf (folder, "%s/", folder);
  }

  gtk_custom_combo_list_add (GTK_CUSTOM_ICON_FILESEL (data), folder);
  
  gtk_custom_icon_file_selection_open_dir (GTK_CUSTOM_ICON_FILESEL (data),
					   folder);
}

/* ************************************************************************* */
static void
combo_changed (GtkWidget	*widget,
	       GtkWidget	*child,
	       gpointer		data) {
  GtkCombo		*combo;
  GtkEntry		*entry;
  GtkCustomIconFileSel 	*filesel;
  gchar			*folder;
  
  filesel = GTK_CUSTOM_ICON_FILESEL (data);
  combo = GTK_COMBO (filesel->dir_combo);
  entry = GTK_ENTRY (combo->entry);

  folder = gtk_entry_get_text (entry);
  if (folder) {
    gtk_signal_handler_block (GTK_OBJECT (combo->list), combo->list_change_id);
    gtk_custom_icon_file_selection_open_dir (filesel, folder);
    gtk_signal_handler_unblock(GTK_OBJECT (combo->list),combo->list_change_id);
  }
}

/* ************************************************************************* */
static void
event_folder_up (GtkWidget	*widget,
		 gpointer	data) {
  GtkDirTree	*dir_tree;	
  gchar		*folder;
  gchar		*ptr;
  int		n;
  
  dir_tree = GTK_DIR_TREE ((GTK_CUSTOM_ICON_FILESEL (data))->dir_tree);

  
  folder = (gchar *) g_strdup (gtk_dir_tree_get_dir (dir_tree));

  if (strcmp (folder, "/") == 0) {
    g_free (folder);
    return;
  }
  
  for (n = 0; n < 2; n++) {
    ptr = (gchar *) strrchr (folder, '/');
    if (n == 0) {
      *ptr     = '\0';
    } else {
      *(ptr+1) = '\0';
    }
  }

  gtk_dir_tree_open_dir (dir_tree, folder);

  g_free (folder);
}

/* ************************************************************************* */
static void
event_folder_home (GtkWidget	*widget,
		   gpointer	data) {
  GtkDirTree	*dir_tree;
  gchar		home[1024];

  dir_tree = GTK_DIR_TREE ((GTK_CUSTOM_ICON_FILESEL (data))->dir_tree);
  sprintf (home, "%s/", getenv ("HOME"));
  gtk_dir_tree_open_dir (dir_tree, home);
}

/* ************************************************************************* */
static void
event_folder_new (GtkWidget	*widget,
		  gpointer	data) {
  GtkWidget	*window;
  
  window = create_dir_new (GTK_CUSTOM_ICON_FILESEL (data));
  gtk_widget_show (window);
  gtk_window_set_modal (GTK_WINDOW (window), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (window), GTK_WINDOW (data));  
}

/* ************************************************************************* */
static void
event_button_ok (GtkWidget	*widget,
		 gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkWidget		*window;
  GtkWidget		*entry;
  gchar			*path;
  gchar			*text;
  gchar			folder[1024];

  filesel = GTK_CUSTOM_ICON_FILESEL (data);

  window = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (data), "window");
  
  entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (data), "entry"));
  text  = gtk_entry_get_text (GTK_ENTRY (entry));
  path  =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry));
  
  if (*text != ' ' && strcmp (text, "") != 0) {
    if (*path != ' ' && strcmp (path, "") != 0) {
      sprintf (folder, "%s%s", path, text);
      if (!y_file_exist_file (folder)) y_dir_make_dir (folder);
    } else {
      if (!y_file_exist_file (folder)) y_dir_make_dir (text);
    }
  }

  gtk_widget_hide    (window);
  gtk_widget_destroy (window);

  gtk_widget_destroy (filesel->dir_tree);
  filesel->dir_tree = gtk_dir_tree_new();
#if 0
  gtk_container_add (GTK_CONTAINER (filesel->scrolled_window),
		     filesel->dir_tree);
#endif
  gtk_widget_show(filesel->dir_tree);
  gtk_custom_icon_file_selection_open_dir (GTK_CUSTOM_ICON_FILESEL (filesel),
					   path);    
}

/* ************************************************************************* */
static void
event_button_cancel (GtkWidget	*widget,
		     gpointer	data) {
  gtk_widget_hide    (GTK_WIDGET (data));
  gtk_widget_destroy (GTK_WIDGET (data));
}

/* ************************************************************************* */
static void
set_new_dirname	(GtkWidget	*widget, 
		 GdkEventKey	*key, 
		 gpointer	data) {
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;
  event_button_ok (NULL, data);
}

/* ************************************************************************* */
static GtkWidget*
create_dir_new (GtkCustomIconFileSel	*parent) {
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *hseparator;
  GtkWidget *button;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, TRUE);
  gtk_window_set_title  (GTK_WINDOW (window), _("Create New Directory"));
  gtk_window_position   (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_object_set_data   (GTK_OBJECT (parent), "window", (gpointer) window);  
  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref  (vbox);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    {
      hbox = gtk_hbox_new (FALSE, 5);
      gtk_widget_ref  (hbox);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 3);
      {
	label = gtk_label_new (_("New Directory:"));
	gtk_widget_ref  (label);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	entry = gtk_entry_new ();
	gtk_object_set_data (GTK_OBJECT (window), "entry", (gpointer) entry);
	gtk_object_set_data (GTK_OBJECT (parent), "entry", (gpointer) entry);
	gtk_widget_ref  (entry);
	gtk_widget_show (entry);
	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (entry), "key_press_event",
			    GTK_SIGNAL_FUNC (set_new_dirname), parent);
      }

      hseparator = gtk_hseparator_new ();
      gtk_widget_ref  (hseparator);
      gtk_widget_show (hseparator);
      gtk_box_pack_start (GTK_BOX (vbox), hseparator, FALSE, TRUE, 3);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_widget_ref  (hbox);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      {
	button = gtk_icon_button_new_with_label (_("Cancel"),
						 stock_button_cancel,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_widget_set_usize (button, 80, -1);
	gtk_widget_ref  (button);
	gtk_widget_show (button);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (event_button_cancel), window);
			     
	button = gtk_icon_button_new_with_label (_("OK"),
						 stock_button_ok,
						 GTK_ICON_BUTTON_TEXT_RIGHT,5);
	gtk_widget_set_usize (button, 80, -1);	
	gtk_widget_ref  (button);
	gtk_widget_show (button);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (event_button_ok), parent);
      }
    }
  }
  return window;
}

/* ************************************************************************* */
gchar*
gtk_custom_icon_file_selection_get_filename (GtkCustomIconFileSel *filesel) {
  gchar	*file;
  
  file = (gchar *)
    malloc (sizeof (gchar)
	    * (strlen
	       (gtk_entry_get_text (GTK_ENTRY
				    (GTK_COMBO (filesel->dir_combo)->entry))) +
	       strlen (gtk_entry_get_text (GTK_ENTRY (filesel->file_entry)))
	       + 1));
	       
  sprintf (file, "%s%s",
	   gtk_entry_get_text (GTK_ENTRY
			       (GTK_COMBO (filesel->dir_combo)->entry)),
	   gtk_entry_get_text (GTK_ENTRY (filesel->file_entry)));
  
  return file;
}

/* Ϥ줿ƥȤ򥳥ܥܥåΥƥɲ **************** */
static void
gtk_custom_combo_list_add (GtkCustomIconFileSel	*parent,
			   gchar		*folder) {
  GList	*list;
  int	flg = 1;
  
  list = g_list_first (parent->dir_combo_list);

  while (list) {
    if (strcmp (folder, (char *) list->data) == 0) {
      flg = 0;
      break;
    }
    list = g_list_next (list);
  }

  if (flg) {
    parent->dir_combo_list = g_list_prepend (parent->dir_combo_list, folder);
    
    if (g_list_length (g_list_first (parent->dir_combo_list))
	> COMBO_LIST_LIMIT) {
      parent->dir_combo_list =
	g_list_remove (parent->dir_combo_list,
		       g_list_last (parent->dir_combo_list)->data);
    }
    gtk_custom_combo_set_popdown_strings (GTK_COMBO (parent->dir_combo),
					  parent->dir_combo_list,
					  (GtkWidget *) parent);
  }
}

/* ܥܥåΥƥब򤵤줿ν **************************** */
static void
gtk_custom_combo_select_item (GtkWidget	*widget,
			      GdkEvent	*ev,
			      gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkWidget		*label;
  DIR 			*dir;
  
  label = GTK_BIN (widget)->child;
  if((dir = opendir(GTK_LABEL (label)->label)) == NULL){
    return;
  }
  filesel = (GtkCustomIconFileSel *) data;
  gtk_custom_icon_file_selection_open_dir (filesel, GTK_LABEL (label)->label);
}

/* ܥܥå˥ƥ򥻥åȤ ************************************ */
static void
gtk_custom_combo_set_popdown_strings (GtkCombo	*combo,
				      GList	*strings,
				      GtkWidget	*filesel) {
  GList 	*list;
  GtkWidget	*li;

  g_return_if_fail (combo != NULL);
  g_return_if_fail (GTK_IS_COMBO (combo));
  g_return_if_fail (strings != NULL);

  gtk_list_clear_items (GTK_LIST (combo->list), 0, -1);
  list = strings;
  while (list) {
    li = gtk_list_item_new_with_label ((gchar *) list->data);
#if 1
    gtk_signal_connect (GTK_OBJECT (li), "focus_in_event",
			GTK_SIGNAL_FUNC (gtk_custom_combo_select_item),
			filesel);
#else
    gtk_signal_connect (GTK_OBJECT (li), "changed",
			GTK_SIGNAL_FUNC (gtk_custom_combo_select_item),
			filesel);
#endif
    gtk_widget_show (li);
    gtk_container_add (GTK_CONTAINER (combo->list), li);
    list = list->next;
  }
}

/* *************************************** End of gtkcustomiconfilesel.c *** */
