/* ***************************************************** gtkiconbutton.c *** *
 * ĥGtkWidget (ܥ)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-09 10:02:37 sugaya>
 * ************************************************************************* */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#if 0
#include <gdk_imlib.h>
#include <gdk_imlib_private.h>
#endif
#include "gtkiconbutton.h"

#define CHILD_SPACING     1
#define DEFAULT_LEFT_POS  4
#define DEFAULT_TOP_POS   4
#define DEFAULT_SPACING   7

enum {
  PRESSED,
  RELEASED,
  CLICKED,
  ENTER,
  LEAVE,
  LAST_SIGNAL
};

enum {
  ARG_0,
  ARG_LABEL,
  ARG_RELIEF
};

static void 	gtk_icon_button_class_init (GtkIconButtonClass	*klass);
static void	gtk_icon_button_init	   (GtkIconButton	*button);

static GtkBinClass	*parent_class = NULL;
static guint		button_signals[LAST_SIGNAL] = { 0 };

/* ************************************************************************* */
GtkType
gtk_icon_button_get_type (void) {
  static GtkType icon_button_type = 0;

  if (!icon_button_type) {
    static const GtkTypeInfo icon_button_info =
    {
      "GtkIconButton",
      sizeof (GtkIconButton),
      sizeof (GtkIconButtonClass),
      (GtkClassInitFunc)  gtk_icon_button_class_init,
      (GtkObjectInitFunc) gtk_icon_button_init,
      /* reserved_1 */	  NULL,
      /* reserved_2 */	  NULL,
      (GtkClassInitFunc)  NULL,
    };
    icon_button_type 
      = gtk_type_unique (gtk_button_get_type (), &icon_button_info);
    gtk_type_set_chunk_alloc (icon_button_type, 16);
  }
  return icon_button_type;
}

/* ************************************************************************* */
static void
gtk_icon_button_class_init (GtkIconButtonClass	*klass) {
}

/* ************************************************************************* */
static void
gtk_icon_button_init (GtkIconButton	*button) {
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_FOCUS | GTK_RECEIVES_DEFAULT);
  GTK_WIDGET_UNSET_FLAGS (button, GTK_NO_WINDOW);
  
  GTK_BUTTON (button)->child		= NULL;
  GTK_BUTTON (button)->in_button	= FALSE;
  GTK_BUTTON (button)->button_down 	= FALSE;
  GTK_BUTTON (button)->relief 		= GTK_RELIEF_NORMAL;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new (gchar	**pix_data) {
  GtkWidget	*button;
  GtkWidget	*box;
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  /* ܥ */
  button = GTK_WIDGET (gtk_type_new (gtk_icon_button_get_type ()));
  gtk_widget_show (button);
  {
    /* ܥå */
    box = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (button), box);
    gtk_widget_show (box);
    {
      /*  */
      pix = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
					  &msk, NULL, pix_data);
      GTK_ICON_BUTTON (button)->icon = gtk_pixmap_new (pix, msk);
      gtk_object_set_data (GTK_OBJECT (button),
			   "icon", GTK_ICON_BUTTON (button)->icon);
      gtk_box_pack_start (GTK_BOX (box),
			  GTK_ICON_BUTTON (button)->icon, FALSE, FALSE, 5);
      gtk_widget_show (GTK_ICON_BUTTON (button)->icon);
    }
  }
  return button;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new_with_label (const gchar	*label,
				gchar		**pix_data,
				gint		text_position,
				gint		border) {
  GtkWidget	*button;
  GtkWidget	*box;
  GtkWidget	*label_widget;
  GdkPixmap	*pix;
  GdkBitmap	*msk;

  /* ܥ */
  button = GTK_WIDGET (gtk_type_new (gtk_icon_button_get_type ()));
  gtk_widget_show (button);
  {
    /* ܥå */
    if (text_position == GTK_ICON_BUTTON_TEXT_TOP ||
	text_position == GTK_ICON_BUTTON_TEXT_BOTTOM) {
      box = gtk_vbox_new (FALSE, 0);
    } else {
      box = gtk_hbox_new (FALSE, 0);      
    }
    gtk_container_add (GTK_CONTAINER (button), box);
    gtk_widget_show (box);

    /*  */
    pix = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT (),
					&msk, NULL, pix_data);
    GTK_ICON_BUTTON (button)->icon = gtk_pixmap_new (pix, msk);
    gtk_object_set_data (GTK_OBJECT (button),
			 "icon", (gpointer) GTK_ICON_BUTTON (button)->icon);

    /* ٥ */
    label_widget = gtk_label_new (label);
    gtk_object_set_data (GTK_OBJECT (button), 
			 "label", (gpointer) label_widget);
    gtk_widget_show (label_widget);

    if (text_position == GTK_ICON_BUTTON_TEXT_TOP ||
	text_position == GTK_ICON_BUTTON_TEXT_LEFT) {

      /* ٥Υѥå */
      gtk_box_pack_start (GTK_BOX (box), label_widget, FALSE, FALSE, border);
      gtk_widget_show (label_widget);

      /* Υѥå */    
      gtk_box_pack_start (GTK_BOX (box),
			  GTK_ICON_BUTTON (button)->icon,
			  FALSE, FALSE, border);
      gtk_widget_show (GTK_ICON_BUTTON (button)->icon);

    } else {

      /* Υѥå */    
      gtk_box_pack_start (GTK_BOX (box),
			  GTK_ICON_BUTTON (button)->icon, FALSE, FALSE,
			  border);
      gtk_widget_show (GTK_ICON_BUTTON (button)->icon);

      /* ٥Υѥå */
      gtk_box_pack_start (GTK_BOX (box), label_widget, FALSE, FALSE, border);
      gtk_widget_show (label_widget);

    }
  }      
  return button;
}

/* ********************************************** End of gtkiconbutton.c *** */
