/* ************************************************ gtkiconitemfactory.h *** *
 * ĥGtkWidget (itemfactory with icon)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-07 22:46:55 sugaya>
 * ************************************************************************* */

/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * GtkItemFactory: Flexible item factory with automatic rc handling
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GTK_ICON_ITEM_FACTORY_H__
#define	__GTK_ICON_ITEM_FACTORY_H__

#include <gtk/gtkwidget.h>
#include <gtk/gtkmenufactory.h>	/* for GtkMenuEntry */
#include <gtk/gtkbindings.h>	/* for GtkPatternSpec */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef void	(*GtkIconPrintFunc)		(gpointer	func_data,
						 gchar		*str);
typedef gchar * (*GtkIconTranslateFunc)		(const gchar	*path,
						 gpointer	func_data);
typedef	void	(*GtkIconItemFactoryCallback)	();
typedef	void	(*GtkIconItemFactoryCallback1)	(gpointer	callback_data,
						 guint	callback_action,
						 GtkWidget	*widget);

#define	GTK_TYPE_ICON_ITEM_FACTORY (gtk_icon_item_factory_get_type ())
#define	GTK_ICON_ITEM_FACTORY(object) (GTK_CHECK_CAST (object, GTK_TYPE_ICON_ITEM_FACTORY, GtkIconItemFactory))
#define	GTK_ICON_ITEM_FACTORY_CLASS(klass) (GTK_CHECK_CLASS_CAST (klass, GTK_TYPE_ICON_ITEM_FACTORY, GtkIconItemFactoryClass))
#define	GTK_IS_ICON_ITEM_FACTORY(object) (GTK_CHECK_TYPE (object, GTK_TYPE_ICON_ITEM_FACTORY))
#define	GTK_IS_ICON_ITEM_FACTORY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_ITEM_FACTORY))

typedef	struct	_GtkIconItemFactory		GtkIconItemFactory;
typedef	struct	_GtkIconItemFactoryClass	GtkIconItemFactoryClass;
typedef	struct	_GtkIconItemFactoryEntry	GtkIconItemFactoryEntry;
typedef	struct	_GtkIconItemFactoryItem		GtkIconItemFactoryItem;

struct _GtkIconItemFactory {
  GtkObject		 object;

  gchar			*path;
  GtkAccelGroup		*accel_group;
  GtkWidget		*widget;
  GSList		*items;

  GtkIconTranslateFunc	translate_func;
  gpointer              translate_data;
  GtkDestroyNotify      translate_notify;   
};

struct _GtkIconItemFactoryClass {
  GtkObjectClass	object_class;
  gchar			*cpair_comment_single;
  GHashTable		*item_ht;
  gpointer		dummy;
};

struct _GtkIconItemFactoryEntry {
  gchar				*path;
  gchar				**pixmap;
  gchar				*accelerator;
  GtkIconItemFactoryCallback	callback;
  guint				callback_action;

  /* possible values:
   * NULL		-> "<Item>"
   * ""			-> "<Item>"
   * "<Title>"		-> create a title item
   * "<Item>"		-> create a simple item
   * "<CheckItem>"	-> create a check item
   * "<ToggleItem>"	-> create a toggle item
   * "<RadioItem>"	-> create a radio item
   * <path>		-> path of a radio item to link against
   * "<Separator>"	-> create a separator
   * "<Branch>"		-> create an item to hold sub items
   * "<LastBranch>"	-> create a right justified item to hold sub items
   */
  gchar			 *item_type;
};

struct _GtkIconItemFactoryItem {
  gchar		*path;
  guint		accelerator_key;
  guint		accelerator_mods;
  guint		modified : 1;
  guint		in_propagation : 1;
  gchar		*dummy;
  GSList	*widgets;
};

GtkType		gtk_icon_item_factory_get_type	(void);

  /*
   * `container_type' must be of GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
   * or GTK_TYPE_OPTION_MENU.
   */
GtkIconItemFactory*
gtk_icon_item_factory_new		(GtkType		container_type,
					 const gchar		*path,
					 GtkAccelGroup  	*accel_group);
void
gtk_icon_item_factory_construct		(GtkIconItemFactory	*ifactory,
					 GtkType		container_type,
					 const gchar		*path,
					 GtkAccelGroup		*accel_group);
     
/* These functions operate on GtkItemFactoryClass basis. */
void
gtk_icon_item_factory_parse_rc		(const gchar		*file_name);
void	
gtk_icon_item_factory_parse_rc_string	(const gchar		*rc_string);
void	
gtk_icon_item_factory_parse_rc_scanner	(GScanner		*scanner);
void		
gtk_icon_item_factory_add_foreign	(GtkWidget		*accel_widget,
					 const gchar		*full_path,
					 GtkAccelGroup		*accel_group,
					 guint			keyval,
					 GdkModifierType	modifiers);
     
GtkIconItemFactory*
gtk_icon_item_factory_from_widget	(GtkWidget		*widget);
gchar*
gtk_icon_item_factory_path_from_widget	(GtkWidget		*widget);
GtkWidget*
gtk_icon_item_factory_get_item		(GtkIconItemFactory	*ifactory,
					 const gchar		*path);
GtkWidget*
gtk_icon_item_factory_get_widget	(GtkIconItemFactory	*ifactory,
					 const gchar   		*path);
GtkWidget*	
gtk_icon_item_factory_get_widget_by_action (GtkIconItemFactory	*ifactory,
					    guint	      	action);
GtkWidget*
gtk_icon_item_factory_get_item_by_action   (GtkIconItemFactory	*ifactory,
					    guint	       	action);

/*
 * If `path_pspec' is passed as `NULL', this function will iterate over
 * all hash entries. otherwise only those entries will be dumped for which
 * the pattern matches, e.g. "<Image>*...".
 */
void
gtk_icon_item_factory_dump_items	(GtkPatternSpec		*path_pspec,
					 gboolean		modified_only,
					 GtkIconPrintFunc	print_func,
					 gpointer		func_data);
void
gtk_icon_item_factory_dump_rc		(const gchar		*file_name,
					 GtkPatternSpec		*path_pspec,
					 gboolean		modified_only);
void
gtk_icon_item_factory_print_func	(gpointer		FILE_pointer,
					 gchar			*string);
void
gtk_icon_item_factory_create_item	(GtkIconItemFactory	*ifactory,
					 GtkIconItemFactoryEntry *entry,
					 gpointer		callback_data,
					 guint			callback_type);
void
gtk_icon_item_factory_create_items	(GtkIconItemFactory	*ifactory,
					 guint			n_entries,
					 GtkIconItemFactoryEntry *entries,
					 gpointer		callback_data);
void
gtk_icon_item_factory_delete_item	(GtkIconItemFactory	*ifactory,
					 const gchar		*path);
void
gtk_icon_item_factory_delete_entry	(GtkIconItemFactory	*ifactory,
					 GtkIconItemFactoryEntry *entry);
void
gtk_icon_item_factory_delete_entries	(GtkIconItemFactory	*ifactory,
					 guint			n_entries,
					 GtkIconItemFactoryEntry *entries);
void
gtk_icon_item_factory_popup		(GtkIconItemFactory	*ifactory,
					 guint			x,
					 guint			y,
					 guint			mouse_button,
					 guint32		time);
void
gtk_icon_item_factory_popup_with_data	(GtkIconItemFactory	*ifactory,
					 gpointer		popup_data,
					 GtkDestroyNotify	destroy,
					 guint			x,
					 guint			y,
					 guint			mouse_button,
					 guint32		time);
gpointer
gtk_icon_item_factory_popup_data	(GtkIconItemFactory	*ifactory);

gpointer
gtk_icon_item_factory_popup_data_from_widget 	(GtkWidget	*widget);

void
gtk_icon_item_factory_set_translate_func (GtkIconItemFactory	*ifactory,
					  GtkIconTranslateFunc	func,
					  gpointer		data,
					  GtkDestroyNotify     notify);

/* Compatibility functions for deprecated GtkMenuFactory code */
GtkIconItemFactory*
gtk_icon_item_factory_from_path		(const gchar		*path);

void
gtk_icon_item_factory_create_menu_entries (guint		n_entries,
					   GtkMenuEntry		*entries);
void
gtk_icon_item_factories_path_delete	(const gchar		*ifactory_path,
					 const gchar		*path);

typedef	void (*GtkIconItemFactoryCallback2) (GtkWidget	*widget,
					     gpointer	 callback_data,
					     guint	 callback_action);
void
gtk_icon_item_factory_create_items_ac	(GtkIconItemFactory	*ifactory,
					 guint			n_entries,
					 GtkIconItemFactoryEntry *entries,
					 gpointer		callback_data,
					 guint			callback_type);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __GTK_ICON_ITEM_FACTORY_H__ */

/* ***************************************** End of gtkiconitemfactory.h *** */
