/* *********************************************************************** *
 *   etc.c
 *	$B0z?t$NFI$_9~$_(B $BEy(B
 * *********************************************************************** */
#include <stdio.h>

/* *********************************************************************** *
 * 	USAGE
 * *********************************************************************** */
void exit_with_usage (char *comname)
{
  fprintf (stderr, "Usage: %s in.teo #frame #plane [out.eps]\n", comname);
  fprintf (stderr, "   -c : color option\n");
  fprintf (stderr, "   -h#: height\n");
  fprintf (stderr, "   -w#: width\n");
  fprintf (stderr, "   -s#: scale (default 100%%)\n");
  fprintf (stderr, "   -v : show version\n");
  exit (1);
}
   
/* *********************************************************************** *
 * 	VERSION
 * *********************************************************************** */
#define NOW_VERSION "teo2eps ver1.1"

void exit_with_version (void)
{
  fprintf (stderr, "teo2eps ver1.0\n");
  fprintf (stderr, "%s +scaling option\n", NOW_VERSION);
  exit (0);
}

/* *********************************************************************** *
 *      ARGUMENTS
 * *********************************************************************** */
#define DEFAULT_SCALE	1.0

int get_args (int argc, char **argv, char **in_file, char **out_file,
	      int *frame, int *plane, unsigned char *flg,
	      int *width, int *height, float *scale)
{
  unsigned char args;
  int		s;

  *in_file = *out_file = NULL;
  *frame = *plane = -1;
  *flg = 0;
  *width = *height = 0;
  *scale = DEFAULT_SCALE;

  for(args = 1; args < argc; ++args)
    if ((*argv[args] == '-') &&
	*(argv[args]+1) && isalpha(*(argv[args]+1)))
      switch (*++argv[args]) { 
      case ('c'):
	*flg = 1;
	break;
      case ('s'):
        if ((!*++argv[args]) && (++args>=argc)) return (-1);
        s = atoi (argv[args]);
        *scale = (float) s / 100;
        break;
      case ('h'):
        if ((!*++argv[args]) && (++args>=argc)) return (-1);
        *height = atoi (argv[args]);
        break;
      case ('w'):
	if ((!*++argv[args]) && (++args>=argc)) return (-1);
        *width = atoi (argv[args]);
        break;
      case ('v'):
	exit_with_version ();
      default:
	return (-1);
      }
    else
      if (!*in_file)
	*in_file = argv[args];
      else if (*frame == -1)
	*frame = atoi (argv[args]);
      else if (*plane == -1)
	*plane = atoi (argv[args]);
      else if (!*out_file)
	*out_file = argv[args];
      else
	return (-1);

  if (*plane == -1) return (-1);
  return (0);
}
