/**************************/
/* $B?tCM7W;;(B               */
/**************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include <teoutil.h>

double TeoUtilInnerProduct(TEOIMAGE *img1,TEOIMAGE *img2){

  int    x,y,p;
  double val=0;

  if ((TeoWidth( img1)!=TeoWidth( img2))||
      (TeoHeight(img1)!=TeoHeight(img2))||
      (TeoPlane( img1)!=TeoPlane( img2))){
    fprintf(stderr,"EROR in TeoUtil(TeoUtilInnerProduct)\n");
    fprintf(stderr,"Image size is not same.\n");
    exit(-1);
  }

  for (y=0; y<TeoHeight(img1); y++){
    for (x=0; x<TeoWidth(img1); x++){
      for(p=0; p<TeoPlane(img1); p++){
	val+=TeoUtilGetAnyPixel(img1,x+TeoXoffset(img1),y+TeoYoffset(img1),p)
            *TeoUtilGetAnyPixel(img2,x+TeoXoffset(img2),y+TeoYoffset(img2),p);
      }
    }
  }
  return val;
}

double TeoUtilInnerProduct_FLOAT64(TEOIMAGE *img1,TEOIMAGE *img2){

  int l,size;
  double val=0;
  TEO_FLOAT64 *data1,*data2;

  if (!TeoIsFLOAT64(img1) || !TeoIsFLOAT64(img2)){
    fprintf(stderr,"EROR in TeoUtil(TeoUtilInnerProduct_FLOAT64)\n");
    fprintf(stderr,"Image type must be FLOAT64.\n");
    exit(-1);
  }

  if ((TeoWidth( img1)!=TeoWidth( img2))||
      (TeoHeight(img1)!=TeoHeight(img2))||
      (TeoPlane( img1)!=TeoPlane( img2))){
    fprintf(stderr,"EROR in TeoUtil(TeoUtilInnerProduct_FLOAT64)\n");
    fprintf(stderr,"Image size is not same.\n");
    exit(-1);
  }

  size=TeoHeight(img1)*TeoWidth(img1)*TeoPlane(img1);
  data1=(TEO_FLOAT64 *)TeoData(img1);
  data2=(TEO_FLOAT64 *)TeoData(img2);
  for (l=0; l<size; l++) val+=(*(data1+l)) * (*(data2+l));
  return val;
}


double TeoUtilCalcSum(TEOIMAGE *img, int plane){
  int          x, y;
  TEO_FLOAT64  add_num=0.0;
  
  for(y=0; y<TeoHeight(img); y++)
    for(x=0; x<TeoWidth(img); x++)
      add_num += TeoUtilGetAnyPixel(img,
		    x+TeoXoffset(img), y+TeoYoffset(img), plane);
  
  return ((double)add_num);
}


double TeoUtilCalcVariance(TEOIMAGE *img, int plane){
  int          x, y;
  int          width, height, pixels;
  TEO_FLOAT64  add_num, myu, sigma=0.0, pix;
  
  width  = TeoWidth(img);
  height = TeoHeight(img);
  pixels = width*height;
  
  add_num = TeoUtilCalcSum(img, plane);
  myu = add_num/pixels;
 
  for(y=0; y<height; y++)
    for(x=0; x<width; x++){
      pix = TeoUtilGetAnyPixel(img,
			       x+TeoXoffset(img), y+TeoYoffset(img), plane);
      sigma += (pix-myu)*(pix-myu);
    }
  sigma /= pixels;

  return ((double)sigma);
}


double TeoUtilCalcL2Norm(TEOIMAGE *img, int plane){
  int          x, y;
  TEO_FLOAT64  l2norm=0.0, pix;
  
  for(y=0; y<TeoHeight(img); y++)
    for(x=0; x<TeoWidth(img); x++){
      pix = TeoUtilGetAnyPixel(img,
			       x+TeoXoffset(img), y+TeoYoffset(img), plane);
      l2norm += pix*pix;
    }

  return(sqrt((double)l2norm));
}


void TeoUtilNormalizeWithoutAlloc(TEOIMAGE *src, TEOIMAGE *dst, int flag){
  int          x, y, p;
  int          width, height, pixels;
  TEO_FLOAT64  pix;
  TEO_FLOAT64  add_num=0.0, l2norm=0.0, myu=0.0, sigma=0.0;
  
  width  = TeoWidth(src);
  height = TeoHeight(src);
  pixels = width*height;
  
  switch(flag){
  case 0: /* $BJ?6Q$r#0$K$7$^$9(B */    
    for(p=0; p<TeoPlane(src); p++){
      add_num = TeoUtilCalcSum(src, p);
      myu = add_num/pixels;
      
      for(y=0; y<height; y++)
	for(x=0; x<width; x++)
	  TeoUtilPutAnyPixel(dst, x+TeoXoffset(dst), y+TeoYoffset(dst), p, 
			     TeoUtilGetAnyPixel(src, x+TeoXoffset(src), 
						y+TeoYoffset(src), p)-myu);
    } break;
    
  case 1: /* $BJ?6Q$r#0$K$7!$D9$5(B(L2$B%N%k%`(B)$B$r#1$K$7$^$9(B */
    for(p=0; p<TeoPlane(src); p++){
      add_num = TeoUtilCalcSum(src, p);
      myu = add_num/pixels;

      for(y=0; y<height; y++)
	for(x=0; x<width; x++){
	  pix = TeoUtilGetAnyPixel(src,x+TeoXoffset(src),y+TeoYoffset(src),p);
	  l2norm += (pix-myu)*(pix-myu);
	}
      l2norm = sqrt(l2norm);
      
      for(y=0; y<height; y++)
	for(x=0; x<width; x++)
	  TeoUtilPutAnyPixel(dst, x+TeoXoffset(dst), y+TeoYoffset(dst), p, 
	     (TeoUtilGetAnyPixel(src, x+TeoXoffset(src), y+TeoYoffset(src),p)
	      - myu ) / l2norm);
    } break;
    
  case 2: /* $BJ?6Q$r#0$K$7!$J,;6$r#1$K$7$^$9(B */
    
    for(p=0; p<TeoPlane(src); p++){
      add_num = TeoUtilCalcSum(src, p);
      myu = add_num/pixels;
      
      for(y=0; y<height; y++)
	for(x=0; x<width; x++){
	  pix = TeoUtilGetAnyPixel(src,x+TeoXoffset(src),y+TeoYoffset(src),p);
	  sigma += (pix-myu)*(pix-myu);
	}
      sigma /= pixels;
      sigma = sqrt(sigma);
      
      for(y=0; y<height; y++)
	for(x=0; x<width; x++)
	  TeoUtilPutAnyPixel(dst, x+TeoXoffset(dst), y+TeoYoffset(dst), p, 
	     (TeoUtilGetAnyPixel(src, x+TeoXoffset(src), y+TeoYoffset(src),p)
	      - myu ) / sigma);
    } break;
  }
}


TEOIMAGE *TeoUtilNormalize(TEOIMAGE *src, int flag){
  TEOIMAGE *dst;
  
  dst = TeoAllocImage(TeoWidth(src),TeoHeight(src),0,0,
		      TEO_FLOAT,64,TeoPlane(src));
  
  TeoUtilNormalizeWithoutAlloc(src, dst, flag);

  return(dst);
}


double TeoUtilCalcMax(TEOIMAGE *img, int plane){
  int          x, y;
  TEO_FLOAT64  max=0.0, pixel;

  for(y=0; y<TeoHeight(img); y++)
    for(x=0; x<TeoWidth(img); x++){
      pixel = TeoUtilGetAnyPixel(img, x+TeoXoffset(img), y+TeoYoffset(img),
				 plane);

      if(y==0&&x==0) max=pixel;
      else if(max<pixel) max=pixel;
    }
  
  return((double)max);
}

double TeoUtilCalcMin(TEOIMAGE *img, int plane){
  int          x, y;
  TEO_FLOAT64  min=0.0, pixel;

  for(y=0; y<TeoHeight(img); y++)
    for(x=0; x<TeoWidth(img); x++){
      pixel = TeoUtilGetAnyPixel(img, x+TeoXoffset(img), y+TeoYoffset(img),
				 plane);

      if(y==0&&x==0) min=pixel;
      else if(min>pixel) min=pixel;
    }
  
  return((double)min);
}
