#include <stdio.h>
#include <stdlib.h>
#include <teopp.h>
#include <teopp/util.h>
void usage(char *pname){
  fprintf(stderr,"usage: %s threshold [teofile]\n",pname);
  exit(-1);
}

int main(int argc,char **argv){
  if(argc<2) usage(argv[0]);
  float th = atof(argv[1]);

  TeoFile file;

  if(argc<3) file = TeoFile("-");
  else file = TeoFile(argv[2]);

  TeoFile outfile("-",file.Width(),file.Height(),
		  file.Xoffset(),file.Yoffset(),
		  TEO_SIGNED,1,file.Plane(),file.Frame());

  TeoImage<TeoFloat32> inimg;
  for(int f=0;f<file.Frame();f++){
    inimg = file.GetImage();
    outfile.PutImage(Binarize(inimg,th));
  }
  return 0;
}

