// -*- Mode: C++ -*-
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <teopp.h>

void usage(char *pname){
    fprintf(stderr,"usage: %s [-s|-l1|-l2|-c] [-abs] teofile1 teofile2\n",pname);
    exit(-1);
}

typedef enum{SIMPLE,L1,L2,COSIN} METHOD;

int main(int argc,char **argv){
  METHOD mflag = SIMPLE;
  int absflag = 0;
  int i=1;
  while(i<argc&&argv[i][0]=='-')
    switch(argv[i++][1]){
    case 's':
      mflag = SIMPLE;
      break;
    case 'l':
      if(argv[i-1][2] == '1')
	mflag = L1;
      else if(argv[i-1][2] == '2')
	mflag = L2;
      else usage(argv[0]);
      break;
    case 'c':
      mflag = COSIN;
      break;
    case 'a':
      absflag = 1;
      break;
    default:
      usage(argv[0]);
      break;
    }
  if(i+1 >= argc) usage(argv[0]);
  TeoFile file1 = TeoFile(argv[i++]);
  TeoFile file2 = TeoFile(argv[i++]);

  int sx = (file1.Xstart() > file2.Xstart())? file1.Xstart():file2.Xstart();
  int ex = (file1.Xend() < file2.Xend())? file1.Xend():file2.Xend();
  int sy = (file1.Ystart() > file2.Ystart())? file1.Ystart():file2.Ystart();
  int ey = (file1.Yend() < file2.Yend())? file1.Yend():file2.Yend();
  int frame = (file1.Frame() > file2.Frame())? file1.Frame():file2.Frame();
  int plane = (file1.Plane() < file2.Plane())? file1.Plane():file2.Plane();
  int oplane;
  if(mflag == SIMPLE)
    oplane = plane;
  else oplane = 1;

  TeoFile output("-",ex-sx+1,ey-sy+1,sx,sy,TEO_FLOAT,64,oplane,frame,0,NULL);

  TeoImage<TeoFloat64> inimg1,inimg2;
  TeoImage<TeoFloat64> outimg(output.Width(),output.Height(),
			      output.Xoffset(),output.Yoffset(),
			      output.Plane());
  for(int f=0;f<frame;f++){
    inimg1 = file1.GetImage();
    inimg2 = file2.GetImage();

    switch(mflag){
    case SIMPLE:
      TeoFloat64 pixel;
      for(int y=sy;y<=ey;y++)
	for(int x=sx;x<=ex;x++)
	  for(int p=0;p<plane;p++){
	    pixel = inimg1(x,y,p) - inimg2(x,y,p);
	    if(absflag==1 && pixel<0 ) pixel = -pixel;
	    outimg(x,y,p)=pixel;
	  }
      break;
    case L1:
      for(int y=sy;y<=ey;y++)
	for(int x=sx;x<=ex;x++){
	  TeoFloat64 tmp,diff=0.0;
	  for(int p=0;p<plane;p++){
	    tmp = inimg1(x,y,p) - inimg2(x,y,p);
	    tmp = (tmp>0)? tmp:-tmp;
	    diff += tmp;
	  }
	  outimg(x,y,0) = diff;
	}
      break;
    case L2:
      for(int y=sy;y<=ey;y++)
	for(int x=sx;x<=ex;x++){
	  TeoFloat64 tmp,diff=0.0;
	  for(int p=0;p<plane;p++){
	    tmp = inimg1(x,y,p) - inimg2(x,y,p);
	    diff += (tmp*tmp);
	  }
	  outimg(x,y,0) = sqrt(diff);
	}
      break;
    case COSIN:
      for(int y=sy;y<=ey;y++)
	for(int x=sx;x<=ex;x++){
	  TeoFloat64 tmp=0.0,tmp1=0.0,tmp2=0.0,pixel=0.0;
	  for(int p=0;p<plane;p++){
	    tmp += inimg1(x,y,p)*inimg2(x,y,p);
	    tmp1 += inimg1(x,y,p)*inimg1(x,y,p);
	    tmp2 += inimg2(x,y,p)*inimg2(x,y,p);
	  }
	  pixel = tmp/sqrt(tmp1*tmp2);
	  if(absflag == 1 && pixel < 0) pixel = -pixel;
	  outimg(x,y,0) = pixel;
	}
      break;
    default:
      break;
    }
    output.PutImage(outimg);

    if(!file1.CheckFrame()) file1.SetAbsFrame(0);
    if(!file2.CheckFrame()) file2.SetAbsFrame(0);
  }
  return 0;
}
