#include<stdio.h>
#include<stdlib.h>
#include<string.h>
/*
#include<stropts.h>
*/
#include<unistd.h>

char *tmpdir;

#ifndef EXIT_SUCCESS
 #define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
 #define EXIT_FAILURE 1
#endif

void usage(char *com)
{
  fprintf(stderr," Usage: %s  [options] filenames... \n",com);
  fprintf(stderr," -h usage\n");
  fprintf(stderr," -v verbose mode\n");
  fprintf(stderr," -d uncompress\n");
  fprintf(stderr," -t# :# = temporal file directory\n");
#ifdef TMPDIR
  fprintf(stderr,"  default %s\n",TMPDIR);
#endif
  exit(EXIT_SUCCESS);
}

int v_flag=0;
int COMPRESS_flag=1;

extern char  *optarg;
extern int   optind, opterr;

void readopt(int argc,char **argv)
{
  int c;

  while((c = getopt(argc, argv, "ht:dv")) != -1)
    switch(c){
    case 'h':
      usage(argv[0]);
    case 'v':
      fprintf(stderr,"verbose mode\n");
      v_flag=1;
      break;
    case 't':
      tmpdir=optarg;
      break;
    case 'd':
      COMPRESS_flag=0;
      break;
    }
}

#ifndef SEEK_SET
 #define SEEK_SET 0
#endif

int headchecker(FILE *fp, const unsigned char* keyword, int length)
{
  int i=0;

  if(fp==NULL){
    fprintf(stderr,"Error:file pointer is NULL. abort.\n");
    exit(EXIT_FAILURE);
  }
  fseek(fp,0,SEEK_SET);
  while(i<length && !feof(fp) && getc(fp)==keyword[i]) i++;
  fseek(fp,0,SEEK_SET);
  if(i==length)return 1;
  else return 0;
}

int check_gziped(FILE *fp)
{
  const unsigned char keyword[4]={0x1f,0x8b,0x08,0x08};
  return headchecker(fp,keyword,4);
}

int check_TEO(FILE *fp)
{
  const unsigned char keyword[3]={'T','E','O'};
  return headchecker(fp,keyword,3);
}

char tmpfilename[512];
void make_unique_name(void)
{
  char filepath[256];
#ifdef TMPDIR
  if(strlen(tmpdir))
    tmpdir = TMPDIR;
#endif
  filepath[0]='\0';
  if(strlen(tmpdir))
  { strcat(filepath,tmpdir);strcat(filepath,"/"); }
  sprintf(tmpfilename,"%steotmp.%d_%d_%d"
	  ,filepath,getuid(),getpid(),time(NULL)%1000);
}

int main(int argc,char **argv)
{
  char NULLSTR[1]="";
  FILE *fp,*fp0;
  char command[512];
  int comlen;

  tmpdir = NULLSTR;
 
  comlen=strlen(argv[0]);
  if( !strcmp(argv[0]+comlen-strlen("teogunzip"),"teogunzip") )
    COMPRESS_flag=0;
  else if( strcmp(argv[0]+comlen-strlen("teogzip"),"teogzip") )
  {
    fprintf(stderr,"Error:invalid command name %s. nop.\n",argv[0]);
    exit(EXIT_FAILURE);
  }
  readopt(argc,argv);

  make_unique_name();
  sprintf(command,"touch %s",tmpfilename);
  if(system(command)!=EXIT_SUCCESS)
  {
    fprintf(stderr,"Error:can not create temp-file %s. nop.\n",tmpfilename);
    exit(EXIT_FAILURE);
  }
  remove(tmpfilename);

  for(;optind<argc;optind++)
  {
    if(argv[optind][0]=='-')
    {
      fprintf(stderr,"Error:invalid option %s. abort.\n",argv[optind]);
      exit(EXIT_FAILURE);
    }

    if(v_flag)
      fprintf(stderr," %s:\n",argv[optind]);
    
    fp=fopen(argv[optind],"rb");
    if(fp==NULL)
    {
      if(v_flag)
	fprintf(stderr,"  can't open!\n");
      continue;
    }
    
    if(COMPRESS_flag)
/* teogzip */
    {
      if(check_gziped(fp))
      {
	if(v_flag)
	  fprintf(stderr,"  already compressed!\n");
	fclose(fp);
	continue;
      }
      if(check_TEO(fp))
      {
	int BAD=0;

	fclose(fp);
	sprintf(command,"gzip -c %s > %s",argv[optind],tmpfilename);
	if(system(command)==EXIT_SUCCESS)
	{
	  fp0=fopen(tmpfilename,"rb");
	  if(fp0==NULL)
	    BAD=1;
	  else if(!check_gziped(fp0))
	  {
	    BAD=1;
	    fclose(fp0);
	    remove(tmpfilename);
	  }
	}else{
	  BAD=1;
	  remove(tmpfilename);
	}
	if(BAD){
	  fprintf(stderr,"Error:gzip did not work. abort.\n");
	  exit(EXIT_FAILURE);
	}

	fp=fopen(argv[optind],"wb");
	if(fp==NULL)
	{
	  fprintf(stderr," %s: can not overwrite.\n",argv[optind]);
	  fclose(fp0);
	  remove(tmpfilename);
	  continue;
	}else{
/* convert */
	  char buff[4096];
	  size_t count;

	  do{
	    count = fread((void*)buff,1,4096,fp0);
	    fwrite(buff,1,count,fp);
	  }while(!feof(fp0));

	  fclose(fp0);
	  fclose(fp);
	  remove(tmpfilename);
	  if(v_flag)
	    fprintf(stderr,"  is now compressed!\n");
	  continue;
	}
      }else{
	fprintf(stderr," %s: not TEO file.\n",argv[optind]);
        fclose(fp);
	continue;
      }
    }

    else
/* teogunzip */      
    {
      if(check_TEO(fp))
      {
	if(v_flag)
          fprintf(stderr,"  is raw TEO file!\n");
	fclose(fp);
        continue;
      }
      if(check_gziped(fp))
      {
	int BAD=0;

        fclose(fp);
        sprintf(command,"gzip -cd %s > %s",argv[optind],tmpfilename);
        if(system(command)==EXIT_SUCCESS)
        {
	  fp0=fopen(tmpfilename,"rb");
	  if(fp0==NULL)
	    BAD=1;
	  else if(!check_TEO(fp0))
	  {
	    fprintf(stderr," %s: not TEO file.\n",argv[optind]);
	    fclose(fp0);
	    remove(tmpfilename);
	    continue;
	  }
	}else{
	  BAD=1;
	  remove(tmpfilename);
	}
	if(BAD){
	  fprintf(stderr,"Error:gunzip did not work. abort.\n");
	  exit(EXIT_FAILURE);
	}

	fp=fopen(argv[optind],"wb");
	if(fp==NULL)
	{
	  fprintf(stderr," %s: can not overwrite.\n",argv[optind]);
	  fclose(fp0);
	  remove(tmpfilename);
	  continue;
	}else{
/* convert */
	  char buff[4096];
	  size_t count;
	  
	  do{
	    count = fread(buff,1,4096,fp0);
	    fwrite((void*)buff,1,count,fp);
	  }while(!feof(fp0));

	  fclose(fp0);
	  fclose(fp);
	  remove(tmpfilename);
	  if(v_flag)
	    fprintf(stderr,"  is now uncompressed!\n");
	  continue;
	}
      }else{
	fprintf(stderr," %s: not TEO file.\n",argv[optind]);
        fclose(fp);
	continue;
      }

    }

  }
  exit(EXIT_SUCCESS);
}
