/* *********************************************************** io-tiff.c *** *
 * TIFF⥸塼
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/24 22:48:43 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "image_loader.h"
#include "format_tiff.icon"

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"MM \x2a", "  z ", 100},
  {"ll\x2a",  "   z", 100},
  {NULL, NULL, 0}
};
static gchar *mime_types[] = {
  "image/tiff",
  NULL
};
static gchar *extensions[] = {
  "tiff",
  "tif",
  NULL
};

/* ************************************************************************* */
static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  g_free (pixels);
}

/* ץ졼ĥǡǡǡ ********** */
static GdkPixbuf*
gdk_pixbuf_remove_alpha (const GdkPixbuf	*src) {
  GdkPixbuf	*dst;
  unsigned char	*data, *src_ptr, *dst_ptr;
  int		size, n;

  size = gdk_pixbuf_get_width (src) * gdk_pixbuf_get_height(src) * 3;
  src_ptr = gdk_pixbuf_get_pixels (src);
  dst_ptr = data = (unsigned char *)
    malloc (sizeof (unsigned char) * size);
			
  for (n = size/3; n > 0; n--) {
    *dst_ptr++ = *src_ptr++;
    *dst_ptr++ = *src_ptr++;
    *dst_ptr++ = *src_ptr++;
    src_ptr++;
  }
  dst = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, FALSE, 8,
				  gdk_pixbuf_get_width (src),
				  gdk_pixbuf_get_height(src),
				  gdk_pixbuf_get_width (src) * 3,
				  free_buffer, NULL);
  return dst;
}

/* ************************************************************************* */
GdkPixbuf*
load_tiff (const gchar	*filename,
	   gpointer	data) {
  return gdk_pixbuf_new_from_file (filename, NULL);
}

/* ************************************************************************* */
gboolean
save_tiff (const gchar	*filename,
	   gpointer	data) {
#if 0
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*dst = NULL;
  if (gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha (src);
  }
  gdk_pixbuf_save ((dst != NULL) ? dst : src, filename, "jpeg", NULL, NULL);
  if (dst) gdk_pixbuf_unref (dst);
#endif
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "TIFF";
  module->info->description	= "The TIFF image format";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_tiff, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "TIFF",
  NULL,
  NULL,
  load_tiff,
  save_tiff,
  load_info
};

/* **************************************************** End of io-tiff.c *** */
