/* ******************************************************** image_info.c *** *
 * $B2hA|>pJs%@%$%"%m%0(B
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 15:20:55 sugaya>
 * ************************************************************************* */
#include <sys/stat.h>
#include <teo.h>
#include "teoeyes.h"
#include "image_info.h"
#include "image_io.h"

#include "unknown_format.icon"

/* $B2hA|>pJs%@%$%"%m%0$N%/%m!<%:(B ******************************************** */
static void
info_dialog_hide (GtkWidget	*widget,
		  gpointer	*data) {
  gtk_widget_hide (info_dialog);  
}

/* $B2hA|>pJs%@%$%"%m%0$N@8@.(B ************************************************ */
GtkWidget*
info_dialog_new (void) {
  GtkWidget		*window;
  GtkWidget		*vbox1;
  GtkWidget		*vbox2;
  GtkWidget		*hbox;
  GtkWidget		*frame;
  GtkWidget		*label[8];
  GtkWidget		*widget;
  GtkWidget		*icon;
  gint			n = 0;
  
  /* $B%&%#%s%I%&$N@8@.(B */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass  (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_title    (GTK_WINDOW (window), _("Image Info Dialog"));
  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (info_dialog_hide), NULL);
  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (info_dialog_hide), NULL);
  {
    vbox1 = gtk_vbox_new (FALSE, 5);
    G_SET_WIDGET (window, "vbox1", vbox1);
    gtk_container_add (GTK_CONTAINER (window), vbox1);
    gtk_container_border_width (GTK_CONTAINER (vbox1), 5);
    {
      /* $B%U%l!<%`$N@8@.(B */
      frame = gtk_frame_new (NULL);
      G_SET_WIDGET (window, "frame", frame);
      gtk_box_pack_start (GTK_BOX (vbox1), frame, FALSE, FALSE, 0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
      {
	vbox2 = gtk_vbox_new (FALSE, 5);
	G_SET_WIDGET (window, "vbox2", vbox2);
	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
	{
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox1", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%"%$%3%s$N@8@.(B */
	    icon = gtk_image_new_from_pixbuf (te_icon);
	    gtk_box_pack_start (GTK_BOX (hbox), icon, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (icon), 0.0, 0.5);

	    /* $B%i%Y%k(B ($B%U%!%$%kL>(B) */
	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  widget = gtk_hseparator_new ();
	  G_SET_WIDGET (window, "separator1", widget);
	  gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, TRUE, 0);

	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox2", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B%U%!%$%k%5%$%:(B) */
	    widget = gtk_label_new (_("File Size"));
	    G_SET_WIDGET (window, "text1", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox3", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B99?7F|(B) */
	    widget = gtk_label_new (_("Update"));
	    G_SET_WIDGET (window, "text2", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  widget = gtk_hseparator_new ();
	  G_SET_WIDGET (window, "separator2", widget);
	  gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, TRUE, 0);

	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox4", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B%U%)!<%^%C%H(B) */
	    widget = gtk_label_new (_("Format"));
	    G_SET_WIDGET (window, "text3", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox5", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B2hA|$NBg$-$5(B) */
	    widget = gtk_label_new (_("Image Size"));
	    G_SET_WIDGET (window, "text4", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox6", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B2hAGCM$N%l%s%8(B) */
	    widget = gtk_label_new (_("Pixel Range"));
	    G_SET_WIDGET (window, "text5", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox7", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B%U%l!<%`?t(B) */
	    widget = gtk_label_new (_("Frame"));
	    G_SET_WIDGET (window, "text6", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	    n++;
	  }
	  hbox = gtk_hbox_new (TRUE, 0);
	  G_SET_WIDGET (window, "hbox8", hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
	  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
	  {
	    /* $B%i%Y%k(B ($B%W%l!<%s?t(B) */
	    widget = gtk_label_new (_("Channel"));
	    G_SET_WIDGET (window, "text7", widget);
	    gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);

	    label[n] = gtk_label_new ("");
	    gtk_box_pack_start (GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	    gtk_misc_set_alignment (GTK_MISC (label[n]), 0.0, 0.5);
	  }
	}
      }
      gtk_container_add (GTK_CONTAINER (frame), vbox2);

      /* $B%;%Q%l!<%?(B */
      widget = gtk_hseparator_new ();
      G_SET_WIDGET (window, "separator3", widget);
      gtk_box_pack_start (GTK_BOX (vbox1), widget, FALSE, FALSE, 0);

      /* $B!VJD$8$k!W%\%?%s(B */
      hbox = gtk_hbox_new (FALSE, 0);
      G_SET_WIDGET (window, "hbox9", hbox);
      gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
	
      widget = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
      G_SET_WIDGET (window, "button", widget);
      gtk_widget_set_size_request (widget, 100, -1);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (info_dialog_hide), NULL);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (widget);
    }
  }
  gtk_widget_realize (window);
  gtk_window_set_icon (GTK_WINDOW (window), te_icon);
  gdk_window_set_icon_name (window->window, _("TeoEyes Image Information"));
  
  /* $B%&%#%8%'%C%H$N%;%C%H(B */
  G_SET_WIDGET (window, "icon",   icon);
  G_SET_WIDGET (window, "label0", label[0]);
  G_SET_WIDGET (window, "label1", label[1]);
  G_SET_WIDGET (window, "label2", label[2]);
  G_SET_WIDGET (window, "label3", label[3]);
  G_SET_WIDGET (window, "label4", label[4]);
  G_SET_WIDGET (window, "label5", label[5]);
  G_SET_WIDGET (window, "label6", label[6]);
  G_SET_WIDGET (window, "label7", label[7]);

  return window;
}

/* $B2hA|>pJs$N%;%C%H(B ******************************************************** */
void
info_dialog_set_info (GtkWidget	*dialog,
		      GList	*list) {
  TeoeyesImageModule*	module = NULL;
  GdkPixbuf		*pixbuf;
  GtkWidget		*label[10];
  GtkWidget		*icon;
  gint			nchannels;
  gint			channel;
  gint			n = 0;
  gchar			buf[MAX_STRING_MDL_LINE];
  gchar			*utf8_label;
  double		min, max;

  /* $B%m!<%@%b%8%e!<%k$N3MF@(B */
  if (ti_get_external (list)) {
    module = select_module_from_file (ti_get_file_path (list));
  }  
  /* $B%"%$%3%s$N%;%C%H(B */
  icon = G_GET_WIDGET (dialog, "icon");
  if (ti_get_external (list)) {  
    gtk_image_set_from_pixbuf (GTK_IMAGE (icon), module->icon);
  } else {
    pixbuf = gdk_pixbuf_new_from_inline (-1, unknown_format, FALSE, NULL);
    gtk_image_set_from_pixbuf (GTK_IMAGE (icon), pixbuf);
    gdk_pixbuf_unref (pixbuf);
  }
  /* $B%i%Y%k%&%#%8%'%C%H$N3MF@(B */
  label[0] = G_GET_WIDGET (dialog, "label0");
  label[1] = G_GET_WIDGET (dialog, "label1");
  label[2] = G_GET_WIDGET (dialog, "label2");
  label[3] = G_GET_WIDGET (dialog, "label3");
  label[4] = G_GET_WIDGET (dialog, "label4");
  label[5] = G_GET_WIDGET (dialog, "label5");
  label[6] = G_GET_WIDGET (dialog, "label6");
  label[7] = G_GET_WIDGET (dialog, "label7");

  /* $B%U%!%$%kL>$N%;%C%H(B */
  if (ti_get_filename (list)) {
    sprintf (buf, "%s", ti_get_filename (list));
  } else {
    sprintf (buf, "%s", _("No name"));
  }
  utf8_label = g_locale_to_utf8 (buf, -1, NULL, NULL, NULL);
  gtk_label_set (GTK_LABEL (label[n++]), utf8_label);
  g_free (utf8_label);

  /* $B%U%!%$%k%5%$%:$N%;%C%H(B */
  if (ti_get_external (list)) {
    sprintf (buf, "%d %s",
	     g_file_get_size (ti_get_file_path (list)), _("Bytes"));
  } else {
    sprintf (buf, "%s", _("Unknown"));
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* $B%U%!%$%k$N99?7F|$N%;%C%H(B */
  if (ti_get_external (list)) {  
    gtk_label_set (GTK_LABEL (label[n++]),
		   g_file_get_moddate_string (ti_get_file_path (list)));
  } else {
    gtk_label_set (GTK_LABEL (label[n++]), _("Unknown"));
  }
  /* $B%U%!%$%k%U%)!<%^%C%H$N%;%C%H(B */
  if (ti_get_external (list)) {
    if (strcmp (module->info->name, "TEO") != 0) {
      sprintf (buf, "%s", module->info->name);
    } else {
      switch (ti_get_type (list)) {
      case (TI_PIXEL_UNSIGNED):
	sprintf (buf, "%s (%s%d)", module->info->name, "U", ti_get_bit (list));
	break;
      case (TI_PIXEL_SIGNED):
	sprintf (buf, "%s (%s%d)", module->info->name, "S", ti_get_bit (list));
	break;
      case (TI_PIXEL_FLOAT):
	sprintf (buf, "%s (%s%d)", module->info->name, "F", ti_get_bit (list));
	break;
      }
    }
  } else {
    sprintf (buf, "%s", _("Unknown"));    
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* $B2hA|%5%$%:$N%;%C%H(B */
  sprintf (buf, "%dx%d (%d:%d, %d:%d)", 
	   ti_get_width  (list),
	   ti_get_height (list),
	   ti_get_xoffset (list),
	   ti_get_xoffset (list) + ti_get_width (list) - 1,
	   ti_get_yoffset (list),
	   ti_get_yoffset (list) + ti_get_height(list) - 1);
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* $B2hAGCM$N%l%s%8$N%;%C%H(B */
  ti_get_pixel_range (list, &min, &max);
  if (!ti_get_original_data (list) || 
      (ti_get_original_data (list) && ti_get_type (list) != TI_PIXEL_FLOAT)) {
    sprintf (buf, "[%ld: %ld]", (long) min, (long) max);
  } else {
    sprintf (buf, "[%.8e: %.8e]", min, max);
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);
  
  /* $B%U%l!<%`?t$N%;%C%H(B */
  sprintf (buf, "%d / %d",
	   ti_get_frame (list) + 1,
	   (!ti_get_fp (list)) ? 1 : ti_get_nframes (list));
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* $B%W%l!<%s?t$N%;%C%H(B */
  nchannels = ti_get_nchannels (image_list);
  channel   = ti_get_channel (image_list);
  if (channel == -1) {
    sprintf (buf, "%d", nchannels);
  } else {
    sprintf (buf, "%d / %d", channel + 1, nchannels);
  }
  gtk_label_set (GTK_LABEL (label[n++]), buf);
}

/* ************************************************* End of image_info.c *** */
