/* ********************************************************* operation.c *** *
 * ˴ؤؿ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <04/04/26 13:17:53 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "image_io.h"
#include "image_window.h"
#include "operation.h"

/* ǡΥХåå ************************************************ */
void
do_backup (GList	*list) {
  TEImage	*ti;
  
  ti = ti_get_image (list);
  if (!ti->backup) {
    ti->backup = gdk_pixbuf_copy (ti->pixbuf);
  } else {
    gdk_pixbuf_copy2 (ti->pixbuf, ti->backup);
  }
}

/* Хååץǡ򸵤᤹ ******************************************** */
void
restore_backup (GList	*list) {
  TEImage	*ti;
  GdkPixbuf	*work;

  ti = ti_get_image (list);
  if (ti->backup) {
    work = gdk_pixbuf_copy (ti->pixbuf);
    gdk_pixbuf_copy2 (ti->backup, ti->pixbuf);
    gdk_pixbuf_copy2 (work, ti->backup);
    gdk_pixbuf_unref (work);
  }
}

/* ΨꤷƲѹ ************************************ */
void
scaling_by_scale (GList		*list,
		  gdouble	xscale,
		  gdouble	yscale) {
  gint		w, h;

  w = xscale * ti_get_current_width  (list);
  h = xscale * ti_get_current_height (list);
  gtk_object_set_data (GTK_OBJECT (image_window), "forcescroll",
		       (gpointer) TRUE);
  gtk_widget_set_size_request (G_GET_WIDGET (image_window, "canvas"), w, h);
  image_window_set_size (image_window, w, h);
}

/* ΨꤷƲѹ ************************************ */
void
scaling_by_size (GList	*list,
		 gint	width,
		 gint	height) {
  G_SET_PARAMETER (image_window, "forcescroll", TRUE);
  gtk_widget_set_size_request (G_GET_WIDGET (image_window, "canvas"),
			       width, height);
  image_window_set_size (image_window, width, height);
}

/* ꥸʥ᤹ **************************************************** */
void
original_image (GList	*list) {
  TEImage	*ti;

  ti = ti_get_image (list);
  if (ti->pixbuf_list) {
    g_list_foreach (ti->pixbuf_list, (GFunc) gdk_pixbuf_unref, NULL);
    ti->pixbuf_list = NULL;
    ti->pixbuf      = NULL;
  }
  ti->pixbuf = teoeyes_image_open (ti);
}

/* 쥤 ********************************************************** */
void
grayscale_image (GList	*list) {
  guchar	r, g, b, y;
  gint		has_alpha, row, col;
  
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      r = ti_get_pixel (list, col, row, 0);
      g = ti_get_pixel (list, col, row, 1);
      b = ti_get_pixel (list, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      ti_put_pixel (list, col, row, 0, y);
      ti_put_pixel (list, col, row, 1, y);
      ti_put_pixel (list, col, row, 2, y);
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* ͤȿž ************************************************************ */
void
reverse_image (GList	*list) {
  gint		has_alpha, row, col;
  
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      ti_put_pixel (list,  col, row, 0, 
		    255 - ti_get_pixel (list, col, row, 0));
      ti_put_pixel (list,  col, row, 1, 
		    255 - ti_get_pixel (list, col, row, 1));
      ti_put_pixel (list,  col, row, 2, 
		    255 - ti_get_pixel (list, col, row, 2));
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* ͤ ********************************************************** */
void
normalize_image (GList		*list,
		 gdouble	min,
		 gdouble	max) {
  gdouble	param, nval;
  gint		has_alpha, row, col, p;

  /* ͤϰϤå */
  if (min == -1 && max == -1) ti_get_pixel_range (list, &min, &max);
  if (min == max) return;

  /* ѿν */
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  param	    = max - min;
  if (param == 0) return;

  /*  */
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      for (p = 0; p < 3; p++) {
	nval = (ti_get_pixel (list, col, row, p) - min) * 255 / param;
	if (nval < 0)   nval = 0;
	if (nval > 255) nval = 255;
	ti_put_pixel (list,  col, row, p, (guchar) nval);
      }
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* οʿȿž ********************************************************** */
void
flip_horizontal (GList	*list) {
  guchar	val1, val2;
  gint		x1, x2, y, p, channel;

  channel = 3 + gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));

  for (y = 0; y < ti_get_height (list); y++) {
    for (x1 = 0, x2 = ti_get_width (list) - 1;
	 x1 < ti_get_width (list) >> 1; x1++, x2--) {
      for (p = 0; p < channel; p++) {
	val1 = ti_get_pixel (list, x1, y, p);
	val2 = ti_get_pixel (list, x2, y, p);
	ti_put_pixel (list, x1, y, p, val2);
	ti_put_pixel (list, x2, y, p, val1);
      }
    }
  }
}

/* οľȿž ********************************************************** */
void
flip_vertical (GList	*list) {
  guchar	*ptr1, *ptr2, r, rr;
  gint		x, y, yy, rowstride, channel;

  rowstride = gdk_pixbuf_get_rowstride (ti_get_pixbuf (list));
  channel   = 3 + gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));

  for (yy = ti_get_height (list) - 1, y = 0;
       y < ti_get_height (list) >> 1; y++, yy--) {
    ptr1 = gdk_pixbuf_get_pixels (ti_get_pixbuf (list)) + (y  * rowstride);
    ptr2 = gdk_pixbuf_get_pixels (ti_get_pixbuf (list)) + (yy * rowstride);
    for (x = 0; x < ti_get_width (list); x++) {
      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      if (channel == 4) {
	r  = *ptr1;
	rr = *ptr2;
	*ptr2++ = r;
	*ptr1++ = rr;
      }
    }
  }
}

/* ************************************************************************* */
void
rotate_90 (GList	*list) {
  
}


/* ********************************************************* operation.c *** */
