/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.messageex.web.action;

import java.util.Map;

import jp.terasoluna.thin.functionsample.messageex.bean.MessageExScopeParam;
import jp.terasoluna.thin.functionsample.messageex.service.MessageExScopeService;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * NGXgXR[vbZ[WANVNX
 *
 */
public class MessageExRequestScopeAction 
            extends AbstractBLogicAction<MessageExScopeParam>{
    
    /**
     * XR[vbZ[Wi[NX錾
     */
    private MessageExScopeService scopeService ;
    
    /**
     * PDɂăbZ[W<br>
     * QDɂăG[bZ[W
     *
     * @param param i[p[^[NX
     * @return bZ[WƃG[bZ[W
     */
    @Override
    public BLogicResult doExecuteBLogic(MessageExScopeParam param) 
                                                    throws Exception {

    	BLogicResult result = new BLogicResult();
    	BLogicMessages error = new BLogicMessages();
    	BLogicMessages mess = new BLogicMessages();
        Map<Integer, String> messKey = scopeService.execute(param);
        
        for (int i=0;i<4;i++) {
            String msg = null;
            String err = null;
            
            // 4Ԗڂ̃bZ[Wmsg0err0Ɋi[B
            if (i == 3) {
                msg = "msg0";
                err = "err0";
            } else {
                msg = "msg" + i;
                err = "err" + i;
            }
            
            if (messKey.get(i+4) != null) {
                // sȓ͎G[bZ[Wݒ肷B
                if (messKey.get(i) != null) {
                    mess.add(msg, new BLogicMessage(messKey.get(i)));                    
                }
                error.add(err, new BLogicMessage(messKey.get(i+4)));
            }
        }
        
        result.setErrors(error);
        result.setMessages(mess);
        result.setResultString("success");
        return result;
    }

    /**
     * XR[vbZ[Wi[NX擾B
     * @return XR[vbZ[Wi[NX
     */
    public MessageExScopeService getScopeService() {
        return scopeService;
    }

    /**
     * XR[vbZ[Wi[NXݒ肷B
     * @param scopeService XR[vbZ[Wi[NX
     */
    public void setScopeService(MessageExScopeService scopeService) {
        this.scopeService = scopeService;
    }
}