/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>
 *  w肵 bean vpeB̒lϊ<code>JspWriter</code>Ƃ
 *  \<code>write</code>^O̎NXB
 * </p>
 * <p>
 *  w肵<code>bean</code>vpeB̒loA
 *  <code>String</code>ƂČ݂ <code>JspWriter</code> ɗ^B
 *  vpeBl̃NXpɍ\Ă<code>PropertyEditor</code>
 *  ꍇA <code>getAsText()</code> \bhĂ΂B
 *  ȊȌꍇ́Aʏ <code>toString()</code> ł̕ϊKpB
 *  ܂AɂAȉ̂悤ɕtϊsB
 * </p>
 * <p>
 *  <li>null͋󕶎 <code>&quot;&amp;nbsp;&quot;</code> ƒu</li>
 *  <li>pXy[X <code>&quot;&amp;nbsp;&quot;</code> ƒu</li>
 *  <li>sR[h <code>&lt;br&gt;</code> ƒu</li>
 *  <li>s𖳎</li>
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <li><code>write</code> ^Oł́Aȉ̑T|[gB</li>
 * <br><br>
 * <div align="center">
 * <table width="90%" border="1">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>filter</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgꍇA
 *      \ꂽvpeBl HTMLŃZVeBuȕ̂߂
 *      tB^[B Ă̂悤ȑSẮ̕A
 *      ȕŒuB
 *      ftHgł́AtB^OsB
 *      ɂ邽߂ɂ́ȂɖI false ZbgKvB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>replaceNullToNbsp</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgA
 *      w肵beanvpeB̒l󕶎yсAnull̏ꍇ
 *      <code>&amp;nbsp;</code>o͂B
 *      ɂ邽߂ɂ́ȂɖI false ZbgKvB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>replaceSpToNbsp</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgA
 *      w肵beanvpeB̒l1ByteR[h̃Xy[X݂ꍇ
 *      <code>&amp;nbsp;</code>ɒuB
 *      ɂ邽߂ɂ́ȂɖI false ZbgKvB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>replaceLFtoBR</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgꍇA
 *      w肵beanvpeB̒l̉sR[h͕A
 *      <code>&lt;br&gt;</code>ɒuB
 *      ɂ邽߂ɂ́ȂɖI false ZbgKvB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>ignore</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgA
 *      name  scopeŎw肵 bean ݂ȂꍇA
 *      ȂɂɃ^[B
 *      ftHgl false (̃^O Cu̒̂ق̃^O
 *      Ȃ悤ɎsOX[)B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>name</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      property (w肪ꍇ) ɂĎw肵l
 *      o߂ɁAvpeBANZX bean ̑w肷B
 *      property w肳ȂꍇA bean g̒l\B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>property</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      name ɂĎw肵 bean ŃANZX
 *      vpeB̖Ow肷B ̒l̓VvACfbNXtA
 *      ܂̓lXgꂽvpeBQƎɂȂB
 *      w肳Ȃꍇ́Aname ɂĎʂꂽ
 *      bean  ꎩg\B
 *      w肵vpeBk߂ꍇA\ȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>scope</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      name ɂĎw肵 bean o߂Ɍꂽ
 *      σXR[vw肷B w肳ȂꍇAPageContext.findAttribute()
 *      ɂēKpꂽftHg̃[KpB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>fillColumn</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      fillColumnɂĎw肳ꂽŋ؂A
 *      ؂I[&lt;br&gt;t^B ͔̐płASpł
 *      P̕Ƃ݂ȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>addBR</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      ̑trueɃZbgꍇAvpeBl̖&lt;br&gt;t^B
 *      ftHgfalseB
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <br>
 * <li>̃^OɂĐݒ肳XNveBOϐ͂܂B</li>
 * <br>
 * <h5>gp@</h5>
 * <p><code><pre>
 * &lt;logic:iterate id=&quot;form&quot;
 *     property="myMap" indexId=&quot;index&quot; &gt;
 *     &lt;t:write name=&quot;form&quot; property=&quot;value&quot; /&gt;
 * &lt;/logic:iterate&gt;
 * </pre></code></p>
 *
 */
public class WriteTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -6953813130272994790L;

    /**
     * ONX
     */
    private static Log log = LogFactory.getLog(WriteTag.class);

    /**
     * <p>
     *  ꕶ <code>HTML</code> ɑΉɒuB
     * </p>
     */
    protected boolean filter = true;

    /**
     * <p>
     *  <code>filter</code><code>get</code>\bh
     * </p>
     * @return filter filter
     */
    public boolean getFilter() {
        return this.filter;
    }

    /**
     * <p>
     *  <code>filter</code><code>set</code>\bh
     * </p>
     *
     * @param filter filterl
     */
    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    /**
     * <p>
     *  <code>null</code>͋󕶎&nbsp;ƒuB
     * </p>
     */
    protected boolean replaceNullToNbsp = true;

    /**
     * <p>
     *  <code>replaceNullToNbsp</code><code>get</code>\bh
     * </p>
     *
     * @return replaceNullToNbsp
     *   <code>null</code>  <code>&amp;nbsp;</code> ϊtO
     */
    public boolean getReplaceNullToNbsp() {
        return this.replaceNullToNbsp;
    }

    /**
     * <p>
     *  <code>replaceNullToNbsp</code>  <code>set</code> \bh
     * </p>
     *
     * @param replaceNullToNbsp
     *   <code>null</code>  <code>&amp;nbsp;</code> ϊtO
     */
    public void setReplaceNullToNbsp(boolean replaceNullToNbsp) {
        this.replaceNullToNbsp = replaceNullToNbsp;
    }

    /**
     * <p>
     *  pXy[X <code>&amp;nbsp;</code> ƒuB
     * </p>
     */
    protected boolean replaceSpToNbsp = true;

    /**
     * <p>
     *  <code>replaceSpToNbsp</code>  <code>get</code> \bh
     * </p>
     *
     * @return replaceSpToNbsp
     *   pXy[X <code>&amp;nbsp;</code> ϊtO
     */
    public boolean getReplaceSpToNbsp() {
        return this.replaceSpToNbsp;
    }

    /**
     * <p>
     *  <code>replaceSpToNbsp</code>  <code>set</code> \bh
     * </p>
     *
     * @param replaceSpToNbsp
     *   pXy[X <code>&amp;nbsp;</code> ϊtO
     */
    public void setReplaceSpToNbsp(boolean replaceSpToNbsp) {
        this.replaceSpToNbsp = replaceSpToNbsp;
    }

    /**
     * <p>
     *  sR[h<code>&lt;br&gt;</code>ƒuB
     * </p>
     */
    protected boolean replaceLFtoBR = true;

    /**
     * <p>
     *  <code>replaceLFtoBR</code>  <code>get</code> \bh
     * </p>
     *
     * @return replaceLFtoBR
     *   sR[h <code>&lt;br&gt;</code> ϊtO
     */
    public boolean getReplaceLFtoBR() {
        return this.replaceLFtoBR;
    }

    /**
     * <p>
     *  <code>replaceLFtoBR</code>  <code>set</code> \bh
     * </p>
     *
     * @param replaceLFtoBR
     *   sR[h <code>&lt;br&gt;</code> ϊtO
     */
    public void setReplaceLFtoBR(boolean replaceLFtoBR) {
        this.replaceLFtoBR = replaceLFtoBR;
    }

    /**
     * <p>
     *  <code>name</code>  <code>scope</code> Ŏw肳ꂽ
     *  <code>Bean</code> ݂ȂꍇAȂ
     * </p>
     */
    protected boolean ignore = false;

    /**
     * <p>
     *  <code>ignore</code>  <code>get</code> \bh
     * </p>
     *
     * @return ignore ignorel
     */
    public boolean getIgnore() {
        return this.ignore;
    }

    /**
     * <p>
     *  <code>ignore</code>  <code>set</code> \bh
     * </p>
     *
     * @param ignore ignorel
     */
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    /**
     * <p>
     *  <code>property</code> Ŏw肵loׂ <code>Bean</code> 
     * </p>
     */
    protected String name = null;

    /**
     * <p>
     *  <code>name</code>  <code>get</code> \bh
     * </p>
     *
     * @return name
     */
    public String getName() {
        return this.name;
    }

    /**
     * <p>
     *  <code>name</code>  <code>set</code> \bh
     * </p>
     *
     * @param name namel
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     *  <code>name</code> ɂĎw肳ꂽ <code>Bean</code> 
     *  ANZXvpeB
     * </p>
     */
    protected String property = null;

    /**
     * <p>
     *  <code>property</code>  <code>get</code> \bh
     * </p>
     *
     * @return property
     */
    public String getProperty() {
        return this.property;
    }

    /**
     * <p>
     *  <code>property</code>  <code>set</code> \bh
     * </p>
     *
     * @param property propertyl
     */
    public void setProperty(String property) {
        this.property = property;
    }

    /**
     * <p>
     *  <code>scope</code>  <code>get</code> \bh
     * </p>
     *
     * @return scope
     */
    public String getScope() {
        return this.scope;
    }

    /**
     * <p>
     *  <code>name</code> ɂĎw肵 <code>bean</code>
     * oׂɌXR[v
     * </p>
     */
    protected String scope = null;

    /**
     * <p>
     *  <code>scope</code>  <code>set</code> \bh
     * </p>
     *
     * @param scope scopel
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * <p>
     *  <code>fillColumn</code> ɂĎw肳ꂽ <code>Bean</code>
     *  ŃANZXvpeB
     * </p>
     */
    protected int fillColumn = -1;

    /**
     * <p>
     *  <code>fillColumn</code>  <code>get</code> \bh
     * </p>
     *
     * @return fillColumn
     */
    public int getFillColumn() {
        return this.fillColumn;
    }

    /**
     * <p>
     *  <code>fillColumn</code>  <code>set</code> \bh
     * </p>
     *
     * @param fillColumn fillColumnl
     */
    public void setFillColumn(int fillColumn) {
        this.fillColumn = fillColumn;
    }

    /**
     * <p>
     *  vpeBl̖&lt;br&gt;B
     * </p>
     */
    protected boolean addBR = false;

    /**
     * <p>
     *  <code>addBR</code>  <code>get</code> \bh
     * </p>
     *
     * @return addBR addBRl
     */
    public boolean getAddBR() {
        return this.addBR;
    }

    /**
     * <p>
     *  <code>addBR</code>  <code>set</code> \bh
     * </p>
     *
     * @param addBR addBRl
     */
    public void setAddBR(boolean addBR) {
        this.addBR = addBR;
    }

    /**
     * <p>Jn^Ȍs܂B</p>
     *
     * @return int w
     * @exception JspException JSPOꍇ
     */
    @Override
    public int doStartTag() throws JspException {

        //vꂽbean
        if (ignore && TagUtil.lookup(pageContext, name, scope) == null) {
                return SKIP_BODY;
        }

        //vꂽvpeB
        Object value = TagUtil.lookup(pageContext, name, property, scope);
        if (value == null) {
            if (replaceNullToNbsp) {
                TagUtil.write(pageContext, "&nbsp;");
            }
            return SKIP_BODY;
        }

        //vpeBl\
        String output = value.toString();
        if (filter) {
            output = TagUtil.filter(output);
        }
        StringReader   sr = null;
        BufferedReader br = null;
        try {
            sr = new StringReader(output);
            br = new BufferedReader(sr);
            StringBuilder sbuilder = new StringBuilder();
            StringBuilder strBuilder = new StringBuilder();
            String line = null;
            int sizeMngCount = 1;
            int index = 0;
            while ((line = br.readLine()) != null) {

                if (index > 0 && replaceLFtoBR) {
                    // sR[h<br>
                    sbuilder.append("<br>");
                }

                // pXy[X&nbsp;ɒu
                if (replaceSpToNbsp && !"".equals(line)) {
                    strBuilder.setLength(0);
                    char ch = line.charAt(0);
                    for (int i = 0; i < line.length(); i++, sizeMngCount++) {
                        ch = line.charAt(i);
                        // pXy[XłꍇA"&nbsp;"ɕϊ܂B
                        if (ch == ' ') {
                            strBuilder.append("&nbsp;");
                        } else {
                            strBuilder.append(ch);
                        }
                        // w肳ꂽTCYŋ؂A<br>t^B
                        if (fillColumn > 0 && sizeMngCount > 1
                                && sizeMngCount % fillColumn == 0
                                && i != line.length() - 1) {
                            strBuilder.append("<br>");
                        }
                    }
                    line = strBuilder.toString();
                }
                sbuilder.append(line);
                ++index;
            }

            // vpeBl̖<br>t^
            if (addBR) {
                sbuilder.append("<br>");
            }

            //""&nbsp;ɒu
            if (replaceNullToNbsp && index == 0) {
                line = br.readLine();
                if (line == null || "".equals(line)) {
                    sbuilder.append("&nbsp;");
                    output = sbuilder.toString();
                    TagUtil.write(pageContext, output);
                    return SKIP_BODY;
                }
            }
            output = sbuilder.toString();
        } catch (IOException e) {
            log.error("StringReader IO error.");

            throw new JspTagException(e.getMessage());
        } finally {
            if (sr != null) {
                sr.close();
            }
            try {
                if (br != null) {
                    br.close();
                }
            } catch (IOException e1) {
                if (log.isWarnEnabled()) {
                    log.warn("StringReader close error : " + e1);
                }
            }
        }
        TagUtil.write(pageContext, output);

        return SKIP_BODY;
    }

    /**
     * <p>ׂẴAP[gꂽB</p>
     */
    @Override
    public void release() {
        super.release();
        this.filter = true;
        this.replaceNullToNbsp = true;
        this.replaceSpToNbsp = true;
        this.replaceLFtoBR = true;
        this.ignore = false;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.fillColumn = -1;
    }

}
